/*
 * Decompiled with CFR 0.152.
 */
package io.cloudreactor.tasksymphony.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.cloudreactor.tasksymphony.model.AwsEcsServiceLoadBalancerDetails;
import io.cloudreactor.tasksymphony.model.PropagateTagsEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Options for running a Task as a service in AWS ECS.")
@JsonPropertyOrder(value={"load_balancers", "health_check_grace_period_seconds", "force_new_deployment", "deploy_minimum_healthy_percent", "deploy_maximum_percent", "deploy_enable_circuit_breaker", "deploy_rollback_on_failure", "enable_ecs_managed_tags", "propagate_tags", "tags"})
@JsonTypeName(value="AwsEcsServiceOptions")
public class AwsEcsServiceOptions {
    public static final String JSON_PROPERTY_LOAD_BALANCERS = "load_balancers";
    private List<AwsEcsServiceLoadBalancerDetails> loadBalancers = new ArrayList<AwsEcsServiceLoadBalancerDetails>();
    public static final String JSON_PROPERTY_HEALTH_CHECK_GRACE_PERIOD_SECONDS = "health_check_grace_period_seconds";
    private Integer healthCheckGracePeriodSeconds;
    public static final String JSON_PROPERTY_FORCE_NEW_DEPLOYMENT = "force_new_deployment";
    private Boolean forceNewDeployment;
    public static final String JSON_PROPERTY_DEPLOY_MINIMUM_HEALTHY_PERCENT = "deploy_minimum_healthy_percent";
    private Integer deployMinimumHealthyPercent;
    public static final String JSON_PROPERTY_DEPLOY_MAXIMUM_PERCENT = "deploy_maximum_percent";
    private Integer deployMaximumPercent;
    public static final String JSON_PROPERTY_DEPLOY_ENABLE_CIRCUIT_BREAKER = "deploy_enable_circuit_breaker";
    private Boolean deployEnableCircuitBreaker;
    public static final String JSON_PROPERTY_DEPLOY_ROLLBACK_ON_FAILURE = "deploy_rollback_on_failure";
    private Boolean deployRollbackOnFailure;
    public static final String JSON_PROPERTY_ENABLE_ECS_MANAGED_TAGS = "enable_ecs_managed_tags";
    private Boolean enableEcsManagedTags;
    public static final String JSON_PROPERTY_PROPAGATE_TAGS = "propagate_tags";
    private PropagateTagsEnum propagateTags;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private JsonNullable<Map<String, String>> tags = JsonNullable.undefined();

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="load_balancers")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<AwsEcsServiceLoadBalancerDetails> getLoadBalancers() {
        return this.loadBalancers;
    }

    public AwsEcsServiceOptions healthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds) {
        this.healthCheckGracePeriodSeconds = healthCheckGracePeriodSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="health_check_grace_period_seconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getHealthCheckGracePeriodSeconds() {
        return this.healthCheckGracePeriodSeconds;
    }

    @JsonProperty(value="health_check_grace_period_seconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHealthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds) {
        this.healthCheckGracePeriodSeconds = healthCheckGracePeriodSeconds;
    }

    public AwsEcsServiceOptions forceNewDeployment(Boolean forceNewDeployment) {
        this.forceNewDeployment = forceNewDeployment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="force_new_deployment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getForceNewDeployment() {
        return this.forceNewDeployment;
    }

    @JsonProperty(value="force_new_deployment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setForceNewDeployment(Boolean forceNewDeployment) {
        this.forceNewDeployment = forceNewDeployment;
    }

    public AwsEcsServiceOptions deployMinimumHealthyPercent(Integer deployMinimumHealthyPercent) {
        this.deployMinimumHealthyPercent = deployMinimumHealthyPercent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="deploy_minimum_healthy_percent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getDeployMinimumHealthyPercent() {
        return this.deployMinimumHealthyPercent;
    }

    @JsonProperty(value="deploy_minimum_healthy_percent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeployMinimumHealthyPercent(Integer deployMinimumHealthyPercent) {
        this.deployMinimumHealthyPercent = deployMinimumHealthyPercent;
    }

    public AwsEcsServiceOptions deployMaximumPercent(Integer deployMaximumPercent) {
        this.deployMaximumPercent = deployMaximumPercent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="deploy_maximum_percent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getDeployMaximumPercent() {
        return this.deployMaximumPercent;
    }

    @JsonProperty(value="deploy_maximum_percent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeployMaximumPercent(Integer deployMaximumPercent) {
        this.deployMaximumPercent = deployMaximumPercent;
    }

    public AwsEcsServiceOptions deployEnableCircuitBreaker(Boolean deployEnableCircuitBreaker) {
        this.deployEnableCircuitBreaker = deployEnableCircuitBreaker;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="deploy_enable_circuit_breaker")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDeployEnableCircuitBreaker() {
        return this.deployEnableCircuitBreaker;
    }

    @JsonProperty(value="deploy_enable_circuit_breaker")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeployEnableCircuitBreaker(Boolean deployEnableCircuitBreaker) {
        this.deployEnableCircuitBreaker = deployEnableCircuitBreaker;
    }

    public AwsEcsServiceOptions deployRollbackOnFailure(Boolean deployRollbackOnFailure) {
        this.deployRollbackOnFailure = deployRollbackOnFailure;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="deploy_rollback_on_failure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDeployRollbackOnFailure() {
        return this.deployRollbackOnFailure;
    }

    @JsonProperty(value="deploy_rollback_on_failure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeployRollbackOnFailure(Boolean deployRollbackOnFailure) {
        this.deployRollbackOnFailure = deployRollbackOnFailure;
    }

    public AwsEcsServiceOptions enableEcsManagedTags(Boolean enableEcsManagedTags) {
        this.enableEcsManagedTags = enableEcsManagedTags;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="enable_ecs_managed_tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getEnableEcsManagedTags() {
        return this.enableEcsManagedTags;
    }

    @JsonProperty(value="enable_ecs_managed_tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnableEcsManagedTags(Boolean enableEcsManagedTags) {
        this.enableEcsManagedTags = enableEcsManagedTags;
    }

    public AwsEcsServiceOptions propagateTags(PropagateTagsEnum propagateTags) {
        this.propagateTags = propagateTags;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="propagate_tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PropagateTagsEnum getPropagateTags() {
        return this.propagateTags;
    }

    @JsonProperty(value="propagate_tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPropagateTags(PropagateTagsEnum propagateTags) {
        this.propagateTags = propagateTags;
    }

    public AwsEcsServiceOptions tags(Map<String, String> tags) {
        this.tags = JsonNullable.of(tags);
        return this;
    }

    public AwsEcsServiceOptions putTagsItem(String key, String tagsItem) {
        if (this.tags == null || !this.tags.isPresent()) {
            this.tags = JsonNullable.of(new HashMap());
        }
        try {
            ((Map)this.tags.get()).put(key, tagsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Map<String, String> getTags() {
        return (Map)this.tags.orElse(null);
    }

    @JsonProperty(value="tags")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Map<String, String>> getTags_JsonNullable() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    public void setTags_JsonNullable(JsonNullable<Map<String, String>> tags) {
        this.tags = tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = JsonNullable.of(tags);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AwsEcsServiceOptions awsEcsServiceOptions = (AwsEcsServiceOptions)o;
        return Objects.equals(this.loadBalancers, awsEcsServiceOptions.loadBalancers) && Objects.equals(this.healthCheckGracePeriodSeconds, awsEcsServiceOptions.healthCheckGracePeriodSeconds) && Objects.equals(this.forceNewDeployment, awsEcsServiceOptions.forceNewDeployment) && Objects.equals(this.deployMinimumHealthyPercent, awsEcsServiceOptions.deployMinimumHealthyPercent) && Objects.equals(this.deployMaximumPercent, awsEcsServiceOptions.deployMaximumPercent) && Objects.equals(this.deployEnableCircuitBreaker, awsEcsServiceOptions.deployEnableCircuitBreaker) && Objects.equals(this.deployRollbackOnFailure, awsEcsServiceOptions.deployRollbackOnFailure) && Objects.equals(this.enableEcsManagedTags, awsEcsServiceOptions.enableEcsManagedTags) && Objects.equals((Object)this.propagateTags, (Object)awsEcsServiceOptions.propagateTags) && AwsEcsServiceOptions.equalsNullable(this.tags, awsEcsServiceOptions.tags);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.loadBalancers, this.healthCheckGracePeriodSeconds, this.forceNewDeployment, this.deployMinimumHealthyPercent, this.deployMaximumPercent, this.deployEnableCircuitBreaker, this.deployRollbackOnFailure, this.enableEcsManagedTags, this.propagateTags, AwsEcsServiceOptions.hashCodeNullable(this.tags)});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AwsEcsServiceOptions {\n");
        sb.append("    loadBalancers: ").append(this.toIndentedString(this.loadBalancers)).append("\n");
        sb.append("    healthCheckGracePeriodSeconds: ").append(this.toIndentedString(this.healthCheckGracePeriodSeconds)).append("\n");
        sb.append("    forceNewDeployment: ").append(this.toIndentedString(this.forceNewDeployment)).append("\n");
        sb.append("    deployMinimumHealthyPercent: ").append(this.toIndentedString(this.deployMinimumHealthyPercent)).append("\n");
        sb.append("    deployMaximumPercent: ").append(this.toIndentedString(this.deployMaximumPercent)).append("\n");
        sb.append("    deployEnableCircuitBreaker: ").append(this.toIndentedString(this.deployEnableCircuitBreaker)).append("\n");
        sb.append("    deployRollbackOnFailure: ").append(this.toIndentedString(this.deployRollbackOnFailure)).append("\n");
        sb.append("    enableEcsManagedTags: ").append(this.toIndentedString(this.enableEcsManagedTags)).append("\n");
        sb.append("    propagateTags: ").append(this.toIndentedString((Object)this.propagateTags)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

