/*
 * Decompiled with CFR 0.152.
 */
package io.cloudreactor.tasksymphony.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.cloudreactor.tasksymphony.model.AwsEcsRunEnvironmentExecutionMethodCapability;
import io.cloudreactor.tasksymphony.model.Group;
import io.cloudreactor.tasksymphony.model.NameAndUuid;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="RunEnvironments contain common settings for running a set of related Tasks. Usually RunEnvironments group Tasks in the same deployment environment (e.g. staging or production). Task and Workflows belong to a RunEnvironment but can override the RunEnvironment's settings.")
@JsonPropertyOrder(value={"url", "uuid", "name", "description", "dashboard_url", "created_by_user", "created_by_group", "created_at", "updated_at", "aws_account_id", "aws_default_region", "aws_access_key", "aws_assumed_role_external_id", "aws_events_role_arn", "aws_workflow_starter_lambda_arn", "aws_workflow_starter_access_key", "default_alert_methods", "execution_method_capabilities"})
@JsonTypeName(value="PatchedRunEnvironment")
public class PatchedRunEnvironment {
    public static final String JSON_PROPERTY_URL = "url";
    private URI url;
    public static final String JSON_PROPERTY_UUID = "uuid";
    private UUID uuid;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_DASHBOARD_URL = "dashboard_url";
    private String dashboardUrl;
    public static final String JSON_PROPERTY_CREATED_BY_USER = "created_by_user";
    private String createdByUser;
    public static final String JSON_PROPERTY_CREATED_BY_GROUP = "created_by_group";
    private JsonNullable<Group> createdByGroup = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private OffsetDateTime updatedAt;
    public static final String JSON_PROPERTY_AWS_ACCOUNT_ID = "aws_account_id";
    private String awsAccountId;
    public static final String JSON_PROPERTY_AWS_DEFAULT_REGION = "aws_default_region";
    private String awsDefaultRegion;
    public static final String JSON_PROPERTY_AWS_ACCESS_KEY = "aws_access_key";
    private String awsAccessKey;
    public static final String JSON_PROPERTY_AWS_ASSUMED_ROLE_EXTERNAL_ID = "aws_assumed_role_external_id";
    private String awsAssumedRoleExternalId;
    public static final String JSON_PROPERTY_AWS_EVENTS_ROLE_ARN = "aws_events_role_arn";
    private String awsEventsRoleArn;
    public static final String JSON_PROPERTY_AWS_WORKFLOW_STARTER_LAMBDA_ARN = "aws_workflow_starter_lambda_arn";
    private String awsWorkflowStarterLambdaArn;
    public static final String JSON_PROPERTY_AWS_WORKFLOW_STARTER_ACCESS_KEY = "aws_workflow_starter_access_key";
    private String awsWorkflowStarterAccessKey;
    public static final String JSON_PROPERTY_DEFAULT_ALERT_METHODS = "default_alert_methods";
    private List<NameAndUuid> defaultAlertMethods = null;
    public static final String JSON_PROPERTY_EXECUTION_METHOD_CAPABILITIES = "execution_method_capabilities";
    private List<AwsEcsRunEnvironmentExecutionMethodCapability> executionMethodCapabilities = null;

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public URI getUrl() {
        return this.url;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="uuid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getUuid() {
        return this.uuid;
    }

    public PatchedRunEnvironment name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public PatchedRunEnvironment description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="dashboard_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDashboardUrl() {
        return this.dashboardUrl;
    }

    @Nullable
    @ApiModelProperty(value="Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.")
    @JsonProperty(value="created_by_user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCreatedByUser() {
        return this.createdByUser;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Group getCreatedByGroup() {
        if (this.createdByGroup == null) {
            this.createdByGroup = JsonNullable.undefined();
        }
        return (Group)this.createdByGroup.orElse(null);
    }

    @JsonProperty(value="created_by_group")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Group> getCreatedByGroup_JsonNullable() {
        return this.createdByGroup;
    }

    @JsonProperty(value="created_by_group")
    private void setCreatedByGroup_JsonNullable(JsonNullable<Group> createdByGroup) {
        this.createdByGroup = createdByGroup;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public PatchedRunEnvironment awsAccountId(String awsAccountId) {
        this.awsAccountId = awsAccountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="aws_account_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAwsAccountId() {
        return this.awsAccountId;
    }

    @JsonProperty(value="aws_account_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAwsAccountId(String awsAccountId) {
        this.awsAccountId = awsAccountId;
    }

    public PatchedRunEnvironment awsDefaultRegion(String awsDefaultRegion) {
        this.awsDefaultRegion = awsDefaultRegion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="aws_default_region")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAwsDefaultRegion() {
        return this.awsDefaultRegion;
    }

    @JsonProperty(value="aws_default_region")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAwsDefaultRegion(String awsDefaultRegion) {
        this.awsDefaultRegion = awsDefaultRegion;
    }

    public PatchedRunEnvironment awsAccessKey(String awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="aws_access_key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAwsAccessKey() {
        return this.awsAccessKey;
    }

    @JsonProperty(value="aws_access_key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAwsAccessKey(String awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
    }

    public PatchedRunEnvironment awsAssumedRoleExternalId(String awsAssumedRoleExternalId) {
        this.awsAssumedRoleExternalId = awsAssumedRoleExternalId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="aws_assumed_role_external_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAwsAssumedRoleExternalId() {
        return this.awsAssumedRoleExternalId;
    }

    @JsonProperty(value="aws_assumed_role_external_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAwsAssumedRoleExternalId(String awsAssumedRoleExternalId) {
        this.awsAssumedRoleExternalId = awsAssumedRoleExternalId;
    }

    public PatchedRunEnvironment awsEventsRoleArn(String awsEventsRoleArn) {
        this.awsEventsRoleArn = awsEventsRoleArn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="aws_events_role_arn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAwsEventsRoleArn() {
        return this.awsEventsRoleArn;
    }

    @JsonProperty(value="aws_events_role_arn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAwsEventsRoleArn(String awsEventsRoleArn) {
        this.awsEventsRoleArn = awsEventsRoleArn;
    }

    public PatchedRunEnvironment awsWorkflowStarterLambdaArn(String awsWorkflowStarterLambdaArn) {
        this.awsWorkflowStarterLambdaArn = awsWorkflowStarterLambdaArn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="aws_workflow_starter_lambda_arn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAwsWorkflowStarterLambdaArn() {
        return this.awsWorkflowStarterLambdaArn;
    }

    @JsonProperty(value="aws_workflow_starter_lambda_arn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAwsWorkflowStarterLambdaArn(String awsWorkflowStarterLambdaArn) {
        this.awsWorkflowStarterLambdaArn = awsWorkflowStarterLambdaArn;
    }

    public PatchedRunEnvironment awsWorkflowStarterAccessKey(String awsWorkflowStarterAccessKey) {
        this.awsWorkflowStarterAccessKey = awsWorkflowStarterAccessKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="aws_workflow_starter_access_key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAwsWorkflowStarterAccessKey() {
        return this.awsWorkflowStarterAccessKey;
    }

    @JsonProperty(value="aws_workflow_starter_access_key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAwsWorkflowStarterAccessKey(String awsWorkflowStarterAccessKey) {
        this.awsWorkflowStarterAccessKey = awsWorkflowStarterAccessKey;
    }

    public PatchedRunEnvironment defaultAlertMethods(List<NameAndUuid> defaultAlertMethods) {
        this.defaultAlertMethods = defaultAlertMethods;
        return this;
    }

    public PatchedRunEnvironment addDefaultAlertMethodsItem(NameAndUuid defaultAlertMethodsItem) {
        if (this.defaultAlertMethods == null) {
            this.defaultAlertMethods = new ArrayList<NameAndUuid>();
        }
        this.defaultAlertMethods.add(defaultAlertMethodsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="default_alert_methods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<NameAndUuid> getDefaultAlertMethods() {
        return this.defaultAlertMethods;
    }

    @JsonProperty(value="default_alert_methods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefaultAlertMethods(List<NameAndUuid> defaultAlertMethods) {
        this.defaultAlertMethods = defaultAlertMethods;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="execution_method_capabilities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AwsEcsRunEnvironmentExecutionMethodCapability> getExecutionMethodCapabilities() {
        return this.executionMethodCapabilities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatchedRunEnvironment patchedRunEnvironment = (PatchedRunEnvironment)o;
        return Objects.equals(this.url, patchedRunEnvironment.url) && Objects.equals(this.uuid, patchedRunEnvironment.uuid) && Objects.equals(this.name, patchedRunEnvironment.name) && Objects.equals(this.description, patchedRunEnvironment.description) && Objects.equals(this.dashboardUrl, patchedRunEnvironment.dashboardUrl) && Objects.equals(this.createdByUser, patchedRunEnvironment.createdByUser) && PatchedRunEnvironment.equalsNullable(this.createdByGroup, patchedRunEnvironment.createdByGroup) && Objects.equals(this.createdAt, patchedRunEnvironment.createdAt) && Objects.equals(this.updatedAt, patchedRunEnvironment.updatedAt) && Objects.equals(this.awsAccountId, patchedRunEnvironment.awsAccountId) && Objects.equals(this.awsDefaultRegion, patchedRunEnvironment.awsDefaultRegion) && Objects.equals(this.awsAccessKey, patchedRunEnvironment.awsAccessKey) && Objects.equals(this.awsAssumedRoleExternalId, patchedRunEnvironment.awsAssumedRoleExternalId) && Objects.equals(this.awsEventsRoleArn, patchedRunEnvironment.awsEventsRoleArn) && Objects.equals(this.awsWorkflowStarterLambdaArn, patchedRunEnvironment.awsWorkflowStarterLambdaArn) && Objects.equals(this.awsWorkflowStarterAccessKey, patchedRunEnvironment.awsWorkflowStarterAccessKey) && Objects.equals(this.defaultAlertMethods, patchedRunEnvironment.defaultAlertMethods) && Objects.equals(this.executionMethodCapabilities, patchedRunEnvironment.executionMethodCapabilities);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.url, this.uuid, this.name, this.description, this.dashboardUrl, this.createdByUser, PatchedRunEnvironment.hashCodeNullable(this.createdByGroup), this.createdAt, this.updatedAt, this.awsAccountId, this.awsDefaultRegion, this.awsAccessKey, this.awsAssumedRoleExternalId, this.awsEventsRoleArn, this.awsWorkflowStarterLambdaArn, this.awsWorkflowStarterAccessKey, this.defaultAlertMethods, this.executionMethodCapabilities);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PatchedRunEnvironment {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    dashboardUrl: ").append(this.toIndentedString(this.dashboardUrl)).append("\n");
        sb.append("    createdByUser: ").append(this.toIndentedString(this.createdByUser)).append("\n");
        sb.append("    createdByGroup: ").append(this.toIndentedString(this.createdByGroup)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    awsAccountId: ").append(this.toIndentedString(this.awsAccountId)).append("\n");
        sb.append("    awsDefaultRegion: ").append(this.toIndentedString(this.awsDefaultRegion)).append("\n");
        sb.append("    awsAccessKey: ").append(this.toIndentedString(this.awsAccessKey)).append("\n");
        sb.append("    awsAssumedRoleExternalId: ").append(this.toIndentedString(this.awsAssumedRoleExternalId)).append("\n");
        sb.append("    awsEventsRoleArn: ").append(this.toIndentedString(this.awsEventsRoleArn)).append("\n");
        sb.append("    awsWorkflowStarterLambdaArn: ").append(this.toIndentedString(this.awsWorkflowStarterLambdaArn)).append("\n");
        sb.append("    awsWorkflowStarterAccessKey: ").append(this.toIndentedString(this.awsWorkflowStarterAccessKey)).append("\n");
        sb.append("    defaultAlertMethods: ").append(this.toIndentedString(this.defaultAlertMethods)).append("\n");
        sb.append("    executionMethodCapabilities: ").append(this.toIndentedString(this.executionMethodCapabilities)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

