/*
 * Decompiled with CFR 0.152.
 */
package io.cloudreactor.tasksymphony.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.cloudreactor.tasksymphony.model.CurrentServiceInfo;
import io.cloudreactor.tasksymphony.model.ExecutionMethodCapability;
import io.cloudreactor.tasksymphony.model.Group;
import io.cloudreactor.tasksymphony.model.Link;
import io.cloudreactor.tasksymphony.model.NameAndUuid;
import io.cloudreactor.tasksymphony.model.TaskExecution;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="A Task is a specification for a runnable job, including details on how to run the task and how often the task is supposed to run.")
@JsonPropertyOrder(value={"url", "uuid", "name", "description", "dashboard_url", "infrastructure_website_url", "max_manual_start_delay_before_alert_seconds", "max_manual_start_delay_before_abandonment_seconds", "heartbeat_interval_seconds", "max_heartbeat_lateness_before_alert_seconds", "max_heartbeat_lateness_before_abandonment_seconds", "schedule", "scheduled_instance_count", "is_service", "service_instance_count", "min_service_instance_count", "max_concurrency", "max_age_seconds", "default_max_retries", "project_url", "log_query", "logs_url", "links", "run_environment", "execution_method_capability", "alert_methods", "other_metadata", "latest_task_execution", "current_service_info", "created_by_user", "created_by_group", "was_auto_created", "passive", "enabled", "created_at", "updated_at"})
@JsonTypeName(value="PatchedTask")
public class PatchedTask {
    public static final String JSON_PROPERTY_URL = "url";
    private URI url;
    public static final String JSON_PROPERTY_UUID = "uuid";
    private UUID uuid;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_DASHBOARD_URL = "dashboard_url";
    private String dashboardUrl;
    public static final String JSON_PROPERTY_INFRASTRUCTURE_WEBSITE_URL = "infrastructure_website_url";
    private JsonNullable<String> infrastructureWebsiteUrl = JsonNullable.undefined();
    public static final String JSON_PROPERTY_MAX_MANUAL_START_DELAY_BEFORE_ALERT_SECONDS = "max_manual_start_delay_before_alert_seconds";
    private JsonNullable<Integer> maxManualStartDelayBeforeAlertSeconds = JsonNullable.undefined();
    public static final String JSON_PROPERTY_MAX_MANUAL_START_DELAY_BEFORE_ABANDONMENT_SECONDS = "max_manual_start_delay_before_abandonment_seconds";
    private JsonNullable<Integer> maxManualStartDelayBeforeAbandonmentSeconds = JsonNullable.undefined();
    public static final String JSON_PROPERTY_HEARTBEAT_INTERVAL_SECONDS = "heartbeat_interval_seconds";
    private JsonNullable<Integer> heartbeatIntervalSeconds = JsonNullable.undefined();
    public static final String JSON_PROPERTY_MAX_HEARTBEAT_LATENESS_BEFORE_ALERT_SECONDS = "max_heartbeat_lateness_before_alert_seconds";
    private JsonNullable<Integer> maxHeartbeatLatenessBeforeAlertSeconds = JsonNullable.undefined();
    public static final String JSON_PROPERTY_MAX_HEARTBEAT_LATENESS_BEFORE_ABANDONMENT_SECONDS = "max_heartbeat_lateness_before_abandonment_seconds";
    private JsonNullable<Integer> maxHeartbeatLatenessBeforeAbandonmentSeconds = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SCHEDULE = "schedule";
    private String schedule;
    public static final String JSON_PROPERTY_SCHEDULED_INSTANCE_COUNT = "scheduled_instance_count";
    private JsonNullable<Integer> scheduledInstanceCount = JsonNullable.undefined();
    public static final String JSON_PROPERTY_IS_SERVICE = "is_service";
    private Boolean isService;
    public static final String JSON_PROPERTY_SERVICE_INSTANCE_COUNT = "service_instance_count";
    private JsonNullable<Integer> serviceInstanceCount = JsonNullable.undefined();
    public static final String JSON_PROPERTY_MIN_SERVICE_INSTANCE_COUNT = "min_service_instance_count";
    private JsonNullable<Integer> minServiceInstanceCount = JsonNullable.undefined();
    public static final String JSON_PROPERTY_MAX_CONCURRENCY = "max_concurrency";
    private JsonNullable<Integer> maxConcurrency = JsonNullable.undefined();
    public static final String JSON_PROPERTY_MAX_AGE_SECONDS = "max_age_seconds";
    private JsonNullable<Integer> maxAgeSeconds = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DEFAULT_MAX_RETRIES = "default_max_retries";
    private Integer defaultMaxRetries;
    public static final String JSON_PROPERTY_PROJECT_URL = "project_url";
    private String projectUrl;
    public static final String JSON_PROPERTY_LOG_QUERY = "log_query";
    private String logQuery;
    public static final String JSON_PROPERTY_LOGS_URL = "logs_url";
    private JsonNullable<String> logsUrl = JsonNullable.undefined();
    public static final String JSON_PROPERTY_LINKS = "links";
    private List<Link> links = null;
    public static final String JSON_PROPERTY_RUN_ENVIRONMENT = "run_environment";
    private JsonNullable<NameAndUuid> runEnvironment = JsonNullable.undefined();
    public static final String JSON_PROPERTY_EXECUTION_METHOD_CAPABILITY = "execution_method_capability";
    private JsonNullable<ExecutionMethodCapability> executionMethodCapability = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ALERT_METHODS = "alert_methods";
    private List<NameAndUuid> alertMethods = null;
    public static final String JSON_PROPERTY_OTHER_METADATA = "other_metadata";
    private JsonNullable<Map<String, Object>> otherMetadata = JsonNullable.undefined();
    public static final String JSON_PROPERTY_LATEST_TASK_EXECUTION = "latest_task_execution";
    private JsonNullable<TaskExecution> latestTaskExecution = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CURRENT_SERVICE_INFO = "current_service_info";
    private JsonNullable<CurrentServiceInfo> currentServiceInfo = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CREATED_BY_USER = "created_by_user";
    private String createdByUser;
    public static final String JSON_PROPERTY_CREATED_BY_GROUP = "created_by_group";
    private JsonNullable<Group> createdByGroup = JsonNullable.undefined();
    public static final String JSON_PROPERTY_WAS_AUTO_CREATED = "was_auto_created";
    private JsonNullable<Boolean> wasAutoCreated = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PASSIVE = "passive";
    private Boolean passive;
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private OffsetDateTime updatedAt;

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public URI getUrl() {
        return this.url;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="uuid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getUuid() {
        return this.uuid;
    }

    public PatchedTask name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public PatchedTask description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="dashboard_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDashboardUrl() {
        return this.dashboardUrl;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public String getInfrastructureWebsiteUrl() {
        if (this.infrastructureWebsiteUrl == null) {
            this.infrastructureWebsiteUrl = JsonNullable.undefined();
        }
        return (String)this.infrastructureWebsiteUrl.orElse(null);
    }

    @JsonProperty(value="infrastructure_website_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getInfrastructureWebsiteUrl_JsonNullable() {
        return this.infrastructureWebsiteUrl;
    }

    @JsonProperty(value="infrastructure_website_url")
    private void setInfrastructureWebsiteUrl_JsonNullable(JsonNullable<String> infrastructureWebsiteUrl) {
        this.infrastructureWebsiteUrl = infrastructureWebsiteUrl;
    }

    public PatchedTask maxManualStartDelayBeforeAlertSeconds(Integer maxManualStartDelayBeforeAlertSeconds) {
        this.maxManualStartDelayBeforeAlertSeconds = JsonNullable.of((Object)maxManualStartDelayBeforeAlertSeconds);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getMaxManualStartDelayBeforeAlertSeconds() {
        return (Integer)this.maxManualStartDelayBeforeAlertSeconds.orElse(null);
    }

    @JsonProperty(value="max_manual_start_delay_before_alert_seconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getMaxManualStartDelayBeforeAlertSeconds_JsonNullable() {
        return this.maxManualStartDelayBeforeAlertSeconds;
    }

    @JsonProperty(value="max_manual_start_delay_before_alert_seconds")
    public void setMaxManualStartDelayBeforeAlertSeconds_JsonNullable(JsonNullable<Integer> maxManualStartDelayBeforeAlertSeconds) {
        this.maxManualStartDelayBeforeAlertSeconds = maxManualStartDelayBeforeAlertSeconds;
    }

    public void setMaxManualStartDelayBeforeAlertSeconds(Integer maxManualStartDelayBeforeAlertSeconds) {
        this.maxManualStartDelayBeforeAlertSeconds = JsonNullable.of((Object)maxManualStartDelayBeforeAlertSeconds);
    }

    public PatchedTask maxManualStartDelayBeforeAbandonmentSeconds(Integer maxManualStartDelayBeforeAbandonmentSeconds) {
        this.maxManualStartDelayBeforeAbandonmentSeconds = JsonNullable.of((Object)maxManualStartDelayBeforeAbandonmentSeconds);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getMaxManualStartDelayBeforeAbandonmentSeconds() {
        return (Integer)this.maxManualStartDelayBeforeAbandonmentSeconds.orElse(null);
    }

    @JsonProperty(value="max_manual_start_delay_before_abandonment_seconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getMaxManualStartDelayBeforeAbandonmentSeconds_JsonNullable() {
        return this.maxManualStartDelayBeforeAbandonmentSeconds;
    }

    @JsonProperty(value="max_manual_start_delay_before_abandonment_seconds")
    public void setMaxManualStartDelayBeforeAbandonmentSeconds_JsonNullable(JsonNullable<Integer> maxManualStartDelayBeforeAbandonmentSeconds) {
        this.maxManualStartDelayBeforeAbandonmentSeconds = maxManualStartDelayBeforeAbandonmentSeconds;
    }

    public void setMaxManualStartDelayBeforeAbandonmentSeconds(Integer maxManualStartDelayBeforeAbandonmentSeconds) {
        this.maxManualStartDelayBeforeAbandonmentSeconds = JsonNullable.of((Object)maxManualStartDelayBeforeAbandonmentSeconds);
    }

    public PatchedTask heartbeatIntervalSeconds(Integer heartbeatIntervalSeconds) {
        this.heartbeatIntervalSeconds = JsonNullable.of((Object)heartbeatIntervalSeconds);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getHeartbeatIntervalSeconds() {
        return (Integer)this.heartbeatIntervalSeconds.orElse(null);
    }

    @JsonProperty(value="heartbeat_interval_seconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getHeartbeatIntervalSeconds_JsonNullable() {
        return this.heartbeatIntervalSeconds;
    }

    @JsonProperty(value="heartbeat_interval_seconds")
    public void setHeartbeatIntervalSeconds_JsonNullable(JsonNullable<Integer> heartbeatIntervalSeconds) {
        this.heartbeatIntervalSeconds = heartbeatIntervalSeconds;
    }

    public void setHeartbeatIntervalSeconds(Integer heartbeatIntervalSeconds) {
        this.heartbeatIntervalSeconds = JsonNullable.of((Object)heartbeatIntervalSeconds);
    }

    public PatchedTask maxHeartbeatLatenessBeforeAlertSeconds(Integer maxHeartbeatLatenessBeforeAlertSeconds) {
        this.maxHeartbeatLatenessBeforeAlertSeconds = JsonNullable.of((Object)maxHeartbeatLatenessBeforeAlertSeconds);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getMaxHeartbeatLatenessBeforeAlertSeconds() {
        return (Integer)this.maxHeartbeatLatenessBeforeAlertSeconds.orElse(null);
    }

    @JsonProperty(value="max_heartbeat_lateness_before_alert_seconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getMaxHeartbeatLatenessBeforeAlertSeconds_JsonNullable() {
        return this.maxHeartbeatLatenessBeforeAlertSeconds;
    }

    @JsonProperty(value="max_heartbeat_lateness_before_alert_seconds")
    public void setMaxHeartbeatLatenessBeforeAlertSeconds_JsonNullable(JsonNullable<Integer> maxHeartbeatLatenessBeforeAlertSeconds) {
        this.maxHeartbeatLatenessBeforeAlertSeconds = maxHeartbeatLatenessBeforeAlertSeconds;
    }

    public void setMaxHeartbeatLatenessBeforeAlertSeconds(Integer maxHeartbeatLatenessBeforeAlertSeconds) {
        this.maxHeartbeatLatenessBeforeAlertSeconds = JsonNullable.of((Object)maxHeartbeatLatenessBeforeAlertSeconds);
    }

    public PatchedTask maxHeartbeatLatenessBeforeAbandonmentSeconds(Integer maxHeartbeatLatenessBeforeAbandonmentSeconds) {
        this.maxHeartbeatLatenessBeforeAbandonmentSeconds = JsonNullable.of((Object)maxHeartbeatLatenessBeforeAbandonmentSeconds);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getMaxHeartbeatLatenessBeforeAbandonmentSeconds() {
        return (Integer)this.maxHeartbeatLatenessBeforeAbandonmentSeconds.orElse(null);
    }

    @JsonProperty(value="max_heartbeat_lateness_before_abandonment_seconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getMaxHeartbeatLatenessBeforeAbandonmentSeconds_JsonNullable() {
        return this.maxHeartbeatLatenessBeforeAbandonmentSeconds;
    }

    @JsonProperty(value="max_heartbeat_lateness_before_abandonment_seconds")
    public void setMaxHeartbeatLatenessBeforeAbandonmentSeconds_JsonNullable(JsonNullable<Integer> maxHeartbeatLatenessBeforeAbandonmentSeconds) {
        this.maxHeartbeatLatenessBeforeAbandonmentSeconds = maxHeartbeatLatenessBeforeAbandonmentSeconds;
    }

    public void setMaxHeartbeatLatenessBeforeAbandonmentSeconds(Integer maxHeartbeatLatenessBeforeAbandonmentSeconds) {
        this.maxHeartbeatLatenessBeforeAbandonmentSeconds = JsonNullable.of((Object)maxHeartbeatLatenessBeforeAbandonmentSeconds);
    }

    public PatchedTask schedule(String schedule) {
        this.schedule = schedule;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="schedule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSchedule() {
        return this.schedule;
    }

    @JsonProperty(value="schedule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    public PatchedTask scheduledInstanceCount(Integer scheduledInstanceCount) {
        this.scheduledInstanceCount = JsonNullable.of((Object)scheduledInstanceCount);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getScheduledInstanceCount() {
        return (Integer)this.scheduledInstanceCount.orElse(null);
    }

    @JsonProperty(value="scheduled_instance_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getScheduledInstanceCount_JsonNullable() {
        return this.scheduledInstanceCount;
    }

    @JsonProperty(value="scheduled_instance_count")
    public void setScheduledInstanceCount_JsonNullable(JsonNullable<Integer> scheduledInstanceCount) {
        this.scheduledInstanceCount = scheduledInstanceCount;
    }

    public void setScheduledInstanceCount(Integer scheduledInstanceCount) {
        this.scheduledInstanceCount = JsonNullable.of((Object)scheduledInstanceCount);
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="is_service")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsService() {
        return this.isService;
    }

    public PatchedTask serviceInstanceCount(Integer serviceInstanceCount) {
        this.serviceInstanceCount = JsonNullable.of((Object)serviceInstanceCount);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getServiceInstanceCount() {
        return (Integer)this.serviceInstanceCount.orElse(null);
    }

    @JsonProperty(value="service_instance_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getServiceInstanceCount_JsonNullable() {
        return this.serviceInstanceCount;
    }

    @JsonProperty(value="service_instance_count")
    public void setServiceInstanceCount_JsonNullable(JsonNullable<Integer> serviceInstanceCount) {
        this.serviceInstanceCount = serviceInstanceCount;
    }

    public void setServiceInstanceCount(Integer serviceInstanceCount) {
        this.serviceInstanceCount = JsonNullable.of((Object)serviceInstanceCount);
    }

    public PatchedTask minServiceInstanceCount(Integer minServiceInstanceCount) {
        this.minServiceInstanceCount = JsonNullable.of((Object)minServiceInstanceCount);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getMinServiceInstanceCount() {
        return (Integer)this.minServiceInstanceCount.orElse(null);
    }

    @JsonProperty(value="min_service_instance_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getMinServiceInstanceCount_JsonNullable() {
        return this.minServiceInstanceCount;
    }

    @JsonProperty(value="min_service_instance_count")
    public void setMinServiceInstanceCount_JsonNullable(JsonNullable<Integer> minServiceInstanceCount) {
        this.minServiceInstanceCount = minServiceInstanceCount;
    }

    public void setMinServiceInstanceCount(Integer minServiceInstanceCount) {
        this.minServiceInstanceCount = JsonNullable.of((Object)minServiceInstanceCount);
    }

    public PatchedTask maxConcurrency(Integer maxConcurrency) {
        this.maxConcurrency = JsonNullable.of((Object)maxConcurrency);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getMaxConcurrency() {
        return (Integer)this.maxConcurrency.orElse(null);
    }

    @JsonProperty(value="max_concurrency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getMaxConcurrency_JsonNullable() {
        return this.maxConcurrency;
    }

    @JsonProperty(value="max_concurrency")
    public void setMaxConcurrency_JsonNullable(JsonNullable<Integer> maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
    }

    public void setMaxConcurrency(Integer maxConcurrency) {
        this.maxConcurrency = JsonNullable.of((Object)maxConcurrency);
    }

    public PatchedTask maxAgeSeconds(Integer maxAgeSeconds) {
        this.maxAgeSeconds = JsonNullable.of((Object)maxAgeSeconds);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getMaxAgeSeconds() {
        return (Integer)this.maxAgeSeconds.orElse(null);
    }

    @JsonProperty(value="max_age_seconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getMaxAgeSeconds_JsonNullable() {
        return this.maxAgeSeconds;
    }

    @JsonProperty(value="max_age_seconds")
    public void setMaxAgeSeconds_JsonNullable(JsonNullable<Integer> maxAgeSeconds) {
        this.maxAgeSeconds = maxAgeSeconds;
    }

    public void setMaxAgeSeconds(Integer maxAgeSeconds) {
        this.maxAgeSeconds = JsonNullable.of((Object)maxAgeSeconds);
    }

    public PatchedTask defaultMaxRetries(Integer defaultMaxRetries) {
        this.defaultMaxRetries = defaultMaxRetries;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="default_max_retries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getDefaultMaxRetries() {
        return this.defaultMaxRetries;
    }

    @JsonProperty(value="default_max_retries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefaultMaxRetries(Integer defaultMaxRetries) {
        this.defaultMaxRetries = defaultMaxRetries;
    }

    public PatchedTask projectUrl(String projectUrl) {
        this.projectUrl = projectUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="project_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProjectUrl() {
        return this.projectUrl;
    }

    @JsonProperty(value="project_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProjectUrl(String projectUrl) {
        this.projectUrl = projectUrl;
    }

    public PatchedTask logQuery(String logQuery) {
        this.logQuery = logQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="log_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLogQuery() {
        return this.logQuery;
    }

    @JsonProperty(value="log_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLogQuery(String logQuery) {
        this.logQuery = logQuery;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public String getLogsUrl() {
        if (this.logsUrl == null) {
            this.logsUrl = JsonNullable.undefined();
        }
        return (String)this.logsUrl.orElse(null);
    }

    @JsonProperty(value="logs_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getLogsUrl_JsonNullable() {
        return this.logsUrl;
    }

    @JsonProperty(value="logs_url")
    private void setLogsUrl_JsonNullable(JsonNullable<String> logsUrl) {
        this.logsUrl = logsUrl;
    }

    public PatchedTask links(List<Link> links) {
        this.links = links;
        return this;
    }

    public PatchedTask addLinksItem(Link linksItem) {
        if (this.links == null) {
            this.links = new ArrayList<Link>();
        }
        this.links.add(linksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Link> getLinks() {
        return this.links;
    }

    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public PatchedTask runEnvironment(NameAndUuid runEnvironment) {
        this.runEnvironment = JsonNullable.of((Object)runEnvironment);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public NameAndUuid getRunEnvironment() {
        return (NameAndUuid)this.runEnvironment.orElse(null);
    }

    @JsonProperty(value="run_environment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<NameAndUuid> getRunEnvironment_JsonNullable() {
        return this.runEnvironment;
    }

    @JsonProperty(value="run_environment")
    public void setRunEnvironment_JsonNullable(JsonNullable<NameAndUuid> runEnvironment) {
        this.runEnvironment = runEnvironment;
    }

    public void setRunEnvironment(NameAndUuid runEnvironment) {
        this.runEnvironment = JsonNullable.of((Object)runEnvironment);
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public ExecutionMethodCapability getExecutionMethodCapability() {
        if (this.executionMethodCapability == null) {
            this.executionMethodCapability = JsonNullable.undefined();
        }
        return (ExecutionMethodCapability)this.executionMethodCapability.orElse(null);
    }

    @JsonProperty(value="execution_method_capability")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<ExecutionMethodCapability> getExecutionMethodCapability_JsonNullable() {
        return this.executionMethodCapability;
    }

    @JsonProperty(value="execution_method_capability")
    private void setExecutionMethodCapability_JsonNullable(JsonNullable<ExecutionMethodCapability> executionMethodCapability) {
        this.executionMethodCapability = executionMethodCapability;
    }

    public PatchedTask alertMethods(List<NameAndUuid> alertMethods) {
        this.alertMethods = alertMethods;
        return this;
    }

    public PatchedTask addAlertMethodsItem(NameAndUuid alertMethodsItem) {
        if (this.alertMethods == null) {
            this.alertMethods = new ArrayList<NameAndUuid>();
        }
        this.alertMethods.add(alertMethodsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="alert_methods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<NameAndUuid> getAlertMethods() {
        return this.alertMethods;
    }

    @JsonProperty(value="alert_methods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAlertMethods(List<NameAndUuid> alertMethods) {
        this.alertMethods = alertMethods;
    }

    public PatchedTask otherMetadata(Map<String, Object> otherMetadata) {
        this.otherMetadata = JsonNullable.of(otherMetadata);
        return this;
    }

    public PatchedTask putOtherMetadataItem(String key, Object otherMetadataItem) {
        if (this.otherMetadata == null || !this.otherMetadata.isPresent()) {
            this.otherMetadata = JsonNullable.of(new HashMap());
        }
        try {
            ((Map)this.otherMetadata.get()).put(key, otherMetadataItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Map<String, Object> getOtherMetadata() {
        return (Map)this.otherMetadata.orElse(null);
    }

    @JsonProperty(value="other_metadata")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Map<String, Object>> getOtherMetadata_JsonNullable() {
        return this.otherMetadata;
    }

    @JsonProperty(value="other_metadata")
    public void setOtherMetadata_JsonNullable(JsonNullable<Map<String, Object>> otherMetadata) {
        this.otherMetadata = otherMetadata;
    }

    public void setOtherMetadata(Map<String, Object> otherMetadata) {
        this.otherMetadata = JsonNullable.of(otherMetadata);
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public TaskExecution getLatestTaskExecution() {
        if (this.latestTaskExecution == null) {
            this.latestTaskExecution = JsonNullable.undefined();
        }
        return (TaskExecution)this.latestTaskExecution.orElse(null);
    }

    @JsonProperty(value="latest_task_execution")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<TaskExecution> getLatestTaskExecution_JsonNullable() {
        return this.latestTaskExecution;
    }

    @JsonProperty(value="latest_task_execution")
    private void setLatestTaskExecution_JsonNullable(JsonNullable<TaskExecution> latestTaskExecution) {
        this.latestTaskExecution = latestTaskExecution;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public CurrentServiceInfo getCurrentServiceInfo() {
        if (this.currentServiceInfo == null) {
            this.currentServiceInfo = JsonNullable.undefined();
        }
        return (CurrentServiceInfo)this.currentServiceInfo.orElse(null);
    }

    @JsonProperty(value="current_service_info")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<CurrentServiceInfo> getCurrentServiceInfo_JsonNullable() {
        return this.currentServiceInfo;
    }

    @JsonProperty(value="current_service_info")
    private void setCurrentServiceInfo_JsonNullable(JsonNullable<CurrentServiceInfo> currentServiceInfo) {
        this.currentServiceInfo = currentServiceInfo;
    }

    @Nullable
    @ApiModelProperty(value="Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.")
    @JsonProperty(value="created_by_user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCreatedByUser() {
        return this.createdByUser;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Group getCreatedByGroup() {
        if (this.createdByGroup == null) {
            this.createdByGroup = JsonNullable.undefined();
        }
        return (Group)this.createdByGroup.orElse(null);
    }

    @JsonProperty(value="created_by_group")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Group> getCreatedByGroup_JsonNullable() {
        return this.createdByGroup;
    }

    @JsonProperty(value="created_by_group")
    private void setCreatedByGroup_JsonNullable(JsonNullable<Group> createdByGroup) {
        this.createdByGroup = createdByGroup;
    }

    public PatchedTask wasAutoCreated(Boolean wasAutoCreated) {
        this.wasAutoCreated = JsonNullable.of((Object)wasAutoCreated);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Boolean getWasAutoCreated() {
        return (Boolean)this.wasAutoCreated.orElse(null);
    }

    @JsonProperty(value="was_auto_created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Boolean> getWasAutoCreated_JsonNullable() {
        return this.wasAutoCreated;
    }

    @JsonProperty(value="was_auto_created")
    public void setWasAutoCreated_JsonNullable(JsonNullable<Boolean> wasAutoCreated) {
        this.wasAutoCreated = wasAutoCreated;
    }

    public void setWasAutoCreated(Boolean wasAutoCreated) {
        this.wasAutoCreated = JsonNullable.of((Object)wasAutoCreated);
    }

    public PatchedTask passive(Boolean passive) {
        this.passive = passive;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="passive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPassive() {
        return this.passive;
    }

    @JsonProperty(value="passive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPassive(Boolean passive) {
        this.passive = passive;
    }

    public PatchedTask enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatchedTask patchedTask = (PatchedTask)o;
        return Objects.equals(this.url, patchedTask.url) && Objects.equals(this.uuid, patchedTask.uuid) && Objects.equals(this.name, patchedTask.name) && Objects.equals(this.description, patchedTask.description) && Objects.equals(this.dashboardUrl, patchedTask.dashboardUrl) && PatchedTask.equalsNullable(this.infrastructureWebsiteUrl, patchedTask.infrastructureWebsiteUrl) && PatchedTask.equalsNullable(this.maxManualStartDelayBeforeAlertSeconds, patchedTask.maxManualStartDelayBeforeAlertSeconds) && PatchedTask.equalsNullable(this.maxManualStartDelayBeforeAbandonmentSeconds, patchedTask.maxManualStartDelayBeforeAbandonmentSeconds) && PatchedTask.equalsNullable(this.heartbeatIntervalSeconds, patchedTask.heartbeatIntervalSeconds) && PatchedTask.equalsNullable(this.maxHeartbeatLatenessBeforeAlertSeconds, patchedTask.maxHeartbeatLatenessBeforeAlertSeconds) && PatchedTask.equalsNullable(this.maxHeartbeatLatenessBeforeAbandonmentSeconds, patchedTask.maxHeartbeatLatenessBeforeAbandonmentSeconds) && Objects.equals(this.schedule, patchedTask.schedule) && PatchedTask.equalsNullable(this.scheduledInstanceCount, patchedTask.scheduledInstanceCount) && Objects.equals(this.isService, patchedTask.isService) && PatchedTask.equalsNullable(this.serviceInstanceCount, patchedTask.serviceInstanceCount) && PatchedTask.equalsNullable(this.minServiceInstanceCount, patchedTask.minServiceInstanceCount) && PatchedTask.equalsNullable(this.maxConcurrency, patchedTask.maxConcurrency) && PatchedTask.equalsNullable(this.maxAgeSeconds, patchedTask.maxAgeSeconds) && Objects.equals(this.defaultMaxRetries, patchedTask.defaultMaxRetries) && Objects.equals(this.projectUrl, patchedTask.projectUrl) && Objects.equals(this.logQuery, patchedTask.logQuery) && PatchedTask.equalsNullable(this.logsUrl, patchedTask.logsUrl) && Objects.equals(this.links, patchedTask.links) && PatchedTask.equalsNullable(this.runEnvironment, patchedTask.runEnvironment) && PatchedTask.equalsNullable(this.executionMethodCapability, patchedTask.executionMethodCapability) && Objects.equals(this.alertMethods, patchedTask.alertMethods) && PatchedTask.equalsNullable(this.otherMetadata, patchedTask.otherMetadata) && PatchedTask.equalsNullable(this.latestTaskExecution, patchedTask.latestTaskExecution) && PatchedTask.equalsNullable(this.currentServiceInfo, patchedTask.currentServiceInfo) && Objects.equals(this.createdByUser, patchedTask.createdByUser) && PatchedTask.equalsNullable(this.createdByGroup, patchedTask.createdByGroup) && PatchedTask.equalsNullable(this.wasAutoCreated, patchedTask.wasAutoCreated) && Objects.equals(this.passive, patchedTask.passive) && Objects.equals(this.enabled, patchedTask.enabled) && Objects.equals(this.createdAt, patchedTask.createdAt) && Objects.equals(this.updatedAt, patchedTask.updatedAt);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.url, this.uuid, this.name, this.description, this.dashboardUrl, PatchedTask.hashCodeNullable(this.infrastructureWebsiteUrl), PatchedTask.hashCodeNullable(this.maxManualStartDelayBeforeAlertSeconds), PatchedTask.hashCodeNullable(this.maxManualStartDelayBeforeAbandonmentSeconds), PatchedTask.hashCodeNullable(this.heartbeatIntervalSeconds), PatchedTask.hashCodeNullable(this.maxHeartbeatLatenessBeforeAlertSeconds), PatchedTask.hashCodeNullable(this.maxHeartbeatLatenessBeforeAbandonmentSeconds), this.schedule, PatchedTask.hashCodeNullable(this.scheduledInstanceCount), this.isService, PatchedTask.hashCodeNullable(this.serviceInstanceCount), PatchedTask.hashCodeNullable(this.minServiceInstanceCount), PatchedTask.hashCodeNullable(this.maxConcurrency), PatchedTask.hashCodeNullable(this.maxAgeSeconds), this.defaultMaxRetries, this.projectUrl, this.logQuery, PatchedTask.hashCodeNullable(this.logsUrl), this.links, PatchedTask.hashCodeNullable(this.runEnvironment), PatchedTask.hashCodeNullable(this.executionMethodCapability), this.alertMethods, PatchedTask.hashCodeNullable(this.otherMetadata), PatchedTask.hashCodeNullable(this.latestTaskExecution), PatchedTask.hashCodeNullable(this.currentServiceInfo), this.createdByUser, PatchedTask.hashCodeNullable(this.createdByGroup), PatchedTask.hashCodeNullable(this.wasAutoCreated), this.passive, this.enabled, this.createdAt, this.updatedAt);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PatchedTask {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    dashboardUrl: ").append(this.toIndentedString(this.dashboardUrl)).append("\n");
        sb.append("    infrastructureWebsiteUrl: ").append(this.toIndentedString(this.infrastructureWebsiteUrl)).append("\n");
        sb.append("    maxManualStartDelayBeforeAlertSeconds: ").append(this.toIndentedString(this.maxManualStartDelayBeforeAlertSeconds)).append("\n");
        sb.append("    maxManualStartDelayBeforeAbandonmentSeconds: ").append(this.toIndentedString(this.maxManualStartDelayBeforeAbandonmentSeconds)).append("\n");
        sb.append("    heartbeatIntervalSeconds: ").append(this.toIndentedString(this.heartbeatIntervalSeconds)).append("\n");
        sb.append("    maxHeartbeatLatenessBeforeAlertSeconds: ").append(this.toIndentedString(this.maxHeartbeatLatenessBeforeAlertSeconds)).append("\n");
        sb.append("    maxHeartbeatLatenessBeforeAbandonmentSeconds: ").append(this.toIndentedString(this.maxHeartbeatLatenessBeforeAbandonmentSeconds)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("    scheduledInstanceCount: ").append(this.toIndentedString(this.scheduledInstanceCount)).append("\n");
        sb.append("    isService: ").append(this.toIndentedString(this.isService)).append("\n");
        sb.append("    serviceInstanceCount: ").append(this.toIndentedString(this.serviceInstanceCount)).append("\n");
        sb.append("    minServiceInstanceCount: ").append(this.toIndentedString(this.minServiceInstanceCount)).append("\n");
        sb.append("    maxConcurrency: ").append(this.toIndentedString(this.maxConcurrency)).append("\n");
        sb.append("    maxAgeSeconds: ").append(this.toIndentedString(this.maxAgeSeconds)).append("\n");
        sb.append("    defaultMaxRetries: ").append(this.toIndentedString(this.defaultMaxRetries)).append("\n");
        sb.append("    projectUrl: ").append(this.toIndentedString(this.projectUrl)).append("\n");
        sb.append("    logQuery: ").append(this.toIndentedString(this.logQuery)).append("\n");
        sb.append("    logsUrl: ").append(this.toIndentedString(this.logsUrl)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    runEnvironment: ").append(this.toIndentedString(this.runEnvironment)).append("\n");
        sb.append("    executionMethodCapability: ").append(this.toIndentedString(this.executionMethodCapability)).append("\n");
        sb.append("    alertMethods: ").append(this.toIndentedString(this.alertMethods)).append("\n");
        sb.append("    otherMetadata: ").append(this.toIndentedString(this.otherMetadata)).append("\n");
        sb.append("    latestTaskExecution: ").append(this.toIndentedString(this.latestTaskExecution)).append("\n");
        sb.append("    currentServiceInfo: ").append(this.toIndentedString(this.currentServiceInfo)).append("\n");
        sb.append("    createdByUser: ").append(this.toIndentedString(this.createdByUser)).append("\n");
        sb.append("    createdByGroup: ").append(this.toIndentedString(this.createdByGroup)).append("\n");
        sb.append("    wasAutoCreated: ").append(this.toIndentedString(this.wasAutoCreated)).append("\n");
        sb.append("    passive: ").append(this.toIndentedString(this.passive)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

