/*
 * Decompiled with CFR 0.152.
 */
package io.cloudreactor.tasksymphony.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.cloudreactor.tasksymphony.model.Group;
import io.cloudreactor.tasksymphony.model.NameAndUuid;
import io.cloudreactor.tasksymphony.model.WorkflowExecutionSummary;
import io.cloudreactor.tasksymphony.model.WorkflowTaskInstance;
import io.cloudreactor.tasksymphony.model.WorkflowTransition;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Workflows are Tasks arranged in a directed graph. Configured Tasks are held by WorkflowTaskInstances, and WorkflowTransitions connect WorkflowTaskInstances together.")
@JsonPropertyOrder(value={"url", "uuid", "name", "description", "dashboard_url", "schedule", "max_concurrency", "max_age_seconds", "default_max_retries", "latest_workflow_execution", "created_by_user", "created_by_group", "run_environment", "enabled", "created_at", "updated_at", "alert_methods", "workflow_task_instances", "workflow_transitions"})
@JsonTypeName(value="PatchedWorkflow")
public class PatchedWorkflow {
    public static final String JSON_PROPERTY_URL = "url";
    private URI url;
    public static final String JSON_PROPERTY_UUID = "uuid";
    private UUID uuid;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_DASHBOARD_URL = "dashboard_url";
    private String dashboardUrl;
    public static final String JSON_PROPERTY_SCHEDULE = "schedule";
    private String schedule;
    public static final String JSON_PROPERTY_MAX_CONCURRENCY = "max_concurrency";
    private JsonNullable<Integer> maxConcurrency = JsonNullable.undefined();
    public static final String JSON_PROPERTY_MAX_AGE_SECONDS = "max_age_seconds";
    private JsonNullable<Integer> maxAgeSeconds = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DEFAULT_MAX_RETRIES = "default_max_retries";
    private Integer defaultMaxRetries;
    public static final String JSON_PROPERTY_LATEST_WORKFLOW_EXECUTION = "latest_workflow_execution";
    private WorkflowExecutionSummary latestWorkflowExecution;
    public static final String JSON_PROPERTY_CREATED_BY_USER = "created_by_user";
    private String createdByUser;
    public static final String JSON_PROPERTY_CREATED_BY_GROUP = "created_by_group";
    private JsonNullable<Group> createdByGroup = JsonNullable.undefined();
    public static final String JSON_PROPERTY_RUN_ENVIRONMENT = "run_environment";
    private JsonNullable<NameAndUuid> runEnvironment = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private OffsetDateTime updatedAt;
    public static final String JSON_PROPERTY_ALERT_METHODS = "alert_methods";
    private List<NameAndUuid> alertMethods = null;
    public static final String JSON_PROPERTY_WORKFLOW_TASK_INSTANCES = "workflow_task_instances";
    private List<WorkflowTaskInstance> workflowTaskInstances = null;
    public static final String JSON_PROPERTY_WORKFLOW_TRANSITIONS = "workflow_transitions";
    private List<WorkflowTransition> workflowTransitions = null;

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public URI getUrl() {
        return this.url;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="uuid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getUuid() {
        return this.uuid;
    }

    public PatchedWorkflow name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public PatchedWorkflow description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="dashboard_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDashboardUrl() {
        return this.dashboardUrl;
    }

    public PatchedWorkflow schedule(String schedule) {
        this.schedule = schedule;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="schedule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSchedule() {
        return this.schedule;
    }

    @JsonProperty(value="schedule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    public PatchedWorkflow maxConcurrency(Integer maxConcurrency) {
        this.maxConcurrency = JsonNullable.of((Object)maxConcurrency);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getMaxConcurrency() {
        return (Integer)this.maxConcurrency.orElse(null);
    }

    @JsonProperty(value="max_concurrency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getMaxConcurrency_JsonNullable() {
        return this.maxConcurrency;
    }

    @JsonProperty(value="max_concurrency")
    public void setMaxConcurrency_JsonNullable(JsonNullable<Integer> maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
    }

    public void setMaxConcurrency(Integer maxConcurrency) {
        this.maxConcurrency = JsonNullable.of((Object)maxConcurrency);
    }

    public PatchedWorkflow maxAgeSeconds(Integer maxAgeSeconds) {
        this.maxAgeSeconds = JsonNullable.of((Object)maxAgeSeconds);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getMaxAgeSeconds() {
        return (Integer)this.maxAgeSeconds.orElse(null);
    }

    @JsonProperty(value="max_age_seconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getMaxAgeSeconds_JsonNullable() {
        return this.maxAgeSeconds;
    }

    @JsonProperty(value="max_age_seconds")
    public void setMaxAgeSeconds_JsonNullable(JsonNullable<Integer> maxAgeSeconds) {
        this.maxAgeSeconds = maxAgeSeconds;
    }

    public void setMaxAgeSeconds(Integer maxAgeSeconds) {
        this.maxAgeSeconds = JsonNullable.of((Object)maxAgeSeconds);
    }

    public PatchedWorkflow defaultMaxRetries(Integer defaultMaxRetries) {
        this.defaultMaxRetries = defaultMaxRetries;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="default_max_retries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getDefaultMaxRetries() {
        return this.defaultMaxRetries;
    }

    @JsonProperty(value="default_max_retries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefaultMaxRetries(Integer defaultMaxRetries) {
        this.defaultMaxRetries = defaultMaxRetries;
    }

    public PatchedWorkflow latestWorkflowExecution(WorkflowExecutionSummary latestWorkflowExecution) {
        this.latestWorkflowExecution = latestWorkflowExecution;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="latest_workflow_execution")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WorkflowExecutionSummary getLatestWorkflowExecution() {
        return this.latestWorkflowExecution;
    }

    @JsonProperty(value="latest_workflow_execution")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLatestWorkflowExecution(WorkflowExecutionSummary latestWorkflowExecution) {
        this.latestWorkflowExecution = latestWorkflowExecution;
    }

    @Nullable
    @ApiModelProperty(value="Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.")
    @JsonProperty(value="created_by_user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCreatedByUser() {
        return this.createdByUser;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Group getCreatedByGroup() {
        if (this.createdByGroup == null) {
            this.createdByGroup = JsonNullable.undefined();
        }
        return (Group)this.createdByGroup.orElse(null);
    }

    @JsonProperty(value="created_by_group")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Group> getCreatedByGroup_JsonNullable() {
        return this.createdByGroup;
    }

    @JsonProperty(value="created_by_group")
    private void setCreatedByGroup_JsonNullable(JsonNullable<Group> createdByGroup) {
        this.createdByGroup = createdByGroup;
    }

    public PatchedWorkflow runEnvironment(NameAndUuid runEnvironment) {
        this.runEnvironment = JsonNullable.of((Object)runEnvironment);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public NameAndUuid getRunEnvironment() {
        return (NameAndUuid)this.runEnvironment.orElse(null);
    }

    @JsonProperty(value="run_environment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<NameAndUuid> getRunEnvironment_JsonNullable() {
        return this.runEnvironment;
    }

    @JsonProperty(value="run_environment")
    public void setRunEnvironment_JsonNullable(JsonNullable<NameAndUuid> runEnvironment) {
        this.runEnvironment = runEnvironment;
    }

    public void setRunEnvironment(NameAndUuid runEnvironment) {
        this.runEnvironment = JsonNullable.of((Object)runEnvironment);
    }

    public PatchedWorkflow enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public PatchedWorkflow alertMethods(List<NameAndUuid> alertMethods) {
        this.alertMethods = alertMethods;
        return this;
    }

    public PatchedWorkflow addAlertMethodsItem(NameAndUuid alertMethodsItem) {
        if (this.alertMethods == null) {
            this.alertMethods = new ArrayList<NameAndUuid>();
        }
        this.alertMethods.add(alertMethodsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="alert_methods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<NameAndUuid> getAlertMethods() {
        return this.alertMethods;
    }

    @JsonProperty(value="alert_methods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAlertMethods(List<NameAndUuid> alertMethods) {
        this.alertMethods = alertMethods;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="workflow_task_instances")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WorkflowTaskInstance> getWorkflowTaskInstances() {
        return this.workflowTaskInstances;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="workflow_transitions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WorkflowTransition> getWorkflowTransitions() {
        return this.workflowTransitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatchedWorkflow patchedWorkflow = (PatchedWorkflow)o;
        return Objects.equals(this.url, patchedWorkflow.url) && Objects.equals(this.uuid, patchedWorkflow.uuid) && Objects.equals(this.name, patchedWorkflow.name) && Objects.equals(this.description, patchedWorkflow.description) && Objects.equals(this.dashboardUrl, patchedWorkflow.dashboardUrl) && Objects.equals(this.schedule, patchedWorkflow.schedule) && PatchedWorkflow.equalsNullable(this.maxConcurrency, patchedWorkflow.maxConcurrency) && PatchedWorkflow.equalsNullable(this.maxAgeSeconds, patchedWorkflow.maxAgeSeconds) && Objects.equals(this.defaultMaxRetries, patchedWorkflow.defaultMaxRetries) && Objects.equals(this.latestWorkflowExecution, patchedWorkflow.latestWorkflowExecution) && Objects.equals(this.createdByUser, patchedWorkflow.createdByUser) && PatchedWorkflow.equalsNullable(this.createdByGroup, patchedWorkflow.createdByGroup) && PatchedWorkflow.equalsNullable(this.runEnvironment, patchedWorkflow.runEnvironment) && Objects.equals(this.enabled, patchedWorkflow.enabled) && Objects.equals(this.createdAt, patchedWorkflow.createdAt) && Objects.equals(this.updatedAt, patchedWorkflow.updatedAt) && Objects.equals(this.alertMethods, patchedWorkflow.alertMethods) && Objects.equals(this.workflowTaskInstances, patchedWorkflow.workflowTaskInstances) && Objects.equals(this.workflowTransitions, patchedWorkflow.workflowTransitions);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.url, this.uuid, this.name, this.description, this.dashboardUrl, this.schedule, PatchedWorkflow.hashCodeNullable(this.maxConcurrency), PatchedWorkflow.hashCodeNullable(this.maxAgeSeconds), this.defaultMaxRetries, this.latestWorkflowExecution, this.createdByUser, PatchedWorkflow.hashCodeNullable(this.createdByGroup), PatchedWorkflow.hashCodeNullable(this.runEnvironment), this.enabled, this.createdAt, this.updatedAt, this.alertMethods, this.workflowTaskInstances, this.workflowTransitions);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PatchedWorkflow {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    dashboardUrl: ").append(this.toIndentedString(this.dashboardUrl)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("    maxConcurrency: ").append(this.toIndentedString(this.maxConcurrency)).append("\n");
        sb.append("    maxAgeSeconds: ").append(this.toIndentedString(this.maxAgeSeconds)).append("\n");
        sb.append("    defaultMaxRetries: ").append(this.toIndentedString(this.defaultMaxRetries)).append("\n");
        sb.append("    latestWorkflowExecution: ").append(this.toIndentedString(this.latestWorkflowExecution)).append("\n");
        sb.append("    createdByUser: ").append(this.toIndentedString(this.createdByUser)).append("\n");
        sb.append("    createdByGroup: ").append(this.toIndentedString(this.createdByGroup)).append("\n");
        sb.append("    runEnvironment: ").append(this.toIndentedString(this.runEnvironment)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    alertMethods: ").append(this.toIndentedString(this.alertMethods)).append("\n");
        sb.append("    workflowTaskInstances: ").append(this.toIndentedString(this.workflowTaskInstances)).append("\n");
        sb.append("    workflowTransitions: ").append(this.toIndentedString(this.workflowTransitions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

