/*
 * Decompiled with CFR 0.152.
 */
package io.cloudreactor.tasksymphony.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.cloudreactor.tasksymphony.model.AwsEcsRunEnvironmentExecutionMethodCapability;
import io.cloudreactor.tasksymphony.model.Group;
import io.cloudreactor.tasksymphony.model.NameAndUuid;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="RunEnvironments contain common settings for running a set of related Tasks. Usually RunEnvironments group Tasks in the same deployment environment (e.g. staging or production). Task and Workflows belong to a RunEnvironment but can override the RunEnvironment's settings.")
@JsonPropertyOrder(value={"url", "uuid", "name", "description", "dashboard_url", "created_by_user", "created_by_group", "created_at", "updated_at", "aws_account_id", "aws_default_region", "aws_access_key", "aws_assumed_role_external_id", "aws_events_role_arn", "aws_workflow_starter_lambda_arn", "aws_workflow_starter_access_key", "default_alert_methods", "execution_method_capabilities"})
@JsonTypeName(value="RunEnvironment")
public class RunEnvironment {
    public static final String JSON_PROPERTY_URL = "url";
    private URI url;
    public static final String JSON_PROPERTY_UUID = "uuid";
    private UUID uuid;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_DASHBOARD_URL = "dashboard_url";
    private String dashboardUrl;
    public static final String JSON_PROPERTY_CREATED_BY_USER = "created_by_user";
    private String createdByUser;
    public static final String JSON_PROPERTY_CREATED_BY_GROUP = "created_by_group";
    private Group createdByGroup;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private OffsetDateTime updatedAt;
    public static final String JSON_PROPERTY_AWS_ACCOUNT_ID = "aws_account_id";
    private String awsAccountId;
    public static final String JSON_PROPERTY_AWS_DEFAULT_REGION = "aws_default_region";
    private String awsDefaultRegion;
    public static final String JSON_PROPERTY_AWS_ACCESS_KEY = "aws_access_key";
    private String awsAccessKey;
    public static final String JSON_PROPERTY_AWS_ASSUMED_ROLE_EXTERNAL_ID = "aws_assumed_role_external_id";
    private String awsAssumedRoleExternalId;
    public static final String JSON_PROPERTY_AWS_EVENTS_ROLE_ARN = "aws_events_role_arn";
    private String awsEventsRoleArn;
    public static final String JSON_PROPERTY_AWS_WORKFLOW_STARTER_LAMBDA_ARN = "aws_workflow_starter_lambda_arn";
    private String awsWorkflowStarterLambdaArn;
    public static final String JSON_PROPERTY_AWS_WORKFLOW_STARTER_ACCESS_KEY = "aws_workflow_starter_access_key";
    private String awsWorkflowStarterAccessKey;
    public static final String JSON_PROPERTY_DEFAULT_ALERT_METHODS = "default_alert_methods";
    private List<NameAndUuid> defaultAlertMethods = null;
    public static final String JSON_PROPERTY_EXECUTION_METHOD_CAPABILITIES = "execution_method_capabilities";
    private List<AwsEcsRunEnvironmentExecutionMethodCapability> executionMethodCapabilities = new ArrayList<AwsEcsRunEnvironmentExecutionMethodCapability>();

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public URI getUrl() {
        return this.url;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="uuid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getUuid() {
        return this.uuid;
    }

    public RunEnvironment name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public RunEnvironment description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="dashboard_url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDashboardUrl() {
        return this.dashboardUrl;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.")
    @JsonProperty(value="created_by_user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCreatedByUser() {
        return this.createdByUser;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="created_by_group")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Group getCreatedByGroup() {
        return this.createdByGroup;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public RunEnvironment awsAccountId(String awsAccountId) {
        this.awsAccountId = awsAccountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="aws_account_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAwsAccountId() {
        return this.awsAccountId;
    }

    @JsonProperty(value="aws_account_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAwsAccountId(String awsAccountId) {
        this.awsAccountId = awsAccountId;
    }

    public RunEnvironment awsDefaultRegion(String awsDefaultRegion) {
        this.awsDefaultRegion = awsDefaultRegion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="aws_default_region")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAwsDefaultRegion() {
        return this.awsDefaultRegion;
    }

    @JsonProperty(value="aws_default_region")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAwsDefaultRegion(String awsDefaultRegion) {
        this.awsDefaultRegion = awsDefaultRegion;
    }

    public RunEnvironment awsAccessKey(String awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="aws_access_key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAwsAccessKey() {
        return this.awsAccessKey;
    }

    @JsonProperty(value="aws_access_key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAwsAccessKey(String awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
    }

    public RunEnvironment awsAssumedRoleExternalId(String awsAssumedRoleExternalId) {
        this.awsAssumedRoleExternalId = awsAssumedRoleExternalId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="aws_assumed_role_external_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAwsAssumedRoleExternalId() {
        return this.awsAssumedRoleExternalId;
    }

    @JsonProperty(value="aws_assumed_role_external_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAwsAssumedRoleExternalId(String awsAssumedRoleExternalId) {
        this.awsAssumedRoleExternalId = awsAssumedRoleExternalId;
    }

    public RunEnvironment awsEventsRoleArn(String awsEventsRoleArn) {
        this.awsEventsRoleArn = awsEventsRoleArn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="aws_events_role_arn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAwsEventsRoleArn() {
        return this.awsEventsRoleArn;
    }

    @JsonProperty(value="aws_events_role_arn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAwsEventsRoleArn(String awsEventsRoleArn) {
        this.awsEventsRoleArn = awsEventsRoleArn;
    }

    public RunEnvironment awsWorkflowStarterLambdaArn(String awsWorkflowStarterLambdaArn) {
        this.awsWorkflowStarterLambdaArn = awsWorkflowStarterLambdaArn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="aws_workflow_starter_lambda_arn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAwsWorkflowStarterLambdaArn() {
        return this.awsWorkflowStarterLambdaArn;
    }

    @JsonProperty(value="aws_workflow_starter_lambda_arn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAwsWorkflowStarterLambdaArn(String awsWorkflowStarterLambdaArn) {
        this.awsWorkflowStarterLambdaArn = awsWorkflowStarterLambdaArn;
    }

    public RunEnvironment awsWorkflowStarterAccessKey(String awsWorkflowStarterAccessKey) {
        this.awsWorkflowStarterAccessKey = awsWorkflowStarterAccessKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="aws_workflow_starter_access_key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAwsWorkflowStarterAccessKey() {
        return this.awsWorkflowStarterAccessKey;
    }

    @JsonProperty(value="aws_workflow_starter_access_key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAwsWorkflowStarterAccessKey(String awsWorkflowStarterAccessKey) {
        this.awsWorkflowStarterAccessKey = awsWorkflowStarterAccessKey;
    }

    public RunEnvironment defaultAlertMethods(List<NameAndUuid> defaultAlertMethods) {
        this.defaultAlertMethods = defaultAlertMethods;
        return this;
    }

    public RunEnvironment addDefaultAlertMethodsItem(NameAndUuid defaultAlertMethodsItem) {
        if (this.defaultAlertMethods == null) {
            this.defaultAlertMethods = new ArrayList<NameAndUuid>();
        }
        this.defaultAlertMethods.add(defaultAlertMethodsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="default_alert_methods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<NameAndUuid> getDefaultAlertMethods() {
        return this.defaultAlertMethods;
    }

    @JsonProperty(value="default_alert_methods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefaultAlertMethods(List<NameAndUuid> defaultAlertMethods) {
        this.defaultAlertMethods = defaultAlertMethods;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="execution_method_capabilities")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<AwsEcsRunEnvironmentExecutionMethodCapability> getExecutionMethodCapabilities() {
        return this.executionMethodCapabilities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunEnvironment runEnvironment = (RunEnvironment)o;
        return Objects.equals(this.url, runEnvironment.url) && Objects.equals(this.uuid, runEnvironment.uuid) && Objects.equals(this.name, runEnvironment.name) && Objects.equals(this.description, runEnvironment.description) && Objects.equals(this.dashboardUrl, runEnvironment.dashboardUrl) && Objects.equals(this.createdByUser, runEnvironment.createdByUser) && Objects.equals(this.createdByGroup, runEnvironment.createdByGroup) && Objects.equals(this.createdAt, runEnvironment.createdAt) && Objects.equals(this.updatedAt, runEnvironment.updatedAt) && Objects.equals(this.awsAccountId, runEnvironment.awsAccountId) && Objects.equals(this.awsDefaultRegion, runEnvironment.awsDefaultRegion) && Objects.equals(this.awsAccessKey, runEnvironment.awsAccessKey) && Objects.equals(this.awsAssumedRoleExternalId, runEnvironment.awsAssumedRoleExternalId) && Objects.equals(this.awsEventsRoleArn, runEnvironment.awsEventsRoleArn) && Objects.equals(this.awsWorkflowStarterLambdaArn, runEnvironment.awsWorkflowStarterLambdaArn) && Objects.equals(this.awsWorkflowStarterAccessKey, runEnvironment.awsWorkflowStarterAccessKey) && Objects.equals(this.defaultAlertMethods, runEnvironment.defaultAlertMethods) && Objects.equals(this.executionMethodCapabilities, runEnvironment.executionMethodCapabilities);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.uuid, this.name, this.description, this.dashboardUrl, this.createdByUser, this.createdByGroup, this.createdAt, this.updatedAt, this.awsAccountId, this.awsDefaultRegion, this.awsAccessKey, this.awsAssumedRoleExternalId, this.awsEventsRoleArn, this.awsWorkflowStarterLambdaArn, this.awsWorkflowStarterAccessKey, this.defaultAlertMethods, this.executionMethodCapabilities);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RunEnvironment {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    dashboardUrl: ").append(this.toIndentedString(this.dashboardUrl)).append("\n");
        sb.append("    createdByUser: ").append(this.toIndentedString(this.createdByUser)).append("\n");
        sb.append("    createdByGroup: ").append(this.toIndentedString(this.createdByGroup)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    awsAccountId: ").append(this.toIndentedString(this.awsAccountId)).append("\n");
        sb.append("    awsDefaultRegion: ").append(this.toIndentedString(this.awsDefaultRegion)).append("\n");
        sb.append("    awsAccessKey: ").append(this.toIndentedString(this.awsAccessKey)).append("\n");
        sb.append("    awsAssumedRoleExternalId: ").append(this.toIndentedString(this.awsAssumedRoleExternalId)).append("\n");
        sb.append("    awsEventsRoleArn: ").append(this.toIndentedString(this.awsEventsRoleArn)).append("\n");
        sb.append("    awsWorkflowStarterLambdaArn: ").append(this.toIndentedString(this.awsWorkflowStarterLambdaArn)).append("\n");
        sb.append("    awsWorkflowStarterAccessKey: ").append(this.toIndentedString(this.awsWorkflowStarterAccessKey)).append("\n");
        sb.append("    defaultAlertMethods: ").append(this.toIndentedString(this.defaultAlertMethods)).append("\n");
        sb.append("    executionMethodCapabilities: ").append(this.toIndentedString(this.executionMethodCapabilities)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

