/*
 * Decompiled with CFR 0.152.
 */
package io.cloudreactor.tasksymphony.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.cloudreactor.tasksymphony.model.AwsEcsExecutionMethod;
import io.cloudreactor.tasksymphony.model.NameAndUuid;
import io.cloudreactor.tasksymphony.model.StopReasonEnum;
import io.cloudreactor.tasksymphony.model.TaskExecutionStatus;
import io.cloudreactor.tasksymphony.model.WorkflowTaskInstanceExecutionBase;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="A Task Execution is an execution / run instance of a Task.")
@JsonPropertyOrder(value={"url", "uuid", "dashboard_url", "infrastructure_website_url", "task", "task_version_number", "task_version_text", "task_version_signature", "commit_url", "other_instance_metadata", "hostname", "environment_variables_overrides", "execution_method", "status", "started_by", "started_at", "finished_at", "marked_done_by", "marked_done_at", "marked_outdated_at", "killed_by", "kill_started_at", "kill_finished_at", "kill_error_code", "stop_reason", "last_heartbeat_at", "failed_attempts", "timed_out_attempts", "exit_code", "last_status_message", "error_count", "skipped_count", "expected_count", "success_count", "other_runtime_metadata", "current_cpu_units", "mean_cpu_units", "max_cpu_units", "current_memory_mb", "mean_memory_mb", "max_memory_mb", "wrapper_version", "wrapper_log_level", "deployment", "process_command", "is_service", "task_max_concurrency", "max_conflicting_age_seconds", "prevent_offline_execution", "process_timeout_seconds", "process_termination_grace_period_seconds", "process_max_retries", "process_retry_delay_seconds", "schedule", "heartbeat_interval_seconds", "workflow_task_instance_execution", "api_base_url", "api_request_timeout_seconds", "api_retry_delay_seconds", "api_resume_delay_seconds", "api_error_timeout_seconds", "api_task_execution_creation_error_timeout_seconds", "api_task_execution_creation_conflict_timeout_seconds", "api_task_execution_creation_conflict_retry_delay_seconds", "api_final_update_timeout_seconds", "status_update_interval_seconds", "status_update_port", "status_update_message_max_bytes", "debug_log_tail", "error_log_tail", "embedded_mode", "created_at", "updated_at"})
@JsonTypeName(value="TaskExecution")
public class TaskExecution {
    public static final String JSON_PROPERTY_URL = "url";
    private URI url;
    public static final String JSON_PROPERTY_UUID = "uuid";
    private UUID uuid;
    public static final String JSON_PROPERTY_DASHBOARD_URL = "dashboard_url";
    private String dashboardUrl;
    public static final String JSON_PROPERTY_INFRASTRUCTURE_WEBSITE_URL = "infrastructure_website_url";
    private String infrastructureWebsiteUrl;
    public static final String JSON_PROPERTY_TASK = "task";
    private NameAndUuid task;
    public static final String JSON_PROPERTY_TASK_VERSION_NUMBER = "task_version_number";
    private JsonNullable<Long> taskVersionNumber = JsonNullable.undefined();
    public static final String JSON_PROPERTY_TASK_VERSION_TEXT = "task_version_text";
    private JsonNullable<String> taskVersionText = JsonNullable.undefined();
    public static final String JSON_PROPERTY_TASK_VERSION_SIGNATURE = "task_version_signature";
    private JsonNullable<String> taskVersionSignature = JsonNullable.undefined();
    public static final String JSON_PROPERTY_COMMIT_URL = "commit_url";
    private String commitUrl;
    public static final String JSON_PROPERTY_OTHER_INSTANCE_METADATA = "other_instance_metadata";
    private JsonNullable<Map<String, Object>> otherInstanceMetadata = JsonNullable.undefined();
    public static final String JSON_PROPERTY_HOSTNAME = "hostname";
    private JsonNullable<String> hostname = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ENVIRONMENT_VARIABLES_OVERRIDES = "environment_variables_overrides";
    private JsonNullable<Map<String, Object>> environmentVariablesOverrides = JsonNullable.undefined();
    public static final String JSON_PROPERTY_EXECUTION_METHOD = "execution_method";
    private AwsEcsExecutionMethod executionMethod;
    public static final String JSON_PROPERTY_STATUS = "status";
    private TaskExecutionStatus status;
    public static final String JSON_PROPERTY_STARTED_BY = "started_by";
    private String startedBy;
    public static final String JSON_PROPERTY_STARTED_AT = "started_at";
    private OffsetDateTime startedAt;
    public static final String JSON_PROPERTY_FINISHED_AT = "finished_at";
    private JsonNullable<OffsetDateTime> finishedAt = JsonNullable.undefined();
    public static final String JSON_PROPERTY_MARKED_DONE_BY = "marked_done_by";
    private String markedDoneBy;
    public static final String JSON_PROPERTY_MARKED_DONE_AT = "marked_done_at";
    private JsonNullable<OffsetDateTime> markedDoneAt = JsonNullable.undefined();
    public static final String JSON_PROPERTY_MARKED_OUTDATED_AT = "marked_outdated_at";
    private JsonNullable<OffsetDateTime> markedOutdatedAt = JsonNullable.undefined();
    public static final String JSON_PROPERTY_KILLED_BY = "killed_by";
    private String killedBy;
    public static final String JSON_PROPERTY_KILL_STARTED_AT = "kill_started_at";
    private JsonNullable<OffsetDateTime> killStartedAt = JsonNullable.undefined();
    public static final String JSON_PROPERTY_KILL_FINISHED_AT = "kill_finished_at";
    private JsonNullable<OffsetDateTime> killFinishedAt = JsonNullable.undefined();
    public static final String JSON_PROPERTY_KILL_ERROR_CODE = "kill_error_code";
    private JsonNullable<Integer> killErrorCode = JsonNullable.undefined();
    public static final String JSON_PROPERTY_STOP_REASON = "stop_reason";
    private StopReasonEnum stopReason;
    public static final String JSON_PROPERTY_LAST_HEARTBEAT_AT = "last_heartbeat_at";
    private JsonNullable<OffsetDateTime> lastHeartbeatAt = JsonNullable.undefined();
    public static final String JSON_PROPERTY_FAILED_ATTEMPTS = "failed_attempts";
    private Integer failedAttempts;
    public static final String JSON_PROPERTY_TIMED_OUT_ATTEMPTS = "timed_out_attempts";
    private Integer timedOutAttempts;
    public static final String JSON_PROPERTY_EXIT_CODE = "exit_code";
    private JsonNullable<Integer> exitCode = JsonNullable.undefined();
    public static final String JSON_PROPERTY_LAST_STATUS_MESSAGE = "last_status_message";
    private JsonNullable<String> lastStatusMessage = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ERROR_COUNT = "error_count";
    private JsonNullable<Long> errorCount = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SKIPPED_COUNT = "skipped_count";
    private JsonNullable<Long> skippedCount = JsonNullable.undefined();
    public static final String JSON_PROPERTY_EXPECTED_COUNT = "expected_count";
    private JsonNullable<Long> expectedCount = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SUCCESS_COUNT = "success_count";
    private JsonNullable<Long> successCount = JsonNullable.undefined();
    public static final String JSON_PROPERTY_OTHER_RUNTIME_METADATA = "other_runtime_metadata";
    private JsonNullable<Map<String, Object>> otherRuntimeMetadata = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CURRENT_CPU_UNITS = "current_cpu_units";
    private JsonNullable<Integer> currentCpuUnits = JsonNullable.undefined();
    public static final String JSON_PROPERTY_MEAN_CPU_UNITS = "mean_cpu_units";
    private JsonNullable<Integer> meanCpuUnits = JsonNullable.undefined();
    public static final String JSON_PROPERTY_MAX_CPU_UNITS = "max_cpu_units";
    private JsonNullable<Integer> maxCpuUnits = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CURRENT_MEMORY_MB = "current_memory_mb";
    private JsonNullable<Integer> currentMemoryMb = JsonNullable.undefined();
    public static final String JSON_PROPERTY_MEAN_MEMORY_MB = "mean_memory_mb";
    private JsonNullable<Integer> meanMemoryMb = JsonNullable.undefined();
    public static final String JSON_PROPERTY_MAX_MEMORY_MB = "max_memory_mb";
    private JsonNullable<Integer> maxMemoryMb = JsonNullable.undefined();
    public static final String JSON_PROPERTY_WRAPPER_VERSION = "wrapper_version";
    private JsonNullable<String> wrapperVersion = JsonNullable.undefined();
    public static final String JSON_PROPERTY_WRAPPER_LOG_LEVEL = "wrapper_log_level";
    private JsonNullable<String> wrapperLogLevel = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DEPLOYMENT = "deployment";
    private JsonNullable<String> deployment = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PROCESS_COMMAND = "process_command";
    private JsonNullable<String> processCommand = JsonNullable.undefined();
    public static final String JSON_PROPERTY_IS_SERVICE = "is_service";
    private JsonNullable<Boolean> isService = JsonNullable.undefined();
    public static final String JSON_PROPERTY_TASK_MAX_CONCURRENCY = "task_max_concurrency";
    private JsonNullable<Integer> taskMaxConcurrency = JsonNullable.undefined();
    public static final String JSON_PROPERTY_MAX_CONFLICTING_AGE_SECONDS = "max_conflicting_age_seconds";
    private JsonNullable<Integer> maxConflictingAgeSeconds = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PREVENT_OFFLINE_EXECUTION = "prevent_offline_execution";
    private JsonNullable<Boolean> preventOfflineExecution = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PROCESS_TIMEOUT_SECONDS = "process_timeout_seconds";
    private JsonNullable<Integer> processTimeoutSeconds = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PROCESS_TERMINATION_GRACE_PERIOD_SECONDS = "process_termination_grace_period_seconds";
    private JsonNullable<Integer> processTerminationGracePeriodSeconds = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PROCESS_MAX_RETRIES = "process_max_retries";
    private JsonNullable<Integer> processMaxRetries = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PROCESS_RETRY_DELAY_SECONDS = "process_retry_delay_seconds";
    private JsonNullable<Integer> processRetryDelaySeconds = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SCHEDULE = "schedule";
    private JsonNullable<String> schedule = JsonNullable.undefined();
    public static final String JSON_PROPERTY_HEARTBEAT_INTERVAL_SECONDS = "heartbeat_interval_seconds";
    private JsonNullable<Integer> heartbeatIntervalSeconds = JsonNullable.undefined();
    public static final String JSON_PROPERTY_WORKFLOW_TASK_INSTANCE_EXECUTION = "workflow_task_instance_execution";
    private WorkflowTaskInstanceExecutionBase workflowTaskInstanceExecution;
    public static final String JSON_PROPERTY_API_BASE_URL = "api_base_url";
    private String apiBaseUrl;
    public static final String JSON_PROPERTY_API_REQUEST_TIMEOUT_SECONDS = "api_request_timeout_seconds";
    private JsonNullable<Integer> apiRequestTimeoutSeconds = JsonNullable.undefined();
    public static final String JSON_PROPERTY_API_RETRY_DELAY_SECONDS = "api_retry_delay_seconds";
    private JsonNullable<Integer> apiRetryDelaySeconds = JsonNullable.undefined();
    public static final String JSON_PROPERTY_API_RESUME_DELAY_SECONDS = "api_resume_delay_seconds";
    private JsonNullable<Integer> apiResumeDelaySeconds = JsonNullable.undefined();
    public static final String JSON_PROPERTY_API_ERROR_TIMEOUT_SECONDS = "api_error_timeout_seconds";
    private JsonNullable<Integer> apiErrorTimeoutSeconds = JsonNullable.undefined();
    public static final String JSON_PROPERTY_API_TASK_EXECUTION_CREATION_ERROR_TIMEOUT_SECONDS = "api_task_execution_creation_error_timeout_seconds";
    private JsonNullable<Integer> apiTaskExecutionCreationErrorTimeoutSeconds = JsonNullable.undefined();
    public static final String JSON_PROPERTY_API_TASK_EXECUTION_CREATION_CONFLICT_TIMEOUT_SECONDS = "api_task_execution_creation_conflict_timeout_seconds";
    private JsonNullable<Integer> apiTaskExecutionCreationConflictTimeoutSeconds = JsonNullable.undefined();
    public static final String JSON_PROPERTY_API_TASK_EXECUTION_CREATION_CONFLICT_RETRY_DELAY_SECONDS = "api_task_execution_creation_conflict_retry_delay_seconds";
    private JsonNullable<Integer> apiTaskExecutionCreationConflictRetryDelaySeconds = JsonNullable.undefined();
    public static final String JSON_PROPERTY_API_FINAL_UPDATE_TIMEOUT_SECONDS = "api_final_update_timeout_seconds";
    private JsonNullable<Integer> apiFinalUpdateTimeoutSeconds = JsonNullable.undefined();
    public static final String JSON_PROPERTY_STATUS_UPDATE_INTERVAL_SECONDS = "status_update_interval_seconds";
    private JsonNullable<Integer> statusUpdateIntervalSeconds = JsonNullable.undefined();
    public static final String JSON_PROPERTY_STATUS_UPDATE_PORT = "status_update_port";
    private JsonNullable<Integer> statusUpdatePort = JsonNullable.undefined();
    public static final String JSON_PROPERTY_STATUS_UPDATE_MESSAGE_MAX_BYTES = "status_update_message_max_bytes";
    private JsonNullable<Integer> statusUpdateMessageMaxBytes = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DEBUG_LOG_TAIL = "debug_log_tail";
    private JsonNullable<String> debugLogTail = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ERROR_LOG_TAIL = "error_log_tail";
    private JsonNullable<String> errorLogTail = JsonNullable.undefined();
    public static final String JSON_PROPERTY_EMBEDDED_MODE = "embedded_mode";
    private JsonNullable<Boolean> embeddedMode = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private OffsetDateTime updatedAt;

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public URI getUrl() {
        return this.url;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="uuid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getUuid() {
        return this.uuid;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="dashboard_url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDashboardUrl() {
        return this.dashboardUrl;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="infrastructure_website_url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getInfrastructureWebsiteUrl() {
        return this.infrastructureWebsiteUrl;
    }

    public TaskExecution task(NameAndUuid task) {
        this.task = task;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="task")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public NameAndUuid getTask() {
        return this.task;
    }

    @JsonProperty(value="task")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTask(NameAndUuid task) {
        this.task = task;
    }

    public TaskExecution taskVersionNumber(Long taskVersionNumber) {
        this.taskVersionNumber = JsonNullable.of((Object)taskVersionNumber);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Long getTaskVersionNumber() {
        return (Long)this.taskVersionNumber.orElse(null);
    }

    @JsonProperty(value="task_version_number")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getTaskVersionNumber_JsonNullable() {
        return this.taskVersionNumber;
    }

    @JsonProperty(value="task_version_number")
    public void setTaskVersionNumber_JsonNullable(JsonNullable<Long> taskVersionNumber) {
        this.taskVersionNumber = taskVersionNumber;
    }

    public void setTaskVersionNumber(Long taskVersionNumber) {
        this.taskVersionNumber = JsonNullable.of((Object)taskVersionNumber);
    }

    public TaskExecution taskVersionText(String taskVersionText) {
        this.taskVersionText = JsonNullable.of((Object)taskVersionText);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public String getTaskVersionText() {
        return (String)this.taskVersionText.orElse(null);
    }

    @JsonProperty(value="task_version_text")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getTaskVersionText_JsonNullable() {
        return this.taskVersionText;
    }

    @JsonProperty(value="task_version_text")
    public void setTaskVersionText_JsonNullable(JsonNullable<String> taskVersionText) {
        this.taskVersionText = taskVersionText;
    }

    public void setTaskVersionText(String taskVersionText) {
        this.taskVersionText = JsonNullable.of((Object)taskVersionText);
    }

    public TaskExecution taskVersionSignature(String taskVersionSignature) {
        this.taskVersionSignature = JsonNullable.of((Object)taskVersionSignature);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public String getTaskVersionSignature() {
        return (String)this.taskVersionSignature.orElse(null);
    }

    @JsonProperty(value="task_version_signature")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getTaskVersionSignature_JsonNullable() {
        return this.taskVersionSignature;
    }

    @JsonProperty(value="task_version_signature")
    public void setTaskVersionSignature_JsonNullable(JsonNullable<String> taskVersionSignature) {
        this.taskVersionSignature = taskVersionSignature;
    }

    public void setTaskVersionSignature(String taskVersionSignature) {
        this.taskVersionSignature = JsonNullable.of((Object)taskVersionSignature);
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="commit_url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCommitUrl() {
        return this.commitUrl;
    }

    public TaskExecution otherInstanceMetadata(Map<String, Object> otherInstanceMetadata) {
        this.otherInstanceMetadata = JsonNullable.of(otherInstanceMetadata);
        return this;
    }

    public TaskExecution putOtherInstanceMetadataItem(String key, Object otherInstanceMetadataItem) {
        if (this.otherInstanceMetadata == null || !this.otherInstanceMetadata.isPresent()) {
            this.otherInstanceMetadata = JsonNullable.of(new HashMap());
        }
        try {
            ((Map)this.otherInstanceMetadata.get()).put(key, otherInstanceMetadataItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Map<String, Object> getOtherInstanceMetadata() {
        return (Map)this.otherInstanceMetadata.orElse(null);
    }

    @JsonProperty(value="other_instance_metadata")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Map<String, Object>> getOtherInstanceMetadata_JsonNullable() {
        return this.otherInstanceMetadata;
    }

    @JsonProperty(value="other_instance_metadata")
    public void setOtherInstanceMetadata_JsonNullable(JsonNullable<Map<String, Object>> otherInstanceMetadata) {
        this.otherInstanceMetadata = otherInstanceMetadata;
    }

    public void setOtherInstanceMetadata(Map<String, Object> otherInstanceMetadata) {
        this.otherInstanceMetadata = JsonNullable.of(otherInstanceMetadata);
    }

    public TaskExecution hostname(String hostname) {
        this.hostname = JsonNullable.of((Object)hostname);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public String getHostname() {
        return (String)this.hostname.orElse(null);
    }

    @JsonProperty(value="hostname")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getHostname_JsonNullable() {
        return this.hostname;
    }

    @JsonProperty(value="hostname")
    public void setHostname_JsonNullable(JsonNullable<String> hostname) {
        this.hostname = hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = JsonNullable.of((Object)hostname);
    }

    public TaskExecution environmentVariablesOverrides(Map<String, Object> environmentVariablesOverrides) {
        this.environmentVariablesOverrides = JsonNullable.of(environmentVariablesOverrides);
        return this;
    }

    public TaskExecution putEnvironmentVariablesOverridesItem(String key, Object environmentVariablesOverridesItem) {
        if (this.environmentVariablesOverrides == null || !this.environmentVariablesOverrides.isPresent()) {
            this.environmentVariablesOverrides = JsonNullable.of(new HashMap());
        }
        try {
            ((Map)this.environmentVariablesOverrides.get()).put(key, environmentVariablesOverridesItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Map<String, Object> getEnvironmentVariablesOverrides() {
        return (Map)this.environmentVariablesOverrides.orElse(null);
    }

    @JsonProperty(value="environment_variables_overrides")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Map<String, Object>> getEnvironmentVariablesOverrides_JsonNullable() {
        return this.environmentVariablesOverrides;
    }

    @JsonProperty(value="environment_variables_overrides")
    public void setEnvironmentVariablesOverrides_JsonNullable(JsonNullable<Map<String, Object>> environmentVariablesOverrides) {
        this.environmentVariablesOverrides = environmentVariablesOverrides;
    }

    public void setEnvironmentVariablesOverrides(Map<String, Object> environmentVariablesOverrides) {
        this.environmentVariablesOverrides = JsonNullable.of(environmentVariablesOverrides);
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="execution_method")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AwsEcsExecutionMethod getExecutionMethod() {
        return this.executionMethod;
    }

    public TaskExecution status(TaskExecutionStatus status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TaskExecutionStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(TaskExecutionStatus status) {
        this.status = status;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.")
    @JsonProperty(value="started_by")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getStartedBy() {
        return this.startedBy;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="started_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getStartedAt() {
        return this.startedAt;
    }

    public TaskExecution finishedAt(OffsetDateTime finishedAt) {
        this.finishedAt = JsonNullable.of((Object)finishedAt);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public OffsetDateTime getFinishedAt() {
        return (OffsetDateTime)this.finishedAt.orElse(null);
    }

    @JsonProperty(value="finished_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getFinishedAt_JsonNullable() {
        return this.finishedAt;
    }

    @JsonProperty(value="finished_at")
    public void setFinishedAt_JsonNullable(JsonNullable<OffsetDateTime> finishedAt) {
        this.finishedAt = finishedAt;
    }

    public void setFinishedAt(OffsetDateTime finishedAt) {
        this.finishedAt = JsonNullable.of((Object)finishedAt);
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.")
    @JsonProperty(value="marked_done_by")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getMarkedDoneBy() {
        return this.markedDoneBy;
    }

    public TaskExecution markedDoneAt(OffsetDateTime markedDoneAt) {
        this.markedDoneAt = JsonNullable.of((Object)markedDoneAt);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public OffsetDateTime getMarkedDoneAt() {
        return (OffsetDateTime)this.markedDoneAt.orElse(null);
    }

    @JsonProperty(value="marked_done_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getMarkedDoneAt_JsonNullable() {
        return this.markedDoneAt;
    }

    @JsonProperty(value="marked_done_at")
    public void setMarkedDoneAt_JsonNullable(JsonNullable<OffsetDateTime> markedDoneAt) {
        this.markedDoneAt = markedDoneAt;
    }

    public void setMarkedDoneAt(OffsetDateTime markedDoneAt) {
        this.markedDoneAt = JsonNullable.of((Object)markedDoneAt);
    }

    public TaskExecution markedOutdatedAt(OffsetDateTime markedOutdatedAt) {
        this.markedOutdatedAt = JsonNullable.of((Object)markedOutdatedAt);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public OffsetDateTime getMarkedOutdatedAt() {
        return (OffsetDateTime)this.markedOutdatedAt.orElse(null);
    }

    @JsonProperty(value="marked_outdated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getMarkedOutdatedAt_JsonNullable() {
        return this.markedOutdatedAt;
    }

    @JsonProperty(value="marked_outdated_at")
    public void setMarkedOutdatedAt_JsonNullable(JsonNullable<OffsetDateTime> markedOutdatedAt) {
        this.markedOutdatedAt = markedOutdatedAt;
    }

    public void setMarkedOutdatedAt(OffsetDateTime markedOutdatedAt) {
        this.markedOutdatedAt = JsonNullable.of((Object)markedOutdatedAt);
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.")
    @JsonProperty(value="killed_by")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getKilledBy() {
        return this.killedBy;
    }

    public TaskExecution killStartedAt(OffsetDateTime killStartedAt) {
        this.killStartedAt = JsonNullable.of((Object)killStartedAt);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public OffsetDateTime getKillStartedAt() {
        return (OffsetDateTime)this.killStartedAt.orElse(null);
    }

    @JsonProperty(value="kill_started_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getKillStartedAt_JsonNullable() {
        return this.killStartedAt;
    }

    @JsonProperty(value="kill_started_at")
    public void setKillStartedAt_JsonNullable(JsonNullable<OffsetDateTime> killStartedAt) {
        this.killStartedAt = killStartedAt;
    }

    public void setKillStartedAt(OffsetDateTime killStartedAt) {
        this.killStartedAt = JsonNullable.of((Object)killStartedAt);
    }

    public TaskExecution killFinishedAt(OffsetDateTime killFinishedAt) {
        this.killFinishedAt = JsonNullable.of((Object)killFinishedAt);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public OffsetDateTime getKillFinishedAt() {
        return (OffsetDateTime)this.killFinishedAt.orElse(null);
    }

    @JsonProperty(value="kill_finished_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getKillFinishedAt_JsonNullable() {
        return this.killFinishedAt;
    }

    @JsonProperty(value="kill_finished_at")
    public void setKillFinishedAt_JsonNullable(JsonNullable<OffsetDateTime> killFinishedAt) {
        this.killFinishedAt = killFinishedAt;
    }

    public void setKillFinishedAt(OffsetDateTime killFinishedAt) {
        this.killFinishedAt = JsonNullable.of((Object)killFinishedAt);
    }

    public TaskExecution killErrorCode(Integer killErrorCode) {
        this.killErrorCode = JsonNullable.of((Object)killErrorCode);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getKillErrorCode() {
        return (Integer)this.killErrorCode.orElse(null);
    }

    @JsonProperty(value="kill_error_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getKillErrorCode_JsonNullable() {
        return this.killErrorCode;
    }

    @JsonProperty(value="kill_error_code")
    public void setKillErrorCode_JsonNullable(JsonNullable<Integer> killErrorCode) {
        this.killErrorCode = killErrorCode;
    }

    public void setKillErrorCode(Integer killErrorCode) {
        this.killErrorCode = JsonNullable.of((Object)killErrorCode);
    }

    public TaskExecution stopReason(StopReasonEnum stopReason) {
        this.stopReason = stopReason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="stop_reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StopReasonEnum getStopReason() {
        return this.stopReason;
    }

    @JsonProperty(value="stop_reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStopReason(StopReasonEnum stopReason) {
        this.stopReason = stopReason;
    }

    public TaskExecution lastHeartbeatAt(OffsetDateTime lastHeartbeatAt) {
        this.lastHeartbeatAt = JsonNullable.of((Object)lastHeartbeatAt);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public OffsetDateTime getLastHeartbeatAt() {
        return (OffsetDateTime)this.lastHeartbeatAt.orElse(null);
    }

    @JsonProperty(value="last_heartbeat_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getLastHeartbeatAt_JsonNullable() {
        return this.lastHeartbeatAt;
    }

    @JsonProperty(value="last_heartbeat_at")
    public void setLastHeartbeatAt_JsonNullable(JsonNullable<OffsetDateTime> lastHeartbeatAt) {
        this.lastHeartbeatAt = lastHeartbeatAt;
    }

    public void setLastHeartbeatAt(OffsetDateTime lastHeartbeatAt) {
        this.lastHeartbeatAt = JsonNullable.of((Object)lastHeartbeatAt);
    }

    public TaskExecution failedAttempts(Integer failedAttempts) {
        this.failedAttempts = failedAttempts;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="failed_attempts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getFailedAttempts() {
        return this.failedAttempts;
    }

    @JsonProperty(value="failed_attempts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFailedAttempts(Integer failedAttempts) {
        this.failedAttempts = failedAttempts;
    }

    public TaskExecution timedOutAttempts(Integer timedOutAttempts) {
        this.timedOutAttempts = timedOutAttempts;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="timed_out_attempts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTimedOutAttempts() {
        return this.timedOutAttempts;
    }

    @JsonProperty(value="timed_out_attempts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTimedOutAttempts(Integer timedOutAttempts) {
        this.timedOutAttempts = timedOutAttempts;
    }

    public TaskExecution exitCode(Integer exitCode) {
        this.exitCode = JsonNullable.of((Object)exitCode);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getExitCode() {
        return (Integer)this.exitCode.orElse(null);
    }

    @JsonProperty(value="exit_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getExitCode_JsonNullable() {
        return this.exitCode;
    }

    @JsonProperty(value="exit_code")
    public void setExitCode_JsonNullable(JsonNullable<Integer> exitCode) {
        this.exitCode = exitCode;
    }

    public void setExitCode(Integer exitCode) {
        this.exitCode = JsonNullable.of((Object)exitCode);
    }

    public TaskExecution lastStatusMessage(String lastStatusMessage) {
        this.lastStatusMessage = JsonNullable.of((Object)lastStatusMessage);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public String getLastStatusMessage() {
        return (String)this.lastStatusMessage.orElse(null);
    }

    @JsonProperty(value="last_status_message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getLastStatusMessage_JsonNullable() {
        return this.lastStatusMessage;
    }

    @JsonProperty(value="last_status_message")
    public void setLastStatusMessage_JsonNullable(JsonNullable<String> lastStatusMessage) {
        this.lastStatusMessage = lastStatusMessage;
    }

    public void setLastStatusMessage(String lastStatusMessage) {
        this.lastStatusMessage = JsonNullable.of((Object)lastStatusMessage);
    }

    public TaskExecution errorCount(Long errorCount) {
        this.errorCount = JsonNullable.of((Object)errorCount);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Long getErrorCount() {
        return (Long)this.errorCount.orElse(null);
    }

    @JsonProperty(value="error_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getErrorCount_JsonNullable() {
        return this.errorCount;
    }

    @JsonProperty(value="error_count")
    public void setErrorCount_JsonNullable(JsonNullable<Long> errorCount) {
        this.errorCount = errorCount;
    }

    public void setErrorCount(Long errorCount) {
        this.errorCount = JsonNullable.of((Object)errorCount);
    }

    public TaskExecution skippedCount(Long skippedCount) {
        this.skippedCount = JsonNullable.of((Object)skippedCount);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Long getSkippedCount() {
        return (Long)this.skippedCount.orElse(null);
    }

    @JsonProperty(value="skipped_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getSkippedCount_JsonNullable() {
        return this.skippedCount;
    }

    @JsonProperty(value="skipped_count")
    public void setSkippedCount_JsonNullable(JsonNullable<Long> skippedCount) {
        this.skippedCount = skippedCount;
    }

    public void setSkippedCount(Long skippedCount) {
        this.skippedCount = JsonNullable.of((Object)skippedCount);
    }

    public TaskExecution expectedCount(Long expectedCount) {
        this.expectedCount = JsonNullable.of((Object)expectedCount);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Long getExpectedCount() {
        return (Long)this.expectedCount.orElse(null);
    }

    @JsonProperty(value="expected_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getExpectedCount_JsonNullable() {
        return this.expectedCount;
    }

    @JsonProperty(value="expected_count")
    public void setExpectedCount_JsonNullable(JsonNullable<Long> expectedCount) {
        this.expectedCount = expectedCount;
    }

    public void setExpectedCount(Long expectedCount) {
        this.expectedCount = JsonNullable.of((Object)expectedCount);
    }

    public TaskExecution successCount(Long successCount) {
        this.successCount = JsonNullable.of((Object)successCount);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Long getSuccessCount() {
        return (Long)this.successCount.orElse(null);
    }

    @JsonProperty(value="success_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getSuccessCount_JsonNullable() {
        return this.successCount;
    }

    @JsonProperty(value="success_count")
    public void setSuccessCount_JsonNullable(JsonNullable<Long> successCount) {
        this.successCount = successCount;
    }

    public void setSuccessCount(Long successCount) {
        this.successCount = JsonNullable.of((Object)successCount);
    }

    public TaskExecution otherRuntimeMetadata(Map<String, Object> otherRuntimeMetadata) {
        this.otherRuntimeMetadata = JsonNullable.of(otherRuntimeMetadata);
        return this;
    }

    public TaskExecution putOtherRuntimeMetadataItem(String key, Object otherRuntimeMetadataItem) {
        if (this.otherRuntimeMetadata == null || !this.otherRuntimeMetadata.isPresent()) {
            this.otherRuntimeMetadata = JsonNullable.of(new HashMap());
        }
        try {
            ((Map)this.otherRuntimeMetadata.get()).put(key, otherRuntimeMetadataItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Map<String, Object> getOtherRuntimeMetadata() {
        return (Map)this.otherRuntimeMetadata.orElse(null);
    }

    @JsonProperty(value="other_runtime_metadata")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Map<String, Object>> getOtherRuntimeMetadata_JsonNullable() {
        return this.otherRuntimeMetadata;
    }

    @JsonProperty(value="other_runtime_metadata")
    public void setOtherRuntimeMetadata_JsonNullable(JsonNullable<Map<String, Object>> otherRuntimeMetadata) {
        this.otherRuntimeMetadata = otherRuntimeMetadata;
    }

    public void setOtherRuntimeMetadata(Map<String, Object> otherRuntimeMetadata) {
        this.otherRuntimeMetadata = JsonNullable.of(otherRuntimeMetadata);
    }

    public TaskExecution currentCpuUnits(Integer currentCpuUnits) {
        this.currentCpuUnits = JsonNullable.of((Object)currentCpuUnits);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getCurrentCpuUnits() {
        return (Integer)this.currentCpuUnits.orElse(null);
    }

    @JsonProperty(value="current_cpu_units")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getCurrentCpuUnits_JsonNullable() {
        return this.currentCpuUnits;
    }

    @JsonProperty(value="current_cpu_units")
    public void setCurrentCpuUnits_JsonNullable(JsonNullable<Integer> currentCpuUnits) {
        this.currentCpuUnits = currentCpuUnits;
    }

    public void setCurrentCpuUnits(Integer currentCpuUnits) {
        this.currentCpuUnits = JsonNullable.of((Object)currentCpuUnits);
    }

    public TaskExecution meanCpuUnits(Integer meanCpuUnits) {
        this.meanCpuUnits = JsonNullable.of((Object)meanCpuUnits);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getMeanCpuUnits() {
        return (Integer)this.meanCpuUnits.orElse(null);
    }

    @JsonProperty(value="mean_cpu_units")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getMeanCpuUnits_JsonNullable() {
        return this.meanCpuUnits;
    }

    @JsonProperty(value="mean_cpu_units")
    public void setMeanCpuUnits_JsonNullable(JsonNullable<Integer> meanCpuUnits) {
        this.meanCpuUnits = meanCpuUnits;
    }

    public void setMeanCpuUnits(Integer meanCpuUnits) {
        this.meanCpuUnits = JsonNullable.of((Object)meanCpuUnits);
    }

    public TaskExecution maxCpuUnits(Integer maxCpuUnits) {
        this.maxCpuUnits = JsonNullable.of((Object)maxCpuUnits);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getMaxCpuUnits() {
        return (Integer)this.maxCpuUnits.orElse(null);
    }

    @JsonProperty(value="max_cpu_units")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getMaxCpuUnits_JsonNullable() {
        return this.maxCpuUnits;
    }

    @JsonProperty(value="max_cpu_units")
    public void setMaxCpuUnits_JsonNullable(JsonNullable<Integer> maxCpuUnits) {
        this.maxCpuUnits = maxCpuUnits;
    }

    public void setMaxCpuUnits(Integer maxCpuUnits) {
        this.maxCpuUnits = JsonNullable.of((Object)maxCpuUnits);
    }

    public TaskExecution currentMemoryMb(Integer currentMemoryMb) {
        this.currentMemoryMb = JsonNullable.of((Object)currentMemoryMb);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getCurrentMemoryMb() {
        return (Integer)this.currentMemoryMb.orElse(null);
    }

    @JsonProperty(value="current_memory_mb")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getCurrentMemoryMb_JsonNullable() {
        return this.currentMemoryMb;
    }

    @JsonProperty(value="current_memory_mb")
    public void setCurrentMemoryMb_JsonNullable(JsonNullable<Integer> currentMemoryMb) {
        this.currentMemoryMb = currentMemoryMb;
    }

    public void setCurrentMemoryMb(Integer currentMemoryMb) {
        this.currentMemoryMb = JsonNullable.of((Object)currentMemoryMb);
    }

    public TaskExecution meanMemoryMb(Integer meanMemoryMb) {
        this.meanMemoryMb = JsonNullable.of((Object)meanMemoryMb);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getMeanMemoryMb() {
        return (Integer)this.meanMemoryMb.orElse(null);
    }

    @JsonProperty(value="mean_memory_mb")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getMeanMemoryMb_JsonNullable() {
        return this.meanMemoryMb;
    }

    @JsonProperty(value="mean_memory_mb")
    public void setMeanMemoryMb_JsonNullable(JsonNullable<Integer> meanMemoryMb) {
        this.meanMemoryMb = meanMemoryMb;
    }

    public void setMeanMemoryMb(Integer meanMemoryMb) {
        this.meanMemoryMb = JsonNullable.of((Object)meanMemoryMb);
    }

    public TaskExecution maxMemoryMb(Integer maxMemoryMb) {
        this.maxMemoryMb = JsonNullable.of((Object)maxMemoryMb);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getMaxMemoryMb() {
        return (Integer)this.maxMemoryMb.orElse(null);
    }

    @JsonProperty(value="max_memory_mb")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getMaxMemoryMb_JsonNullable() {
        return this.maxMemoryMb;
    }

    @JsonProperty(value="max_memory_mb")
    public void setMaxMemoryMb_JsonNullable(JsonNullable<Integer> maxMemoryMb) {
        this.maxMemoryMb = maxMemoryMb;
    }

    public void setMaxMemoryMb(Integer maxMemoryMb) {
        this.maxMemoryMb = JsonNullable.of((Object)maxMemoryMb);
    }

    public TaskExecution wrapperVersion(String wrapperVersion) {
        this.wrapperVersion = JsonNullable.of((Object)wrapperVersion);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public String getWrapperVersion() {
        return (String)this.wrapperVersion.orElse(null);
    }

    @JsonProperty(value="wrapper_version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getWrapperVersion_JsonNullable() {
        return this.wrapperVersion;
    }

    @JsonProperty(value="wrapper_version")
    public void setWrapperVersion_JsonNullable(JsonNullable<String> wrapperVersion) {
        this.wrapperVersion = wrapperVersion;
    }

    public void setWrapperVersion(String wrapperVersion) {
        this.wrapperVersion = JsonNullable.of((Object)wrapperVersion);
    }

    public TaskExecution wrapperLogLevel(String wrapperLogLevel) {
        this.wrapperLogLevel = JsonNullable.of((Object)wrapperLogLevel);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public String getWrapperLogLevel() {
        return (String)this.wrapperLogLevel.orElse(null);
    }

    @JsonProperty(value="wrapper_log_level")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getWrapperLogLevel_JsonNullable() {
        return this.wrapperLogLevel;
    }

    @JsonProperty(value="wrapper_log_level")
    public void setWrapperLogLevel_JsonNullable(JsonNullable<String> wrapperLogLevel) {
        this.wrapperLogLevel = wrapperLogLevel;
    }

    public void setWrapperLogLevel(String wrapperLogLevel) {
        this.wrapperLogLevel = JsonNullable.of((Object)wrapperLogLevel);
    }

    public TaskExecution deployment(String deployment) {
        this.deployment = JsonNullable.of((Object)deployment);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public String getDeployment() {
        return (String)this.deployment.orElse(null);
    }

    @JsonProperty(value="deployment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDeployment_JsonNullable() {
        return this.deployment;
    }

    @JsonProperty(value="deployment")
    public void setDeployment_JsonNullable(JsonNullable<String> deployment) {
        this.deployment = deployment;
    }

    public void setDeployment(String deployment) {
        this.deployment = JsonNullable.of((Object)deployment);
    }

    public TaskExecution processCommand(String processCommand) {
        this.processCommand = JsonNullable.of((Object)processCommand);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public String getProcessCommand() {
        return (String)this.processCommand.orElse(null);
    }

    @JsonProperty(value="process_command")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getProcessCommand_JsonNullable() {
        return this.processCommand;
    }

    @JsonProperty(value="process_command")
    public void setProcessCommand_JsonNullable(JsonNullable<String> processCommand) {
        this.processCommand = processCommand;
    }

    public void setProcessCommand(String processCommand) {
        this.processCommand = JsonNullable.of((Object)processCommand);
    }

    public TaskExecution isService(Boolean isService) {
        this.isService = JsonNullable.of((Object)isService);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Boolean getIsService() {
        return (Boolean)this.isService.orElse(null);
    }

    @JsonProperty(value="is_service")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Boolean> getIsService_JsonNullable() {
        return this.isService;
    }

    @JsonProperty(value="is_service")
    public void setIsService_JsonNullable(JsonNullable<Boolean> isService) {
        this.isService = isService;
    }

    public void setIsService(Boolean isService) {
        this.isService = JsonNullable.of((Object)isService);
    }

    public TaskExecution taskMaxConcurrency(Integer taskMaxConcurrency) {
        this.taskMaxConcurrency = JsonNullable.of((Object)taskMaxConcurrency);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getTaskMaxConcurrency() {
        return (Integer)this.taskMaxConcurrency.orElse(null);
    }

    @JsonProperty(value="task_max_concurrency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getTaskMaxConcurrency_JsonNullable() {
        return this.taskMaxConcurrency;
    }

    @JsonProperty(value="task_max_concurrency")
    public void setTaskMaxConcurrency_JsonNullable(JsonNullable<Integer> taskMaxConcurrency) {
        this.taskMaxConcurrency = taskMaxConcurrency;
    }

    public void setTaskMaxConcurrency(Integer taskMaxConcurrency) {
        this.taskMaxConcurrency = JsonNullable.of((Object)taskMaxConcurrency);
    }

    public TaskExecution maxConflictingAgeSeconds(Integer maxConflictingAgeSeconds) {
        this.maxConflictingAgeSeconds = JsonNullable.of((Object)maxConflictingAgeSeconds);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getMaxConflictingAgeSeconds() {
        return (Integer)this.maxConflictingAgeSeconds.orElse(null);
    }

    @JsonProperty(value="max_conflicting_age_seconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getMaxConflictingAgeSeconds_JsonNullable() {
        return this.maxConflictingAgeSeconds;
    }

    @JsonProperty(value="max_conflicting_age_seconds")
    public void setMaxConflictingAgeSeconds_JsonNullable(JsonNullable<Integer> maxConflictingAgeSeconds) {
        this.maxConflictingAgeSeconds = maxConflictingAgeSeconds;
    }

    public void setMaxConflictingAgeSeconds(Integer maxConflictingAgeSeconds) {
        this.maxConflictingAgeSeconds = JsonNullable.of((Object)maxConflictingAgeSeconds);
    }

    public TaskExecution preventOfflineExecution(Boolean preventOfflineExecution) {
        this.preventOfflineExecution = JsonNullable.of((Object)preventOfflineExecution);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Boolean getPreventOfflineExecution() {
        return (Boolean)this.preventOfflineExecution.orElse(null);
    }

    @JsonProperty(value="prevent_offline_execution")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Boolean> getPreventOfflineExecution_JsonNullable() {
        return this.preventOfflineExecution;
    }

    @JsonProperty(value="prevent_offline_execution")
    public void setPreventOfflineExecution_JsonNullable(JsonNullable<Boolean> preventOfflineExecution) {
        this.preventOfflineExecution = preventOfflineExecution;
    }

    public void setPreventOfflineExecution(Boolean preventOfflineExecution) {
        this.preventOfflineExecution = JsonNullable.of((Object)preventOfflineExecution);
    }

    public TaskExecution processTimeoutSeconds(Integer processTimeoutSeconds) {
        this.processTimeoutSeconds = JsonNullable.of((Object)processTimeoutSeconds);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getProcessTimeoutSeconds() {
        return (Integer)this.processTimeoutSeconds.orElse(null);
    }

    @JsonProperty(value="process_timeout_seconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getProcessTimeoutSeconds_JsonNullable() {
        return this.processTimeoutSeconds;
    }

    @JsonProperty(value="process_timeout_seconds")
    public void setProcessTimeoutSeconds_JsonNullable(JsonNullable<Integer> processTimeoutSeconds) {
        this.processTimeoutSeconds = processTimeoutSeconds;
    }

    public void setProcessTimeoutSeconds(Integer processTimeoutSeconds) {
        this.processTimeoutSeconds = JsonNullable.of((Object)processTimeoutSeconds);
    }

    public TaskExecution processTerminationGracePeriodSeconds(Integer processTerminationGracePeriodSeconds) {
        this.processTerminationGracePeriodSeconds = JsonNullable.of((Object)processTerminationGracePeriodSeconds);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getProcessTerminationGracePeriodSeconds() {
        return (Integer)this.processTerminationGracePeriodSeconds.orElse(null);
    }

    @JsonProperty(value="process_termination_grace_period_seconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getProcessTerminationGracePeriodSeconds_JsonNullable() {
        return this.processTerminationGracePeriodSeconds;
    }

    @JsonProperty(value="process_termination_grace_period_seconds")
    public void setProcessTerminationGracePeriodSeconds_JsonNullable(JsonNullable<Integer> processTerminationGracePeriodSeconds) {
        this.processTerminationGracePeriodSeconds = processTerminationGracePeriodSeconds;
    }

    public void setProcessTerminationGracePeriodSeconds(Integer processTerminationGracePeriodSeconds) {
        this.processTerminationGracePeriodSeconds = JsonNullable.of((Object)processTerminationGracePeriodSeconds);
    }

    public TaskExecution processMaxRetries(Integer processMaxRetries) {
        this.processMaxRetries = JsonNullable.of((Object)processMaxRetries);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getProcessMaxRetries() {
        return (Integer)this.processMaxRetries.orElse(null);
    }

    @JsonProperty(value="process_max_retries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getProcessMaxRetries_JsonNullable() {
        return this.processMaxRetries;
    }

    @JsonProperty(value="process_max_retries")
    public void setProcessMaxRetries_JsonNullable(JsonNullable<Integer> processMaxRetries) {
        this.processMaxRetries = processMaxRetries;
    }

    public void setProcessMaxRetries(Integer processMaxRetries) {
        this.processMaxRetries = JsonNullable.of((Object)processMaxRetries);
    }

    public TaskExecution processRetryDelaySeconds(Integer processRetryDelaySeconds) {
        this.processRetryDelaySeconds = JsonNullable.of((Object)processRetryDelaySeconds);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getProcessRetryDelaySeconds() {
        return (Integer)this.processRetryDelaySeconds.orElse(null);
    }

    @JsonProperty(value="process_retry_delay_seconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getProcessRetryDelaySeconds_JsonNullable() {
        return this.processRetryDelaySeconds;
    }

    @JsonProperty(value="process_retry_delay_seconds")
    public void setProcessRetryDelaySeconds_JsonNullable(JsonNullable<Integer> processRetryDelaySeconds) {
        this.processRetryDelaySeconds = processRetryDelaySeconds;
    }

    public void setProcessRetryDelaySeconds(Integer processRetryDelaySeconds) {
        this.processRetryDelaySeconds = JsonNullable.of((Object)processRetryDelaySeconds);
    }

    public TaskExecution schedule(String schedule) {
        this.schedule = JsonNullable.of((Object)schedule);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public String getSchedule() {
        return (String)this.schedule.orElse(null);
    }

    @JsonProperty(value="schedule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getSchedule_JsonNullable() {
        return this.schedule;
    }

    @JsonProperty(value="schedule")
    public void setSchedule_JsonNullable(JsonNullable<String> schedule) {
        this.schedule = schedule;
    }

    public void setSchedule(String schedule) {
        this.schedule = JsonNullable.of((Object)schedule);
    }

    public TaskExecution heartbeatIntervalSeconds(Integer heartbeatIntervalSeconds) {
        this.heartbeatIntervalSeconds = JsonNullable.of((Object)heartbeatIntervalSeconds);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getHeartbeatIntervalSeconds() {
        return (Integer)this.heartbeatIntervalSeconds.orElse(null);
    }

    @JsonProperty(value="heartbeat_interval_seconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getHeartbeatIntervalSeconds_JsonNullable() {
        return this.heartbeatIntervalSeconds;
    }

    @JsonProperty(value="heartbeat_interval_seconds")
    public void setHeartbeatIntervalSeconds_JsonNullable(JsonNullable<Integer> heartbeatIntervalSeconds) {
        this.heartbeatIntervalSeconds = heartbeatIntervalSeconds;
    }

    public void setHeartbeatIntervalSeconds(Integer heartbeatIntervalSeconds) {
        this.heartbeatIntervalSeconds = JsonNullable.of((Object)heartbeatIntervalSeconds);
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="workflow_task_instance_execution")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public WorkflowTaskInstanceExecutionBase getWorkflowTaskInstanceExecution() {
        return this.workflowTaskInstanceExecution;
    }

    public TaskExecution apiBaseUrl(String apiBaseUrl) {
        this.apiBaseUrl = apiBaseUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="api_base_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getApiBaseUrl() {
        return this.apiBaseUrl;
    }

    @JsonProperty(value="api_base_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApiBaseUrl(String apiBaseUrl) {
        this.apiBaseUrl = apiBaseUrl;
    }

    public TaskExecution apiRequestTimeoutSeconds(Integer apiRequestTimeoutSeconds) {
        this.apiRequestTimeoutSeconds = JsonNullable.of((Object)apiRequestTimeoutSeconds);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getApiRequestTimeoutSeconds() {
        return (Integer)this.apiRequestTimeoutSeconds.orElse(null);
    }

    @JsonProperty(value="api_request_timeout_seconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getApiRequestTimeoutSeconds_JsonNullable() {
        return this.apiRequestTimeoutSeconds;
    }

    @JsonProperty(value="api_request_timeout_seconds")
    public void setApiRequestTimeoutSeconds_JsonNullable(JsonNullable<Integer> apiRequestTimeoutSeconds) {
        this.apiRequestTimeoutSeconds = apiRequestTimeoutSeconds;
    }

    public void setApiRequestTimeoutSeconds(Integer apiRequestTimeoutSeconds) {
        this.apiRequestTimeoutSeconds = JsonNullable.of((Object)apiRequestTimeoutSeconds);
    }

    public TaskExecution apiRetryDelaySeconds(Integer apiRetryDelaySeconds) {
        this.apiRetryDelaySeconds = JsonNullable.of((Object)apiRetryDelaySeconds);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getApiRetryDelaySeconds() {
        return (Integer)this.apiRetryDelaySeconds.orElse(null);
    }

    @JsonProperty(value="api_retry_delay_seconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getApiRetryDelaySeconds_JsonNullable() {
        return this.apiRetryDelaySeconds;
    }

    @JsonProperty(value="api_retry_delay_seconds")
    public void setApiRetryDelaySeconds_JsonNullable(JsonNullable<Integer> apiRetryDelaySeconds) {
        this.apiRetryDelaySeconds = apiRetryDelaySeconds;
    }

    public void setApiRetryDelaySeconds(Integer apiRetryDelaySeconds) {
        this.apiRetryDelaySeconds = JsonNullable.of((Object)apiRetryDelaySeconds);
    }

    public TaskExecution apiResumeDelaySeconds(Integer apiResumeDelaySeconds) {
        this.apiResumeDelaySeconds = JsonNullable.of((Object)apiResumeDelaySeconds);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getApiResumeDelaySeconds() {
        return (Integer)this.apiResumeDelaySeconds.orElse(null);
    }

    @JsonProperty(value="api_resume_delay_seconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getApiResumeDelaySeconds_JsonNullable() {
        return this.apiResumeDelaySeconds;
    }

    @JsonProperty(value="api_resume_delay_seconds")
    public void setApiResumeDelaySeconds_JsonNullable(JsonNullable<Integer> apiResumeDelaySeconds) {
        this.apiResumeDelaySeconds = apiResumeDelaySeconds;
    }

    public void setApiResumeDelaySeconds(Integer apiResumeDelaySeconds) {
        this.apiResumeDelaySeconds = JsonNullable.of((Object)apiResumeDelaySeconds);
    }

    public TaskExecution apiErrorTimeoutSeconds(Integer apiErrorTimeoutSeconds) {
        this.apiErrorTimeoutSeconds = JsonNullable.of((Object)apiErrorTimeoutSeconds);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getApiErrorTimeoutSeconds() {
        return (Integer)this.apiErrorTimeoutSeconds.orElse(null);
    }

    @JsonProperty(value="api_error_timeout_seconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getApiErrorTimeoutSeconds_JsonNullable() {
        return this.apiErrorTimeoutSeconds;
    }

    @JsonProperty(value="api_error_timeout_seconds")
    public void setApiErrorTimeoutSeconds_JsonNullable(JsonNullable<Integer> apiErrorTimeoutSeconds) {
        this.apiErrorTimeoutSeconds = apiErrorTimeoutSeconds;
    }

    public void setApiErrorTimeoutSeconds(Integer apiErrorTimeoutSeconds) {
        this.apiErrorTimeoutSeconds = JsonNullable.of((Object)apiErrorTimeoutSeconds);
    }

    public TaskExecution apiTaskExecutionCreationErrorTimeoutSeconds(Integer apiTaskExecutionCreationErrorTimeoutSeconds) {
        this.apiTaskExecutionCreationErrorTimeoutSeconds = JsonNullable.of((Object)apiTaskExecutionCreationErrorTimeoutSeconds);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getApiTaskExecutionCreationErrorTimeoutSeconds() {
        return (Integer)this.apiTaskExecutionCreationErrorTimeoutSeconds.orElse(null);
    }

    @JsonProperty(value="api_task_execution_creation_error_timeout_seconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getApiTaskExecutionCreationErrorTimeoutSeconds_JsonNullable() {
        return this.apiTaskExecutionCreationErrorTimeoutSeconds;
    }

    @JsonProperty(value="api_task_execution_creation_error_timeout_seconds")
    public void setApiTaskExecutionCreationErrorTimeoutSeconds_JsonNullable(JsonNullable<Integer> apiTaskExecutionCreationErrorTimeoutSeconds) {
        this.apiTaskExecutionCreationErrorTimeoutSeconds = apiTaskExecutionCreationErrorTimeoutSeconds;
    }

    public void setApiTaskExecutionCreationErrorTimeoutSeconds(Integer apiTaskExecutionCreationErrorTimeoutSeconds) {
        this.apiTaskExecutionCreationErrorTimeoutSeconds = JsonNullable.of((Object)apiTaskExecutionCreationErrorTimeoutSeconds);
    }

    public TaskExecution apiTaskExecutionCreationConflictTimeoutSeconds(Integer apiTaskExecutionCreationConflictTimeoutSeconds) {
        this.apiTaskExecutionCreationConflictTimeoutSeconds = JsonNullable.of((Object)apiTaskExecutionCreationConflictTimeoutSeconds);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getApiTaskExecutionCreationConflictTimeoutSeconds() {
        return (Integer)this.apiTaskExecutionCreationConflictTimeoutSeconds.orElse(null);
    }

    @JsonProperty(value="api_task_execution_creation_conflict_timeout_seconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getApiTaskExecutionCreationConflictTimeoutSeconds_JsonNullable() {
        return this.apiTaskExecutionCreationConflictTimeoutSeconds;
    }

    @JsonProperty(value="api_task_execution_creation_conflict_timeout_seconds")
    public void setApiTaskExecutionCreationConflictTimeoutSeconds_JsonNullable(JsonNullable<Integer> apiTaskExecutionCreationConflictTimeoutSeconds) {
        this.apiTaskExecutionCreationConflictTimeoutSeconds = apiTaskExecutionCreationConflictTimeoutSeconds;
    }

    public void setApiTaskExecutionCreationConflictTimeoutSeconds(Integer apiTaskExecutionCreationConflictTimeoutSeconds) {
        this.apiTaskExecutionCreationConflictTimeoutSeconds = JsonNullable.of((Object)apiTaskExecutionCreationConflictTimeoutSeconds);
    }

    public TaskExecution apiTaskExecutionCreationConflictRetryDelaySeconds(Integer apiTaskExecutionCreationConflictRetryDelaySeconds) {
        this.apiTaskExecutionCreationConflictRetryDelaySeconds = JsonNullable.of((Object)apiTaskExecutionCreationConflictRetryDelaySeconds);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getApiTaskExecutionCreationConflictRetryDelaySeconds() {
        return (Integer)this.apiTaskExecutionCreationConflictRetryDelaySeconds.orElse(null);
    }

    @JsonProperty(value="api_task_execution_creation_conflict_retry_delay_seconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getApiTaskExecutionCreationConflictRetryDelaySeconds_JsonNullable() {
        return this.apiTaskExecutionCreationConflictRetryDelaySeconds;
    }

    @JsonProperty(value="api_task_execution_creation_conflict_retry_delay_seconds")
    public void setApiTaskExecutionCreationConflictRetryDelaySeconds_JsonNullable(JsonNullable<Integer> apiTaskExecutionCreationConflictRetryDelaySeconds) {
        this.apiTaskExecutionCreationConflictRetryDelaySeconds = apiTaskExecutionCreationConflictRetryDelaySeconds;
    }

    public void setApiTaskExecutionCreationConflictRetryDelaySeconds(Integer apiTaskExecutionCreationConflictRetryDelaySeconds) {
        this.apiTaskExecutionCreationConflictRetryDelaySeconds = JsonNullable.of((Object)apiTaskExecutionCreationConflictRetryDelaySeconds);
    }

    public TaskExecution apiFinalUpdateTimeoutSeconds(Integer apiFinalUpdateTimeoutSeconds) {
        this.apiFinalUpdateTimeoutSeconds = JsonNullable.of((Object)apiFinalUpdateTimeoutSeconds);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getApiFinalUpdateTimeoutSeconds() {
        return (Integer)this.apiFinalUpdateTimeoutSeconds.orElse(null);
    }

    @JsonProperty(value="api_final_update_timeout_seconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getApiFinalUpdateTimeoutSeconds_JsonNullable() {
        return this.apiFinalUpdateTimeoutSeconds;
    }

    @JsonProperty(value="api_final_update_timeout_seconds")
    public void setApiFinalUpdateTimeoutSeconds_JsonNullable(JsonNullable<Integer> apiFinalUpdateTimeoutSeconds) {
        this.apiFinalUpdateTimeoutSeconds = apiFinalUpdateTimeoutSeconds;
    }

    public void setApiFinalUpdateTimeoutSeconds(Integer apiFinalUpdateTimeoutSeconds) {
        this.apiFinalUpdateTimeoutSeconds = JsonNullable.of((Object)apiFinalUpdateTimeoutSeconds);
    }

    public TaskExecution statusUpdateIntervalSeconds(Integer statusUpdateIntervalSeconds) {
        this.statusUpdateIntervalSeconds = JsonNullable.of((Object)statusUpdateIntervalSeconds);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getStatusUpdateIntervalSeconds() {
        return (Integer)this.statusUpdateIntervalSeconds.orElse(null);
    }

    @JsonProperty(value="status_update_interval_seconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getStatusUpdateIntervalSeconds_JsonNullable() {
        return this.statusUpdateIntervalSeconds;
    }

    @JsonProperty(value="status_update_interval_seconds")
    public void setStatusUpdateIntervalSeconds_JsonNullable(JsonNullable<Integer> statusUpdateIntervalSeconds) {
        this.statusUpdateIntervalSeconds = statusUpdateIntervalSeconds;
    }

    public void setStatusUpdateIntervalSeconds(Integer statusUpdateIntervalSeconds) {
        this.statusUpdateIntervalSeconds = JsonNullable.of((Object)statusUpdateIntervalSeconds);
    }

    public TaskExecution statusUpdatePort(Integer statusUpdatePort) {
        this.statusUpdatePort = JsonNullable.of((Object)statusUpdatePort);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getStatusUpdatePort() {
        return (Integer)this.statusUpdatePort.orElse(null);
    }

    @JsonProperty(value="status_update_port")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getStatusUpdatePort_JsonNullable() {
        return this.statusUpdatePort;
    }

    @JsonProperty(value="status_update_port")
    public void setStatusUpdatePort_JsonNullable(JsonNullable<Integer> statusUpdatePort) {
        this.statusUpdatePort = statusUpdatePort;
    }

    public void setStatusUpdatePort(Integer statusUpdatePort) {
        this.statusUpdatePort = JsonNullable.of((Object)statusUpdatePort);
    }

    public TaskExecution statusUpdateMessageMaxBytes(Integer statusUpdateMessageMaxBytes) {
        this.statusUpdateMessageMaxBytes = JsonNullable.of((Object)statusUpdateMessageMaxBytes);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getStatusUpdateMessageMaxBytes() {
        return (Integer)this.statusUpdateMessageMaxBytes.orElse(null);
    }

    @JsonProperty(value="status_update_message_max_bytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getStatusUpdateMessageMaxBytes_JsonNullable() {
        return this.statusUpdateMessageMaxBytes;
    }

    @JsonProperty(value="status_update_message_max_bytes")
    public void setStatusUpdateMessageMaxBytes_JsonNullable(JsonNullable<Integer> statusUpdateMessageMaxBytes) {
        this.statusUpdateMessageMaxBytes = statusUpdateMessageMaxBytes;
    }

    public void setStatusUpdateMessageMaxBytes(Integer statusUpdateMessageMaxBytes) {
        this.statusUpdateMessageMaxBytes = JsonNullable.of((Object)statusUpdateMessageMaxBytes);
    }

    public TaskExecution debugLogTail(String debugLogTail) {
        this.debugLogTail = JsonNullable.of((Object)debugLogTail);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public String getDebugLogTail() {
        return (String)this.debugLogTail.orElse(null);
    }

    @JsonProperty(value="debug_log_tail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDebugLogTail_JsonNullable() {
        return this.debugLogTail;
    }

    @JsonProperty(value="debug_log_tail")
    public void setDebugLogTail_JsonNullable(JsonNullable<String> debugLogTail) {
        this.debugLogTail = debugLogTail;
    }

    public void setDebugLogTail(String debugLogTail) {
        this.debugLogTail = JsonNullable.of((Object)debugLogTail);
    }

    public TaskExecution errorLogTail(String errorLogTail) {
        this.errorLogTail = JsonNullable.of((Object)errorLogTail);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public String getErrorLogTail() {
        return (String)this.errorLogTail.orElse(null);
    }

    @JsonProperty(value="error_log_tail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getErrorLogTail_JsonNullable() {
        return this.errorLogTail;
    }

    @JsonProperty(value="error_log_tail")
    public void setErrorLogTail_JsonNullable(JsonNullable<String> errorLogTail) {
        this.errorLogTail = errorLogTail;
    }

    public void setErrorLogTail(String errorLogTail) {
        this.errorLogTail = JsonNullable.of((Object)errorLogTail);
    }

    public TaskExecution embeddedMode(Boolean embeddedMode) {
        this.embeddedMode = JsonNullable.of((Object)embeddedMode);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Boolean getEmbeddedMode() {
        return (Boolean)this.embeddedMode.orElse(null);
    }

    @JsonProperty(value="embedded_mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Boolean> getEmbeddedMode_JsonNullable() {
        return this.embeddedMode;
    }

    @JsonProperty(value="embedded_mode")
    public void setEmbeddedMode_JsonNullable(JsonNullable<Boolean> embeddedMode) {
        this.embeddedMode = embeddedMode;
    }

    public void setEmbeddedMode(Boolean embeddedMode) {
        this.embeddedMode = JsonNullable.of((Object)embeddedMode);
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskExecution taskExecution = (TaskExecution)o;
        return Objects.equals(this.url, taskExecution.url) && Objects.equals(this.uuid, taskExecution.uuid) && Objects.equals(this.dashboardUrl, taskExecution.dashboardUrl) && Objects.equals(this.infrastructureWebsiteUrl, taskExecution.infrastructureWebsiteUrl) && Objects.equals(this.task, taskExecution.task) && TaskExecution.equalsNullable(this.taskVersionNumber, taskExecution.taskVersionNumber) && TaskExecution.equalsNullable(this.taskVersionText, taskExecution.taskVersionText) && TaskExecution.equalsNullable(this.taskVersionSignature, taskExecution.taskVersionSignature) && Objects.equals(this.commitUrl, taskExecution.commitUrl) && TaskExecution.equalsNullable(this.otherInstanceMetadata, taskExecution.otherInstanceMetadata) && TaskExecution.equalsNullable(this.hostname, taskExecution.hostname) && TaskExecution.equalsNullable(this.environmentVariablesOverrides, taskExecution.environmentVariablesOverrides) && Objects.equals(this.executionMethod, taskExecution.executionMethod) && Objects.equals((Object)this.status, (Object)taskExecution.status) && Objects.equals(this.startedBy, taskExecution.startedBy) && Objects.equals(this.startedAt, taskExecution.startedAt) && TaskExecution.equalsNullable(this.finishedAt, taskExecution.finishedAt) && Objects.equals(this.markedDoneBy, taskExecution.markedDoneBy) && TaskExecution.equalsNullable(this.markedDoneAt, taskExecution.markedDoneAt) && TaskExecution.equalsNullable(this.markedOutdatedAt, taskExecution.markedOutdatedAt) && Objects.equals(this.killedBy, taskExecution.killedBy) && TaskExecution.equalsNullable(this.killStartedAt, taskExecution.killStartedAt) && TaskExecution.equalsNullable(this.killFinishedAt, taskExecution.killFinishedAt) && TaskExecution.equalsNullable(this.killErrorCode, taskExecution.killErrorCode) && Objects.equals((Object)this.stopReason, (Object)taskExecution.stopReason) && TaskExecution.equalsNullable(this.lastHeartbeatAt, taskExecution.lastHeartbeatAt) && Objects.equals(this.failedAttempts, taskExecution.failedAttempts) && Objects.equals(this.timedOutAttempts, taskExecution.timedOutAttempts) && TaskExecution.equalsNullable(this.exitCode, taskExecution.exitCode) && TaskExecution.equalsNullable(this.lastStatusMessage, taskExecution.lastStatusMessage) && TaskExecution.equalsNullable(this.errorCount, taskExecution.errorCount) && TaskExecution.equalsNullable(this.skippedCount, taskExecution.skippedCount) && TaskExecution.equalsNullable(this.expectedCount, taskExecution.expectedCount) && TaskExecution.equalsNullable(this.successCount, taskExecution.successCount) && TaskExecution.equalsNullable(this.otherRuntimeMetadata, taskExecution.otherRuntimeMetadata) && TaskExecution.equalsNullable(this.currentCpuUnits, taskExecution.currentCpuUnits) && TaskExecution.equalsNullable(this.meanCpuUnits, taskExecution.meanCpuUnits) && TaskExecution.equalsNullable(this.maxCpuUnits, taskExecution.maxCpuUnits) && TaskExecution.equalsNullable(this.currentMemoryMb, taskExecution.currentMemoryMb) && TaskExecution.equalsNullable(this.meanMemoryMb, taskExecution.meanMemoryMb) && TaskExecution.equalsNullable(this.maxMemoryMb, taskExecution.maxMemoryMb) && TaskExecution.equalsNullable(this.wrapperVersion, taskExecution.wrapperVersion) && TaskExecution.equalsNullable(this.wrapperLogLevel, taskExecution.wrapperLogLevel) && TaskExecution.equalsNullable(this.deployment, taskExecution.deployment) && TaskExecution.equalsNullable(this.processCommand, taskExecution.processCommand) && TaskExecution.equalsNullable(this.isService, taskExecution.isService) && TaskExecution.equalsNullable(this.taskMaxConcurrency, taskExecution.taskMaxConcurrency) && TaskExecution.equalsNullable(this.maxConflictingAgeSeconds, taskExecution.maxConflictingAgeSeconds) && TaskExecution.equalsNullable(this.preventOfflineExecution, taskExecution.preventOfflineExecution) && TaskExecution.equalsNullable(this.processTimeoutSeconds, taskExecution.processTimeoutSeconds) && TaskExecution.equalsNullable(this.processTerminationGracePeriodSeconds, taskExecution.processTerminationGracePeriodSeconds) && TaskExecution.equalsNullable(this.processMaxRetries, taskExecution.processMaxRetries) && TaskExecution.equalsNullable(this.processRetryDelaySeconds, taskExecution.processRetryDelaySeconds) && TaskExecution.equalsNullable(this.schedule, taskExecution.schedule) && TaskExecution.equalsNullable(this.heartbeatIntervalSeconds, taskExecution.heartbeatIntervalSeconds) && Objects.equals(this.workflowTaskInstanceExecution, taskExecution.workflowTaskInstanceExecution) && Objects.equals(this.apiBaseUrl, taskExecution.apiBaseUrl) && TaskExecution.equalsNullable(this.apiRequestTimeoutSeconds, taskExecution.apiRequestTimeoutSeconds) && TaskExecution.equalsNullable(this.apiRetryDelaySeconds, taskExecution.apiRetryDelaySeconds) && TaskExecution.equalsNullable(this.apiResumeDelaySeconds, taskExecution.apiResumeDelaySeconds) && TaskExecution.equalsNullable(this.apiErrorTimeoutSeconds, taskExecution.apiErrorTimeoutSeconds) && TaskExecution.equalsNullable(this.apiTaskExecutionCreationErrorTimeoutSeconds, taskExecution.apiTaskExecutionCreationErrorTimeoutSeconds) && TaskExecution.equalsNullable(this.apiTaskExecutionCreationConflictTimeoutSeconds, taskExecution.apiTaskExecutionCreationConflictTimeoutSeconds) && TaskExecution.equalsNullable(this.apiTaskExecutionCreationConflictRetryDelaySeconds, taskExecution.apiTaskExecutionCreationConflictRetryDelaySeconds) && TaskExecution.equalsNullable(this.apiFinalUpdateTimeoutSeconds, taskExecution.apiFinalUpdateTimeoutSeconds) && TaskExecution.equalsNullable(this.statusUpdateIntervalSeconds, taskExecution.statusUpdateIntervalSeconds) && TaskExecution.equalsNullable(this.statusUpdatePort, taskExecution.statusUpdatePort) && TaskExecution.equalsNullable(this.statusUpdateMessageMaxBytes, taskExecution.statusUpdateMessageMaxBytes) && TaskExecution.equalsNullable(this.debugLogTail, taskExecution.debugLogTail) && TaskExecution.equalsNullable(this.errorLogTail, taskExecution.errorLogTail) && TaskExecution.equalsNullable(this.embeddedMode, taskExecution.embeddedMode) && Objects.equals(this.createdAt, taskExecution.createdAt) && Objects.equals(this.updatedAt, taskExecution.updatedAt);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.url, this.uuid, this.dashboardUrl, this.infrastructureWebsiteUrl, this.task, TaskExecution.hashCodeNullable(this.taskVersionNumber), TaskExecution.hashCodeNullable(this.taskVersionText), TaskExecution.hashCodeNullable(this.taskVersionSignature), this.commitUrl, TaskExecution.hashCodeNullable(this.otherInstanceMetadata), TaskExecution.hashCodeNullable(this.hostname), TaskExecution.hashCodeNullable(this.environmentVariablesOverrides), this.executionMethod, this.status, this.startedBy, this.startedAt, TaskExecution.hashCodeNullable(this.finishedAt), this.markedDoneBy, TaskExecution.hashCodeNullable(this.markedDoneAt), TaskExecution.hashCodeNullable(this.markedOutdatedAt), this.killedBy, TaskExecution.hashCodeNullable(this.killStartedAt), TaskExecution.hashCodeNullable(this.killFinishedAt), TaskExecution.hashCodeNullable(this.killErrorCode), this.stopReason, TaskExecution.hashCodeNullable(this.lastHeartbeatAt), this.failedAttempts, this.timedOutAttempts, TaskExecution.hashCodeNullable(this.exitCode), TaskExecution.hashCodeNullable(this.lastStatusMessage), TaskExecution.hashCodeNullable(this.errorCount), TaskExecution.hashCodeNullable(this.skippedCount), TaskExecution.hashCodeNullable(this.expectedCount), TaskExecution.hashCodeNullable(this.successCount), TaskExecution.hashCodeNullable(this.otherRuntimeMetadata), TaskExecution.hashCodeNullable(this.currentCpuUnits), TaskExecution.hashCodeNullable(this.meanCpuUnits), TaskExecution.hashCodeNullable(this.maxCpuUnits), TaskExecution.hashCodeNullable(this.currentMemoryMb), TaskExecution.hashCodeNullable(this.meanMemoryMb), TaskExecution.hashCodeNullable(this.maxMemoryMb), TaskExecution.hashCodeNullable(this.wrapperVersion), TaskExecution.hashCodeNullable(this.wrapperLogLevel), TaskExecution.hashCodeNullable(this.deployment), TaskExecution.hashCodeNullable(this.processCommand), TaskExecution.hashCodeNullable(this.isService), TaskExecution.hashCodeNullable(this.taskMaxConcurrency), TaskExecution.hashCodeNullable(this.maxConflictingAgeSeconds), TaskExecution.hashCodeNullable(this.preventOfflineExecution), TaskExecution.hashCodeNullable(this.processTimeoutSeconds), TaskExecution.hashCodeNullable(this.processTerminationGracePeriodSeconds), TaskExecution.hashCodeNullable(this.processMaxRetries), TaskExecution.hashCodeNullable(this.processRetryDelaySeconds), TaskExecution.hashCodeNullable(this.schedule), TaskExecution.hashCodeNullable(this.heartbeatIntervalSeconds), this.workflowTaskInstanceExecution, this.apiBaseUrl, TaskExecution.hashCodeNullable(this.apiRequestTimeoutSeconds), TaskExecution.hashCodeNullable(this.apiRetryDelaySeconds), TaskExecution.hashCodeNullable(this.apiResumeDelaySeconds), TaskExecution.hashCodeNullable(this.apiErrorTimeoutSeconds), TaskExecution.hashCodeNullable(this.apiTaskExecutionCreationErrorTimeoutSeconds), TaskExecution.hashCodeNullable(this.apiTaskExecutionCreationConflictTimeoutSeconds), TaskExecution.hashCodeNullable(this.apiTaskExecutionCreationConflictRetryDelaySeconds), TaskExecution.hashCodeNullable(this.apiFinalUpdateTimeoutSeconds), TaskExecution.hashCodeNullable(this.statusUpdateIntervalSeconds), TaskExecution.hashCodeNullable(this.statusUpdatePort), TaskExecution.hashCodeNullable(this.statusUpdateMessageMaxBytes), TaskExecution.hashCodeNullable(this.debugLogTail), TaskExecution.hashCodeNullable(this.errorLogTail), TaskExecution.hashCodeNullable(this.embeddedMode), this.createdAt, this.updatedAt});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaskExecution {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    dashboardUrl: ").append(this.toIndentedString(this.dashboardUrl)).append("\n");
        sb.append("    infrastructureWebsiteUrl: ").append(this.toIndentedString(this.infrastructureWebsiteUrl)).append("\n");
        sb.append("    task: ").append(this.toIndentedString(this.task)).append("\n");
        sb.append("    taskVersionNumber: ").append(this.toIndentedString(this.taskVersionNumber)).append("\n");
        sb.append("    taskVersionText: ").append(this.toIndentedString(this.taskVersionText)).append("\n");
        sb.append("    taskVersionSignature: ").append(this.toIndentedString(this.taskVersionSignature)).append("\n");
        sb.append("    commitUrl: ").append(this.toIndentedString(this.commitUrl)).append("\n");
        sb.append("    otherInstanceMetadata: ").append(this.toIndentedString(this.otherInstanceMetadata)).append("\n");
        sb.append("    hostname: ").append(this.toIndentedString(this.hostname)).append("\n");
        sb.append("    environmentVariablesOverrides: ").append(this.toIndentedString(this.environmentVariablesOverrides)).append("\n");
        sb.append("    executionMethod: ").append(this.toIndentedString(this.executionMethod)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    startedBy: ").append(this.toIndentedString(this.startedBy)).append("\n");
        sb.append("    startedAt: ").append(this.toIndentedString(this.startedAt)).append("\n");
        sb.append("    finishedAt: ").append(this.toIndentedString(this.finishedAt)).append("\n");
        sb.append("    markedDoneBy: ").append(this.toIndentedString(this.markedDoneBy)).append("\n");
        sb.append("    markedDoneAt: ").append(this.toIndentedString(this.markedDoneAt)).append("\n");
        sb.append("    markedOutdatedAt: ").append(this.toIndentedString(this.markedOutdatedAt)).append("\n");
        sb.append("    killedBy: ").append(this.toIndentedString(this.killedBy)).append("\n");
        sb.append("    killStartedAt: ").append(this.toIndentedString(this.killStartedAt)).append("\n");
        sb.append("    killFinishedAt: ").append(this.toIndentedString(this.killFinishedAt)).append("\n");
        sb.append("    killErrorCode: ").append(this.toIndentedString(this.killErrorCode)).append("\n");
        sb.append("    stopReason: ").append(this.toIndentedString((Object)this.stopReason)).append("\n");
        sb.append("    lastHeartbeatAt: ").append(this.toIndentedString(this.lastHeartbeatAt)).append("\n");
        sb.append("    failedAttempts: ").append(this.toIndentedString(this.failedAttempts)).append("\n");
        sb.append("    timedOutAttempts: ").append(this.toIndentedString(this.timedOutAttempts)).append("\n");
        sb.append("    exitCode: ").append(this.toIndentedString(this.exitCode)).append("\n");
        sb.append("    lastStatusMessage: ").append(this.toIndentedString(this.lastStatusMessage)).append("\n");
        sb.append("    errorCount: ").append(this.toIndentedString(this.errorCount)).append("\n");
        sb.append("    skippedCount: ").append(this.toIndentedString(this.skippedCount)).append("\n");
        sb.append("    expectedCount: ").append(this.toIndentedString(this.expectedCount)).append("\n");
        sb.append("    successCount: ").append(this.toIndentedString(this.successCount)).append("\n");
        sb.append("    otherRuntimeMetadata: ").append(this.toIndentedString(this.otherRuntimeMetadata)).append("\n");
        sb.append("    currentCpuUnits: ").append(this.toIndentedString(this.currentCpuUnits)).append("\n");
        sb.append("    meanCpuUnits: ").append(this.toIndentedString(this.meanCpuUnits)).append("\n");
        sb.append("    maxCpuUnits: ").append(this.toIndentedString(this.maxCpuUnits)).append("\n");
        sb.append("    currentMemoryMb: ").append(this.toIndentedString(this.currentMemoryMb)).append("\n");
        sb.append("    meanMemoryMb: ").append(this.toIndentedString(this.meanMemoryMb)).append("\n");
        sb.append("    maxMemoryMb: ").append(this.toIndentedString(this.maxMemoryMb)).append("\n");
        sb.append("    wrapperVersion: ").append(this.toIndentedString(this.wrapperVersion)).append("\n");
        sb.append("    wrapperLogLevel: ").append(this.toIndentedString(this.wrapperLogLevel)).append("\n");
        sb.append("    deployment: ").append(this.toIndentedString(this.deployment)).append("\n");
        sb.append("    processCommand: ").append(this.toIndentedString(this.processCommand)).append("\n");
        sb.append("    isService: ").append(this.toIndentedString(this.isService)).append("\n");
        sb.append("    taskMaxConcurrency: ").append(this.toIndentedString(this.taskMaxConcurrency)).append("\n");
        sb.append("    maxConflictingAgeSeconds: ").append(this.toIndentedString(this.maxConflictingAgeSeconds)).append("\n");
        sb.append("    preventOfflineExecution: ").append(this.toIndentedString(this.preventOfflineExecution)).append("\n");
        sb.append("    processTimeoutSeconds: ").append(this.toIndentedString(this.processTimeoutSeconds)).append("\n");
        sb.append("    processTerminationGracePeriodSeconds: ").append(this.toIndentedString(this.processTerminationGracePeriodSeconds)).append("\n");
        sb.append("    processMaxRetries: ").append(this.toIndentedString(this.processMaxRetries)).append("\n");
        sb.append("    processRetryDelaySeconds: ").append(this.toIndentedString(this.processRetryDelaySeconds)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("    heartbeatIntervalSeconds: ").append(this.toIndentedString(this.heartbeatIntervalSeconds)).append("\n");
        sb.append("    workflowTaskInstanceExecution: ").append(this.toIndentedString(this.workflowTaskInstanceExecution)).append("\n");
        sb.append("    apiBaseUrl: ").append(this.toIndentedString(this.apiBaseUrl)).append("\n");
        sb.append("    apiRequestTimeoutSeconds: ").append(this.toIndentedString(this.apiRequestTimeoutSeconds)).append("\n");
        sb.append("    apiRetryDelaySeconds: ").append(this.toIndentedString(this.apiRetryDelaySeconds)).append("\n");
        sb.append("    apiResumeDelaySeconds: ").append(this.toIndentedString(this.apiResumeDelaySeconds)).append("\n");
        sb.append("    apiErrorTimeoutSeconds: ").append(this.toIndentedString(this.apiErrorTimeoutSeconds)).append("\n");
        sb.append("    apiTaskExecutionCreationErrorTimeoutSeconds: ").append(this.toIndentedString(this.apiTaskExecutionCreationErrorTimeoutSeconds)).append("\n");
        sb.append("    apiTaskExecutionCreationConflictTimeoutSeconds: ").append(this.toIndentedString(this.apiTaskExecutionCreationConflictTimeoutSeconds)).append("\n");
        sb.append("    apiTaskExecutionCreationConflictRetryDelaySeconds: ").append(this.toIndentedString(this.apiTaskExecutionCreationConflictRetryDelaySeconds)).append("\n");
        sb.append("    apiFinalUpdateTimeoutSeconds: ").append(this.toIndentedString(this.apiFinalUpdateTimeoutSeconds)).append("\n");
        sb.append("    statusUpdateIntervalSeconds: ").append(this.toIndentedString(this.statusUpdateIntervalSeconds)).append("\n");
        sb.append("    statusUpdatePort: ").append(this.toIndentedString(this.statusUpdatePort)).append("\n");
        sb.append("    statusUpdateMessageMaxBytes: ").append(this.toIndentedString(this.statusUpdateMessageMaxBytes)).append("\n");
        sb.append("    debugLogTail: ").append(this.toIndentedString(this.debugLogTail)).append("\n");
        sb.append("    errorLogTail: ").append(this.toIndentedString(this.errorLogTail)).append("\n");
        sb.append("    embeddedMode: ").append(this.toIndentedString(this.embeddedMode)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

