/*
 * Decompiled with CFR 0.152.
 */
package io.cloudreactor.tasksymphony.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.cloudreactor.tasksymphony.model.FailureBehaviorEnum;
import io.cloudreactor.tasksymphony.model.NameAndUuid;
import io.cloudreactor.tasksymphony.model.StartTransitionConditionEnum;
import io.cloudreactor.tasksymphony.model.TimeoutBehaviorEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="A WorkflowTaskInstance contains a Task that is configured to run in a Workflow.")
@JsonPropertyOrder(value={"url", "uuid", "name", "description", "workflow", "task", "start_transition_condition", "max_complete_executions", "should_eval_transitions_after_first_execution", "condition_count_threshold", "condition_ratio_threshold", "max_age_seconds", "default_max_retries", "failure_behavior", "allow_workflow_execution_after_failure", "timeout_behavior", "allow_workflow_execution_after_timeout", "environment_variables_overrides", "allocated_cpu_units", "allocated_memory_mb", "use_task_alert_methods", "ui_color", "ui_icon_type", "ui_scale", "ui_center_margin_top", "ui_center_margin_left", "created_at", "updated_at"})
@JsonTypeName(value="WorkflowTaskInstance")
public class WorkflowTaskInstance {
    public static final String JSON_PROPERTY_URL = "url";
    private URI url;
    public static final String JSON_PROPERTY_UUID = "uuid";
    private UUID uuid;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_WORKFLOW = "workflow";
    private NameAndUuid workflow;
    public static final String JSON_PROPERTY_TASK = "task";
    private NameAndUuid task;
    public static final String JSON_PROPERTY_START_TRANSITION_CONDITION = "start_transition_condition";
    private StartTransitionConditionEnum startTransitionCondition;
    public static final String JSON_PROPERTY_MAX_COMPLETE_EXECUTIONS = "max_complete_executions";
    private JsonNullable<Integer> maxCompleteExecutions = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SHOULD_EVAL_TRANSITIONS_AFTER_FIRST_EXECUTION = "should_eval_transitions_after_first_execution";
    private Boolean shouldEvalTransitionsAfterFirstExecution;
    public static final String JSON_PROPERTY_CONDITION_COUNT_THRESHOLD = "condition_count_threshold";
    private JsonNullable<Integer> conditionCountThreshold = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CONDITION_RATIO_THRESHOLD = "condition_ratio_threshold";
    private JsonNullable<Float> conditionRatioThreshold = JsonNullable.undefined();
    public static final String JSON_PROPERTY_MAX_AGE_SECONDS = "max_age_seconds";
    private JsonNullable<Integer> maxAgeSeconds = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DEFAULT_MAX_RETRIES = "default_max_retries";
    private Integer defaultMaxRetries;
    public static final String JSON_PROPERTY_FAILURE_BEHAVIOR = "failure_behavior";
    private FailureBehaviorEnum failureBehavior;
    public static final String JSON_PROPERTY_ALLOW_WORKFLOW_EXECUTION_AFTER_FAILURE = "allow_workflow_execution_after_failure";
    private Boolean allowWorkflowExecutionAfterFailure;
    public static final String JSON_PROPERTY_TIMEOUT_BEHAVIOR = "timeout_behavior";
    private TimeoutBehaviorEnum timeoutBehavior;
    public static final String JSON_PROPERTY_ALLOW_WORKFLOW_EXECUTION_AFTER_TIMEOUT = "allow_workflow_execution_after_timeout";
    private Boolean allowWorkflowExecutionAfterTimeout;
    public static final String JSON_PROPERTY_ENVIRONMENT_VARIABLES_OVERRIDES = "environment_variables_overrides";
    private JsonNullable<Map<String, Object>> environmentVariablesOverrides = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ALLOCATED_CPU_UNITS = "allocated_cpu_units";
    private JsonNullable<Integer> allocatedCpuUnits = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ALLOCATED_MEMORY_MB = "allocated_memory_mb";
    private JsonNullable<Integer> allocatedMemoryMb = JsonNullable.undefined();
    public static final String JSON_PROPERTY_USE_TASK_ALERT_METHODS = "use_task_alert_methods";
    private Boolean useTaskAlertMethods;
    public static final String JSON_PROPERTY_UI_COLOR = "ui_color";
    private String uiColor;
    public static final String JSON_PROPERTY_UI_ICON_TYPE = "ui_icon_type";
    private String uiIconType;
    public static final String JSON_PROPERTY_UI_SCALE = "ui_scale";
    private JsonNullable<Float> uiScale = JsonNullable.undefined();
    public static final String JSON_PROPERTY_UI_CENTER_MARGIN_TOP = "ui_center_margin_top";
    private JsonNullable<Float> uiCenterMarginTop = JsonNullable.undefined();
    public static final String JSON_PROPERTY_UI_CENTER_MARGIN_LEFT = "ui_center_margin_left";
    private JsonNullable<Float> uiCenterMarginLeft = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private OffsetDateTime updatedAt;

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public URI getUrl() {
        return this.url;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="uuid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getUuid() {
        return this.uuid;
    }

    public WorkflowTaskInstance name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public WorkflowTaskInstance description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public WorkflowTaskInstance workflow(NameAndUuid workflow) {
        this.workflow = workflow;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="workflow")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public NameAndUuid getWorkflow() {
        return this.workflow;
    }

    @JsonProperty(value="workflow")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setWorkflow(NameAndUuid workflow) {
        this.workflow = workflow;
    }

    public WorkflowTaskInstance task(NameAndUuid task) {
        this.task = task;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="task")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public NameAndUuid getTask() {
        return this.task;
    }

    @JsonProperty(value="task")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTask(NameAndUuid task) {
        this.task = task;
    }

    public WorkflowTaskInstance startTransitionCondition(StartTransitionConditionEnum startTransitionCondition) {
        this.startTransitionCondition = startTransitionCondition;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="start_transition_condition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StartTransitionConditionEnum getStartTransitionCondition() {
        return this.startTransitionCondition;
    }

    @JsonProperty(value="start_transition_condition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartTransitionCondition(StartTransitionConditionEnum startTransitionCondition) {
        this.startTransitionCondition = startTransitionCondition;
    }

    public WorkflowTaskInstance maxCompleteExecutions(Integer maxCompleteExecutions) {
        this.maxCompleteExecutions = JsonNullable.of((Object)maxCompleteExecutions);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getMaxCompleteExecutions() {
        return (Integer)this.maxCompleteExecutions.orElse(null);
    }

    @JsonProperty(value="max_complete_executions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getMaxCompleteExecutions_JsonNullable() {
        return this.maxCompleteExecutions;
    }

    @JsonProperty(value="max_complete_executions")
    public void setMaxCompleteExecutions_JsonNullable(JsonNullable<Integer> maxCompleteExecutions) {
        this.maxCompleteExecutions = maxCompleteExecutions;
    }

    public void setMaxCompleteExecutions(Integer maxCompleteExecutions) {
        this.maxCompleteExecutions = JsonNullable.of((Object)maxCompleteExecutions);
    }

    public WorkflowTaskInstance shouldEvalTransitionsAfterFirstExecution(Boolean shouldEvalTransitionsAfterFirstExecution) {
        this.shouldEvalTransitionsAfterFirstExecution = shouldEvalTransitionsAfterFirstExecution;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="should_eval_transitions_after_first_execution")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShouldEvalTransitionsAfterFirstExecution() {
        return this.shouldEvalTransitionsAfterFirstExecution;
    }

    @JsonProperty(value="should_eval_transitions_after_first_execution")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShouldEvalTransitionsAfterFirstExecution(Boolean shouldEvalTransitionsAfterFirstExecution) {
        this.shouldEvalTransitionsAfterFirstExecution = shouldEvalTransitionsAfterFirstExecution;
    }

    public WorkflowTaskInstance conditionCountThreshold(Integer conditionCountThreshold) {
        this.conditionCountThreshold = JsonNullable.of((Object)conditionCountThreshold);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getConditionCountThreshold() {
        return (Integer)this.conditionCountThreshold.orElse(null);
    }

    @JsonProperty(value="condition_count_threshold")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getConditionCountThreshold_JsonNullable() {
        return this.conditionCountThreshold;
    }

    @JsonProperty(value="condition_count_threshold")
    public void setConditionCountThreshold_JsonNullable(JsonNullable<Integer> conditionCountThreshold) {
        this.conditionCountThreshold = conditionCountThreshold;
    }

    public void setConditionCountThreshold(Integer conditionCountThreshold) {
        this.conditionCountThreshold = JsonNullable.of((Object)conditionCountThreshold);
    }

    public WorkflowTaskInstance conditionRatioThreshold(Float conditionRatioThreshold) {
        this.conditionRatioThreshold = JsonNullable.of((Object)conditionRatioThreshold);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Float getConditionRatioThreshold() {
        return (Float)this.conditionRatioThreshold.orElse(null);
    }

    @JsonProperty(value="condition_ratio_threshold")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Float> getConditionRatioThreshold_JsonNullable() {
        return this.conditionRatioThreshold;
    }

    @JsonProperty(value="condition_ratio_threshold")
    public void setConditionRatioThreshold_JsonNullable(JsonNullable<Float> conditionRatioThreshold) {
        this.conditionRatioThreshold = conditionRatioThreshold;
    }

    public void setConditionRatioThreshold(Float conditionRatioThreshold) {
        this.conditionRatioThreshold = JsonNullable.of((Object)conditionRatioThreshold);
    }

    public WorkflowTaskInstance maxAgeSeconds(Integer maxAgeSeconds) {
        this.maxAgeSeconds = JsonNullable.of((Object)maxAgeSeconds);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getMaxAgeSeconds() {
        return (Integer)this.maxAgeSeconds.orElse(null);
    }

    @JsonProperty(value="max_age_seconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getMaxAgeSeconds_JsonNullable() {
        return this.maxAgeSeconds;
    }

    @JsonProperty(value="max_age_seconds")
    public void setMaxAgeSeconds_JsonNullable(JsonNullable<Integer> maxAgeSeconds) {
        this.maxAgeSeconds = maxAgeSeconds;
    }

    public void setMaxAgeSeconds(Integer maxAgeSeconds) {
        this.maxAgeSeconds = JsonNullable.of((Object)maxAgeSeconds);
    }

    public WorkflowTaskInstance defaultMaxRetries(Integer defaultMaxRetries) {
        this.defaultMaxRetries = defaultMaxRetries;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="default_max_retries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getDefaultMaxRetries() {
        return this.defaultMaxRetries;
    }

    @JsonProperty(value="default_max_retries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefaultMaxRetries(Integer defaultMaxRetries) {
        this.defaultMaxRetries = defaultMaxRetries;
    }

    public WorkflowTaskInstance failureBehavior(FailureBehaviorEnum failureBehavior) {
        this.failureBehavior = failureBehavior;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="failure_behavior")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FailureBehaviorEnum getFailureBehavior() {
        return this.failureBehavior;
    }

    @JsonProperty(value="failure_behavior")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFailureBehavior(FailureBehaviorEnum failureBehavior) {
        this.failureBehavior = failureBehavior;
    }

    public WorkflowTaskInstance allowWorkflowExecutionAfterFailure(Boolean allowWorkflowExecutionAfterFailure) {
        this.allowWorkflowExecutionAfterFailure = allowWorkflowExecutionAfterFailure;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="allow_workflow_execution_after_failure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowWorkflowExecutionAfterFailure() {
        return this.allowWorkflowExecutionAfterFailure;
    }

    @JsonProperty(value="allow_workflow_execution_after_failure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowWorkflowExecutionAfterFailure(Boolean allowWorkflowExecutionAfterFailure) {
        this.allowWorkflowExecutionAfterFailure = allowWorkflowExecutionAfterFailure;
    }

    public WorkflowTaskInstance timeoutBehavior(TimeoutBehaviorEnum timeoutBehavior) {
        this.timeoutBehavior = timeoutBehavior;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="timeout_behavior")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TimeoutBehaviorEnum getTimeoutBehavior() {
        return this.timeoutBehavior;
    }

    @JsonProperty(value="timeout_behavior")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTimeoutBehavior(TimeoutBehaviorEnum timeoutBehavior) {
        this.timeoutBehavior = timeoutBehavior;
    }

    public WorkflowTaskInstance allowWorkflowExecutionAfterTimeout(Boolean allowWorkflowExecutionAfterTimeout) {
        this.allowWorkflowExecutionAfterTimeout = allowWorkflowExecutionAfterTimeout;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="allow_workflow_execution_after_timeout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowWorkflowExecutionAfterTimeout() {
        return this.allowWorkflowExecutionAfterTimeout;
    }

    @JsonProperty(value="allow_workflow_execution_after_timeout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowWorkflowExecutionAfterTimeout(Boolean allowWorkflowExecutionAfterTimeout) {
        this.allowWorkflowExecutionAfterTimeout = allowWorkflowExecutionAfterTimeout;
    }

    public WorkflowTaskInstance environmentVariablesOverrides(Map<String, Object> environmentVariablesOverrides) {
        this.environmentVariablesOverrides = JsonNullable.of(environmentVariablesOverrides);
        return this;
    }

    public WorkflowTaskInstance putEnvironmentVariablesOverridesItem(String key, Object environmentVariablesOverridesItem) {
        if (this.environmentVariablesOverrides == null || !this.environmentVariablesOverrides.isPresent()) {
            this.environmentVariablesOverrides = JsonNullable.of(new HashMap());
        }
        try {
            ((Map)this.environmentVariablesOverrides.get()).put(key, environmentVariablesOverridesItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Map<String, Object> getEnvironmentVariablesOverrides() {
        return (Map)this.environmentVariablesOverrides.orElse(null);
    }

    @JsonProperty(value="environment_variables_overrides")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Map<String, Object>> getEnvironmentVariablesOverrides_JsonNullable() {
        return this.environmentVariablesOverrides;
    }

    @JsonProperty(value="environment_variables_overrides")
    public void setEnvironmentVariablesOverrides_JsonNullable(JsonNullable<Map<String, Object>> environmentVariablesOverrides) {
        this.environmentVariablesOverrides = environmentVariablesOverrides;
    }

    public void setEnvironmentVariablesOverrides(Map<String, Object> environmentVariablesOverrides) {
        this.environmentVariablesOverrides = JsonNullable.of(environmentVariablesOverrides);
    }

    public WorkflowTaskInstance allocatedCpuUnits(Integer allocatedCpuUnits) {
        this.allocatedCpuUnits = JsonNullable.of((Object)allocatedCpuUnits);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getAllocatedCpuUnits() {
        return (Integer)this.allocatedCpuUnits.orElse(null);
    }

    @JsonProperty(value="allocated_cpu_units")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getAllocatedCpuUnits_JsonNullable() {
        return this.allocatedCpuUnits;
    }

    @JsonProperty(value="allocated_cpu_units")
    public void setAllocatedCpuUnits_JsonNullable(JsonNullable<Integer> allocatedCpuUnits) {
        this.allocatedCpuUnits = allocatedCpuUnits;
    }

    public void setAllocatedCpuUnits(Integer allocatedCpuUnits) {
        this.allocatedCpuUnits = JsonNullable.of((Object)allocatedCpuUnits);
    }

    public WorkflowTaskInstance allocatedMemoryMb(Integer allocatedMemoryMb) {
        this.allocatedMemoryMb = JsonNullable.of((Object)allocatedMemoryMb);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getAllocatedMemoryMb() {
        return (Integer)this.allocatedMemoryMb.orElse(null);
    }

    @JsonProperty(value="allocated_memory_mb")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getAllocatedMemoryMb_JsonNullable() {
        return this.allocatedMemoryMb;
    }

    @JsonProperty(value="allocated_memory_mb")
    public void setAllocatedMemoryMb_JsonNullable(JsonNullable<Integer> allocatedMemoryMb) {
        this.allocatedMemoryMb = allocatedMemoryMb;
    }

    public void setAllocatedMemoryMb(Integer allocatedMemoryMb) {
        this.allocatedMemoryMb = JsonNullable.of((Object)allocatedMemoryMb);
    }

    public WorkflowTaskInstance useTaskAlertMethods(Boolean useTaskAlertMethods) {
        this.useTaskAlertMethods = useTaskAlertMethods;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="use_task_alert_methods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getUseTaskAlertMethods() {
        return this.useTaskAlertMethods;
    }

    @JsonProperty(value="use_task_alert_methods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUseTaskAlertMethods(Boolean useTaskAlertMethods) {
        this.useTaskAlertMethods = useTaskAlertMethods;
    }

    public WorkflowTaskInstance uiColor(String uiColor) {
        this.uiColor = uiColor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="ui_color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUiColor() {
        return this.uiColor;
    }

    @JsonProperty(value="ui_color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUiColor(String uiColor) {
        this.uiColor = uiColor;
    }

    public WorkflowTaskInstance uiIconType(String uiIconType) {
        this.uiIconType = uiIconType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="ui_icon_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUiIconType() {
        return this.uiIconType;
    }

    @JsonProperty(value="ui_icon_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUiIconType(String uiIconType) {
        this.uiIconType = uiIconType;
    }

    public WorkflowTaskInstance uiScale(Float uiScale) {
        this.uiScale = JsonNullable.of((Object)uiScale);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Float getUiScale() {
        return (Float)this.uiScale.orElse(null);
    }

    @JsonProperty(value="ui_scale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Float> getUiScale_JsonNullable() {
        return this.uiScale;
    }

    @JsonProperty(value="ui_scale")
    public void setUiScale_JsonNullable(JsonNullable<Float> uiScale) {
        this.uiScale = uiScale;
    }

    public void setUiScale(Float uiScale) {
        this.uiScale = JsonNullable.of((Object)uiScale);
    }

    public WorkflowTaskInstance uiCenterMarginTop(Float uiCenterMarginTop) {
        this.uiCenterMarginTop = JsonNullable.of((Object)uiCenterMarginTop);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Float getUiCenterMarginTop() {
        return (Float)this.uiCenterMarginTop.orElse(null);
    }

    @JsonProperty(value="ui_center_margin_top")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Float> getUiCenterMarginTop_JsonNullable() {
        return this.uiCenterMarginTop;
    }

    @JsonProperty(value="ui_center_margin_top")
    public void setUiCenterMarginTop_JsonNullable(JsonNullable<Float> uiCenterMarginTop) {
        this.uiCenterMarginTop = uiCenterMarginTop;
    }

    public void setUiCenterMarginTop(Float uiCenterMarginTop) {
        this.uiCenterMarginTop = JsonNullable.of((Object)uiCenterMarginTop);
    }

    public WorkflowTaskInstance uiCenterMarginLeft(Float uiCenterMarginLeft) {
        this.uiCenterMarginLeft = JsonNullable.of((Object)uiCenterMarginLeft);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Float getUiCenterMarginLeft() {
        return (Float)this.uiCenterMarginLeft.orElse(null);
    }

    @JsonProperty(value="ui_center_margin_left")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Float> getUiCenterMarginLeft_JsonNullable() {
        return this.uiCenterMarginLeft;
    }

    @JsonProperty(value="ui_center_margin_left")
    public void setUiCenterMarginLeft_JsonNullable(JsonNullable<Float> uiCenterMarginLeft) {
        this.uiCenterMarginLeft = uiCenterMarginLeft;
    }

    public void setUiCenterMarginLeft(Float uiCenterMarginLeft) {
        this.uiCenterMarginLeft = JsonNullable.of((Object)uiCenterMarginLeft);
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowTaskInstance workflowTaskInstance = (WorkflowTaskInstance)o;
        return Objects.equals(this.url, workflowTaskInstance.url) && Objects.equals(this.uuid, workflowTaskInstance.uuid) && Objects.equals(this.name, workflowTaskInstance.name) && Objects.equals(this.description, workflowTaskInstance.description) && Objects.equals(this.workflow, workflowTaskInstance.workflow) && Objects.equals(this.task, workflowTaskInstance.task) && Objects.equals((Object)this.startTransitionCondition, (Object)workflowTaskInstance.startTransitionCondition) && WorkflowTaskInstance.equalsNullable(this.maxCompleteExecutions, workflowTaskInstance.maxCompleteExecutions) && Objects.equals(this.shouldEvalTransitionsAfterFirstExecution, workflowTaskInstance.shouldEvalTransitionsAfterFirstExecution) && WorkflowTaskInstance.equalsNullable(this.conditionCountThreshold, workflowTaskInstance.conditionCountThreshold) && WorkflowTaskInstance.equalsNullable(this.conditionRatioThreshold, workflowTaskInstance.conditionRatioThreshold) && WorkflowTaskInstance.equalsNullable(this.maxAgeSeconds, workflowTaskInstance.maxAgeSeconds) && Objects.equals(this.defaultMaxRetries, workflowTaskInstance.defaultMaxRetries) && Objects.equals((Object)this.failureBehavior, (Object)workflowTaskInstance.failureBehavior) && Objects.equals(this.allowWorkflowExecutionAfterFailure, workflowTaskInstance.allowWorkflowExecutionAfterFailure) && Objects.equals((Object)this.timeoutBehavior, (Object)workflowTaskInstance.timeoutBehavior) && Objects.equals(this.allowWorkflowExecutionAfterTimeout, workflowTaskInstance.allowWorkflowExecutionAfterTimeout) && WorkflowTaskInstance.equalsNullable(this.environmentVariablesOverrides, workflowTaskInstance.environmentVariablesOverrides) && WorkflowTaskInstance.equalsNullable(this.allocatedCpuUnits, workflowTaskInstance.allocatedCpuUnits) && WorkflowTaskInstance.equalsNullable(this.allocatedMemoryMb, workflowTaskInstance.allocatedMemoryMb) && Objects.equals(this.useTaskAlertMethods, workflowTaskInstance.useTaskAlertMethods) && Objects.equals(this.uiColor, workflowTaskInstance.uiColor) && Objects.equals(this.uiIconType, workflowTaskInstance.uiIconType) && WorkflowTaskInstance.equalsNullable(this.uiScale, workflowTaskInstance.uiScale) && WorkflowTaskInstance.equalsNullable(this.uiCenterMarginTop, workflowTaskInstance.uiCenterMarginTop) && WorkflowTaskInstance.equalsNullable(this.uiCenterMarginLeft, workflowTaskInstance.uiCenterMarginLeft) && Objects.equals(this.createdAt, workflowTaskInstance.createdAt) && Objects.equals(this.updatedAt, workflowTaskInstance.updatedAt);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.url, this.uuid, this.name, this.description, this.workflow, this.task, this.startTransitionCondition, WorkflowTaskInstance.hashCodeNullable(this.maxCompleteExecutions), this.shouldEvalTransitionsAfterFirstExecution, WorkflowTaskInstance.hashCodeNullable(this.conditionCountThreshold), WorkflowTaskInstance.hashCodeNullable(this.conditionRatioThreshold), WorkflowTaskInstance.hashCodeNullable(this.maxAgeSeconds), this.defaultMaxRetries, this.failureBehavior, this.allowWorkflowExecutionAfterFailure, this.timeoutBehavior, this.allowWorkflowExecutionAfterTimeout, WorkflowTaskInstance.hashCodeNullable(this.environmentVariablesOverrides), WorkflowTaskInstance.hashCodeNullable(this.allocatedCpuUnits), WorkflowTaskInstance.hashCodeNullable(this.allocatedMemoryMb), this.useTaskAlertMethods, this.uiColor, this.uiIconType, WorkflowTaskInstance.hashCodeNullable(this.uiScale), WorkflowTaskInstance.hashCodeNullable(this.uiCenterMarginTop), WorkflowTaskInstance.hashCodeNullable(this.uiCenterMarginLeft), this.createdAt, this.updatedAt});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkflowTaskInstance {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    workflow: ").append(this.toIndentedString(this.workflow)).append("\n");
        sb.append("    task: ").append(this.toIndentedString(this.task)).append("\n");
        sb.append("    startTransitionCondition: ").append(this.toIndentedString((Object)this.startTransitionCondition)).append("\n");
        sb.append("    maxCompleteExecutions: ").append(this.toIndentedString(this.maxCompleteExecutions)).append("\n");
        sb.append("    shouldEvalTransitionsAfterFirstExecution: ").append(this.toIndentedString(this.shouldEvalTransitionsAfterFirstExecution)).append("\n");
        sb.append("    conditionCountThreshold: ").append(this.toIndentedString(this.conditionCountThreshold)).append("\n");
        sb.append("    conditionRatioThreshold: ").append(this.toIndentedString(this.conditionRatioThreshold)).append("\n");
        sb.append("    maxAgeSeconds: ").append(this.toIndentedString(this.maxAgeSeconds)).append("\n");
        sb.append("    defaultMaxRetries: ").append(this.toIndentedString(this.defaultMaxRetries)).append("\n");
        sb.append("    failureBehavior: ").append(this.toIndentedString((Object)this.failureBehavior)).append("\n");
        sb.append("    allowWorkflowExecutionAfterFailure: ").append(this.toIndentedString(this.allowWorkflowExecutionAfterFailure)).append("\n");
        sb.append("    timeoutBehavior: ").append(this.toIndentedString((Object)this.timeoutBehavior)).append("\n");
        sb.append("    allowWorkflowExecutionAfterTimeout: ").append(this.toIndentedString(this.allowWorkflowExecutionAfterTimeout)).append("\n");
        sb.append("    environmentVariablesOverrides: ").append(this.toIndentedString(this.environmentVariablesOverrides)).append("\n");
        sb.append("    allocatedCpuUnits: ").append(this.toIndentedString(this.allocatedCpuUnits)).append("\n");
        sb.append("    allocatedMemoryMb: ").append(this.toIndentedString(this.allocatedMemoryMb)).append("\n");
        sb.append("    useTaskAlertMethods: ").append(this.toIndentedString(this.useTaskAlertMethods)).append("\n");
        sb.append("    uiColor: ").append(this.toIndentedString(this.uiColor)).append("\n");
        sb.append("    uiIconType: ").append(this.toIndentedString(this.uiIconType)).append("\n");
        sb.append("    uiScale: ").append(this.toIndentedString(this.uiScale)).append("\n");
        sb.append("    uiCenterMarginTop: ").append(this.toIndentedString(this.uiCenterMarginTop)).append("\n");
        sb.append("    uiCenterMarginLeft: ").append(this.toIndentedString(this.uiCenterMarginLeft)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

