/*
 * Decompiled with CFR 0.152.
 */
package io.cloudreactor.tasksymphony.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.cloudreactor.tasksymphony.model.NameAndUuid;
import io.cloudreactor.tasksymphony.model.RuleTypeEnum;
import io.cloudreactor.tasksymphony.model.ThresholdPropertyEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="A WorkflowTransition is a directed edge in a Worfklow, which is a directed graph. It contains a source WorkflowTaskInstance, a destination WorkflowTaskInstance, as well as conditions for triggering the destination to execution.")
@JsonPropertyOrder(value={"url", "uuid", "description", "from_workflow_task_instance", "to_workflow_task_instance", "rule_type", "exit_codes", "threshold_property", "custom_expression", "priority", "ui_color", "ui_line_style", "ui_scale", "created_at", "updated_at"})
@JsonTypeName(value="WorkflowTransition")
public class WorkflowTransition {
    public static final String JSON_PROPERTY_URL = "url";
    private URI url;
    public static final String JSON_PROPERTY_UUID = "uuid";
    private UUID uuid;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_FROM_WORKFLOW_TASK_INSTANCE = "from_workflow_task_instance";
    private NameAndUuid fromWorkflowTaskInstance;
    public static final String JSON_PROPERTY_TO_WORKFLOW_TASK_INSTANCE = "to_workflow_task_instance";
    private NameAndUuid toWorkflowTaskInstance;
    public static final String JSON_PROPERTY_RULE_TYPE = "rule_type";
    private RuleTypeEnum ruleType;
    public static final String JSON_PROPERTY_EXIT_CODES = "exit_codes";
    private JsonNullable<List<String>> exitCodes = JsonNullable.undefined();
    public static final String JSON_PROPERTY_THRESHOLD_PROPERTY = "threshold_property";
    private ThresholdPropertyEnum thresholdProperty;
    public static final String JSON_PROPERTY_CUSTOM_EXPRESSION = "custom_expression";
    private String customExpression;
    public static final String JSON_PROPERTY_PRIORITY = "priority";
    private JsonNullable<Integer> priority = JsonNullable.undefined();
    public static final String JSON_PROPERTY_UI_COLOR = "ui_color";
    private String uiColor;
    public static final String JSON_PROPERTY_UI_LINE_STYLE = "ui_line_style";
    private String uiLineStyle;
    public static final String JSON_PROPERTY_UI_SCALE = "ui_scale";
    private JsonNullable<Float> uiScale = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private OffsetDateTime updatedAt;

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public URI getUrl() {
        return this.url;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="uuid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getUuid() {
        return this.uuid;
    }

    public WorkflowTransition description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public WorkflowTransition fromWorkflowTaskInstance(NameAndUuid fromWorkflowTaskInstance) {
        this.fromWorkflowTaskInstance = fromWorkflowTaskInstance;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="from_workflow_task_instance")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public NameAndUuid getFromWorkflowTaskInstance() {
        return this.fromWorkflowTaskInstance;
    }

    @JsonProperty(value="from_workflow_task_instance")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFromWorkflowTaskInstance(NameAndUuid fromWorkflowTaskInstance) {
        this.fromWorkflowTaskInstance = fromWorkflowTaskInstance;
    }

    public WorkflowTransition toWorkflowTaskInstance(NameAndUuid toWorkflowTaskInstance) {
        this.toWorkflowTaskInstance = toWorkflowTaskInstance;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="to_workflow_task_instance")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public NameAndUuid getToWorkflowTaskInstance() {
        return this.toWorkflowTaskInstance;
    }

    @JsonProperty(value="to_workflow_task_instance")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setToWorkflowTaskInstance(NameAndUuid toWorkflowTaskInstance) {
        this.toWorkflowTaskInstance = toWorkflowTaskInstance;
    }

    public WorkflowTransition ruleType(RuleTypeEnum ruleType) {
        this.ruleType = ruleType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="rule_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RuleTypeEnum getRuleType() {
        return this.ruleType;
    }

    @JsonProperty(value="rule_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRuleType(RuleTypeEnum ruleType) {
        this.ruleType = ruleType;
    }

    public WorkflowTransition exitCodes(List<String> exitCodes) {
        this.exitCodes = JsonNullable.of(exitCodes);
        return this;
    }

    public WorkflowTransition addExitCodesItem(String exitCodesItem) {
        if (this.exitCodes == null || !this.exitCodes.isPresent()) {
            this.exitCodes = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.exitCodes.get()).add(exitCodesItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public List<String> getExitCodes() {
        return (List)this.exitCodes.orElse(null);
    }

    @JsonProperty(value="exit_codes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getExitCodes_JsonNullable() {
        return this.exitCodes;
    }

    @JsonProperty(value="exit_codes")
    public void setExitCodes_JsonNullable(JsonNullable<List<String>> exitCodes) {
        this.exitCodes = exitCodes;
    }

    public void setExitCodes(List<String> exitCodes) {
        this.exitCodes = JsonNullable.of(exitCodes);
    }

    public WorkflowTransition thresholdProperty(ThresholdPropertyEnum thresholdProperty) {
        this.thresholdProperty = thresholdProperty;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="threshold_property")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ThresholdPropertyEnum getThresholdProperty() {
        return this.thresholdProperty;
    }

    @JsonProperty(value="threshold_property")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThresholdProperty(ThresholdPropertyEnum thresholdProperty) {
        this.thresholdProperty = thresholdProperty;
    }

    public WorkflowTransition customExpression(String customExpression) {
        this.customExpression = customExpression;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="custom_expression")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomExpression() {
        return this.customExpression;
    }

    @JsonProperty(value="custom_expression")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomExpression(String customExpression) {
        this.customExpression = customExpression;
    }

    public WorkflowTransition priority(Integer priority) {
        this.priority = JsonNullable.of((Object)priority);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Integer getPriority() {
        return (Integer)this.priority.orElse(null);
    }

    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getPriority_JsonNullable() {
        return this.priority;
    }

    @JsonProperty(value="priority")
    public void setPriority_JsonNullable(JsonNullable<Integer> priority) {
        this.priority = priority;
    }

    public void setPriority(Integer priority) {
        this.priority = JsonNullable.of((Object)priority);
    }

    public WorkflowTransition uiColor(String uiColor) {
        this.uiColor = uiColor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="ui_color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUiColor() {
        return this.uiColor;
    }

    @JsonProperty(value="ui_color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUiColor(String uiColor) {
        this.uiColor = uiColor;
    }

    public WorkflowTransition uiLineStyle(String uiLineStyle) {
        this.uiLineStyle = uiLineStyle;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="ui_line_style")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUiLineStyle() {
        return this.uiLineStyle;
    }

    @JsonProperty(value="ui_line_style")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUiLineStyle(String uiLineStyle) {
        this.uiLineStyle = uiLineStyle;
    }

    public WorkflowTransition uiScale(Float uiScale) {
        this.uiScale = JsonNullable.of((Object)uiScale);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public Float getUiScale() {
        return (Float)this.uiScale.orElse(null);
    }

    @JsonProperty(value="ui_scale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Float> getUiScale_JsonNullable() {
        return this.uiScale;
    }

    @JsonProperty(value="ui_scale")
    public void setUiScale_JsonNullable(JsonNullable<Float> uiScale) {
        this.uiScale = uiScale;
    }

    public void setUiScale(Float uiScale) {
        this.uiScale = JsonNullable.of((Object)uiScale);
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowTransition workflowTransition = (WorkflowTransition)o;
        return Objects.equals(this.url, workflowTransition.url) && Objects.equals(this.uuid, workflowTransition.uuid) && Objects.equals(this.description, workflowTransition.description) && Objects.equals(this.fromWorkflowTaskInstance, workflowTransition.fromWorkflowTaskInstance) && Objects.equals(this.toWorkflowTaskInstance, workflowTransition.toWorkflowTaskInstance) && Objects.equals((Object)this.ruleType, (Object)workflowTransition.ruleType) && WorkflowTransition.equalsNullable(this.exitCodes, workflowTransition.exitCodes) && Objects.equals((Object)this.thresholdProperty, (Object)workflowTransition.thresholdProperty) && Objects.equals(this.customExpression, workflowTransition.customExpression) && WorkflowTransition.equalsNullable(this.priority, workflowTransition.priority) && Objects.equals(this.uiColor, workflowTransition.uiColor) && Objects.equals(this.uiLineStyle, workflowTransition.uiLineStyle) && WorkflowTransition.equalsNullable(this.uiScale, workflowTransition.uiScale) && Objects.equals(this.createdAt, workflowTransition.createdAt) && Objects.equals(this.updatedAt, workflowTransition.updatedAt);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.url, this.uuid, this.description, this.fromWorkflowTaskInstance, this.toWorkflowTaskInstance, this.ruleType, WorkflowTransition.hashCodeNullable(this.exitCodes), this.thresholdProperty, this.customExpression, WorkflowTransition.hashCodeNullable(this.priority), this.uiColor, this.uiLineStyle, WorkflowTransition.hashCodeNullable(this.uiScale), this.createdAt, this.updatedAt});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkflowTransition {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    fromWorkflowTaskInstance: ").append(this.toIndentedString(this.fromWorkflowTaskInstance)).append("\n");
        sb.append("    toWorkflowTaskInstance: ").append(this.toIndentedString(this.toWorkflowTaskInstance)).append("\n");
        sb.append("    ruleType: ").append(this.toIndentedString((Object)this.ruleType)).append("\n");
        sb.append("    exitCodes: ").append(this.toIndentedString(this.exitCodes)).append("\n");
        sb.append("    thresholdProperty: ").append(this.toIndentedString((Object)this.thresholdProperty)).append("\n");
        sb.append("    customExpression: ").append(this.toIndentedString(this.customExpression)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    uiColor: ").append(this.toIndentedString(this.uiColor)).append("\n");
        sb.append("    uiLineStyle: ").append(this.toIndentedString(this.uiLineStyle)).append("\n");
        sb.append("    uiScale: ").append(this.toIndentedString(this.uiScale)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

