/*
 * Decompiled with CFR 0.152.
 */
package io.cloudreactor.tasksymphony.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.cloudreactor.tasksymphony.model.NameAndUuid;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="A WorkflowTransitionEvaluation is a saved evaluation of the conditions in a WorkflowTransition during a WorkflowExecution.")
@JsonPropertyOrder(value={"uuid", "result", "workflow_transition", "workflow_execution", "from_workflow_task_instance_execution", "evaluated_at"})
@JsonTypeName(value="WorkflowTransitionEvaluation")
public class WorkflowTransitionEvaluation {
    public static final String JSON_PROPERTY_UUID = "uuid";
    private UUID uuid;
    public static final String JSON_PROPERTY_RESULT = "result";
    private Boolean result;
    public static final String JSON_PROPERTY_WORKFLOW_TRANSITION = "workflow_transition";
    private NameAndUuid workflowTransition;
    public static final String JSON_PROPERTY_WORKFLOW_EXECUTION = "workflow_execution";
    private NameAndUuid workflowExecution;
    public static final String JSON_PROPERTY_FROM_WORKFLOW_TASK_INSTANCE_EXECUTION = "from_workflow_task_instance_execution";
    private String fromWorkflowTaskInstanceExecution;
    public static final String JSON_PROPERTY_EVALUATED_AT = "evaluated_at";
    private OffsetDateTime evaluatedAt;

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="uuid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getUuid() {
        return this.uuid;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="result")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getResult() {
        return this.result;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="workflow_transition")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public NameAndUuid getWorkflowTransition() {
        return this.workflowTransition;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="workflow_execution")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public NameAndUuid getWorkflowExecution() {
        return this.workflowExecution;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="from_workflow_task_instance_execution")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFromWorkflowTaskInstanceExecution() {
        return this.fromWorkflowTaskInstanceExecution;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="evaluated_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getEvaluatedAt() {
        return this.evaluatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowTransitionEvaluation workflowTransitionEvaluation = (WorkflowTransitionEvaluation)o;
        return Objects.equals(this.uuid, workflowTransitionEvaluation.uuid) && Objects.equals(this.result, workflowTransitionEvaluation.result) && Objects.equals(this.workflowTransition, workflowTransitionEvaluation.workflowTransition) && Objects.equals(this.workflowExecution, workflowTransitionEvaluation.workflowExecution) && Objects.equals(this.fromWorkflowTaskInstanceExecution, workflowTransitionEvaluation.fromWorkflowTaskInstanceExecution) && Objects.equals(this.evaluatedAt, workflowTransitionEvaluation.evaluatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.uuid, this.result, this.workflowTransition, this.workflowExecution, this.fromWorkflowTaskInstanceExecution, this.evaluatedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkflowTransitionEvaluation {\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    result: ").append(this.toIndentedString(this.result)).append("\n");
        sb.append("    workflowTransition: ").append(this.toIndentedString(this.workflowTransition)).append("\n");
        sb.append("    workflowExecution: ").append(this.toIndentedString(this.workflowExecution)).append("\n");
        sb.append("    fromWorkflowTaskInstanceExecution: ").append(this.toIndentedString(this.fromWorkflowTaskInstanceExecution)).append("\n");
        sb.append("    evaluatedAt: ").append(this.toIndentedString(this.evaluatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

