/*
 * Decompiled with CFR 0.152.
 */
package io.cloudreactor.tasksymphony.wrapperio;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudreactor.tasksymphony.wrapperio.MaxRetriesExceededException;
import io.cloudreactor.tasksymphony.wrapperio.MessageConversionException;
import io.cloudreactor.tasksymphony.wrapperio.UpdateException;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskStatusUpdater
implements AutoCloseable {
    public static final int DEFAULT_STATUS_UPDATE_PORT = 2373;
    public static final long DEFAULT_MAX_ATTEMPTS = 10L;
    private static final long DEFAULT_TIMEOUT_MILLIS = 600000L;
    private static final long DEFAULT_BACKOFF_DURATION_MILLIS = 30000L;
    private final boolean isEnabled;
    private final int outboundPort;
    private final Integer bindPort;
    private final InetAddress localhostInetAddress;
    private DatagramSocket socket = null;
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskStatusUpdater.class);

    public TaskStatusUpdater() {
        String value = System.getenv("PROC_WRAPPER_ENABLE_STATUS_UPDATE_LISTENER");
        this.isEnabled = value != null && value.toUpperCase(Locale.US).equals("TRUE");
        value = System.getenv("PROC_WRAPPER_STATUS_UPDATE_SOCKET_PORT");
        this.outboundPort = value == null || value.trim().isEmpty() ? 2373 : Integer.parseInt(value);
        if (this.outboundPort <= 0) {
            throw new IllegalArgumentException("Port " + this.outboundPort + " is not a valid port number.");
        }
        value = System.getenv("PROC_WRAPPER_STATUS_UPDATE_SOCKET_BIND_PORT");
        if (value == null || value.trim().isEmpty()) {
            this.bindPort = null;
        } else {
            this.bindPort = Integer.valueOf(value);
            if (this.bindPort == this.outboundPort) {
                throw new IllegalArgumentException("Outbound port and bind port are both " + this.outboundPort);
            }
        }
        try {
            this.localhostInetAddress = InetAddress.getByName("localhost");
        }
        catch (UnknownHostException uhe) {
            throw new IllegalStateException("Can't get address of localhost");
        }
        LOGGER.info("TaskStatusUpdater isEnabled = {}, outboundPort = {}, bindPort = {}", new Object[]{this.isEnabled, this.outboundPort, this.bindPort});
    }

    public TaskStatusUpdater(boolean isEnabled, int outboundPort, Integer bindPort) {
        if (outboundPort <= 0) {
            throw new IllegalArgumentException("Outbound port " + outboundPort + " is not a valid port number.");
        }
        if (bindPort != null) {
            int iBindPort = bindPort;
            if (iBindPort <= 0) {
                throw new IllegalArgumentException("Bind port " + iBindPort + " is not a valid port number.");
            }
            if (iBindPort == outboundPort) {
                throw new IllegalArgumentException("Outbound port and bind port are both " + outboundPort);
            }
        }
        this.isEnabled = isEnabled;
        this.outboundPort = outboundPort;
        this.bindPort = bindPort;
        try {
            this.localhostInetAddress = InetAddress.getByName("localhost");
        }
        catch (UnknownHostException uhe) {
            throw new IllegalStateException("Can't get address of localhost");
        }
    }

    public TaskStatusUpdater(int outboundPort) {
        this(true, outboundPort, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendUpdate(Long successCount, Long errorCount, Long skippedCount, Long expectedCount, String lastStatusMessage, Map<String, Object> extraProps, Long maxRetries, Long timeoutMillis, long backoffDurationMillis) throws UpdateException, TimeoutException, InterruptedException {
        if (!this.isEnabled) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("sendUpdate() exiting early since updater is disabled.");
            }
            return false;
        }
        long backoffMillis = backoffDurationMillis < 0L ? 30000L : backoffDurationMillis;
        byte[] message = this.makeMessage(successCount, errorCount, skippedCount, expectedCount, lastStatusMessage, extraProps);
        DatagramPacket packet = new DatagramPacket(message, message.length, this.localhostInetAddress, this.outboundPort);
        long maxAttempts = maxRetries == null ? 10L : maxRetries + 1L;
        long timeoutMillisValue = timeoutMillis == null ? 600000L : timeoutMillis;
        Long deadlineMillis = timeoutMillisValue < 0L ? null : Long.valueOf(System.currentTimeMillis() + timeoutMillisValue);
        long attemptCount = 0L;
        while (true) {
            LOGGER.debug("Sending update, attempt {}", (Object)(++attemptCount));
            TaskStatusUpdater taskStatusUpdater = this;
            synchronized (taskStatusUpdater) {
                DatagramSocket sock = null;
                try {
                    sock = this.acquireSocket();
                    sock.send(packet);
                    this.notifyAll();
                    return true;
                }
                catch (IOException ioe) {
                    LOGGER.warn("Got IOException when sending update message", (Throwable)ioe);
                    if (sock != null) {
                        try {
                            sock.close();
                        }
                        catch (Exception ex) {
                            LOGGER.debug("Can't close socket", (Throwable)ex);
                        }
                    }
                    this.socket = null;
                    if (maxAttempts > 0L && attemptCount >= maxAttempts) {
                        throw new MaxRetriesExceededException(maxAttempts - 1L, ioe);
                    }
                    if (deadlineMillis != null && System.currentTimeMillis() > deadlineMillis) {
                        throw new TimeoutException("sendUpdate() timed out after " + timeoutMillis + " ms");
                    }
                    LOGGER.info("Waiting {} ms before retrying ...", (Object)backoffMillis);
                    this.wait(backoffMillis);
                }
            }
        }
    }

    public boolean sendUpdate(Long successCount, Long errorCount, Long skippedCount, Long expectedCount, String lastStatusMessage, Map<String, Object> extraProps) throws UpdateException, TimeoutException, InterruptedException {
        return this.sendUpdate(successCount, errorCount, skippedCount, expectedCount, lastStatusMessage, extraProps, null, null, -1L);
    }

    public boolean sendUpdateAndIgnoreError(Long successCount, Long errorCount, Long skippedCount, Long expectedCount, String lastStatusMessage, Map<String, Object> extraProps) {
        try {
            return this.sendUpdate(successCount, errorCount, skippedCount, expectedCount, lastStatusMessage, extraProps, null, null, -1L);
        }
        catch (UpdateException uex) {
            LOGGER.info("Ignoring update exception", (Throwable)uex);
            return false;
        }
        catch (TimeoutException tex) {
            LOGGER.info("Ignoring timeout exception", (Throwable)tex);
            return false;
        }
        catch (InterruptedException iex) {
            LOGGER.info("Ignoring interrupted exception", (Throwable)iex);
            return false;
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public int getOutboundPort() {
        return this.outboundPort;
    }

    public Integer getBindPort() {
        return this.bindPort;
    }

    @Override
    public synchronized void close() {
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
    }

    protected byte[] makeMessage(Long successCount, Long errorCount, Long skippedCount, Long expectedCount, String lastStatusMessage, Map<String, Object> extraProps) throws MessageConversionException {
        HashMap<String, Object> props = new HashMap<String, Object>((extraProps == null ? 0 : extraProps.size()) + 7);
        if (successCount != null) {
            props.put("success_count", successCount);
        }
        if (errorCount != null) {
            props.put("error_count", errorCount);
        }
        if (skippedCount != null) {
            props.put("skipped_count", skippedCount);
        }
        if (expectedCount != null) {
            props.put("expected_count", expectedCount);
        }
        if (lastStatusMessage != null) {
            props.put("last_status_message", lastStatusMessage);
        }
        if (extraProps != null) {
            props.putAll(extraProps);
        }
        try {
            return (MAPPER.writeValueAsString(props) + "\n").getBytes(StandardCharsets.UTF_8);
        }
        catch (JsonProcessingException jpe) {
            throw new MessageConversionException((Exception)((Object)jpe), props);
        }
    }

    private DatagramSocket acquireSocket() throws SocketException {
        if (this.socket != null) {
            return this.socket;
        }
        this.socket = this.bindPort == null ? new DatagramSocket() : new DatagramSocket(this.bindPort);
        return this.socket;
    }
}

