/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.launcher;

import brooklyn.config.BrooklynProperties;
import brooklyn.config.BrooklynServerConfig;
import brooklyn.config.ConfigKey;
import brooklyn.config.ConfigMap;
import brooklyn.config.StringConfigMap;
import brooklyn.entity.Application;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.ApplicationBuilder;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.StartableApplication;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.rebind.RebindManager;
import brooklyn.entity.rebind.RebindManagerImpl;
import brooklyn.entity.rebind.persister.BrooklynMementoPersisterToMultiFile;
import brooklyn.entity.trait.Startable;
import brooklyn.launcher.BrooklynServerDetails;
import brooklyn.launcher.BrooklynWebServer;
import brooklyn.launcher.FatalConfigurationRuntimeException;
import brooklyn.launcher.PersistMode;
import brooklyn.location.Location;
import brooklyn.location.PortRange;
import brooklyn.location.basic.PortRanges;
import brooklyn.management.ManagementContext;
import brooklyn.management.internal.LocalManagementContext;
import brooklyn.management.internal.ManagementContextInternal;
import brooklyn.mementos.BrooklynMementoPersister;
import brooklyn.rest.BrooklynWebConfig;
import brooklyn.rest.security.BrooklynPropertiesSecurityFilter;
import brooklyn.util.exceptions.CompoundRuntimeException;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.exceptions.RuntimeInterruptedException;
import brooklyn.util.net.Networking;
import brooklyn.util.stream.Streams;
import brooklyn.util.time.Duration;
import brooklyn.util.time.Time;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.brooklyn.camp.CampPlatform;
import io.brooklyn.camp.brooklyn.BrooklynCampPlatformLauncherNoServer;
import io.brooklyn.camp.brooklyn.spi.creation.BrooklynAssemblyTemplateInstantiator;
import io.brooklyn.camp.spi.AssemblyTemplate;
import io.brooklyn.camp.spi.instantiate.AssemblyTemplateInstantiator;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynLauncher {
    private static final Logger LOG = LoggerFactory.getLogger(BrooklynLauncher.class);
    private final Map<String, Object> brooklynAdditionalProperties = Maps.newLinkedHashMap();
    private BrooklynProperties brooklynProperties;
    private ManagementContext managementContext;
    private final List<String> locationSpecs = new ArrayList<String>();
    private final List<Location> locations = new ArrayList<Location>();
    private final List<Application> appsToManage = new ArrayList<Application>();
    private final List<ApplicationBuilder> appBuildersToManage = new ArrayList<ApplicationBuilder>();
    private final List<String> yamlAppsToManage = new ArrayList<String>();
    private final List<Application> apps = new ArrayList<Application>();
    private boolean startWebApps = true;
    private PortRange port = PortRanges.fromString((String)"8081+");
    private InetAddress bindAddress = null;
    private Map<String, String> webApps = new LinkedHashMap<String, String>();
    private Map<String, ?> webconsoleFlags = Maps.newLinkedHashMap();
    private Boolean skipSecurityFilter = null;
    private boolean shutdownOnExit = true;
    private PersistMode persistMode = PersistMode.DISABLED;
    private File persistenceDir;
    private Duration persistPeriod = Duration.ONE_SECOND;
    private volatile BrooklynWebServer webServer;
    private CampPlatform campPlatform;
    private boolean started;
    private String globalBrooklynPropertiesFile;
    private String localBrooklynPropertiesFile;

    public static BrooklynLauncher newInstance() {
        return new BrooklynLauncher();
    }

    public List<Application> getApplications() {
        if (!this.started) {
            throw new IllegalStateException("Cannot retrieve application until started");
        }
        return ImmutableList.copyOf(this.apps);
    }

    public BrooklynServerDetails getServerDetails() {
        if (!this.started) {
            throw new IllegalStateException("Cannot retrieve server details until started");
        }
        return new BrooklynServerDetails(this.webServer, this.managementContext);
    }

    public BrooklynLauncher application(Application app) {
        if (Entities.isManaged((Entity)app)) {
            throw new IllegalArgumentException("Application must not already be managed");
        }
        this.appsToManage.add((Application)Preconditions.checkNotNull((Object)app, (Object)"app"));
        return this;
    }

    public BrooklynLauncher application(ApplicationBuilder appBuilder) {
        this.appBuildersToManage.add((ApplicationBuilder)Preconditions.checkNotNull((Object)appBuilder, (Object)"appBuilder"));
        return this;
    }

    public BrooklynLauncher application(EntitySpec<? extends StartableApplication> appSpec) {
        this.appBuildersToManage.add(new ApplicationBuilder((EntitySpec)Preconditions.checkNotNull(appSpec, (Object)"appSpec")){

            protected void doBuild() {
            }
        });
        return this;
    }

    public BrooklynLauncher application(String yaml) {
        this.yamlAppsToManage.add(yaml);
        return this;
    }

    public BrooklynLauncher location(Location location) {
        this.locations.add((Location)Preconditions.checkNotNull((Object)location, (Object)"location"));
        return this;
    }

    public BrooklynLauncher location(String spec) {
        this.locationSpecs.add((String)Preconditions.checkNotNull((Object)spec, (Object)"spec"));
        return this;
    }

    public BrooklynLauncher locations(List<String> specs) {
        this.locationSpecs.addAll((Collection)Preconditions.checkNotNull(specs, (Object)"specs"));
        return this;
    }

    public BrooklynLauncher shutdownOnExit(boolean val) {
        this.shutdownOnExit = val;
        return this;
    }

    public BrooklynLauncher globalBrooklynPropertiesFile(String file) {
        this.globalBrooklynPropertiesFile = file;
        return this;
    }

    public BrooklynLauncher localBrooklynPropertiesFile(String file) {
        this.localBrooklynPropertiesFile = file;
        return this;
    }

    public BrooklynLauncher managementContext(ManagementContext context) {
        if (this.brooklynProperties != null) {
            throw new IllegalStateException("Cannot set brooklynProperties and managementContext");
        }
        this.managementContext = context;
        return this;
    }

    public BrooklynLauncher brooklynProperties(BrooklynProperties brooklynProperties) {
        if (this.managementContext != null) {
            throw new IllegalStateException("Cannot set brooklynProperties and managementContext");
        }
        this.brooklynProperties = (BrooklynProperties)Preconditions.checkNotNull((Object)brooklynProperties, (Object)"brooklynProperties");
        return this;
    }

    public BrooklynLauncher brooklynProperties(String field, Object value) {
        this.brooklynAdditionalProperties.put((String)Preconditions.checkNotNull((Object)field, (Object)"field"), value);
        return this;
    }

    public <T> BrooklynLauncher brooklynProperties(ConfigKey<T> key, T value) {
        return this.brooklynProperties(key.getName(), value);
    }

    public BrooklynLauncher webconsole(boolean startWebApps) {
        this.startWebApps = startWebApps;
        return this;
    }

    public BrooklynLauncher installSecurityFilter(Boolean val) {
        this.skipSecurityFilter = val == null ? null : Boolean.valueOf(val == false);
        return this;
    }

    public BrooklynLauncher webconsolePort(int port) {
        return this.webconsolePort(PortRanges.fromInteger((int)port));
    }

    public BrooklynLauncher webconsolePort(String port) {
        return this.webconsolePort(PortRanges.fromString((String)port));
    }

    public BrooklynLauncher webconsolePort(PortRange port) {
        this.port = port;
        return this;
    }

    public BrooklynLauncher bindAddress(InetAddress bindAddress) {
        this.bindAddress = bindAddress;
        return this;
    }

    public BrooklynLauncher webServerFlags(Map<String, ?> webServerFlags) {
        this.webconsoleFlags = webServerFlags;
        return this;
    }

    public BrooklynLauncher webapp(String contextPath, String warUrl) {
        this.webApps.put(contextPath, warUrl);
        return this;
    }

    public BrooklynLauncher persistMode(PersistMode persistMode) {
        this.persistMode = persistMode;
        return this;
    }

    public BrooklynLauncher persistenceDir(String persistenceDir) {
        return this.persistenceDir(new File(persistenceDir));
    }

    public BrooklynLauncher persistenceDir(File persistenceDir) {
        this.persistenceDir = persistenceDir;
        return this;
    }

    public BrooklynLauncher persistPeriod(Duration persistPeriod) {
        this.persistPeriod = persistPeriod;
        return this;
    }

    public BrooklynLauncher start() {
        if (this.started) {
            throw new IllegalStateException("Cannot start() or launch() multiple times");
        }
        this.started = true;
        if (this.managementContext == null) {
            if (this.brooklynProperties == null) {
                BrooklynProperties.Factory.Builder builder = new BrooklynProperties.Factory.Builder();
                if (this.globalBrooklynPropertiesFile != null) {
                    builder.globalPropertiesFile(this.globalBrooklynPropertiesFile);
                }
                if (this.localBrooklynPropertiesFile != null) {
                    builder.localPropertiesFile(this.localBrooklynPropertiesFile);
                }
                this.managementContext = new LocalManagementContext(builder, this.brooklynAdditionalProperties);
            } else {
                this.managementContext = new LocalManagementContext(this.brooklynProperties, this.brooklynAdditionalProperties);
            }
            this.brooklynProperties = ((ManagementContextInternal)this.managementContext).getBrooklynProperties();
        } else if (this.brooklynProperties == null) {
            this.brooklynProperties = ((ManagementContextInternal)this.managementContext).getBrooklynProperties();
            this.brooklynProperties.addFromMap(this.brooklynAdditionalProperties);
        }
        this.locations.addAll(this.managementContext.getLocationRegistry().resolve(this.locationSpecs));
        this.campPlatform = new BrooklynCampPlatformLauncherNoServer().useManagementContext(this.managementContext).launch().getCampPlatform();
        if (this.startWebApps) {
            this.startWebApps();
        }
        this.initPersistence();
        this.createApps();
        this.startApps();
        return this;
    }

    protected void startWebApps() {
        if (BrooklynWebConfig.hasNoSecurityOptions((ConfigMap)this.brooklynProperties)) {
            if (this.bindAddress == null) {
                LOG.info("Starting brooklyn web-console on loopback interface because no security config is set");
                this.bindAddress = Networking.LOOPBACK;
            }
            if (this.skipSecurityFilter == null) {
                LOG.debug("Starting brooklyn web-console without security because we are loopback and no security is set");
                this.skipSecurityFilter = true;
            }
        }
        try {
            this.webServer = new BrooklynWebServer(this.webconsoleFlags, this.managementContext);
            this.webServer.setBindAddress(this.bindAddress);
            this.webServer.setPort(this.port);
            this.webServer.putAttributes((Map)this.brooklynProperties);
            if (this.skipSecurityFilter != Boolean.TRUE) {
                this.webServer.setSecurityFilter(BrooklynPropertiesSecurityFilter.class);
            }
            for (Map.Entry<String, String> webapp : this.webApps.entrySet()) {
                this.webServer.deploy(webapp.getKey(), webapp.getValue());
            }
            this.webServer.start();
        }
        catch (Exception e) {
            LOG.warn("Failed to start Brooklyn web-console: " + e, (Throwable)e);
        }
    }

    protected void initPersistence() {
        block21: {
            try {
                boolean success;
                boolean rebinding;
                if (this.persistMode == PersistMode.DISABLED) {
                    LOG.info("Persistence disabled");
                    break block21;
                }
                if (this.persistenceDir == null) {
                    this.persistenceDir = new File(BrooklynServerConfig.getPersistenceDir((StringConfigMap)this.brooklynProperties));
                }
                String persistencePath = this.persistenceDir.getAbsolutePath();
                switch (this.persistMode) {
                    case CLEAN: {
                        if (this.persistenceDir.exists()) {
                            this.checkPersistenceDirAccessible(this.persistenceDir);
                            try {
                                File old = BrooklynLauncher.moveDirectory(this.persistenceDir);
                                LOG.info("Clean start using " + persistencePath + "; moved old directory to " + old.getAbsolutePath());
                            }
                            catch (IOException e) {
                                throw new FatalConfigurationRuntimeException("Error moving old persistence directory " + this.persistenceDir.getAbsolutePath(), e);
                            }
                        } else {
                            LOG.info("Clean start using " + persistencePath + "; no pre-existing persisted data");
                        }
                        rebinding = false;
                        break;
                    }
                    case REBIND: {
                        File backup;
                        this.checkPersistenceDirAccessible(this.persistenceDir);
                        this.checkPersistenceDirNonEmpty(this.persistenceDir);
                        try {
                            backup = BrooklynLauncher.backupDirectory(this.persistenceDir);
                            LOG.info("Rebind using " + persistencePath + "; backed up directory to " + backup.getAbsolutePath());
                        }
                        catch (IOException e) {
                            throw new FatalConfigurationRuntimeException("Error backing up persistence directory " + this.persistenceDir.getAbsolutePath(), e);
                        }
                        rebinding = true;
                        break;
                    }
                    case AUTO: {
                        File backup;
                        if (this.persistenceDir.exists()) {
                            this.checkPersistenceDirAccessible(this.persistenceDir);
                        }
                        if (this.persistenceDir.exists() && !BrooklynLauncher.isMementoDirEmpty(this.persistenceDir)) {
                            try {
                                backup = BrooklynLauncher.backupDirectory(this.persistenceDir);
                                LOG.info("Auto rebind using " + persistencePath + "; backed up directory to " + backup.getAbsolutePath());
                            }
                            catch (IOException e) {
                                throw new FatalConfigurationRuntimeException("Error backing up persistence directory " + this.persistenceDir.getAbsolutePath(), e);
                            }
                            rebinding = true;
                            break;
                        }
                        rebinding = false;
                        LOG.info("Auto fresh using " + persistencePath + "; no pre-existing persisted data");
                        break;
                    }
                    default: {
                        throw new FatalConfigurationRuntimeException("Unexpected persist mode " + (Object)((Object)this.persistMode) + "; modified during initialization?!");
                    }
                }
                if (!this.persistenceDir.exists() && !(success = this.persistenceDir.mkdirs())) {
                    throw new FatalConfigurationRuntimeException("Failed to create persistence directory " + this.persistenceDir);
                }
                RebindManager rebindManager = this.managementContext.getRebindManager();
                BrooklynMementoPersisterToMultiFile persister = new BrooklynMementoPersisterToMultiFile(this.persistenceDir, this.managementContext.getCatalog().getRootClassLoader());
                ((RebindManagerImpl)rebindManager).setPeriodicPersistPeriod(this.persistPeriod);
                rebindManager.setPersister((BrooklynMementoPersister)persister);
                if (rebinding) {
                    ClassLoader classLoader = this.managementContext.getCatalog().getRootClassLoader();
                    rebindManager.rebind(classLoader);
                }
                rebindManager.start();
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }
    }

    protected void checkPersistenceDirAccessible(File persistenceDir) {
        if (!(persistenceDir.exists() && persistenceDir.isDirectory() && persistenceDir.canRead() && persistenceDir.canWrite())) {
            throw new FatalConfigurationRuntimeException("Invalid persistence directory " + persistenceDir + " because " + (!persistenceDir.exists() ? "does not exist" : (!persistenceDir.isDirectory() ? "not a directory" : (!persistenceDir.canRead() ? "not readable" : (!persistenceDir.canWrite() ? "not writable" : "unknown reason")))));
        }
    }

    protected void checkPersistenceDirNonEmpty(File persistenceDir) {
        if (BrooklynLauncher.isMementoDirEmpty(persistenceDir)) {
            throw new FatalConfigurationRuntimeException("Invalid persistence directory " + persistenceDir + " because directory is empty");
        }
    }

    protected void createApps() {
        StartableApplication app;
        for (ApplicationBuilder appBuilder : this.appBuildersToManage) {
            app = appBuilder.manage(this.managementContext);
            this.apps.add((Application)app);
        }
        for (Application app2 : this.appsToManage) {
            Entities.startManagement((Application)app2, (ManagementContext)this.managementContext);
            this.apps.add(app2);
        }
        for (String blueprint : this.yamlAppsToManage) {
            app = this.getAppFromYaml(blueprint);
            this.apps.add((Application)app);
        }
    }

    protected Application getAppFromYaml(String input) {
        BrooklynAssemblyTemplateInstantiator instantiator;
        AssemblyTemplate at = this.campPlatform.pdp().registerDeploymentPlan((Reader)new StringReader(input));
        try {
            AssemblyTemplateInstantiator ati = (AssemblyTemplateInstantiator)at.getInstantiator().newInstance();
            if (!(ati instanceof BrooklynAssemblyTemplateInstantiator)) {
                throw new IllegalStateException("Cannot create application with instantiator: " + ati);
            }
            instantiator = (BrooklynAssemblyTemplateInstantiator)BrooklynAssemblyTemplateInstantiator.class.cast(ati);
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
        return instantiator.create(at, this.campPlatform);
    }

    protected void startApps() {
        ArrayList appExceptions = Lists.newArrayList();
        for (Application app : this.apps) {
            if (!(app instanceof Startable)) continue;
            if (this.shutdownOnExit) {
                Entities.invokeStopOnShutdown((Entity)app);
            }
            try {
                LOG.info("Starting brooklyn application {} in location{} {}", new Object[]{app, this.locations.size() != 1 ? "s" : "", this.locations});
                ((Startable)app).start(this.locations);
            }
            catch (Exception e) {
                LOG.error("Error starting " + app + ": " + Exceptions.collapseText((Throwable)e), Exceptions.getFirstInteresting((Throwable)e));
                appExceptions.add(Exceptions.collapse((Throwable)e));
                if (!Thread.currentThread().isInterrupted()) continue;
                LOG.error("Interrupted while starting applications; aborting");
                break;
            }
        }
        if (appExceptions.size() > 0) {
            throw new CompoundRuntimeException("Error starting applications", (Iterable)appExceptions);
        }
    }

    public void terminate() {
        if (!this.started) {
            return;
        }
        if (this.webServer != null) {
            try {
                this.webServer.stop();
            }
            catch (Exception e) {
                LOG.warn("Error stopping web-server; continuing with termination", (Throwable)e);
            }
        }
        if (this.persistMode != PersistMode.DISABLED) {
            try {
                Stopwatch stopwatch = Stopwatch.createStarted();
                this.managementContext.getRebindManager().waitForPendingComplete(10L, TimeUnit.SECONDS);
                LOG.info("Finished waiting for persist; took " + Time.makeTimeStringRounded((Stopwatch)stopwatch));
            }
            catch (RuntimeInterruptedException runtimeInterruptedException) {
                Thread.currentThread().interrupt();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            catch (TimeoutException timeoutException) {
                LOG.warn("Timeout after 10 seconds waiting for persistance to write all data; continuing");
            }
        }
        if (this.managementContext instanceof ManagementContextInternal) {
            ((ManagementContextInternal)this.managementContext).terminate();
        }
        for (Location loc : this.locations) {
            if (!(loc instanceof Closeable)) continue;
            Streams.closeQuietly((Closeable)((Closeable)loc));
        }
    }

    static File backupDirectory(File dir) throws IOException, InterruptedException {
        File parentDir = dir.getParentFile();
        String simpleName = dir.getName();
        String timestamp = new SimpleDateFormat("yyyy-MM-dd-hhmm-ss").format(new Date());
        File backupDir = new File(parentDir, String.valueOf(simpleName) + "-" + timestamp + ".bak");
        String cmd = "cp -R " + dir.getAbsolutePath() + " " + backupDir.getAbsolutePath();
        Process proc = Runtime.getRuntime().exec(cmd);
        proc.waitFor();
        if (proc.exitValue() != 0) {
            throw new IOException("Error backing up directory, with command " + cmd);
        }
        return backupDir;
    }

    static File moveDirectory(File dir) throws InterruptedException, IOException {
        File parentDir = dir.getParentFile();
        String simpleName = dir.getName();
        String timestamp = new SimpleDateFormat("yyyy-MM-dd-hhmm-ss").format(new Date());
        File newDir = new File(parentDir, String.valueOf(simpleName) + "-" + timestamp + ".old");
        String cmd = "mv  " + dir.getAbsolutePath() + " " + newDir.getAbsolutePath();
        Process proc = Runtime.getRuntime().exec(cmd);
        proc.waitFor();
        if (proc.exitValue() != 0) {
            throw new IOException("Error moving directory, with command " + cmd);
        }
        return newDir;
    }

    static boolean isMementoDirEmpty(File dir) {
        if (!dir.exists()) {
            return false;
        }
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File sub = fileArray[n2];
            if (sub.isFile()) {
                return false;
            }
            if (sub.isDirectory() && sub.listFiles().length > 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

