/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.launcher;

import brooklyn.BrooklynVersion;
import brooklyn.config.BrooklynServerConfig;
import brooklyn.config.BrooklynServiceAttributes;
import brooklyn.config.ConfigKey;
import brooklyn.config.ConfigMap;
import brooklyn.launcher.config.CustomResourceLocator;
import brooklyn.location.PortRange;
import brooklyn.location.basic.LocalhostMachineProvisioningLocation;
import brooklyn.location.basic.PortRanges;
import brooklyn.management.ManagementContext;
import brooklyn.rest.BrooklynRestApi;
import brooklyn.rest.BrooklynWebConfig;
import brooklyn.rest.security.BrooklynPropertiesSecurityFilter;
import brooklyn.util.BrooklynLanguageExtensions;
import brooklyn.util.BrooklynNetworkUtils;
import brooklyn.util.ResourceUtils;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.crypto.FluentKeySigner;
import brooklyn.util.crypto.SecureKeys;
import brooklyn.util.flags.FlagUtils;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.flags.TypeCoercions;
import brooklyn.util.javalang.Threads;
import brooklyn.util.logging.LoggingSetup;
import brooklyn.util.os.Os;
import brooklyn.util.text.Identifiers;
import brooklyn.util.text.Strings;
import brooklyn.util.web.ContextHandlerCollectionHotSwappable;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.sun.jersey.api.container.filter.GZIPContentEncodingFilter;
import com.sun.jersey.api.core.DefaultResourceConfig;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.ws.rs.core.Application;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynWebServer {
    private static final Logger log = LoggerFactory.getLogger(BrooklynWebServer.class);
    public static final String BROOKLYN_WAR_URL = "classpath://brooklyn.war";
    protected Server server;
    private WebAppContext rootContext;
    @SetFromFlag
    protected PortRange port = PortRanges.fromString((String)"8081+");
    @SetFromFlag
    protected PortRange httpsPort = PortRanges.fromString((String)"8443+");
    protected volatile int actualPort = -1;
    protected InetAddress actualAddress = null;
    @SetFromFlag
    protected String war = "classpath://brooklyn.war";
    @SetFromFlag
    protected InetAddress bindAddress = null;
    @SetFromFlag
    private Map<String, String> wars = new LinkedHashMap<String, String>();
    @SetFromFlag
    private Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private ManagementContext managementContext;
    @SetFromFlag
    private Boolean httpsEnabled;
    @SetFromFlag
    private String keystorePath;
    @SetFromFlag
    private String keystorePassword;
    @SetFromFlag
    private String truststorePath;
    @SetFromFlag
    private String trustStorePassword;
    private File webappTempDir;
    private Class<BrooklynPropertiesSecurityFilter> securityFilterClazz;
    ContextHandlerCollectionHotSwappable handlers = new ContextHandlerCollectionHotSwappable();
    private Thread shutdownHook = null;

    static {
        CustomResourceLocator.registerAlternateLocator(new CustomResourceLocator.SearchingClassPathInDevMode(BROOKLYN_WAR_URL, "/usage/launcher/target", "/usage/jsgui/target/brooklyn-jsgui-" + BrooklynVersion.get() + ".war"));
        LoggingSetup.installJavaUtilLoggingBridge();
    }

    public BrooklynWebServer(ManagementContext managementContext) {
        this(Maps.newLinkedHashMap(), managementContext);
    }

    public BrooklynWebServer(Map<?, ?> flags, ManagementContext managementContext) {
        this.managementContext = managementContext;
        Map leftovers = FlagUtils.setFieldsFromFlags(flags, (Object)this);
        if (!leftovers.isEmpty()) {
            log.warn("Ignoring unknown flags " + leftovers);
        }
        this.webappTempDir = BrooklynServerConfig.getBrooklynWebTmpDir((ManagementContext)managementContext);
    }

    public BrooklynWebServer(ManagementContext managementContext, int port) {
        this(managementContext, port, "brooklyn.war");
    }

    public BrooklynWebServer(ManagementContext managementContext, int port, String warUrl) {
        this((Map<?, ?>)MutableMap.of((Object)"port", (Object)port, (Object)"war", (Object)warUrl), managementContext);
    }

    public void setSecurityFilter(Class<BrooklynPropertiesSecurityFilter> filterClazz) {
        this.securityFilterClazz = filterClazz;
    }

    public BrooklynWebServer setPort(Object port) {
        if (this.getActualPort() > 0) {
            throw new IllegalStateException("Can't set port after port has been assigned to server (using " + this.getActualPort() + ")");
        }
        this.port = (PortRange)TypeCoercions.coerce((Object)port, PortRange.class);
        return this;
    }

    @VisibleForTesting
    File getWebappTempDir() {
        return this.webappTempDir;
    }

    public boolean getHttpsEnabled() {
        if (this.httpsEnabled != null) {
            return this.httpsEnabled;
        }
        this.httpsEnabled = (Boolean)this.managementContext.getConfig().getConfig(BrooklynWebConfig.HTTPS_REQUIRED);
        return this.httpsEnabled;
    }

    public PortRange getRequestedPort() {
        return this.port;
    }

    public int getActualPort() {
        return this.actualPort;
    }

    public InetAddress getAddress() {
        return this.actualAddress;
    }

    public String getRootUrl() {
        if (this.getActualPort() > 0) {
            String protocol = this.getHttpsEnabled() ? "https" : "http";
            return String.valueOf(protocol) + "://" + this.getAddress().getHostName() + ":" + this.getActualPort() + "/";
        }
        return null;
    }

    public BrooklynWebServer setWar(String url) {
        this.war = url;
        return this;
    }

    public BrooklynWebServer addWar(String path, String warUrl) {
        this.deploy(path, warUrl);
        return this;
    }

    public BrooklynWebServer setBindAddress(InetAddress address) {
        this.bindAddress = address;
        return this;
    }

    public BrooklynWebServer addAttribute(String field, Object value) {
        return this.setAttribute(field, value);
    }

    public BrooklynWebServer setAttribute(String field, Object value) {
        this.attributes.put(field, value);
        return this;
    }

    public <T> BrooklynWebServer configure(ConfigKey<T> key, T value) {
        return this.setAttribute(key.getName(), value);
    }

    public BrooklynWebServer putAttributes(Map newAttrs) {
        if (newAttrs != null) {
            this.attributes.putAll(newAttrs);
        }
        return this;
    }

    public static void installAsServletFilter(ServletContextHandler context) {
        DefaultResourceConfig config = new DefaultResourceConfig();
        for (Object r : BrooklynRestApi.getAllResources()) {
            config.getSingletons().add(r);
        }
        config.getProperties().put("com.sun.jersey.spi.container.ContainerRequestFilters", GZIPContentEncodingFilter.class.getName());
        config.getProperties().put("com.sun.jersey.spi.container.ContainerResponseFilters", GZIPContentEncodingFilter.class.getName());
        config.getProperties().put("com.sun.jersey.config.property.WebPageContentRegex", "(/?|[^?]*/assets/[^?]+\\.[A-Za-z0-9_]+)");
        config.getFeatures().put("com.sun.jersey.config.feature.FilterForwardOn404", true);
        FilterHolder filterHolder = new FilterHolder((Filter)new ServletContainer((Application)config));
        context.addFilter(filterHolder, "/*", EnumSet.allOf(DispatcherType.class));
    }

    public synchronized void start() throws Exception {
        if (this.server != null) {
            throw new IllegalStateException(this + " already running");
        }
        if (this.actualPort == -1) {
            this.actualPort = LocalhostMachineProvisioningLocation.obtainPort((InetAddress)this.getAddress(), (PortRange)(this.getHttpsEnabled() ? this.httpsPort : this.port));
            if (this.actualPort == -1) {
                throw new IllegalStateException("Unable to provision port for web console (wanted " + (this.getHttpsEnabled() ? this.httpsPort : this.port) + ")");
            }
        }
        if (this.bindAddress != null) {
            this.actualAddress = this.bindAddress;
            this.server = new Server(new InetSocketAddress(this.bindAddress, this.actualPort));
        } else {
            this.actualAddress = BrooklynNetworkUtils.getLocalhostInetAddress();
            this.server = new Server(this.actualPort);
        }
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setName("brooklyn-jetty-server-" + this.actualPort + "-" + threadPool.getName());
        this.server.setThreadPool((ThreadPool)threadPool);
        if (log.isDebugEnabled()) {
            log.debug("Starting Brooklyn console at " + this.getRootUrl() + ", running " + this.war + (this.wars != null ? " and " + this.wars.values() : ""));
        }
        if (this.getHttpsEnabled()) {
            Connector[] connectorArray = this.server.getConnectors();
            int n = connectorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Connector c = connectorArray[n2];
                this.server.removeConnector(c);
                ++n2;
            }
            SslContextFactory sslContextFactory = new SslContextFactory();
            if (this.keystorePath != null) {
                sslContextFactory.setKeyStorePath(this.checkFileExists(this.keystorePath, "keystore"));
                sslContextFactory.setKeyStorePassword(this.keystorePassword);
            } else {
                log.info("No keystore specified but https enabled; creating a default keystore");
                if (Strings.isEmpty((CharSequence)this.keystorePassword)) {
                    this.keystorePassword = "password";
                }
                KeyStore ks = SecureKeys.newKeyStore();
                KeyPair key = SecureKeys.newKeyPair();
                X509Certificate cert = new FluentKeySigner("brooklyn").newCertificateFor("web-console", key);
                ks.setKeyEntry("web-console", key.getPrivate(), this.keystorePassword.toCharArray(), new Certificate[]{cert});
                sslContextFactory.setKeyStore(ks);
                sslContextFactory.setKeyStorePassword(this.keystorePassword);
            }
            if (!Strings.isEmpty((CharSequence)this.truststorePath)) {
                sslContextFactory.setTrustStore(this.checkFileExists(this.truststorePath, "truststore"));
                sslContextFactory.setTrustStorePassword(this.trustStorePassword);
            }
            SslSocketConnector sslSocketConnector = new SslSocketConnector(sslContextFactory);
            sslSocketConnector.setPort(this.actualPort);
            this.server.addConnector((Connector)sslSocketConnector);
        }
        this.addShutdownHook();
        for (Map.Entry<String, String> entry : this.wars.entrySet()) {
            String pathSpec = entry.getKey();
            String warUrl = entry.getValue();
            WebAppContext webapp = this.deploy(pathSpec, warUrl);
            webapp.setTempDirectory(Os.mkdirs((File)new File(this.webappTempDir, this.newTimestampedDirName("war", 8))));
        }
        this.rootContext = this.deploy("/", this.war);
        this.rootContext.setTempDirectory(Os.mkdirs((File)new File(this.webappTempDir, "war-root")));
        if (this.securityFilterClazz != null) {
            this.rootContext.addFilter(this.securityFilterClazz, "/*", EnumSet.allOf(DispatcherType.class));
        }
        BrooklynWebServer.installAsServletFilter((ServletContextHandler)this.rootContext);
        this.server.setHandler((Handler)this.handlers);
        this.server.start();
        BrooklynLanguageExtensions.reinit();
        log.info("Started Brooklyn console at " + this.getRootUrl() + ", running " + this.war + (this.wars != null ? " and " + this.wars.values() : ""));
    }

    private String newTimestampedDirName(String prefix, int randomSuffixLength) {
        return String.valueOf(prefix) + "-" + new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date()) + "-" + Identifiers.makeRandomId((int)randomSuffixLength);
    }

    private String checkFileExists(String path, String name) {
        if (!new File(path).exists()) {
            throw new IllegalArgumentException("Could not find " + name + ": " + path);
        }
        return path;
    }

    public synchronized void stop() throws Exception {
        if (this.server == null) {
            return;
        }
        String root = this.getRootUrl();
        Threads.removeShutdownHook((Thread)this.shutdownHook);
        if (log.isDebugEnabled()) {
            log.debug("Stopping Brooklyn web console at " + root + " (" + this.war + (this.wars != null ? " and " + this.wars.values() : "") + ")");
        }
        this.server.stop();
        try {
            this.server.join();
        }
        catch (Exception exception) {}
        this.server = null;
        LocalhostMachineProvisioningLocation.releasePort((InetAddress)this.getAddress(), (int)this.actualPort);
        this.actualPort = -1;
        if (log.isDebugEnabled()) {
            log.debug("Stopped Brooklyn web console at " + root);
        }
    }

    public WebAppContext deploy(String pathSpec, String warUrl) {
        String cleanPathSpec = pathSpec;
        while (cleanPathSpec.startsWith("/")) {
            cleanPathSpec = cleanPathSpec.substring(1);
        }
        boolean isRoot = cleanPathSpec.isEmpty();
        WebAppContext context = new WebAppContext();
        context.setAttribute(BrooklynServiceAttributes.BROOKLYN_MANAGEMENT_CONTEXT, (Object)this.managementContext);
        for (Map.Entry<String, Object> attributeEntry : this.attributes.entrySet()) {
            context.setAttribute(attributeEntry.getKey(), attributeEntry.getValue());
        }
        try {
            File tmpWarFile = Os.writeToTempFile((InputStream)new CustomResourceLocator((ConfigMap)this.managementContext.getConfig(), ResourceUtils.create((Object)this)).getResourceFromUrl(warUrl), (String)(isRoot ? "ROOT" : "embedded-" + cleanPathSpec), (String)".war");
            context.setWar(tmpWarFile.getAbsolutePath());
        }
        catch (Exception e) {
            log.error("Unabled to load WAR file from " + warUrl + "; launching run without WAR: " + e);
            log.debug("Detail on why running without WAR file: " + e, (Throwable)e);
            context.setWar("/dev/null");
        }
        context.setContextPath("/" + cleanPathSpec);
        context.setParentLoaderPriority(true);
        this.deploy(context);
        return context;
    }

    protected synchronized void addShutdownHook() {
        if (this.shutdownHook != null) {
            return;
        }
        this.shutdownHook = Threads.addShutdownHook((Runnable)new Runnable(){

            @Override
            public void run() {
                log.info("BrooklynWebServer detected shut-down: stopping web-console");
                try {
                    BrooklynWebServer.this.stop();
                }
                catch (Exception e) {
                    log.error("Failure shutting down web-console: " + e, (Throwable)e);
                }
            }
        });
    }

    public void deploy(WebAppContext context) {
        try {
            this.handlers.updateHandler(context);
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public Server getServer() {
        return this.server;
    }

    public WebAppContext getRootContext() {
        return this.rootContext;
    }
}

