/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

final class ActivityWatcher
implements Application.ActivityLifecycleCallbacks {
    @NonNull
    private final Application application;
    @NonNull
    private static final HashSet<Observer> observers = new HashSet();
    @NonNull
    private static final LinkedList<WeakReference<Activity>> activities = new LinkedList();
    @Nullable
    private static WeakReference<Activity> foregroundActivity;

    ActivityWatcher(@NonNull Application app) {
        this.application = app;
        app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    @Nullable
    static Activity foregroundActivity() {
        if (foregroundActivity == null) {
            return null;
        }
        return (Activity)foregroundActivity.get();
    }

    static void registerActivityObserver(@NonNull Observer obs) {
        observers.add(obs);
    }

    static void removeActivityObserver(@NonNull Observer obs) {
        observers.remove(obs);
    }

    private static void track(@Nullable Activity activity) {
        if (activity != null && !ActivityWatcher.getActivities().contains(activity)) {
            activities.addLast(new WeakReference<Activity>(activity));
        }
    }

    private static void setForeground(@Nullable Activity activity) {
        ActivityWatcher.track(activity);
        Activity previous = ActivityWatcher.foregroundActivity();
        foregroundActivity = activity == null || activity.isFinishing() || activity.isDestroyed() ? null : new WeakReference<Activity>(activity);
        for (Observer obs : observers) {
            obs.activityChanged(activity, previous);
        }
    }

    private static void clear(@NonNull Activity activity) {
        WeakReference matched = null;
        for (WeakReference weakReference : activities) {
            if (!activity.equals(weakReference.get())) continue;
            matched = weakReference;
        }
        if (matched != null) {
            activities.remove(matched);
        }
        if (ActivityWatcher.foregroundActivity() == activity) {
            ActivityWatcher.setForeground(null);
        }
    }

    @NonNull
    static Set<Activity> getActivities() {
        HashSet<Activity> activities = new HashSet<Activity>();
        for (WeakReference weakReference : ActivityWatcher.activities) {
            Activity activity = (Activity)weakReference.get();
            if (activity == null) continue;
            activities.add(activity);
        }
        return activities;
    }

    public void onActivityCreated(@NonNull Activity activity, Bundle bundle) {
        Log.v((String)"CobrowseIO", (String)("Activity created " + activity));
        ActivityWatcher.track(activity);
    }

    public void onActivityStarted(@NonNull Activity activity) {
        Log.v((String)"CobrowseIO", (String)("Activity started " + activity));
        ActivityWatcher.track(activity);
    }

    public void onActivityResumed(@NonNull Activity activity) {
        Log.v((String)"CobrowseIO", (String)("Activity resumed " + activity));
        ActivityWatcher.track(activity);
        ActivityWatcher.setForeground(activity);
    }

    public void onActivityPaused(@NonNull Activity activity) {
        Log.v((String)"CobrowseIO", (String)("Activity paused " + activity));
        if (ActivityWatcher.foregroundActivity() == activity) {
            ActivityWatcher.setForeground(null);
        }
    }

    public void onActivityStopped(@NonNull Activity activity) {
        Log.v((String)"CobrowseIO", (String)("Activity stopped " + activity));
    }

    public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle bundle) {
    }

    public void onActivityDestroyed(@NonNull Activity activity) {
        Log.v((String)"CobrowseIO", (String)("Activity destroyed " + activity));
        ActivityWatcher.clear(activity);
    }

    void destroy() {
        this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        activities.clear();
        foregroundActivity = null;
    }

    static interface Observer {
        public void activityChanged(@Nullable Activity var1, @Nullable Activity var2);
    }
}

