/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PointF;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import java.util.HashMap;

final class AgentTouchesView
extends FrameLayout {
    @NonNull
    private final HashMap<String, AgentTouch> dots = new HashMap();

    AgentTouchesView(@NonNull Context context) {
        super(context);
    }

    private void centreOn(@NonNull View view, @NonNull PointF point) {
        view.setX(point.x - (float)(view.getWidth() / 2));
        view.setY(point.y - (float)(view.getHeight() / 2));
    }

    public void start(@NonNull PointF point, @NonNull String id) {
        AgentTouch dot = new AgentTouch(this.getContext());
        this.dots.put(id, dot);
        this.addView(dot, 80, 80);
        dot.post(() -> this.centreOn(dot, point));
    }

    public void move(@NonNull PointF point, @NonNull String id) {
        AgentTouch dot = this.dots.get(id);
        if (dot != null) {
            this.centreOn(dot, point);
        }
    }

    public void end(@NonNull PointF point, @NonNull String id) {
        AgentTouch dot = this.dots.get(id);
        if (dot != null) {
            this.removeView(dot);
            this.dots.remove(id);
        }
    }

    public boolean isEmpty() {
        return this.dots.isEmpty();
    }

    private static class AgentTouch
    extends View {
        AgentTouch(@NonNull Context context) {
            super(context);
            this.setAlpha(0.25f);
        }

        public void draw(@NonNull Canvas canvas) {
            super.draw(canvas);
            int radius = Math.min(this.getWidth(), this.getHeight()) / 2 - 1;
            Paint fill = new Paint(1);
            fill.setColor(Color.rgb((int)80, (int)80, (int)80));
            fill.setStyle(Paint.Style.FILL);
            canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), (float)radius, fill);
            Paint stroke = new Paint(1);
            stroke.setColor(Color.rgb((int)20, (int)20, (int)20));
            stroke.setStyle(Paint.Style.STROKE);
            stroke.setStrokeWidth(3.0f);
            canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), (float)radius, stroke);
        }
    }
}

