/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import io.cobrowse.BaseAnnotationOverlay;

@SuppressLint(value={"ViewConstructor"})
final class AnnotationOverlay
extends BaseAnnotationOverlay {
    @NonNull
    private final Activity activity;

    public AnnotationOverlay(@NonNull Activity activity) {
        super(activity.getApplicationContext());
        this.activity = activity;
        this.bringToFront();
    }

    @Override
    protected WindowManager getWindowManager() {
        return this.activity.getWindowManager();
    }

    @Override
    void show() {
        if (this.activity.isChangingConfigurations() || this.activity.isDestroyed() || this.activity.isFinishing()) {
            return;
        }
        WindowManager.LayoutParams decorParams = (WindowManager.LayoutParams)this.activity.getWindow().getDecorView().getLayoutParams();
        if (decorParams != null) {
            WindowManager.LayoutParams params = new WindowManager.LayoutParams();
            params.copyFrom(decorParams);
            params.flags |= 0x20398;
            params.format = -3;
            params.type = 2;
            params.setTitle((CharSequence)"Cobrowse Overlay");
            if (this.getParent() != null) {
                this.activity.getWindowManager().removeViewImmediate((View)this);
            }
            this.activity.getWindowManager().addView((View)this, (ViewGroup.LayoutParams)params);
        }
        this.bringToFront();
    }

    @Override
    public void hide() {
        this.clear();
        if (this.getParent() != null) {
            this.activity.getWindowManager().removeViewImmediate((View)this);
        }
    }
}

