/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.app.Activity;
import android.app.Application;
import android.hardware.display.DisplayManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.ViewTreeObserver;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.UiThread;
import io.cobrowse.ActivityWatcher;
import io.cobrowse.AgentEvent;
import io.cobrowse.AnnotationOverlay;
import io.cobrowse.DisplayScaling;
import io.cobrowse.Drawing;
import io.cobrowse.FullDeviceOverlayAccessibility;
import io.cobrowse.Laser;
import io.cobrowse.Session;
import io.cobrowse.SessionCapabilities;
import io.cobrowse.SessionContextModule;
import io.cobrowse.StreamProtocol;
import io.cobrowse.Touch;

@UiThread
final class AnnotationOverlayManager
extends SessionContextModule
implements ActivityWatcher.Observer,
Session.Listener,
StreamProtocol.Listener,
ViewTreeObserver.OnWindowFocusChangeListener,
DisplayManager.DisplayListener {
    @Nullable
    private AnnotationOverlay overlay;
    @Nullable
    private Activity activity;
    private int currentDisplayId;
    private int currentDisplayWidth;
    private int currentDisplayHeight;

    AnnotationOverlayManager(@NonNull Application app, @NonNull Session session) {
        super(app, session);
        session.registerSessionListener(this);
        ActivityWatcher.registerActivityObserver(this);
        this.getDisplayManager().registerDisplayListener((DisplayManager.DisplayListener)this, new Handler(Looper.getMainLooper()));
        Display display = this.getWindowManager().getDefaultDisplay();
        DisplayMetrics metrics = DisplayScaling.getMetrics(display);
        this.currentDisplayId = display.getDisplayId();
        this.currentDisplayWidth = metrics.widthPixels;
        this.currentDisplayHeight = metrics.heightPixels;
    }

    @Override
    void destroy() {
        this.hide();
        this.session.removeSessionListener(this);
        ActivityWatcher.removeActivityObserver(this);
        this.getDisplayManager().unregisterDisplayListener((DisplayManager.DisplayListener)this);
    }

    private void setActivity(@Nullable Activity newActivity) {
        ViewTreeObserver tree;
        if (this.activity != null) {
            tree = this.activity.getWindow().getDecorView().getViewTreeObserver();
            tree.removeOnWindowFocusChangeListener((ViewTreeObserver.OnWindowFocusChangeListener)this);
        }
        this.activity = newActivity;
        if (newActivity != null) {
            tree = newActivity.getWindow().getDecorView().getViewTreeObserver();
            tree.addOnWindowFocusChangeListener((ViewTreeObserver.OnWindowFocusChangeListener)this);
        }
    }

    private synchronized void show(@NonNull Activity newActivity) {
        if (!this.session.isActive()) {
            return;
        }
        if (this.activity != newActivity) {
            this.hide();
            this.setActivity(newActivity);
            this.overlay = new AnnotationOverlay(newActivity);
        }
        if (this.overlay != null) {
            this.overlay.show();
        }
    }

    private synchronized void hide() {
        if (this.overlay != null) {
            this.overlay.hide();
            this.overlay = null;
        }
        this.setActivity(null);
    }

    @Override
    public void sessionDidUpdate(@NonNull Session session) {
        if (Build.VERSION.SDK_INT >= 22) {
            FullDeviceOverlayAccessibility.notifySessionStateChanged(this.getApplication(), session);
        }
        if (this.getActivity() != null) {
            this.show(this.getActivity());
        }
    }

    @Override
    public void sessionDidEnd(@NonNull Session session) {
        if (Build.VERSION.SDK_INT >= 22) {
            FullDeviceOverlayAccessibility.notifySessionStateChanged(this.getApplication(), session);
        }
        this.hide();
    }

    @Override
    public void agentEventReceived(@NonNull Session session, @NonNull AgentEvent event) {
        if (this.overlay != null) {
            AnnotationOverlayManager.handleAppOverlayEvent(this.overlay, event, session.capabilities());
        }
        if (Build.VERSION.SDK_INT >= 22) {
            AnnotationOverlayManager.handleFullDeviceOverlayEvent(this.getApplication(), event, session.capabilities());
        }
    }

    @RequiresApi(api=22)
    private static void handleFullDeviceOverlayEvent(@NonNull Application application, @NonNull AgentEvent event, @NonNull String[] capabilities) {
        if (event instanceof Laser) {
            if (SessionCapabilities.isForbidden(capabilities, "laser")) {
                Log.w((String)"CobrowseIO", (String)"Capability 'laser' not allowed.");
                return;
            }
            FullDeviceOverlayAccessibility.inject(application, (Laser)event);
        } else if (event instanceof Drawing) {
            if (SessionCapabilities.isForbidden(capabilities, "drawing")) {
                Log.w((String)"CobrowseIO", (String)"Capability 'drawing' not allowed.");
                return;
            }
            FullDeviceOverlayAccessibility.inject(application, (Drawing)event);
        }
    }

    private static void handleAppOverlayEvent(@NonNull AnnotationOverlay overlay, @NonNull AgentEvent event, @NonNull String[] capabilities) {
        if (event instanceof Drawing) {
            if (SessionCapabilities.isForbidden(capabilities, "drawing")) {
                Log.w((String)"CobrowseIO", (String)"Capability 'drawing' not allowed.");
                return;
            }
            overlay.updateDrawing((Drawing)event);
        } else if (event instanceof Laser) {
            if (SessionCapabilities.isForbidden(capabilities, "laser")) {
                Log.w((String)"CobrowseIO", (String)"Capability 'laser' not allowed.");
                return;
            }
            overlay.updateLaser((Laser)event);
        } else if (event instanceof Touch) {
            if (SessionCapabilities.isForbidden(capabilities, "pointer")) {
                Log.w((String)"CobrowseIO", (String)"Capability 'pointer' not allowed.");
                return;
            }
            overlay.updateTouches((Touch)event);
        }
    }

    @Override
    public void activityChanged(@Nullable Activity to, @Nullable Activity from) {
        if (to == null || to.isFinishing() || to.isDestroyed() || to.isChangingConfigurations()) {
            this.hide();
        } else {
            this.show(to);
        }
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        Activity current = this.activity;
        this.hide();
        if (current != null) {
            this.show(current);
        }
    }

    public void onDisplayAdded(int displayId) {
    }

    public void onDisplayRemoved(int displayId) {
    }

    public void onDisplayChanged(int displayId) {
        Display display = this.getDisplayManager().getDisplay(displayId);
        if (display == null) {
            return;
        }
        DisplayMetrics metrics = DisplayScaling.getMetrics(display);
        if (this.currentDisplayId == displayId && this.currentDisplayWidth == metrics.widthPixels && this.currentDisplayHeight == metrics.heightPixels) {
            return;
        }
        this.currentDisplayId = displayId;
        this.currentDisplayWidth = metrics.widthPixels;
        this.currentDisplayHeight = metrics.heightPixels;
        if (this.overlay != null) {
            this.overlay.hide();
            this.overlay.show();
        }
    }
}

