/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.drawable.BitmapDrawable;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import io.cobrowse.AgentTouchesView;
import io.cobrowse.DisplayScaling;
import io.cobrowse.Drawing;
import io.cobrowse.Laser;
import io.cobrowse.LaserPointerView;
import io.cobrowse.Touch;

abstract class BaseAnnotationOverlay
extends FrameLayout {
    @NonNull
    private final ImageView annotation;
    @NonNull
    private final LaserPointerView laser;
    @NonNull
    private final AgentTouchesView touches;

    public BaseAnnotationOverlay(@NonNull Context context) {
        super(context);
        this.setFitsSystemWindows(false);
        this.annotation = new ImageView(this.getContext());
        this.annotation.setScaleType(ImageView.ScaleType.FIT_XY);
        this.annotation.setFitsSystemWindows(false);
        this.addView((View)this.annotation, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.laser = new LaserPointerView(this.getContext());
        this.laser.setFitsSystemWindows(false);
        this.addView(this.laser, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.touches = new AgentTouchesView(this.getContext());
        this.touches.setFitsSystemWindows(false);
        this.addView((View)this.touches, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }

    protected abstract WindowManager getWindowManager();

    abstract void show();

    abstract void hide();

    public void updateDrawing(@NonNull Drawing drawing) {
        if (drawing.image != null && drawing.position != null) {
            Display display = this.getWindowManager().getDefaultDisplay();
            PointF position = DisplayScaling.scale(display, drawing.position);
            PointF size = DisplayScaling.scale(display, drawing.width, drawing.height);
            int[] location = new int[2];
            this.annotation.getLocationOnScreen(location);
            int x = (int)position.x - location[0];
            int y = (int)position.y - location[1];
            this.annotation.setPadding(x, y, (int)((float)this.annotation.getWidth() - ((float)x + size.x)), (int)((float)this.annotation.getHeight() - ((float)y + size.y)));
            this.annotation.setImageBitmap(drawing.image);
        } else {
            this.clear();
        }
    }

    public void updateLaser(@NonNull Laser laser) {
        Display display = this.getWindowManager().getDefaultDisplay();
        if (laser.position != null) {
            PointF screenPos = DisplayScaling.scale(display, laser.position);
            int[] location = new int[2];
            this.laser.getLocationOnScreen(location);
            screenPos.x -= (float)location[0];
            screenPos.y -= (float)location[1];
            this.laser.setLaserPosition(screenPos);
        }
        if (laser.isEnd()) {
            this.laser.stopPointing();
        }
    }

    public void updateTouches(@NonNull Touch touch) {
        Display display = this.getWindowManager().getDefaultDisplay();
        PointF point = DisplayScaling.scale(display, touch.position);
        int[] location = new int[2];
        this.laser.getLocationOnScreen(location);
        point.x -= (float)location[0];
        point.y -= (float)location[1];
        if (touch.isStart()) {
            this.touches.start(point, touch.id);
        } else if (touch.isMove()) {
            this.touches.move(point, touch.id);
        } else if (touch.isEnd()) {
            this.touches.end(point, touch.id);
        }
    }

    public void clear() {
        this.annotation.setImageResource(17170445);
    }

    public boolean isEmpty() {
        return !this.laser.isPointing() && !(this.annotation.getDrawable() instanceof BitmapDrawable) && this.touches.isEmpty();
    }
}

