/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import androidx.annotation.NonNull;
import java.util.HashSet;

class BitmapScaleConverter {
    private final HashSet<Bitmap> cachedBitmap = new HashSet();

    BitmapScaleConverter() {
    }

    public void clear() {
        this.cachedBitmap.clear();
    }

    public Bitmap downscale(Bitmap bitmap, float scale) {
        return this.downscale(bitmap, scale, 1.0f, new Point(1, 1));
    }

    public Bitmap downscale(Bitmap bitmap, float scale, Point constraints) {
        return this.downscale(bitmap, scale, 1.0f, constraints);
    }

    public Bitmap createScaledBitmap(Bitmap input, int expectedWidth, int expectedHeight) {
        return Bitmap.createScaledBitmap((Bitmap)input, (int)expectedWidth, (int)expectedHeight, (boolean)true);
    }

    private Bitmap downscale(@NonNull Bitmap bitmap, float desiredScale, float currentScale, Point constraints) {
        if (desiredScale > currentScale) {
            desiredScale = currentScale;
        }
        if (currentScale / 2.0f > desiredScale) {
            return this.downscale(this.doResize(bitmap, 0.5f, new Point(1, 1)), desiredScale, currentScale / 2.0f, constraints);
        }
        return this.doResize(bitmap, desiredScale / currentScale, constraints);
    }

    private Bitmap doResize(@NonNull Bitmap bitmap, float scale, Point sizeConstraints) {
        int scaledWidth = (int)((float)bitmap.getWidth() * scale);
        int remainderWidth = scaledWidth % sizeConstraints.x;
        int targetWidth = scaledWidth - remainderWidth;
        float adjustedScaleWidth = (float)targetWidth / (float)bitmap.getWidth();
        int scaledHeight = (int)((float)bitmap.getHeight() * adjustedScaleWidth);
        int remainderHeight = scaledHeight % sizeConstraints.y;
        int targetHeight = scaledHeight - remainderHeight;
        float adjustedScaledHeight = (float)targetHeight / (float)bitmap.getHeight();
        Bitmap resized = this.getOrCreateBitmap(targetWidth, targetHeight, bitmap.getConfig());
        resized.eraseColor(0);
        Canvas canvas = new Canvas(resized);
        canvas.scale(adjustedScaleWidth, adjustedScaledHeight);
        Paint paint = new Paint();
        paint.setFilterBitmap(true);
        paint.setAntiAlias(true);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        return resized;
    }

    @NonNull
    private Bitmap getOrCreateBitmap(int targetWidth, int targetHeight, Bitmap.Config config) {
        for (Bitmap next : this.cachedBitmap) {
            if (next.getWidth() != targetWidth || next.getHeight() != targetHeight || next.getConfig() != config) continue;
            return next;
        }
        Bitmap created = Bitmap.createBitmap((int)targetWidth, (int)targetHeight, (Bitmap.Config)config);
        this.cachedBitmap.add(created);
        return created;
    }
}

