/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.accessibilityservice.AccessibilityService;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.UiThread;
import io.cobrowse.CobrowseIO;
import io.cobrowse.CobrowseService;
import io.cobrowse.ControlInjectorAccessibility;
import io.cobrowse.FullDeviceOverlayAccessibility;
import io.cobrowse.ui.CobrowseAccessibilitySetup;

@RequiresApi(api=21)
public class CobrowseAccessibilityService
extends AccessibilityService {
    @Nullable
    private ControlInjectorAccessibility controlInjector;
    @Nullable
    private FullDeviceOverlayAccessibility overlayInjector;
    @Nullable
    private String currentShownAppId;

    void sendStateUpdate(boolean running) {
        Intent intent = new Intent((Context)this, CobrowseService.Receiver.class);
        intent.setAction("io.cobrowse.ACCESSIBILITY_UPDATED");
        intent.putExtra("running", running);
        this.sendBroadcast(intent);
    }

    private void updateShownAppId(@NonNull String packageName) {
        if (this.currentShownAppId == null && packageName.equals("com.android.settings")) {
            try {
                CobrowseIO.instance().launchApp();
            }
            catch (Throwable e) {
                Log.w((String)"CobrowseIO", (String)("CobrowseAccessibilityService failed to launch app: " + e.getMessage()));
            }
        }
        this.currentShownAppId = packageName;
    }

    protected void onServiceConnected() {
        super.onServiceConnected();
        Log.i((String)"CobrowseIO", (String)"CobrowseAccessibilityService Connected");
        this.currentShownAppId = null;
        this.sendStateUpdate(true);
        try {
            AccessibilityNodeInfo node = this.getRootInActiveWindow();
            if (node != null && node.getPackageName() != null) {
                this.updateShownAppId(node.getPackageName().toString());
            }
        }
        catch (Exception e) {
            Log.w((String)"CobrowseIO", (String)("Failed to invoke getRootInActiveWindow: " + e.getMessage()));
        }
        if (Build.VERSION.SDK_INT >= 22) {
            if (this.overlayInjector != null) {
                Log.w((String)"CobrowseIO", (String)"Overlay injector already existed...");
            } else {
                try {
                    this.overlayInjector = new FullDeviceOverlayAccessibility(this);
                }
                catch (Throwable e) {
                    Log.w((String)"CobrowseIO", (String)("CobrowseAccessibilityService error creating injector" + e.getMessage()));
                }
            }
        }
        if (this.controlInjector != null) {
            Log.w((String)"CobrowseIO", (String)"Control injector already existed...");
        } else {
            try {
                this.controlInjector = new ControlInjectorAccessibility(this);
            }
            catch (Throwable e) {
                Log.w((String)"CobrowseIO", (String)("CobrowseAccessibilityService error creating injector" + e.getMessage()));
            }
        }
    }

    public void onDestroy() {
        Log.i((String)"CobrowseIO", (String)"CobrowseAccessibilityService Destroyed");
        this.currentShownAppId = null;
        if (Build.VERSION.SDK_INT >= 22 && this.overlayInjector != null) {
            try {
                this.overlayInjector.onDestroy();
            }
            catch (Throwable e) {
                Log.w((String)"CobrowseIO", (String)("CobrowseAccessibilityService error destroying injector" + e.getMessage()));
            }
            this.overlayInjector = null;
        }
        if (this.controlInjector != null) {
            try {
                this.controlInjector.onDestroy();
                this.sendStateUpdate(false);
            }
            catch (Throwable e) {
                Log.w((String)"CobrowseIO", (String)("CobrowseAccessibilityService error destroying injector" + e.getMessage()));
            }
            this.controlInjector = null;
        }
        super.onDestroy();
    }

    public void onInterrupt() {
    }

    public void onAccessibilityEvent(@NonNull AccessibilityEvent event) {
        if (event.getEventType() == 32 && event.getPackageName() != null) {
            this.updateShownAppId(event.getPackageName().toString());
        }
        try {
            if (this.controlInjector != null) {
                this.controlInjector.onAccessibilityEvent(event);
            } else {
                Log.w((String)"CobrowseIO", (String)"Control injector was null");
            }
        }
        catch (Throwable e) {
            Log.w((String)"CobrowseIO", (String)("CobrowseAccessibilityService error processing event" + e.getMessage()));
        }
    }

    public static boolean isEnabled(@NonNull Context context) {
        try {
            PackageInfo info = context.getPackageManager().getPackageInfo(context.getPackageName(), 4);
            if (info.services == null) {
                return false;
            }
            for (ServiceInfo service : info.services) {
                if (!CobrowseAccessibilityService.class.getName().equals(service.name)) continue;
                if (!service.isEnabled()) {
                    return false;
                }
                return "android.permission.BIND_ACCESSIBILITY_SERVICE".equals(service.permission);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)"CobrowseIO", (String)"Failed to read the app package info", (Throwable)e);
        }
        return false;
    }

    public static boolean isRunning(@NonNull Context context) {
        ComponentName expectedComponentName = new ComponentName(context, CobrowseAccessibilityService.class);
        String enabledServicesSetting = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"enabled_accessibility_services");
        if (enabledServicesSetting == null) {
            return false;
        }
        TextUtils.SimpleStringSplitter colonSplitter = new TextUtils.SimpleStringSplitter(':');
        colonSplitter.setString(enabledServicesSetting);
        while (colonSplitter.hasNext()) {
            String componentNameString = colonSplitter.next();
            ComponentName enabledService = ComponentName.unflattenFromString((String)componentNameString);
            if (enabledService == null || !enabledService.equals((Object)expectedComponentName)) continue;
            return true;
        }
        return false;
    }

    @UiThread
    public static void showSetup(@NonNull Context context) {
        if (CobrowseAccessibilityService.isEnabled(context)) {
            if (!CobrowseAccessibilityService.isRunning(context)) {
                Log.e((String)"CobrowseIO", (String)"Cobrowse accessibility service is enabled but not running. You need to enable it.");
                Intent i = new Intent(context, CobrowseAccessibilitySetup.class);
                i.addFlags(0x10000000);
                context.startActivity(i);
            } else {
                Log.i((String)"CobrowseIO", (String)"Cobrowse accessibility service is enabled and running");
            }
        } else {
            Log.i((String)"CobrowseIO", (String)"Cobrowse accessibility service is enabled and running");
        }
    }

    static interface AccessibilityInjector {
        public void onDestroy();
    }
}

