/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import io.cobrowse.ActivityWatcher;
import io.cobrowse.Callback;
import io.cobrowse.CobrowseAccessibilityService;
import io.cobrowse.CobrowseInitProvider;
import io.cobrowse.CobrowseService;
import io.cobrowse.Device;
import io.cobrowse.DeviceRegistrationLoop;
import io.cobrowse.FullDeviceFrameSource;
import io.cobrowse.KeyEvent;
import io.cobrowse.MapUtils;
import io.cobrowse.Selector;
import io.cobrowse.SelectorParser;
import io.cobrowse.Session;
import io.cobrowse.SessionContext;
import io.cobrowse.ThreadUtils;
import io.cobrowse.Touch;
import io.cobrowse.integrations.Integration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.Request;

public final class CobrowseIO {
    @NonNull
    public static final String USER_ID_KEY = "user_id";
    @NonNull
    public static final String USER_NAME_KEY = "user_name";
    @NonNull
    public static final String USER_EMAIL_KEY = "user_email";
    @NonNull
    public static final String DEVICE_NAME_KEY = "device_name";
    @NonNull
    public static final String DEVICE_ID_KEY = "device_id";
    @NonNull
    static final String TAG = "CobrowseIO";
    @Nullable
    private String license = null;
    @NonNull
    private HttpUrl api = HttpUrl.get((String)"https://api.cobrowse.io");
    private boolean registration = true;
    @NonNull
    private final String[] availableCapabilities = Device.availableCapabilities();
    @NonNull
    private String[] capabilities = this.availableCapabilities;
    @NonNull
    private String[] webviewRedactedViews = new String[0];
    @NonNull
    private String[] redactedViews = new String[0];
    @NonNull
    private String[] unredactedViews = new String[0];
    @Nullable
    private SessionContext context;
    @Nullable
    private Delegate delegate;
    @Nullable
    private Device device;
    private boolean started = false;
    @NonNull
    private final SessionContext.Delegate contextDelegate = new SessionContext.Delegate(){

        @Override
        @NonNull
        public List<Selector> redactionSelectors() {
            return SelectorParser.parseAll(CobrowseIO.this.redactedViews);
        }

        @Override
        @NonNull
        public List<Selector> unredactionSelectors() {
            return SelectorParser.parseAll(CobrowseIO.this.unredactedViews);
        }
    };
    @NonNull
    private static final CobrowseIO instance = new CobrowseIO();
    private long lastFCMTime;
    private Toast upgradeToast;

    @NonNull
    public static CobrowseIO instance() {
        return instance;
    }

    private CobrowseIO() {
    }

    @Deprecated
    @NonNull
    public String deviceId(@NonNull Application app) {
        return this.deviceId();
    }

    @NonNull
    public String deviceId() {
        return Device.deviceId(CobrowseInitProvider.getApplication());
    }

    @Nullable
    Device getDevice() {
        return this.device;
    }

    @NonNull
    static String version() {
        return "2.39.2";
    }

    public void setDelegate(@Nullable Delegate delegate) {
        this.delegate = delegate;
    }

    @Nullable
    Delegate getDelegate() {
        return this.delegate;
    }

    @Nullable
    <T extends Delegate> T getDelegate(@NonNull Class interf) {
        if (this.delegate == null) {
            return null;
        }
        if (interf.isAssignableFrom(this.delegate.getClass())) {
            return (T)this.delegate;
        }
        return null;
    }

    @UiThread
    private void setCurrentSession(@Nullable Session currentSession) {
        if (!this.started) {
            throw new RuntimeException("Cobrowse not started");
        }
        if (this.context != null) {
            this.context.destroy();
            this.context = null;
        }
        if (currentSession == null) {
            return;
        }
        this.context = new SessionContext(this.contextDelegate, CobrowseInitProvider.getApplication(), currentSession);
        currentSession.registerSessionListener(new Session.Listener(){

            @Override
            public void sessionDidUpdate(@NonNull Session session) {
                if (CobrowseIO.this.delegate != null) {
                    CobrowseIO.this.delegate.sessionDidUpdate(session);
                }
                CobrowseIO.this.showBannerMessageIfRequired();
            }

            @Override
            public void sessionDidEnd(@NonNull Session session) {
                if (CobrowseIO.this.delegate != null) {
                    CobrowseIO.this.delegate.sessionDidEnd(session);
                }
                if (CobrowseIO.this.context != null) {
                    CobrowseIO.this.context.destroy();
                    CobrowseIO.this.context = null;
                }
            }
        });
    }

    @Nullable
    public Session currentSession() {
        if (this.context != null) {
            return this.context.session;
        }
        return null;
    }

    public synchronized void createSession(@Nullable Callback<Error, Session> callback) {
        if (!this.started) {
            ThreadUtils.invoke(callback, new Error("start() must be called before creating a session"));
            return;
        }
        Session current = this.currentSession();
        if (current != null && (current.isAuthorizing() || current.isActive())) {
            ThreadUtils.invoke(callback, new Error("Already in a session"));
            return;
        }
        Session s = new Session(this.capabilities());
        s.create((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("device", Device.info(CobrowseInitProvider.getApplication()));
                if (CobrowseIO.this.customData() != null) {
                    this.put("custom_data", CobrowseIO.this.customData());
                }
            }
        }, (err, arg) -> {
            if (err != null) {
                this.setCurrentSession(null);
            }
            ThreadUtils.invoke(callback, err, err != null ? null : arg);
            SessionLoadDelegate d = (SessionLoadDelegate)this.getDelegate(SessionLoadDelegate.class);
            if (d != null) {
                d.sessionDidLoad(s);
            }
        });
        ThreadUtils.invokeAndWait(() -> this.setCurrentSession(s));
    }

    public synchronized void getSession(@NonNull String idOrCode, @Nullable Callback<Error, Session> callback) {
        if (!this.started) {
            ThreadUtils.invoke(callback, new Error("start() must be called before getting a session"));
            return;
        }
        Session current = this.currentSession();
        if (current != null && current.hasIdOrCode(idOrCode)) {
            ThreadUtils.invoke(callback, current);
            return;
        }
        Session s = new Session(this.capabilities());
        s.resource = new HashMap();
        s.resource.put("code", idOrCode);
        ThreadUtils.invokeAndWait(() -> this.setCurrentSession(s));
        s.fetch((err, arg) -> {
            if (err != null) {
                this.setCurrentSession(null);
            }
            ThreadUtils.invoke(callback, err, err != null ? null : arg);
            SessionLoadDelegate d = (SessionLoadDelegate)this.getDelegate(SessionLoadDelegate.class);
            if (d != null) {
                d.sessionDidLoad(s);
            }
        });
    }

    void reinitialize() {
        if (!this.started) {
            return;
        }
        assert (this.device != null);
        this.device.reset();
        if (this.registration()) {
            DeviceRegistrationLoop.schedule((Context)CobrowseInitProvider.getApplication(), 0L, 0);
        }
    }

    @NonNull
    public String license() {
        if (this.license == null) {
            return "";
        }
        return this.license;
    }

    public synchronized void license(@NonNull String license) {
        boolean changed;
        boolean bl = changed = !license.equals(this.license);
        if (changed && this.started) {
            throw new RuntimeException("Error: cannot change license once Cobrowse is started");
        }
        this.license = license;
    }

    @NonNull
    public String api() {
        return this.api.toString();
    }

    @NonNull
    HttpUrl apiUrl() {
        return this.api;
    }

    public synchronized void api(@NonNull String api) {
        boolean changed;
        boolean bl = changed = !api.equals(this.api.toString());
        if (changed && this.started) {
            throw new RuntimeException("Error: cannot change API once Cobrowse is started");
        }
        this.api = HttpUrl.get((String)api);
    }

    public synchronized void registration(boolean registration) {
        boolean changed;
        boolean bl = changed = registration != this.registration;
        if (changed && this.started) {
            throw new RuntimeException("Error: cannot change auto-registration configuration once Cobrowse is started");
        }
        this.registration = registration;
    }

    public boolean registration() {
        return this.registration;
    }

    public void start() {
        ThreadUtils.invokeAndWait(this::performStart);
    }

    @UiThread
    private synchronized void performStart() {
        if (this.started) {
            return;
        }
        if (this.license == null) {
            Log.e((String)TAG, (String)"You must set a license before calling start(...)");
            return;
        }
        this.started = true;
        Log.i((String)TAG, (String)("Initialising CobrowseIO " + CobrowseIO.version()));
        if (this.device == null) {
            this.device = new Device(CobrowseInitProvider.getApplication());
            this.device.registerDeviceListener(device -> this.showBannerMessageIfRequired());
        }
        Integration.init(CobrowseInitProvider.getApplication());
        this.reinitialize();
        if (this.registration()) {
            DeviceRegistrationLoop.init((Context)CobrowseInitProvider.getApplication());
        }
        CobrowseService.startCobrowseService(CobrowseInitProvider.getApplication());
    }

    @Deprecated
    public void start(@NonNull Application application) {
        this.start();
    }

    @Deprecated
    public void start(@NonNull Activity currentActivity) {
        this.start();
    }

    public void stop() {
        ThreadUtils.invokeAndWait(this::performStop);
    }

    @UiThread
    private synchronized void performStop() {
        DeviceRegistrationLoop.stop((Context)CobrowseInitProvider.getApplication());
        if (this.currentSession() != null) {
            this.currentSession().end(null);
        }
        if (this.context != null) {
            this.context.destroy();
            this.context = null;
        }
        if (this.device != null && this.registration()) {
            this.device.deregister(null);
            this.device = null;
        }
        this.started = false;
    }

    public synchronized void customData(@NonNull Map<String, Object> customData) {
        if (Device.customData() != null && MapUtils.contains(Device.customData(), customData)) {
            Log.i((String)TAG, (String)"Skipping customData update as cached data matches");
            return;
        }
        Device.customData(customData);
        if (this.started) {
            if (this.device != null && this.registration()) {
                this.device.register(null);
            }
            if (this.currentSession() != null && this.currentSession().isActive()) {
                HashMap<String, Object> update = new HashMap<String, Object>();
                update.put("custom_data", customData);
                this.currentSession().update((Map<String, Object>)update, (Callback<Error, Session>)null);
            }
        }
    }

    @Nullable
    public Map<String, Object> customData() {
        if (Device.customData() == null) {
            return null;
        }
        return Collections.unmodifiableMap(Device.customData());
    }

    public synchronized void capabilities(@NonNull String[] capabilities) {
        if (this.started) {
            throw new RuntimeException("Error: cannot change capabilities once Cobrowse is started");
        }
        HashSet<String> existingCapabilities = new HashSet<String>();
        for (String capability : capabilities) {
            if (!Arrays.asList(this.availableCapabilities).contains(capability)) {
                Log.w((String)TAG, (String)("Warning: Capability '" + capability + "' not supported. Ignoring..."));
                continue;
            }
            existingCapabilities.add(capability);
        }
        this.capabilities = existingCapabilities.toArray(new String[0]);
    }

    @NonNull
    public synchronized String[] capabilities() {
        if (this.currentSession() != null && this.currentSession().isActive()) {
            return this.currentSession().capabilities();
        }
        return this.capabilities;
    }

    public synchronized void redactedViews(@NonNull String[] selectors) {
        if (this.started) {
            throw new RuntimeException("Error: cannot change redactedViews once Cobrowse is started");
        }
        for (String s : selectors) {
            if (SelectorParser.parse(s) != null) continue;
            Log.e((String)TAG, (String)("Failed to parse redaction selector: " + s));
        }
        this.redactedViews = selectors;
    }

    @NonNull
    public synchronized String[] redactedViews() {
        return this.redactedViews;
    }

    public synchronized void unredactedViews(@NonNull String[] selectors) {
        if (this.started) {
            throw new RuntimeException("Error: cannot change unredactedViews once Cobrowse is started");
        }
        for (String s : selectors) {
            if (SelectorParser.parse(s) != null) continue;
            Log.e((String)TAG, (String)("Failed to parse unredaction selector: " + s));
        }
        this.unredactedViews = selectors;
    }

    @NonNull
    public synchronized String[] unredactedViews() {
        return this.unredactedViews;
    }

    public synchronized void webviewRedactedViews(@NonNull String[] redactionSelectors) {
        if (this.started) {
            throw new RuntimeException("Error: cannot change webviewRedaction once Cobrowse is started");
        }
        this.webviewRedactedViews = redactionSelectors;
    }

    @NonNull
    public synchronized String[] webviewRedactedViews() {
        return this.webviewRedactedViews;
    }

    @Deprecated
    public synchronized void setDeviceToken(@NonNull Application app, @NonNull String token) {
        this.setDeviceToken(token);
    }

    public synchronized void setDeviceToken(@NonNull String token) {
        if (token.equals(Device.getToken())) {
            return;
        }
        Device.setToken(token);
        if (this.started && this.device != null && this.registration()) {
            this.device.register(null);
        }
    }

    private boolean canLaunchFromBackground(@NonNull Application app) {
        if (ActivityWatcher.foregroundActivity() != null) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 29) {
            if (CobrowseAccessibilityService.isRunning((Context)app)) {
                Log.i((String)TAG, (String)"Relying on Accessibility for background launch");
                return true;
            }
            long delta = System.currentTimeMillis() - this.lastFCMTime;
            if (delta < 10000L) {
                Log.i((String)TAG, (String)("Relying on FCM for background launch, delta=" + delta));
                return true;
            }
            Log.i((String)TAG, (String)("Cannot automatically launch app from background, delta=" + delta));
            return false;
        }
        return true;
    }

    boolean launchApp() {
        if (!this.canLaunchFromBackground(CobrowseInitProvider.getApplication())) {
            return false;
        }
        String packageName = CobrowseInitProvider.getApplication().getPackageName();
        Intent launchIntent = CobrowseInitProvider.getApplication().getPackageManager().getLaunchIntentForPackage(packageName);
        if (launchIntent == null) {
            return false;
        }
        launchIntent.setFlags(0x10000000);
        CobrowseInitProvider.getApplication().startActivity(launchIntent);
        return true;
    }

    boolean launchPermissionActivity() {
        if (!this.canLaunchFromBackground(CobrowseInitProvider.getApplication())) {
            return false;
        }
        Intent intent = new Intent((Context)CobrowseInitProvider.getApplication(), FullDeviceFrameSource.PermissionRequestActivity.class);
        intent.setFlags(0x10008000);
        CobrowseInitProvider.getApplication().startActivity(intent);
        return true;
    }

    public synchronized void onPushNotification(@NonNull Map<String, String> data) {
        this.onPushNotification(data, true);
    }

    void onPushNotification(@NonNull Map<String, String> data, boolean isFCM) {
        try {
            if (CobrowseIO.isCobrowseNotification(data).booleanValue()) {
                String code;
                if (isFCM) {
                    this.lastFCMTime = System.currentTimeMillis();
                }
                if ((code = data.get("cobrowseio-code")) != null) {
                    this.getSession(code, (err, arg) -> {
                        if (err != null) {
                            Log.w((String)TAG, (String)("Push failed: " + err.getMessage()));
                        }
                    });
                }
            }
        }
        catch (Throwable e) {
            Log.w((String)TAG, (String)("Error processing notification " + e));
        }
    }

    private void showBannerMessageIfRequired() {
        if (Build.VERSION.SDK_INT == 25) {
            return;
        }
        if (this.device != null && this.device.bannerMessage() != null) {
            if (this.upgradeToast != null) {
                this.upgradeToast.cancel();
            }
            this.upgradeToast = Toast.makeText((Context)CobrowseInitProvider.getApplication(), (CharSequence)this.device.bannerMessage(), (int)1);
            this.upgradeToast.show();
        }
    }

    public static synchronized Boolean isCobrowseNotification(@Nullable Map<String, String> data) {
        if (data == null) {
            return false;
        }
        if (!data.containsKey("cobrowseio-notification")) {
            return false;
        }
        String isCobrowse = data.get("cobrowseio-notification");
        if (isCobrowse == null) {
            return false;
        }
        return isCobrowse.equals("true");
    }

    static HashMap<String, String> headers() {
        return new HashMap<String, String>(){
            {
                this.put("X-CobrowseSDKVersion", CobrowseIO.version());
                this.put("X-CobrowsePlatform", "android");
                this.put("X-CobrowseDevice", CobrowseIO.instance().deviceId());
                this.put("X-CobrowseLicense", CobrowseIO.instance().license());
                this.put("X-CobrowseAPIVersion", "1.2.0");
            }
        };
    }

    @NonNull
    static Request.Builder request(@NonNull Application app) {
        Request.Builder b = new Request.Builder();
        for (Map.Entry<String, String> e : CobrowseIO.headers().entrySet()) {
            b.header(e.getKey(), e.getValue());
        }
        return b;
    }

    @UiThread
    public static interface Delegate
    extends Session.Listener {
    }

    @UiThread
    public static interface SessionLoadDelegate
    extends Delegate {
        public void sessionDidLoad(@NonNull Session var1);
    }

    @UiThread
    public static interface UnredactionDelegate {
        @Nullable
        public List<View> unredactedViews(@NonNull Activity var1);
    }

    @UiThread
    public static interface RedactionDelegate {
        @Nullable
        public List<View> redactedViews(@NonNull Activity var1);
    }

    @UiThread
    public static interface SessionControlsDelegate
    extends Delegate {
        public void showSessionControls(@Nullable Activity var1, @NonNull Session var2);

        public void hideSessionControls(@Nullable Activity var1, @NonNull Session var2);
    }

    @UiThread
    public static interface FullDeviceRequestDelegate
    extends Delegate {
        public void handleFullDeviceRequest(@NonNull Activity var1, @NonNull Session var2);
    }

    @UiThread
    public static interface RemoteControlRequestDelegate
    extends Delegate {
        public void handleRemoteControlRequest(@NonNull Activity var1, @NonNull Session var2);
    }

    @UiThread
    public static interface SessionRequestDelegate
    extends Delegate {
        public void handleSessionRequest(@NonNull Activity var1, @NonNull Session var2);
    }

    @UiThread
    static interface RemoteControlDelegate
    extends Delegate {
        public boolean shouldAllowTouch(@Nullable View var1, @NonNull Touch var2, @NonNull Session var3);

        public boolean shouldAllowKeyEvent(@Nullable View var1, @NonNull KeyEvent var2, @NonNull Session var3);
    }

    @UiThread
    public static interface Unredacted {
        public List<View> unredactedViews();
    }

    @UiThread
    public static interface Redacted {
        public List<View> redactedViews();
    }
}

