/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.app.Application;
import android.app.ForegroundServiceStartNotAllowedException;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Build;
import android.os.IBinder;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import io.cobrowse.Callback;
import io.cobrowse.CobrowseIO;
import io.cobrowse.CobrowseInitProvider;
import io.cobrowse.CompatibilityUtils;
import io.cobrowse.Device;
import io.cobrowse.R;
import io.cobrowse.Session;
import io.cobrowse.ThreadUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public final class CobrowseService
extends Service {
    @NonNull
    static final String END_SESSION = "io.cobrowse.END_SESSION";
    @NonNull
    static final String ACCESSIBILITY_UPDATED = "io.cobrowse.ACCESSIBILITY_UPDATED";
    @Nullable
    private static Boolean isEnabled = null;
    @Nullable
    private static Boolean isMediaProjectionEnabled = null;
    private static boolean isForeground = false;
    private static boolean isRunning = false;
    private static final ConcurrentLinkedQueue<Boolean> startCommandRequests = new ConcurrentLinkedQueue();
    @NonNull
    private final Timer timer = new Timer();

    static boolean isEnabled() {
        if (isEnabled != null) {
            return isEnabled;
        }
        Application context = CobrowseInitProvider.getApplication();
        try {
            PackageInfo info = context.getPackageManager().getPackageInfo(context.getPackageName(), 4);
            if (info.services == null) {
                isEnabled = false;
                return isEnabled;
            }
            for (ServiceInfo service : info.services) {
                if (!CobrowseService.class.getName().equals(service.name)) continue;
                isEnabled = service.isEnabled();
                return isEnabled;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)"CobrowseIO", (String)"Failed to read the app package info", (Throwable)e);
        }
        isEnabled = false;
        return isEnabled;
    }

    static boolean isMediaProjectionEnabled() {
        if (isMediaProjectionEnabled != null) {
            return isMediaProjectionEnabled;
        }
        if (!CobrowseService.isEnabled()) {
            isMediaProjectionEnabled = false;
            return isMediaProjectionEnabled;
        }
        Application context = CobrowseInitProvider.getApplication();
        try {
            PackageInfo info = context.getPackageManager().getPackageInfo(context.getPackageName(), 4);
            if (info.services == null) {
                isMediaProjectionEnabled = false;
                return isMediaProjectionEnabled;
            }
            for (ServiceInfo service : info.services) {
                if (!CobrowseService.class.getName().equals(service.name)) continue;
                isMediaProjectionEnabled = Build.VERSION.SDK_INT >= 29 ? Boolean.valueOf((service.getForegroundServiceType() & 0x20) == 32) : Boolean.valueOf(true);
                return isMediaProjectionEnabled;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)"CobrowseIO", (String)"Failed to read the app package info", (Throwable)e);
        }
        isMediaProjectionEnabled = false;
        return isMediaProjectionEnabled;
    }

    static boolean needMediaProjectionPermissionBeforeStart() {
        return Build.VERSION.SDK_INT >= 34 && CompatibilityUtils.targetSdkVersion() >= 34;
    }

    static void startCobrowseService(@NonNull Application app) {
        if (!CobrowseService.isEnabled()) {
            return;
        }
        CobrowseService.setForeground(app, false);
    }

    static void stopCobrowseService(@NonNull Application app) {
        if (!CobrowseService.isEnabled()) {
            return;
        }
        try {
            app.stopService(new Intent((Context)app, CobrowseService.class));
        }
        catch (Exception e) {
            Log.i((String)"CobrowseIO", (String)("CobrowseService didn't stop: " + e.getMessage()));
        }
    }

    static void setForeground(@NonNull Callback<Error, Boolean> callback) {
        if (!CobrowseService.isEnabled()) {
            return;
        }
        new Thread(() -> {
            CobrowseService.setForeground(CobrowseInitProvider.getApplication(), true);
            ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            executor.scheduleAtFixedRate(() -> {
                if (startCommandRequests.peek() == null) {
                    ThreadUtils.invoke(callback, null, true);
                    executor.shutdown();
                }
            }, 0L, 17L, TimeUnit.MILLISECONDS);
        }).start();
    }

    static void setForeground() {
        if (!CobrowseService.isEnabled()) {
            return;
        }
        CobrowseService.setForeground(CobrowseInitProvider.getApplication(), true);
    }

    static void setBackground() {
        if (!CobrowseService.isEnabled()) {
            return;
        }
        CobrowseService.setForeground(CobrowseInitProvider.getApplication(), false);
    }

    private static void setForeground(@NonNull Application app, boolean foreground) {
        block5: {
            if (isRunning && foreground == isForeground) {
                return;
            }
            try {
                Intent i = new Intent((Context)app, CobrowseService.class);
                i.putExtra("foreground", foreground);
                if (foreground && Build.VERSION.SDK_INT >= 26) {
                    app.startForegroundService(i);
                } else {
                    app.startService(i);
                }
                startCommandRequests.add(foreground);
                isForeground = foreground;
                isRunning = true;
            }
            catch (Exception e) {
                if (Build.VERSION.SDK_INT >= 31 && e.getClass().getSimpleName().equals(ForegroundServiceStartNotAllowedException.class.getSimpleName())) break block5;
                Log.e((String)"CobrowseIO", (String)("CobrowseService service didn't start: " + e.getMessage()));
            }
        }
    }

    @RequiresApi(value=26)
    @NonNull
    private NotificationChannel getNotificationChannel() {
        NotificationChannel channel = new NotificationChannel("cobrowse-io-notifications", (CharSequence)this.getString(R.string.cobrowse_notification_channel_name), 2);
        NotificationManager manager = (NotificationManager)this.getSystemService("notification");
        if (manager != null) {
            manager.createNotificationChannel(channel);
        }
        return channel;
    }

    @NonNull
    private PendingIntent getEndSessionIntent() {
        Intent endSessionIntent = new Intent((Context)this, Receiver.class);
        endSessionIntent.setAction(END_SESSION);
        return PendingIntent.getBroadcast((Context)this, (int)0, (Intent)endSessionIntent, (int)(Build.VERSION.SDK_INT >= 23 ? 0x4000000 : 0));
    }

    private Notification getForegroundNotification() {
        return new Notification.Builder((Context)this).setContentTitle(this.getText(R.string.cobrowse_foreground_service_title)).setSmallIcon(R.drawable.cobrowse_service_icon).addAction(R.drawable.cobrowse_service_icon, this.getText(R.string.cobrowse_button_end_session), this.getEndSessionIntent()).build();
    }

    @RequiresApi(value=26)
    private Notification getForegroundNotificationV26() {
        return new Notification.Builder((Context)this, this.getNotificationChannel().getId()).setContentTitle(this.getText(R.string.cobrowse_foreground_service_title)).setSmallIcon(R.drawable.cobrowse_service_icon).addAction(R.drawable.cobrowse_service_icon, this.getText(R.string.cobrowse_button_end_session), this.getEndSessionIntent()).build();
    }

    public int onStartCommand(@Nullable Intent intent, int flags, int startId) {
        block6: {
            boolean foreground = false;
            if (intent != null) {
                foreground = intent.getBooleanExtra("foreground", false);
            }
            if (foreground) {
                try {
                    this.startForeground(R.string.cobrowse_foreground_service_title, Build.VERSION.SDK_INT >= 26 ? this.getForegroundNotificationV26() : this.getForegroundNotification());
                }
                catch (Exception e) {
                    if (Build.VERSION.SDK_INT >= 31 && e.getClass().getSimpleName().equals(ForegroundServiceStartNotAllowedException.class.getSimpleName())) {
                        isForeground = false;
                        break block6;
                    }
                    Log.e((String)"CobrowseIO", (String)("CobrowseService service didn't start: " + e.getMessage()));
                }
            } else {
                this.stopForeground(true);
            }
        }
        startCommandRequests.poll();
        return 1;
    }

    @Nullable
    public IBinder onBind(@Nullable Intent intent) {
        return null;
    }

    private void debugTimer() {
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                Log.i((String)"CobrowseIO", (String)"CobrowseService service is running");
            }
        }, 0L, 10000L);
    }

    public static class Receiver
    extends BroadcastReceiver {
        public void onReceive(@NonNull Context context, @NonNull Intent intent) {
            if (CobrowseService.END_SESSION.equals(intent.getAction()) && CobrowseIO.instance().currentSession() != null) {
                CobrowseIO.instance().currentSession().end(null);
            }
            if (CobrowseService.ACCESSIBILITY_UPDATED.equals(intent.getAction())) {
                CobrowseIO.instance().reinitialize();
                Session session = CobrowseIO.instance().currentSession();
                if (session != null && !session.isEnded()) {
                    session.toggleCapabilitiesForFullDeviceState(session.fullDeviceState() != Session.FullDeviceState.On);
                    HashMap<String, Object> update = new HashMap<String, Object>();
                    update.put("device", Device.info(CobrowseInitProvider.getApplication()));
                    session.update((Map<String, Object>)update, (Callback<Error, Session>)null);
                }
            }
        }
    }
}

