/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.cobrowse.CobrowseInitProvider;

final class CompatibilityUtils {
    @Nullable
    private static Integer hostAppTargetSdk;

    CompatibilityUtils() {
    }

    @SuppressLint(value={"UnspecifiedRegisterReceiverFlag"})
    static void registerBroadcastReceiver(@NonNull Context context, @NonNull BroadcastReceiver receiver, @NonNull IntentFilter filter) {
        if (Build.VERSION.SDK_INT >= 34) {
            context.registerReceiver(receiver, filter, 4);
        } else {
            context.registerReceiver(receiver, filter);
        }
    }

    static int targetSdkVersion() {
        if (hostAppTargetSdk == null) {
            hostAppTargetSdk = CobrowseInitProvider.getApplication().getApplicationInfo().targetSdkVersion;
        }
        return hostAppTargetSdk;
    }

    static class VERSION_CODES {
        public static final int VANILLA_ICE_CREAM = 35;

        VERSION_CODES() {
        }
    }
}

