/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.SystemClock;
import android.view.KeyCharacterMap;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.cobrowse.CobrowseAccessibilityService;
import io.cobrowse.ControlInjectorAccessibility;
import io.cobrowse.KeyEvent;
import io.cobrowse.Session;
import io.cobrowse.SessionContextModule;
import io.cobrowse.Touch;
import java.util.ArrayList;
import java.util.Arrays;

final class ControlInjector
extends SessionContextModule {
    ControlInjector(@NonNull Application app, @NonNull Session session) {
        super(app, session);
    }

    @Override
    void destroy() {
        if (Build.VERSION.SDK_INT >= 21) {
            ControlInjectorAccessibility.notifySessionEnded(this.getApplication());
        }
    }

    private void dispatchTouch(@NonNull View target, @NonNull MotionEvent e) {
        target.dispatchTouchEvent(e);
    }

    private void onTouchStart(@NonNull View target, @NonNull Touch touch) {
        long downtime = SystemClock.uptimeMillis();
        long eventtime = SystemClock.uptimeMillis();
        this.dispatchTouch(target, MotionEvent.obtain((long)downtime, (long)eventtime, (int)0, (float)touch.position.x, (float)touch.position.y, (int)0));
    }

    private void onTouchMove(@NonNull View target, @NonNull Touch touch) {
        long downtime = SystemClock.uptimeMillis();
        long eventtime = SystemClock.uptimeMillis();
        this.dispatchTouch(target, MotionEvent.obtain((long)downtime, (long)eventtime, (int)2, (float)touch.position.x, (float)touch.position.y, (int)0));
    }

    private void onTouchEnd(@NonNull View target, @NonNull Touch touch) {
        long downtime = SystemClock.uptimeMillis();
        long eventtime = SystemClock.uptimeMillis();
        this.dispatchTouch(target, MotionEvent.obtain((long)downtime, (long)eventtime, (int)1, (float)touch.position.x, (float)touch.position.y, (int)0));
    }

    @NonNull
    private ArrayList<android.view.KeyEvent> synthesizeKeypress(int keycode) {
        ArrayList<android.view.KeyEvent> events = new ArrayList<android.view.KeyEvent>();
        events.add(new android.view.KeyEvent(0, keycode));
        events.add(new android.view.KeyEvent(1, keycode));
        return events;
    }

    private void onKeyDown(@NonNull View target, @NonNull KeyEvent event) {
        KeyCharacterMap CharMap;
        android.view.KeyEvent[] keyEvents;
        ArrayList<android.view.KeyEvent> events = new ArrayList<android.view.KeyEvent>();
        Application app = this.getApplication();
        if (event.code.equals("GoHome")) {
            Intent startMain = new Intent("android.intent.action.MAIN");
            startMain.addCategory("android.intent.category.HOME");
            startMain.setFlags(0x10000000);
            app.startActivity(startMain);
        }
        if (event.key.length() == 1 && (keyEvents = (CharMap = KeyCharacterMap.load((int)-1)).getEvents(event.key.toCharArray())) != null) {
            events.addAll(Arrays.asList(keyEvents));
        }
        switch (event.code) {
            case "Backspace": {
                events = this.synthesizeKeypress(67);
                break;
            }
            case "GoBack": {
                events = this.synthesizeKeypress(4);
                break;
            }
            case "ArrowLeft": {
                events = this.synthesizeKeypress(21);
                break;
            }
            case "ArrowRight": {
                events = this.synthesizeKeypress(22);
                break;
            }
            case "ArrowUp": {
                events = this.synthesizeKeypress(19);
                break;
            }
            case "ArrowDown": {
                events = this.synthesizeKeypress(20);
                break;
            }
            case "Enter": {
                events = this.synthesizeKeypress(66);
            }
        }
        for (android.view.KeyEvent k : events) {
            target.dispatchKeyEvent(k);
        }
    }

    void inject(@Nullable View target, @NonNull KeyEvent event) {
        if (target == null) {
            if (Build.VERSION.SDK_INT >= 21) {
                ControlInjectorAccessibility.inject(this.getApplication(), event);
            }
        } else if (event.isKeyDown()) {
            this.onKeyDown(target, event);
        }
    }

    void inject(@Nullable View target, @NonNull Touch touch) {
        if (target == null) {
            if (Build.VERSION.SDK_INT >= 21) {
                ControlInjectorAccessibility.inject(this.getApplication(), touch);
            }
            return;
        }
        if (Build.VERSION.SDK_INT >= 24 && this.session.fullDevice().booleanValue() && CobrowseAccessibilityService.isRunning((Context)this.getApplication())) {
            ControlInjectorAccessibility.inject(this.getApplication(), touch);
            return;
        }
        int[] location = new int[2];
        target.getLocationOnScreen(location);
        touch.position.x -= (float)location[0];
        touch.position.y -= (float)location[1];
        if (touch.isStart()) {
            this.onTouchStart(target, touch);
        } else if (touch.isMove()) {
            this.onTouchMove(target, touch);
        } else if (touch.isEnd()) {
            this.onTouchEnd(target, touch);
        }
    }
}

