/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.accessibilityservice.AccessibilityService;
import android.accessibilityservice.GestureDescription;
import android.annotation.SuppressLint;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Path;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.ViewConfiguration;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import io.cobrowse.CobrowseAccessibilityService;
import io.cobrowse.CobrowseIO;
import io.cobrowse.CompatibilityUtils;
import io.cobrowse.GestureRecognizer;
import io.cobrowse.KeyEvent;
import io.cobrowse.PanGestureRecognizer;
import io.cobrowse.Predicate;
import io.cobrowse.R;
import io.cobrowse.Session;
import io.cobrowse.Touch;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RequiresApi(api=21)
class ControlInjectorAccessibility
extends BroadcastReceiver
implements CobrowseAccessibilityService.AccessibilityInjector {
    @NonNull
    private static final String REMOTE_CONTROL_INTENT = "io.cobrowse.REMOTE_CONTROL";
    @NonNull
    private static final String SESSION_ENDED_INTENT = "io.cobrowse.SESSION_ENDED";
    @NonNull
    private final AccessibilityService service;
    private final boolean acceptMediaProjectionPrompt;
    @NonNull
    private final TypedPasswordsStorage passwords;
    private boolean isAwaitingMediaProjectionLayoutChange;
    @Nullable
    @RequiresApi(api=26)
    private GestureDescription.StrokeDescription strokeDescription;
    @NonNull
    private static final PanGestureRecognizer panRecognizer = new PanGestureRecognizer();
    @Nullable
    private static Touch initialTouch;
    @Nullable
    private static Touch previousTouch;

    ControlInjectorAccessibility(@NonNull AccessibilityService service) {
        this.service = service;
        CompatibilityUtils.registerBroadcastReceiver((Context)service, this, new IntentFilter(REMOTE_CONTROL_INTENT));
        CompatibilityUtils.registerBroadcastReceiver((Context)service, this, new IntentFilter(SESSION_ENDED_INTENT));
        this.acceptMediaProjectionPrompt = service.getResources().getBoolean(R.bool.cobrowse_automatically_accept_media_projection_prompt);
        this.passwords = new TypedPasswordsStorage();
    }

    @Override
    public void onDestroy() {
        this.service.unregisterReceiver((BroadcastReceiver)this);
        this.isAwaitingMediaProjectionLayoutChange = false;
    }

    @Nullable
    private AccessibilityNodeInfo findNode(@NonNull AccessibilityNodeInfo node, @NonNull Predicate<AccessibilityNodeInfo> predicate) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            AccessibilityNodeInfo child = this.findNode(node.getChild(i), predicate);
            if (child == null) continue;
            return child;
        }
        if (predicate.test(node)) {
            return node;
        }
        return null;
    }

    @Nullable
    private AccessibilityNodeInfo pick(@NonNull AccessibilityNodeInfo parent, int x, int y, @NonNull Predicate<AccessibilityNodeInfo> predicate) {
        return this.findNode(parent, node -> {
            Rect bounds = new Rect();
            node.getBoundsInScreen(bounds);
            return bounds.contains(x, y) && predicate.test((AccessibilityNodeInfo)node);
        });
    }

    private void key(@Nullable String state, @Nullable String key, @Nullable String code) {
        if (state == null || key == null || code == null) {
            return;
        }
        if (!state.equals("keydown")) {
            return;
        }
        if (code.equals("GoBack")) {
            this.service.performGlobalAction(1);
            return;
        }
        if (code.equals("GoHome")) {
            this.service.performGlobalAction(2);
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            AccessibilityNodeInfo node = this.service.findFocus(1);
            if (node == null) {
                return;
            }
            int cursor = Math.max(0, node.getTextSelectionStart());
            Bundle arguments = new Bundle();
            if (code.equals("ArrowLeft")) {
                arguments.putInt("ACTION_ARGUMENT_SELECTION_START_INT", cursor - 1);
                arguments.putInt("ACTION_ARGUMENT_SELECTION_END_INT", cursor - 1);
                node.performAction(131072, arguments);
                return;
            }
            if (code.equals("ArrowRight")) {
                arguments.putInt("ACTION_ARGUMENT_SELECTION_START_INT", cursor + 1);
                arguments.putInt("ACTION_ARGUMENT_SELECTION_END_INT", cursor + 1);
                node.performAction(131072, arguments);
                return;
            }
            if (Build.VERSION.SDK_INT >= 30 && code.equals("Enter")) {
                node.performAction(16908372);
                return;
            }
            if (node.isPassword()) {
                CharSequence newText = this.passwords.guessNewValue(node, code, key);
                arguments.putCharSequence("ACTION_ARGUMENT_SET_TEXT_CHARSEQUENCE", newText);
                node.performAction(0x200000, arguments);
                return;
            }
            CharSequence text = ControlInjectorAccessibility.getTextFromNode(node);
            CharSequence pre = text.subSequence(0, cursor);
            CharSequence post = text.subSequence(cursor, text.length());
            if (key.length() != 1) {
                key = "";
                if (code.equals("Backspace")) {
                    pre = pre.subSequence(0, Math.max(0, pre.length() - 1));
                    --cursor;
                }
            } else {
                ++cursor;
            }
            String newText = pre + key + post;
            arguments.putCharSequence("ACTION_ARGUMENT_SET_TEXT_CHARSEQUENCE", (CharSequence)newText);
            node.performAction(0x200000, arguments);
            arguments.putInt("ACTION_ARGUMENT_SELECTION_START_INT", cursor);
            arguments.putInt("ACTION_ARGUMENT_SELECTION_END_INT", cursor);
            node.performAction(131072, arguments);
        }
    }

    @NonNull
    private static CharSequence getTextFromNode(@NonNull AccessibilityNodeInfo node) {
        CharSequence text = node.getText();
        if (text == null) {
            text = "";
        }
        if (Build.VERSION.SDK_INT >= 26 && node.isShowingHintText()) {
            text = "";
        }
        return text;
    }

    @RequiresApi(api=24)
    private void gestureV24(int startX, int startY, int endX, int endY, int duration) {
        duration = duration > 0 ? duration : 1;
        GestureDescription.Builder gestureBuilder = new GestureDescription.Builder();
        Path path = new Path();
        path.moveTo((float)startX, (float)startY);
        path.lineTo((float)endX, (float)endY);
        gestureBuilder.addStroke(new GestureDescription.StrokeDescription(path, 0L, (long)duration));
        this.service.dispatchGesture(gestureBuilder.build(), null, null);
    }

    @RequiresApi(api=26)
    private void gestureV26(int startX, int startY, int endX, int endY, int duration, int action) {
        duration = duration > 0 ? duration : 1;
        Path path = new Path();
        switch (action) {
            case 0: {
                path.moveTo((float)startX, (float)startY);
                this.strokeDescription = new GestureDescription.StrokeDescription(path, 0L, (long)duration, true);
                break;
            }
            case 2: {
                if (this.strokeDescription == null) {
                    Log.e((String)"CobrowseIO", (String)"Received ACTION_MOVE, but there was no ACTION_DOWN");
                    return;
                }
                path.moveTo((float)startX, (float)startY);
                path.lineTo((float)endX, (float)endY);
                this.strokeDescription = this.strokeDescription.continueStroke(path, 0L, (long)duration, true);
                break;
            }
            case 1: {
                if (this.strokeDescription == null) {
                    Log.e((String)"CobrowseIO", (String)"Received ACTION_UP, but there was no ACTION_DOWN");
                    return;
                }
                path.moveTo((float)startX, (float)startY);
                path.lineTo((float)endX, (float)endY);
                this.strokeDescription = this.strokeDescription.continueStroke(path, 0L, (long)duration, false);
                break;
            }
            default: {
                Log.e((String)"CobrowseIO", (String)("Unsupported action " + action));
                return;
            }
        }
        GestureDescription gestureDescription = new GestureDescription.Builder().addStroke(this.strokeDescription).build();
        this.service.dispatchGesture(gestureDescription, null, null);
    }

    private void click(int x, int y, int duration) {
        AccessibilityNodeInfo root = this.service.getRootInActiveWindow();
        if (root == null) {
            return;
        }
        boolean performed = false;
        for (AccessibilityNodeInfo node = this.pick(root, x, y, node1 -> node1.isVisibleToUser() && node1.isClickable()); node != null && !performed; node = node.getParent()) {
            int action = duration >= ViewConfiguration.getLongPressTimeout() ? 32 : 16;
            performed = node.performAction(action);
        }
        root.recycle();
    }

    private void scroll(int x, int y, @NonNull PanGestureRecognizer.Direction direction) {
        int action;
        switch (direction) {
            case Up: 
            case Left: {
                action = 4096;
                break;
            }
            case Down: 
            case Right: {
                action = 8192;
                break;
            }
            default: {
                return;
            }
        }
        AccessibilityNodeInfo root = this.service.getRootInActiveWindow();
        if (root == null) {
            return;
        }
        boolean performed = false;
        for (AccessibilityNodeInfo node = this.pick(root, x, y, node1 -> node1.isScrollable()); node != null && !performed; node = node.getParent()) {
            performed = node.performAction(action);
        }
        root.recycle();
    }

    static void inject(@NonNull Application application, @NonNull Touch touch) {
        if (touch.isStart()) {
            initialTouch = touch;
        }
        panRecognizer.onTouchEvent(touch);
        Bundle data = new Bundle();
        if (Build.VERSION.SDK_INT >= 26) {
            if (initialTouch != null && previousTouch != null) {
                data.putString("action", "gestureV26");
                data.putInt("start_x", (int)ControlInjectorAccessibility.previousTouch.position.x);
                data.putInt("start_y", (int)ControlInjectorAccessibility.previousTouch.position.y);
                data.putInt("end_x", (int)touch.position.x);
                data.putInt("end_y", (int)touch.position.y);
                if (touch.isStart()) {
                    data.putInt("touch_action", 0);
                } else if (touch.isMove()) {
                    data.putInt("touch_action", 2);
                } else {
                    data.putInt("touch_action", 1);
                }
            }
            previousTouch = touch;
        } else if (touch.isEnd()) {
            long duration;
            if (Build.VERSION.SDK_INT >= 24) {
                if (initialTouch != null) {
                    duration = touch.timestamp.getTime() - ControlInjectorAccessibility.initialTouch.timestamp.getTime();
                    data.putString("action", "gestureV24");
                    data.putInt("start_x", (int)ControlInjectorAccessibility.initialTouch.position.x);
                    data.putInt("start_y", (int)ControlInjectorAccessibility.initialTouch.position.y);
                    data.putInt("end_x", (int)touch.position.x);
                    data.putInt("end_y", (int)touch.position.y);
                    data.putInt("duration", (int)duration);
                }
            } else if (panRecognizer.state() == GestureRecognizer.GestureState.Recognized) {
                data.putString("action", "scroll");
                data.putString("direction", panRecognizer.getDirection().toString());
                data.putInt("x", (int)touch.position.x);
                data.putInt("y", (int)touch.position.y);
            } else {
                data.putString("action", "click");
                data.putInt("x", (int)touch.position.x);
                data.putInt("y", (int)touch.position.y);
                if (initialTouch != null) {
                    duration = touch.timestamp.getTime() - ControlInjectorAccessibility.initialTouch.timestamp.getTime();
                    data.putInt("duration", (int)duration);
                }
            }
        }
        if (!data.isEmpty()) {
            Intent intent = new Intent(REMOTE_CONTROL_INTENT);
            intent.setPackage(application.getPackageName());
            intent.putExtras(data);
            application.sendBroadcast(intent);
        }
        if (touch.isEnd()) {
            panRecognizer.reset();
            initialTouch = null;
            previousTouch = null;
        }
    }

    static void inject(@NonNull Application application, @NonNull KeyEvent key) {
        Intent intent = new Intent(REMOTE_CONTROL_INTENT);
        intent.setPackage(application.getPackageName());
        Bundle data = new Bundle();
        data.putString("action", "key");
        data.putString("state", key.state);
        data.putString("code", key.code);
        data.putString("key", key.key);
        intent.putExtras(data);
        application.sendBroadcast(intent);
    }

    static void notifySessionEnded(@NonNull Application application) {
        Intent intent = new Intent(SESSION_ENDED_INTENT);
        intent.setPackage(application.getPackageName());
        application.sendBroadcast(intent);
    }

    private void acceptMediaProjectionPermissionActivity(@Nullable AccessibilityNodeInfo root) {
        if (root == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 35) {
            this.acceptMediaProjectionPermissionActivityV34Partial(root);
            return;
        }
        if (this.acceptMediaProjectionPermissionActivityV21(root)) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 34) {
            if (this.isAwaitingMediaProjectionLayoutChange) {
                this.acceptMediaProjectionPermissionActivityV34Partial(root);
            } else if (!this.acceptMediaProjectionPermissionActivityV34Partial(root)) {
                this.acceptMediaProjectionPermissionActivityV34(root);
            }
        }
    }

    @RequiresApi(api=34)
    private boolean acceptMediaProjectionPermissionActivityV34Partial(@NonNull AccessibilityNodeInfo root) {
        AccessibilityNodeInfo spinner = this.findNode(root, node -> node.getClassName() != null && node.getClassName().equals("android.widget.Spinner"));
        AccessibilityNodeInfo spinnerSelection = this.findNode(root, node -> node.getParent() != null && node.getParent().getClassName() != null && node.getParent().getClassName().equals("android.widget.Spinner"));
        String titleEntireScreen = ControlInjectorAccessibility.findMediaProjectionOptionEntireScreen((Context)this.service);
        String titleSingleApp = ControlInjectorAccessibility.findMediaProjectionOptionSingleApp((Context)this.service);
        if (this.isAwaitingMediaProjectionLayoutChange && spinnerSelection == null) {
            AccessibilityNodeInfo entireScreenOption = this.findNode(root, node -> node.isClickable() && node.getChildCount() == 1 && node.getChild(0).getText() != null && node.getChild(0).getText().equals(titleEntireScreen));
            if (entireScreenOption == null) {
                Log.w((String)"CobrowseIO", (String)"Failed to activate the full device screen-casting automatically");
                this.isAwaitingMediaProjectionLayoutChange = false;
                return false;
            }
            this.isAwaitingMediaProjectionLayoutChange = true;
            entireScreenOption.performAction(16);
            return true;
        }
        if (spinner != null && spinnerSelection != null && spinnerSelection.getText() != null && spinnerSelection.getText().equals(titleSingleApp)) {
            this.isAwaitingMediaProjectionLayoutChange = true;
            spinner.performAction(16);
            return true;
        }
        if (spinner != null && spinnerSelection != null && spinnerSelection.getText() != null && spinnerSelection.getText().equals(titleEntireScreen)) {
            this.isAwaitingMediaProjectionLayoutChange = false;
            String startButtonName = ControlInjectorAccessibility.findMediaProjectionActionText((Context)this.service);
            AccessibilityNodeInfo startButton = this.findMediaProjectionStartButton(root, startButtonName);
            if (startButton == null) {
                return false;
            }
            startButton.performAction(16);
            return true;
        }
        if (spinner == null && spinnerSelection != null) {
            this.isAwaitingMediaProjectionLayoutChange = false;
            String startButtonName = ControlInjectorAccessibility.findMediaProjectionActionTextV21((Context)this.service);
            AccessibilityNodeInfo startButton = this.findMediaProjectionStartButton(root, startButtonName);
            if (startButton == null) {
                return false;
            }
            startButton.performAction(16);
            return true;
        }
        if (Build.VERSION.SDK_INT >= 35) {
            Log.w((String)"CobrowseIO", (String)"Unknown structure of the media projection prompt");
        }
        this.isAwaitingMediaProjectionLayoutChange = false;
        return false;
    }

    @RequiresApi(api=34)
    private boolean acceptMediaProjectionPermissionActivityV34(@NonNull AccessibilityNodeInfo root) {
        int startButtonRight;
        int startButtonLeft;
        int startButtonBottom;
        int startButtonTop;
        String endButtonName = ControlInjectorAccessibility.findMediaProjectionCancelText((Context)this.service);
        if (endButtonName == null) {
            return false;
        }
        AccessibilityNodeInfo endButton = this.findNode(root, node -> {
            if (!node.isClickable()) {
                return false;
            }
            CharSequence text = node.getText();
            return text != null && text.toString().equalsIgnoreCase(endButtonName);
        });
        if (endButton == null) {
            return false;
        }
        Rect endButtonRect = new Rect();
        endButton.getBoundsInScreen(endButtonRect);
        if (endButtonRect.left <= 0 || endButtonRect.top <= 0) {
            return false;
        }
        Rect rootRect = new Rect();
        root.getWindow().getBoundsInScreen(rootRect);
        if (rootRect.isEmpty()) {
            return false;
        }
        if (endButtonRect.left < (rootRect.right + rootRect.left) / 2) {
            startButtonTop = endButtonRect.top;
            startButtonBottom = endButtonRect.bottom;
            startButtonLeft = rootRect.right - (endButtonRect.left - rootRect.left) - (endButtonRect.right - endButtonRect.left);
            startButtonRight = startButtonLeft + (endButtonRect.right - endButtonRect.left);
        } else {
            startButtonTop = endButtonRect.top;
            startButtonBottom = endButtonRect.bottom;
            startButtonLeft = rootRect.left + (rootRect.right - endButtonRect.right);
            startButtonRight = startButtonLeft + (endButtonRect.right - endButtonRect.left);
        }
        int startButtonX = startButtonLeft + (startButtonRight - startButtonLeft) / 2;
        int startButtonY = startButtonTop + (startButtonBottom - startButtonTop) / 2;
        this.gestureV26(startButtonX, startButtonY, startButtonX, startButtonY, 1, 0);
        this.gestureV26(startButtonX, startButtonY, startButtonX, startButtonY, 1, 1);
        return true;
    }

    private boolean acceptMediaProjectionPermissionActivityV21(@NonNull AccessibilityNodeInfo root) {
        String startButtonName = ControlInjectorAccessibility.findMediaProjectionActionTextV21((Context)this.service);
        AccessibilityNodeInfo startButton = this.findMediaProjectionStartButton(root, startButtonName);
        if (startButton == null) {
            return false;
        }
        startButton.performAction(16);
        return true;
    }

    @Nullable
    private AccessibilityNodeInfo findMediaProjectionStartButton(@NonNull AccessibilityNodeInfo root, @Nullable String startButtonName) {
        return this.findNode(root, node -> {
            if (!node.isClickable()) {
                return false;
            }
            CharSequence text = node.getText();
            if (text != null && startButtonName != null) {
                return text.toString().equalsIgnoreCase(startButtonName);
            }
            return text != null && text.toString().toLowerCase().contains("start");
        });
    }

    @RequiresApi(api=34)
    @Nullable
    private static String findMediaProjectionActionText(@NonNull Context context) {
        return ControlInjectorAccessibility.findSystemString(context, "com.android.systemui", "media_projection_entry_app_permission_dialog_continue");
    }

    @RequiresApi(api=34)
    @Nullable
    private static String findMediaProjectionOptionSingleApp(@NonNull Context context) {
        return ControlInjectorAccessibility.findSystemString(context, "com.android.systemui", "screen_share_permission_dialog_option_single_app");
    }

    @RequiresApi(api=34)
    @Nullable
    private static String findMediaProjectionOptionEntireScreen(@NonNull Context context) {
        return ControlInjectorAccessibility.findSystemString(context, "com.android.systemui", "screen_share_permission_dialog_option_entire_screen");
    }

    @Nullable
    private static String findMediaProjectionActionTextV21(@NonNull Context context) {
        return ControlInjectorAccessibility.findSystemString(context, "com.android.systemui", "media_projection_action_text");
    }

    @SuppressLint(value={"DiscouragedApi"})
    @Nullable
    private static String findSystemString(@NonNull Context context, @NonNull String applicationId, @NonNull String resource) {
        PackageManager pm = context.getPackageManager();
        try {
            Resources resources = pm.getResourcesForApplication(applicationId);
            int id2 = resources.getIdentifier(resource, "string", applicationId);
            return resources.getString(id2);
        }
        catch (PackageManager.NameNotFoundException | Resources.NotFoundException e) {
            Log.w((String)"CobrowseIO", (String)("Cannot obtain " + resource + " value from " + applicationId + ": " + e.getMessage()));
            return null;
        }
    }

    @Nullable
    private static String findMediaProjectionCancelText(@NonNull Context context) {
        return context.getResources().getString(0x1040000);
    }

    public void onAccessibilityEvent(@NonNull AccessibilityEvent event) {
        AccessibilityNodeInfo source;
        Session session;
        boolean probablyMediaProjectionPrompt;
        if (!this.acceptMediaProjectionPrompt) {
            return;
        }
        CharSequence className = event.getClassName();
        CharSequence packageName = event.getPackageName();
        if (className == null || packageName == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 34) {
            probablyMediaProjectionPrompt = this.isAwaitingMediaProjectionLayoutChange ? packageName.equals("com.android.systemui") && className.equals("android.widget.FrameLayout") && event.getEventType() == 2048 : className.equals("com.android.systemui.mediaprojection.permission.MediaProjectionPermissionActivity") || className.equals("com.android.systemui.media.MediaProjectionPermissionActivity");
        } else if (Build.VERSION.SDK_INT == 22) {
            List texts = event.getText();
            probablyMediaProjectionPrompt = packageName.equals("com.android.systemui") && className.equals("android.app.AlertDialog") && texts != null && texts.size() == 4;
        } else {
            probablyMediaProjectionPrompt = className.equals("com.android.systemui.media.MediaProjectionPermissionActivity");
        }
        if (probablyMediaProjectionPrompt && (session = CobrowseIO.instance().currentSession()) != null && session.fullDevice().booleanValue() && (source = this.service.getRootInActiveWindow()) != null) {
            this.acceptMediaProjectionPermissionActivity(source);
            source.recycle();
        }
    }

    private static void logNode(@NonNull AccessibilityNodeInfo nodeInfo, int depth) {
        int i;
        Rect bounds = new Rect();
        nodeInfo.getBoundsInScreen(bounds);
        StringBuilder sb = new StringBuilder();
        if (depth > 0) {
            for (i = 0; i < depth; ++i) {
                sb.append("  ");
            }
            sb.append("\u2514 ");
        }
        sb.append(nodeInfo.getClassName());
        if (nodeInfo.getText() != null) {
            sb.append(nodeInfo.getText());
        }
        Log.v((String)"", (String)(sb + " - " + nodeInfo));
        for (i = 0; i < nodeInfo.getChildCount(); ++i) {
            AccessibilityNodeInfo childNode = nodeInfo.getChild(i);
            if (childNode == null) continue;
            ControlInjectorAccessibility.logNode(childNode, depth + 1);
        }
    }

    public void onReceive(@NonNull Context context, @NonNull Intent intent) {
        try {
            String packageName = context.getPackageName();
            if (packageName == null || !context.getPackageName().equals(intent.getPackage())) {
                return;
            }
            if (intent.getAction() == null) {
                return;
            }
            switch (intent.getAction()) {
                case "io.cobrowse.SESSION_ENDED": {
                    this.onSessionEndedIntentReceived();
                    break;
                }
                case "io.cobrowse.REMOTE_CONTROL": {
                    this.onRemoteControlIntentReceived(intent);
                }
            }
        }
        catch (Throwable e) {
            Log.i((String)"CobrowseIO", (String)("Error in CobrowseInjectorAccessibility.onReceive(): " + e));
        }
    }

    private void onSessionEndedIntentReceived() {
        this.passwords.clear();
    }

    private void onRemoteControlIntentReceived(@NonNull Intent intent) {
        Bundle extras = intent.getExtras();
        if (extras != null) {
            String action = extras.getString("action");
            if (action == null) {
                return;
            }
            switch (action) {
                case "click": {
                    this.click(extras.getInt("x"), extras.getInt("y"), extras.getInt("duration"));
                    break;
                }
                case "scroll": {
                    this.scroll(extras.getInt("x"), extras.getInt("y"), PanGestureRecognizer.Direction.valueOf(extras.getString("direction")));
                    break;
                }
                case "gestureV26": {
                    if (Build.VERSION.SDK_INT < 26) break;
                    this.gestureV26(extras.getInt("start_x"), extras.getInt("start_y"), extras.getInt("end_x"), extras.getInt("end_y"), extras.getInt("duration"), extras.getInt("touch_action"));
                    break;
                }
                case "gestureV24": {
                    if (Build.VERSION.SDK_INT < 24) break;
                    this.gestureV24(extras.getInt("start_x"), extras.getInt("start_y"), extras.getInt("end_x"), extras.getInt("end_y"), extras.getInt("duration"));
                    break;
                }
                case "key": {
                    this.key(extras.getString("state"), extras.getString("key"), extras.getString("code"));
                }
            }
        }
    }

    private static final class TypedPasswordsStorage {
        private final Map<String, String> previouslyTypedValues = new HashMap<String, String>();

        private TypedPasswordsStorage() {
        }

        @NonNull
        public CharSequence guessNewValue(@NonNull AccessibilityNodeInfo node, @NonNull String code, @NonNull String key) {
            String rvalue;
            String id2 = TypedPasswordsStorage.getId(node);
            String previous = this.previouslyTypedValues.get(id2);
            if (previous == null) {
                previous = "";
            }
            CharSequence actual = ControlInjectorAccessibility.getTextFromNode(node);
            if (code.equals("Backspace")) {
                rvalue = previous.length() != actual.length() ? "" : (previous.length() > 1 ? previous.substring(0, previous.length() - 1) : "");
            } else {
                if (key.length() != 1) {
                    return previous;
                }
                rvalue = previous.length() != actual.length() ? key : previous + key;
            }
            this.previouslyTypedValues.put(id2, rvalue);
            return rvalue;
        }

        public void clear() {
            this.previouslyTypedValues.clear();
        }

        @NonNull
        private static String getId(@NonNull AccessibilityNodeInfo node) {
            String id2 = null;
            if (Build.VERSION.SDK_INT >= 33) {
                id2 = node.getUniqueId();
            }
            if (id2 == null || id2.equals("")) {
                id2 = node.getViewIdResourceName();
            }
            if (id2 == null || id2.equals("")) {
                id2 = String.valueOf(node.hashCode());
            }
            return id2;
        }
    }
}

