/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.app.Application;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationManagerCompat;
import io.cobrowse.CBORSocket;
import io.cobrowse.Callback;
import io.cobrowse.CobrowseAccessibilityService;
import io.cobrowse.CobrowseIO;
import io.cobrowse.CobrowseService;
import io.cobrowse.RESTResource;
import io.cobrowse.SecureStorage;
import io.cobrowse.SocketURL;
import io.cobrowse.ThreadUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import okhttp3.HttpUrl;

final class Device
extends RESTResource<Device> {
    @NonNull
    private final Set<Listener> listeners = new HashSet<Listener>();
    @Nullable
    private static String deviceId;
    @Nullable
    private static Map<String, Object> customData;
    @Nullable
    private static String token;
    @NonNull
    private static final String DeviceIdPrefsKey = "cobrowse_io_device_id";
    @NonNull
    private final Application app;
    @Nullable
    private CBORSocket notificationSocket;

    Device(@NonNull Application app) {
        this.app = app;
    }

    public void registerDeviceListener(@NonNull Listener listener) {
        this.listeners.add(listener);
    }

    @Nullable
    static String getToken() {
        return token;
    }

    static void setToken(@NonNull String tkn) {
        token = tkn;
    }

    static void customData(@NonNull Map<String, Object> customData) {
        Device.customData = customData;
    }

    @Nullable
    static Map<String, Object> customData() {
        return customData;
    }

    @NonNull
    static synchronized String deviceId(@NonNull Application app) {
        if (deviceId != null) {
            return deviceId;
        }
        deviceId = SecureStorage.instance().getValue(app, DeviceIdPrefsKey);
        if (deviceId == null) {
            deviceId = UUID.randomUUID().toString();
            boolean success = SecureStorage.instance().setValue(app, DeviceIdPrefsKey, deviceId);
            if (!success) {
                Log.e((String)"CobrowseIO", (String)"Failed to persist Cobrowse device ID");
            }
        }
        return deviceId;
    }

    @NonNull
    private String deviceId() {
        return Device.deviceId(this.app);
    }

    @Nullable
    private String notificationUrl() {
        return this.field("notification_url", String.class);
    }

    @Nullable
    private String notificationToken() {
        return this.field("notification_token", String.class);
    }

    int registrationInterval() {
        return this.field("next_registration", Integer.class, 3600);
    }

    String bannerMessage() {
        return this.field("banner_message", String.class);
    }

    @Override
    @NonNull
    HttpUrl url() {
        HttpUrl rvalue = CobrowseIO.instance().apiUrl().resolve("/api/1/devices/" + this.deviceId());
        if (rvalue == null) {
            throw new RuntimeException("Cannot create an HTTP Url, is API a valid HTTP(S) scheme?");
        }
        return rvalue;
    }

    private synchronized void updateNotificationSocket() {
        if (this.notificationToken() != null && this.notificationUrl() != null) {
            this.openNotificationSocket();
        } else {
            this.closeNotificationSocket();
        }
    }

    private synchronized void openNotificationSocket() {
        if (this.notificationSocket != null) {
            return;
        }
        this.notificationSocket = new CBORSocket(() -> CobrowseIO.request(this.app).url(SocketURL.resolve(this.notificationUrl(), CobrowseIO.instance().apiUrl())).header("Authorization", "Bearer " + this.notificationToken()).build());
        this.notificationSocket.setMaxReconnectDelay(60000L);
        this.notificationSocket.onMessage("notification", message -> {
            HashMap<String, String> notification = new HashMap<String, String>();
            for (String key : message.keySet()) {
                Object value = message.get(key);
                if (value == null) continue;
                notification.put(key, value.toString());
            }
            CobrowseIO.instance().onPushNotification(notification, false);
        });
        this.notificationSocket.onMessage("probe", message -> {
            try {
                this.notificationSocket.send("alive", message);
            }
            catch (IOException e) {
                Log.w((String)"CobrowseIO", (String)"Failed to send alive message");
            }
        });
        this.notificationSocket.onError((err, res) -> {
            Log.e((String)"CobrowseIO", (String)("Notification socket error " + err));
            if (res != null) {
                Log.e((String)"CobrowseIO", (String)("Response code = " + res.code()));
            }
            if (res != null && res.code() >= 400 && res.code() < 500) {
                this.closeNotificationSocket();
            }
        });
    }

    private void closeNotificationSocket() {
        if (this.notificationSocket != null) {
            this.notificationSocket.disconnect();
            this.notificationSocket = null;
        }
    }

    @Override
    void reset() {
        super.reset();
        this.closeNotificationSocket();
    }

    void register(@Nullable Callback<Error, Device> callback) {
        Map<String, Object> data;
        Device self = this;
        HashMap<String, Object> patch = new HashMap<String, Object>();
        if (token != null) {
            patch.put("push_provider", "FCM");
            patch.put("push_token", token);
        }
        if ((data = Device.customData()) != null) {
            patch.put("custom_data", data);
        }
        patch.put("device", Device.info(this.app));
        this.update(patch, (err, arg) -> {
            if (err == null) {
                self.updateNotificationSocket();
            }
            ThreadUtils.invoke(callback, err, arg);
            for (Listener listener : this.listeners) {
                listener.deviceDidRegister(self);
            }
        });
    }

    synchronized void deregister(@Nullable Callback<Error, Device> callback) {
        customData = null;
        this.closeNotificationSocket();
        this.delete(callback);
    }

    @NonNull
    static Map<String, Object> info(@NonNull Application app) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        String version = "";
        String build = "";
        try {
            PackageInfo pInfo = app.getPackageManager().getPackageInfo(app.getPackageName(), 0);
            version = pInfo.versionName;
            build = String.valueOf(pInfo.versionCode);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)"CobrowseIO", (String)"Failed to obtain the host app package information", (Throwable)e);
        }
        info.put("platform", "android");
        info.put("device", Build.DEVICE);
        info.put("device_locale", Locale.getDefault().getLanguage());
        info.put("os_version", System.getProperty("os.version"));
        info.put("os_api_level", String.valueOf(Build.VERSION.SDK_INT));
        info.put("app_id", app.getPackageName());
        info.put("app_name", app.getApplicationContext().getApplicationInfo().loadLabel(app.getPackageManager()).toString());
        info.put("app_installation_id", Device.deviceId(app));
        info.put("app_version", version);
        info.put("app_build", build);
        info.put("app_build_configuration", "release");
        info.put("sdk_version", CobrowseIO.version());
        info.put("push_enabled", NotificationManagerCompat.from((Context)app).areNotificationsEnabled());
        info.put("video_codecs", new String[]{"video/avc", "image/jpeg"});
        info.put("capabilities", Device.availableCapabilities());
        if (Build.VERSION.SDK_INT >= 21 && Device.isFullDeviceControlAvailable(app)) {
            info.put("full_device_control", CobrowseAccessibilityService.isRunning((Context)app));
        }
        return info;
    }

    private static boolean isFullDeviceControlAvailable(@NonNull Application app) {
        if (Build.VERSION.SDK_INT >= 21) {
            return CobrowseAccessibilityService.isEnabled((Context)app);
        }
        return false;
    }

    @NonNull
    static String[] availableCapabilities() {
        HashSet<String> capabilities = new HashSet<String>(Arrays.asList("laser", "drawing", "pointer", "keypress", "selectors"));
        if (Build.VERSION.SDK_INT >= 21 && CobrowseService.isMediaProjectionEnabled()) {
            capabilities.add("full_device");
        }
        return capabilities.toArray(new String[0]);
    }

    static {
        customData = null;
        token = null;
    }

    static interface Listener {
        public void deviceDidRegister(@NonNull Device var1);
    }
}

