/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PersistableBundle;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import io.cobrowse.Callback;
import io.cobrowse.CobrowseIO;
import io.cobrowse.Device;
import io.cobrowse.R;
import io.cobrowse.ThreadUtils;
import java.util.Timer;
import java.util.TimerTask;

public class DeviceRegistrationLoop {
    static void init(@NonNull Context context) {
        if (DeviceRegistrationLoop.supportsJobService()) {
            CobrowseRegistrationJob.ensureServiceIsStarted(context);
        }
    }

    private static void register(@NonNull Context context, int attempt, @NonNull Callback<Error, Device> callback) {
        Device device = CobrowseIO.instance().getDevice();
        if (device == null) {
            ThreadUtils.invoke(callback, new Error("Background job device was null"), null);
            return;
        }
        Log.i((String)"CobrowseIO", (String)"CobrowseIO registering device");
        device.register((err, device1) -> {
            if (err != null || device1 == null) {
                Log.w((String)"CobrowseIO", (String)("CobrowseIO device registration failed " + err));
                long nextUpdateIn = Math.round(60.0 * Math.pow(1.5, attempt));
                if (nextUpdateIn < 60L) {
                    nextUpdateIn = 60L;
                }
                DeviceRegistrationLoop.schedule(context, nextUpdateIn * 1000L, attempt + 1);
            } else {
                int interval = device1.registrationInterval();
                DeviceRegistrationLoop.schedule(context, (long)interval * 1000L, 0);
            }
            ThreadUtils.invoke(callback, err, device1);
        });
    }

    private static boolean supportsJobService() {
        return Build.VERSION.SDK_INT >= 21;
    }

    static void stop(@NonNull Context context) {
        if (DeviceRegistrationLoop.supportsJobService()) {
            CobrowseRegistrationJob.stop(context);
        } else {
            CobrowseRegistrationTimer.stop();
        }
    }

    static void schedule(@NonNull Context context, long delay, int attempt) {
        Log.i((String)"CobrowseIO", (String)("CobrowseIO scheduling next registration attempt (" + attempt + ") in " + delay));
        if (DeviceRegistrationLoop.supportsJobService()) {
            CobrowseRegistrationJob.schedule(context, delay, attempt);
        } else {
            CobrowseRegistrationTimer.schedule(context, delay, attempt);
        }
    }

    @RequiresApi(api=21)
    public static class CobrowseRegistrationJob
    extends JobService {
        private int getRegistrationJobId() {
            return CobrowseRegistrationJob.getRegistrationJobId((Context)this);
        }

        private static int getRegistrationJobId(@NonNull Context context) {
            return context.getResources().getInteger(R.integer.cobrowse_job_id);
        }

        private static void ensureServiceIsStarted(@NonNull Context context) {
            try {
                context.startService(new Intent(context, CobrowseRegistrationJob.class));
            }
            catch (IllegalStateException e) {
                Log.w((String)"CobrowseIO", (String)("Error creating service: " + e));
            }
        }

        public boolean onStartJob(@NonNull JobParameters params) {
            if (params.getJobId() != this.getRegistrationJobId()) {
                return false;
            }
            int attempt = params.getExtras().getInt("attempt", 0);
            DeviceRegistrationLoop.register((Context)this.getApplication(), attempt, (err, arg) -> this.jobFinished(params, false));
            return false;
        }

        public boolean onStopJob(JobParameters params) {
            if (params.getJobId() != this.getRegistrationJobId()) {
                return false;
            }
            int attempt = params.getExtras().getInt("attempt", 0);
            CobrowseRegistrationJob.schedule((Context)this.getApplication(), 60000L, attempt);
            return false;
        }

        static void schedule(@NonNull Context context, long delay, int attempt) {
            JobInfo.Builder builder = new JobInfo.Builder(CobrowseRegistrationJob.getRegistrationJobId(context), new ComponentName(context, CobrowseRegistrationJob.class));
            builder.setMinimumLatency(delay);
            builder.setOverrideDeadline(delay);
            builder.setRequiredNetworkType(1);
            PersistableBundle bundle = new PersistableBundle();
            bundle.putInt("attempt", attempt);
            builder.setExtras(bundle);
            JobScheduler tm = (JobScheduler)context.getSystemService("jobscheduler");
            if (tm != null && tm.schedule(builder.build()) != 1) {
                Log.e((String)"CobrowseIO", (String)"Scheduling registration job failed");
            }
        }

        static void stop(@NonNull Context context) {
            JobScheduler tm = (JobScheduler)context.getSystemService("jobscheduler");
            if (tm != null) {
                tm.cancel(CobrowseRegistrationJob.getRegistrationJobId(context));
            }
        }
    }

    static class CobrowseRegistrationTimer {
        @Nullable
        private static Timer next;

        CobrowseRegistrationTimer() {
        }

        static void schedule(final @NonNull Context context, long delay, final int attempt) {
            CobrowseRegistrationTimer.stop();
            next = new Timer();
            next.schedule(new TimerTask(){

                @Override
                public void run() {
                    next = null;
                    DeviceRegistrationLoop.register(context, attempt, (err, arg) -> {});
                }
            }, delay);
        }

        static void stop() {
            if (next != null) {
                next.cancel();
                next = null;
            }
        }
    }
}

