/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.PointF;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.cobrowse.AgentEvent;
import io.cobrowse.SerializationError;
import io.cobrowse.TypeUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

final class Drawing
extends AgentEvent {
    @Nullable
    byte[] imageData;
    @Nullable
    Bitmap image;
    @Nullable
    PointF position;
    float height;
    float width;

    Drawing(@NonNull Map<String, Object> obj) throws SerializationError {
        super(obj);
        if (obj.containsKey("image")) {
            this.imageData = TypeUtils.check(obj.get("image"), byte[].class);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(this.imageData);
            this.image = BitmapFactory.decodeStream((InputStream)inputStream);
        }
        Double x = TypeUtils.check(obj.get("x"), Double.class);
        Double y = TypeUtils.check(obj.get("y"), Double.class);
        if (x != null && y != null) {
            this.position = new PointF(x.floatValue(), y.floatValue());
        }
        this.height = TypeUtils.check(obj.get("height"), 0.0f);
        this.width = TypeUtils.check(obj.get("width"), 0.0f);
    }

    public boolean isEmpty() {
        return this.image == null || this.position == null;
    }
}

