/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.os.Handler;
import androidx.annotation.NonNull;
import io.cobrowse.Frame;

abstract class Encoder {
    protected Delegate delegate;
    protected Handler handler;

    Encoder(Delegate delegate) {
        this.delegate = delegate;
    }

    Encoder(Delegate delegate, Handler handler) {
        this.delegate = delegate;
        this.handler = handler;
    }

    @NonNull
    abstract String mimeType();

    abstract void encode(@NonNull Frame var1);

    abstract int maximumFramesInFlight();

    abstract void reset();

    void destroy() {
        this.delegate = null;
    }

    protected void raiseEncodedFrameData(@NonNull byte[] data) {
        Delegate callback = this.delegate;
        if (callback == null) {
            return;
        }
        if (this.handler == null) {
            callback.onEncodedFrameData(this, data);
            return;
        }
        this.handler.post(() -> callback.onEncodedFrameData(this, data));
    }

    protected void raiseEncoderError(@NonNull Error e) {
        Delegate callback = this.delegate;
        if (callback == null) {
            return;
        }
        if (this.handler == null) {
            callback.onEncoderError(this, e);
            return;
        }
        this.handler.post(() -> callback.onEncoderError(this, e));
    }

    static interface Delegate {
        public void onEncodedFrameData(Encoder var1, byte[] var2);

        public void onEncoderError(Encoder var1, Error var2);
    }
}

