/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.graphics.Bitmap;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

class Frame {
    @NonNull
    private final Bitmap bitmap;
    private boolean isDirty;
    private float scale;

    Frame(@NonNull Bitmap bitmap) {
        this(bitmap, true);
    }

    private Frame(@NonNull Bitmap bitmap, boolean isDirty) {
        this(bitmap, isDirty, 1.0f);
    }

    private Frame(@NonNull Bitmap bitmap, boolean isDirty, float scale) {
        this.bitmap = bitmap;
        this.isDirty = isDirty;
        this.scale = scale;
    }

    boolean sameSizeAs(@Nullable Frame other) {
        if (other == null) {
            return false;
        }
        return other.bitmap.getWidth() == this.bitmap.getWidth() && other.bitmap.getHeight() == this.bitmap.getHeight() && other.scale == this.scale;
    }

    @NonNull
    Bitmap getBitmap() {
        return this.bitmap;
    }

    float getScale() {
        return this.scale;
    }

    void setScale(float value) {
        this.scale = value;
    }

    boolean isDirty() {
        return this.isDirty;
    }

    void setDirty(boolean value) {
        this.isDirty = value;
    }
}

