/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.os.Handler;
import android.os.Looper;
import android.view.Display;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.cobrowse.Frame;

final class FrameLoop {
    private final Delegate delegate;
    @Nullable
    private Source source;
    @NonNull
    private final Display display;
    @Nullable
    private Frame previousFrame;
    @NonNull
    private final Handler handler = new Handler(Looper.getMainLooper());
    @Nullable
    private Runnable frameRunner;

    FrameLoop(@NonNull Display display, @NonNull Delegate delegate) {
        this.display = display;
        this.delegate = delegate;
    }

    synchronized void start(Source source) {
        if (this.frameRunner == null) {
            this.source = source;
            source.capturingWillStart(this.display);
            this.frameRunner = this::loop;
            this.loop();
        }
    }

    boolean isRunning() {
        return this.frameRunner != null;
    }

    void setFrameSource(@NonNull Source source) {
        if (this.source == source) {
            return;
        }
        if (this.isRunning()) {
            if (this.source != null) {
                this.source.capturingWillStop(this.display);
            }
            this.source = source;
            source.capturingWillStart(this.display);
        } else {
            this.source = source;
        }
    }

    private synchronized void loop() {
        if (!this.isRunning()) {
            return;
        }
        this.handler.postDelayed(this.frameRunner, 100L);
        Frame frame = this.generateFrame(this.previousFrame);
        if (frame == null) {
            this.handler.removeCallbacks(this.frameRunner);
            this.handler.postDelayed(this.frameRunner, 15L);
            return;
        }
        this.previousFrame = frame;
        this.delegate.handleFrame(this.display, frame);
    }

    synchronized void stop() {
        if (this.frameRunner != null) {
            this.handler.removeCallbacks(this.frameRunner);
            this.frameRunner = null;
        }
        if (this.source != null) {
            this.source.capturingWillStop(this.display);
            this.source = null;
        }
        this.previousFrame = null;
    }

    @Nullable
    private Frame generateFrame(Frame previousFrame) {
        if (this.source == null) {
            return null;
        }
        if (previousFrame != null && !this.source.isNewFrameAvailable(this.display)) {
            return previousFrame;
        }
        if (this.delegate.willCaptureFrame(this.display)) {
            Frame f = this.source.newFrame(this.display);
            this.delegate.didCaptureFrame(this.display, f);
            return f;
        }
        return null;
    }

    static interface Delegate
    extends Listener {
        public void handleFrame(@NonNull Display var1, @NonNull Frame var2);
    }

    static interface Source {
        public void capturingWillStart(@NonNull Display var1);

        public void capturingWillStop(@NonNull Display var1);

        @Nullable
        public Frame newFrame(@NonNull Display var1);

        public boolean isNewFrameAvailable(@NonNull Display var1);
    }

    static interface Listener {
        public boolean willCaptureFrame(@NonNull Display var1);

        public void didCaptureFrame(@NonNull Display var1, @Nullable Frame var2);
    }
}

