/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.app.Activity;
import android.app.Application;
import android.hardware.display.DisplayManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.util.SparseArray;
import android.view.Display;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.cobrowse.ActivityWatcher;
import io.cobrowse.Callback;
import io.cobrowse.CobrowseIO;
import io.cobrowse.Frame;
import io.cobrowse.FrameLoop;
import io.cobrowse.FullDeviceFrameSource;
import io.cobrowse.Session;
import io.cobrowse.SessionContextModule;
import io.cobrowse.StreamProtocol;
import io.cobrowse.ViewRenderingFrameSource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

final class FrameLoopManager
extends SessionContextModule
implements Session.Listener,
DisplayManager.DisplayListener,
FrameLoop.Delegate,
FullDeviceFrameSource.Delegate,
ActivityWatcher.Observer {
    @NonNull
    private final StreamProtocol stream;
    private final HashSet<FrameLoop.Listener> frameListeners = new HashSet();
    @NonNull
    private final SparseArray<FrameLoop> loops = new SparseArray();
    @NonNull
    private final ViewRenderingFrameSource viewRenderSource;
    @Nullable
    private FullDeviceFrameSource systemCaptureSource;
    private FullDeviceFrameSource.PermissionRequest waitingToShow;

    FrameLoopManager(@NonNull Application app, @NonNull StreamProtocol stream) {
        super(app, stream.session);
        this.stream = stream;
        this.session.registerSessionListener(this);
        this.getDisplayManager().registerDisplayListener((DisplayManager.DisplayListener)this, new Handler(Looper.getMainLooper()));
        ActivityWatcher.registerActivityObserver(this);
        this.viewRenderSource = new ViewRenderingFrameSource();
        if (Build.VERSION.SDK_INT >= 21) {
            this.systemCaptureSource = new FullDeviceFrameSource(app, this);
        }
    }

    @Override
    void destroy() {
        this.session.removeSessionListener(this);
        this.getDisplayManager().unregisterDisplayListener((DisplayManager.DisplayListener)this);
        ActivityWatcher.removeActivityObserver(this);
        for (FrameLoop loop : this.allLoops()) {
            loop.stop();
        }
        this.loops.clear();
        this.frameListeners.clear();
        if (this.waitingToShow != null) {
            this.waitingToShow.cancel();
            this.waitingToShow = null;
        }
    }

    void registerFrameListener(@NonNull FrameLoop.Listener listener) {
        this.frameListeners.add(listener);
    }

    void removeFrameListener(@NonNull FrameLoop.Listener listener) {
        this.frameListeners.remove(listener);
    }

    @Override
    public boolean willCaptureFrame(@NonNull Display display) {
        for (FrameLoop.Listener l : this.frameListeners) {
            if (l.willCaptureFrame(display)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void didCaptureFrame(@NonNull Display display, @Nullable Frame screenshot) {
        for (FrameLoop.Listener l : this.frameListeners) {
            l.didCaptureFrame(display, screenshot);
        }
    }

    @NonNull
    private FrameLoop[] allLoops() {
        FrameLoop[] all = new FrameLoop[this.loops.size()];
        for (int i = 0; i < this.loops.size(); ++i) {
            int key = this.loops.keyAt(i);
            all[i] = (FrameLoop)this.loops.get(key);
        }
        return all;
    }

    private FrameLoop.Source currentSource() {
        if (this.session.fullDeviceState() == Session.FullDeviceState.On && this.systemCaptureSource != null) {
            return this.systemCaptureSource;
        }
        return this.viewRenderSource;
    }

    private void startLoop(@NonNull Display display) {
        if (display.getName().contains("cobrowse")) {
            return;
        }
        if (this.loops.get(display.getDisplayId()) == null) {
            FrameLoop loop = new FrameLoop(display, this);
            loop.start(this.currentSource());
            this.loops.put(display.getDisplayId(), (Object)loop);
        }
    }

    @Override
    public void sessionDidUpdate(@NonNull Session session) {
        if (session.isActive()) {
            for (FrameLoop frameLoop : this.allLoops()) {
                frameLoop.setFrameSource(this.currentSource());
            }
            for (FrameLoop frameLoop : this.getDisplayManager().getDisplays()) {
                this.startLoop((Display)frameLoop);
            }
        }
    }

    @Override
    public void sessionDidEnd(@NonNull Session session) {
        this.destroy();
    }

    public void onDisplayAdded(int displayId) {
        Display display = this.getDisplayManager().getDisplay(displayId);
        if (this.session.isActive() && display != null) {
            this.startLoop(display);
        }
    }

    public void onDisplayRemoved(int displayId) {
        if (this.loops.get(displayId) != null) {
            ((FrameLoop)this.loops.get(displayId)).stop();
            this.loops.remove(displayId);
        }
    }

    public void onDisplayChanged(int displayId) {
        Display display = this.getDisplayManager().getDisplay(displayId);
        if (display != null && this.systemCaptureSource != null) {
            this.systemCaptureSource.restart(display);
        }
    }

    @Override
    public void handleFrame(@NonNull Display display, @NonNull Frame frame) {
        this.stream.sendFrame(display, frame);
    }

    @Override
    public void requestFullDevicePermission(FullDeviceFrameSource.PermissionRequest request) {
        Activity activity = this.getActivity();
        if (activity != null && !activity.isFinishing()) {
            request.show(activity);
        } else if (CobrowseIO.instance().launchPermissionActivity()) {
            Log.i((String)"CobrowseIO", (String)"No activity for full device prompt, launching cobrowse permission activity.");
            this.waitingToShow = request;
        } else if (CobrowseIO.instance().launchApp()) {
            Log.i((String)"CobrowseIO", (String)"No activity for full device prompt, launching app.");
            this.waitingToShow = request;
        } else {
            Log.i((String)"CobrowseIO", (String)"Could not launch app, cancelling full device request.");
            request.cancel();
        }
    }

    @Override
    public void fullDeviceCaptureStarted() {
        this.session.setFullDeviceState(Session.FullDeviceState.On, null);
    }

    @Override
    public void fullDeviceCaptureRejected() {
        this.session.setFullDeviceState(Session.FullDeviceState.Rejected, null);
    }

    @Override
    public void fullDeviceCaptureStopped() {
        this.session.setFullDeviceState(Session.FullDeviceState.Off, null);
        this.session.toggleCapabilitiesForFullDeviceState(true);
        this.session.update((Map<String, Object>)new HashMap<String, Object>(), (Callback<Error, Session>)null);
    }

    @Override
    public void activityChanged(@Nullable Activity to, @Nullable Activity from) {
        if (this.waitingToShow != null && to != null) {
            this.waitingToShow.show(to);
            this.waitingToShow = null;
        }
    }
}

