/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.Fragment;
import android.app.FragmentTransaction;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.hardware.display.VirtualDisplay;
import android.media.Image;
import android.media.ImageReader;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.cobrowse.BitmapUtils;
import io.cobrowse.Callback;
import io.cobrowse.CobrowseService;
import io.cobrowse.CodedError;
import io.cobrowse.DisplayScaling;
import io.cobrowse.Frame;
import io.cobrowse.FrameLoop;
import io.cobrowse.ThreadUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;

@TargetApi(value=21)
final class FullDeviceFrameSource
implements FrameLoop.Source,
ImageReader.OnImageAvailableListener {
    private final Application application;
    private final Delegate delegate;
    @Nullable
    private MediaProjection projection;
    @NonNull
    private final MediaProjection.Callback projectionCallback;
    @Nullable
    private VirtualDisplay virtualDisplay;
    @Nullable
    private Intent permissionToken;
    @Nullable
    private ImageReader reader;
    @Nullable
    private Bitmap writableOriginalBitmap;
    @Nullable
    private Bitmap writableBitmap;
    @Nullable
    private Bitmap previousBitmap;
    private boolean isDirty = false;
    @Nullable
    private Frame mostRecent;
    private boolean isFirstFrameReturned;
    @Nullable
    private static PermissionRequest currentRequest;

    FullDeviceFrameSource(@NonNull Application app, final @NonNull Delegate delegate) {
        this.application = app;
        this.delegate = delegate;
        this.projectionCallback = new MediaProjection.Callback(){

            public void onStop() {
                super.onStop();
                delegate.fullDeviceCaptureStopped();
            }
        };
    }

    public void onImageAvailable(ImageReader reader) {
        this.isDirty = true;
    }

    @Override
    public boolean isNewFrameAvailable(@NonNull Display display) {
        if (!this.isPrimaryDisplay(display)) {
            return false;
        }
        return this.isDirty;
    }

    @SuppressLint(value={"WrongConstant"})
    private boolean startProjection(@NonNull Display display, @NonNull Intent token) {
        MediaProjectionManager manager = (MediaProjectionManager)this.application.getSystemService("media_projection");
        if (manager == null) {
            Log.e((String)"CobrowseIO", (String)"Media projection service not available");
            return false;
        }
        try {
            this.projection = manager.getMediaProjection(-1, token);
            this.projection.registerCallback(this.projectionCallback, new Handler(Looper.myLooper()));
        }
        catch (Exception e) {
            Log.e((String)"CobrowseIO", (String)("Media projection failed to start: " + e.getMessage()));
            return false;
        }
        if (this.projection == null) {
            Log.e((String)"CobrowseIO", (String)"Media projection was null");
            return false;
        }
        DisplayMetrics metrics = DisplayScaling.getMetrics(display);
        int width = metrics.widthPixels;
        int height = metrics.heightPixels;
        this.reader = ImageReader.newInstance((int)width, (int)height, (int)1, (int)2);
        this.reader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)this, null);
        this.virtualDisplay = this.projection.createVirtualDisplay("cobrowse-virtual-display", width, height, 120, 0, this.reader.getSurface(), null, null);
        return true;
    }

    private void stopProjection() {
        this.mostRecent = null;
        this.isFirstFrameReturned = false;
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        if (this.virtualDisplay != null) {
            this.virtualDisplay.release();
            this.virtualDisplay = null;
        }
        if (this.projection != null) {
            this.projection.unregisterCallback(this.projectionCallback);
            this.projection.stop();
            this.projection = null;
        }
    }

    protected void restart(Display display) {
        if (!this.isPrimaryDisplay(display)) {
            return;
        }
        if (this.permissionToken != null) {
            this.stopProjection();
            this.startProjection(display, this.permissionToken);
        }
    }

    private boolean isPrimaryDisplay(Display display) {
        WindowManager wm = (WindowManager)this.application.getSystemService("window");
        if (wm == null) {
            return false;
        }
        Display defaultDisplay = wm.getDefaultDisplay();
        if (defaultDisplay == null) {
            return false;
        }
        return display.getDisplayId() == defaultDisplay.getDisplayId();
    }

    @Override
    public void capturingWillStart(@NonNull Display display) {
        if (!this.isPrimaryDisplay(display)) {
            return;
        }
        this.stopProjection();
        if (this.permissionToken != null) {
            if (!this.startProjection(display, this.permissionToken)) {
                this.delegate.fullDeviceCaptureStopped();
            } else {
                this.delegate.fullDeviceCaptureStarted();
            }
            return;
        }
        if (currentRequest != null) {
            Log.w((String)"CobrowseIO", (String)"Full device request already in progress");
            return;
        }
        currentRequest = new PermissionRequest().callback((err, data) -> {
            Log.i((String)"CobrowseIO", (String)("Full device screen request completed " + err));
            currentRequest = null;
            if (err != null || data == null) {
                this.delegate.fullDeviceCaptureRejected();
                return;
            }
            if (!CobrowseService.isMediaProjectionEnabled()) {
                Log.e((String)"CobrowseIO", (String)"CobrowseService is not enabled. It must be enabled in order for the full-device screensharing to work.");
                this.delegate.fullDeviceCaptureRejected();
                return;
            }
            if (CobrowseService.needMediaProjectionPermissionBeforeStart()) {
                CobrowseService.setForeground((serviceError, isServiceStarted) -> {
                    if (Boolean.TRUE.equals(isServiceStarted) && this.startProjection(display, (Intent)data)) {
                        this.delegate.fullDeviceCaptureStarted();
                    } else {
                        this.delegate.fullDeviceCaptureStopped();
                    }
                });
            } else {
                if (Build.VERSION.SDK_INT < 34) {
                    this.permissionToken = data;
                }
                if (this.startProjection(display, (Intent)data)) {
                    this.delegate.fullDeviceCaptureStarted();
                } else {
                    this.delegate.fullDeviceCaptureStopped();
                }
            }
        });
        Log.i((String)"CobrowseIO", (String)"Requesting full device screen access");
        this.delegate.requestFullDevicePermission(currentRequest);
    }

    @Override
    public void capturingWillStop(@NonNull Display display) {
        if (!this.isPrimaryDisplay(display)) {
            return;
        }
        this.stopProjection();
        if (CobrowseService.needMediaProjectionPermissionBeforeStart()) {
            CobrowseService.setBackground();
        }
        this.delegate.fullDeviceCaptureStopped();
        this.previousBitmap = null;
        this.writableBitmap = null;
        this.writableOriginalBitmap = null;
    }

    @Override
    @Nullable
    public Frame newFrame(@NonNull Display display) {
        if (!this.isPrimaryDisplay(display)) {
            return null;
        }
        if (this.reader == null) {
            return null;
        }
        boolean isFirstFrame = this.mostRecent == null;
        Image image = this.reader.acquireLatestImage();
        if (image != null) {
            this.updateMostRecentFrame(image);
            image.close();
        } else if (this.mostRecent != null && this.mostRecent.isDirty()) {
            this.mostRecent.setDirty(false);
        }
        if (isFirstFrame) {
            return null;
        }
        if (!this.isFirstFrameReturned && this.mostRecent != null) {
            this.mostRecent.setDirty(true);
            this.isFirstFrameReturned = true;
        }
        this.isDirty = false;
        return this.mostRecent;
    }

    private void updateMostRecentFrame(@NonNull Image image) {
        Rect r = image.getCropRect();
        Image.Plane[] planes = image.getPlanes();
        ByteBuffer buffer = planes[0].getBuffer();
        int pixelStride = planes[0].getPixelStride();
        int rowStride = planes[0].getRowStride();
        int rowPadding = rowStride - pixelStride * image.getWidth();
        int width = image.getWidth() + rowPadding / pixelStride;
        int height = image.getHeight();
        if (this.writableOriginalBitmap == null || this.writableOriginalBitmap.getWidth() != width || this.writableOriginalBitmap.getHeight() != height) {
            this.writableOriginalBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            if (this.writableOriginalBitmap == null) {
                throw new RuntimeException(String.format("Failed to create a bitmap %d:%d", width, height));
            }
        }
        this.writableOriginalBitmap.copyPixelsFromBuffer((Buffer)buffer);
        int croppedWidth = r.width() - r.left;
        int croppedHeight = r.height() - r.top;
        if (this.mostRecent == null || this.writableBitmap == null || this.writableBitmap.getWidth() != croppedWidth || this.writableBitmap.getHeight() != croppedHeight) {
            this.writableBitmap = Bitmap.createBitmap((int)croppedWidth, (int)croppedHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            if (this.writableBitmap == null) {
                throw new RuntimeException(String.format("Failed to create a bitmap %d:%d", width, height));
            }
            this.mostRecent = new Frame(this.writableBitmap);
        }
        Paint paint = new Paint();
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        Canvas canvas = new Canvas(this.writableBitmap);
        canvas.drawBitmap(this.writableOriginalBitmap, (float)r.left, (float)r.top, null);
        if (this.previousBitmap == null || !BitmapUtils.sameSize(this.previousBitmap, this.writableBitmap)) {
            this.mostRecent.setDirty(true);
            this.previousBitmap = BitmapUtils.copy(this.writableBitmap);
        } else if (!this.previousBitmap.sameAs(this.writableBitmap)) {
            this.mostRecent.setDirty(true);
            BitmapUtils.copy(this.writableBitmap, this.previousBitmap);
        } else {
            this.mostRecent.setDirty(false);
        }
    }

    static interface Delegate {
        public void requestFullDevicePermission(PermissionRequest var1);

        public void fullDeviceCaptureStarted();

        public void fullDeviceCaptureRejected();

        public void fullDeviceCaptureStopped();
    }

    public static class PermissionRequest
    extends Fragment {
        @Nullable
        private Callback<Error, Intent> callback;

        @NonNull
        PermissionRequest callback(@NonNull Callback<Error, Intent> callback) {
            this.callback = callback;
            return this;
        }

        public void onAttach(@NonNull Activity activity) {
            super.onAttach(activity);
            MediaProjectionManager mgr = (MediaProjectionManager)activity.getSystemService("media_projection");
            if (mgr != null) {
                this.startActivityForResult(mgr.createScreenCaptureIntent(), 1);
            } else {
                this.cancel();
            }
        }

        public void onActivityResult(int requestCode, int resultCode, Intent data) {
            if (requestCode == 1) {
                if (this.callback != null) {
                    if (resultCode == -1) {
                        ThreadUtils.invoke(this.callback, null, data);
                    } else {
                        ThreadUtils.invoke(this.callback, new CodedError(resultCode, "Result not OK"), data);
                    }
                    this.callback = null;
                }
                this.remove();
            }
        }

        public void show(@Nullable Activity activity) {
            if (activity == null || activity.isFinishing() || activity.isDestroyed()) {
                Log.i((String)"CobrowseIO", (String)"No activity to attach full device request to, cancelling request.");
                this.cancel();
            } else {
                Log.i((String)"CobrowseIO", (String)"Attaching full device permission prompt");
                FragmentTransaction fragmentTransaction = activity.getFragmentManager().beginTransaction();
                fragmentTransaction.add((Fragment)this, "cobrowse-get-media-permission");
                fragmentTransaction.commitAllowingStateLoss();
            }
        }

        public void cancel() {
            if (this.callback != null) {
                ThreadUtils.invoke(this.callback, new CodedError(0, "Request was canceled"), null);
                this.callback = null;
            }
            this.remove();
        }

        private void remove() {
            Activity activity;
            try {
                activity = this.getActivity();
                if (activity != null && !activity.isFinishing()) {
                    activity.getFragmentManager().beginTransaction().remove((Fragment)this).commitAllowingStateLoss();
                }
            }
            catch (Throwable e) {
                Log.e((String)"CobrowseIO", (String)("Error while removing full device permission fragment: " + e.getMessage()));
            }
            try {
                activity = this.getActivity();
                if (activity instanceof PermissionRequestActivity) {
                    activity.finish();
                }
            }
            catch (Throwable e) {
                Log.e((String)"CobrowseIO", (String)("Error while finishing full device permission fragment parent: " + e.getMessage()));
            }
            this.callback = null;
        }
    }

    public static class PermissionRequestActivity
    extends Activity {
    }
}

