/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.accessibilityservice.AccessibilityService;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.util.Log;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.util.Consumer;
import io.cobrowse.AccessibilityAnnotationOverlay;
import io.cobrowse.CobrowseAccessibilityService;
import io.cobrowse.CompatibilityUtils;
import io.cobrowse.Drawing;
import io.cobrowse.Laser;
import io.cobrowse.SerializationError;
import io.cobrowse.Session;
import java.util.HashMap;
import java.util.Map;

@RequiresApi(api=22)
class FullDeviceOverlayAccessibility
extends BroadcastReceiver
implements CobrowseAccessibilityService.AccessibilityInjector {
    private static final String FULL_DEVICE_OVERLAY_INTENT = "io.cobrowse.FULL_DEVICE_OVERLAY";
    private static final String ACTION_SESSION_STATE = "session_state";
    private static final String ACTION_LASER = "laser";
    private static final String ACTION_DRAWING = "drawing";
    @NonNull
    private final AccessibilityService service;
    @Nullable
    private AccessibilityAnnotationOverlay overlay;
    @Nullable
    private Drawing toBeDrawn;
    private boolean isOverlayAllowed;
    @NonNull
    private final Map<String, Consumer<Bundle>> broadcastSenders = new HashMap<String, Consumer<Bundle>>(){
        {
            this.put(FullDeviceOverlayAccessibility.ACTION_SESSION_STATE, bundle -> FullDeviceOverlayAccessibility.this.handleSessionState(bundle));
            this.put(FullDeviceOverlayAccessibility.ACTION_LASER, bundle -> FullDeviceOverlayAccessibility.this.laser(bundle));
            this.put(FullDeviceOverlayAccessibility.ACTION_DRAWING, bundle -> FullDeviceOverlayAccessibility.this.drawing(bundle));
        }
    };

    FullDeviceOverlayAccessibility(@NonNull AccessibilityService service) {
        this.service = service;
        CompatibilityUtils.registerBroadcastReceiver((Context)service, this, new IntentFilter(FULL_DEVICE_OVERLAY_INTENT));
    }

    @Override
    public void onDestroy() {
        this.service.unregisterReceiver((BroadcastReceiver)this);
    }

    private void prepareOverlay() {
        if (this.overlay != null) {
            return;
        }
        WindowManager wm = (WindowManager)this.service.getSystemService("window");
        this.overlay = new AccessibilityAnnotationOverlay(this.service.getApplicationContext(), wm);
        this.overlay.show();
        Drawing drawing = this.toBeDrawn;
        this.toBeDrawn = null;
        if (drawing != null) {
            this.overlay.post(() -> this.overlay.updateDrawing(drawing));
        }
    }

    private void destroyOverlay() {
        if (this.overlay != null) {
            this.overlay.hide();
            this.overlay = null;
        }
    }

    private void handleSessionState(@NonNull Bundle bundle) {
        String state = bundle.getString("state");
        boolean fullDevice = bundle.getBoolean("full_device");
        if ("active".equals(state) && fullDevice) {
            this.isOverlayAllowed = true;
            if (this.toBeDrawn != null && !this.toBeDrawn.isEmpty()) {
                this.prepareOverlay();
            }
        } else if ("ended".equals(state) || !fullDevice) {
            this.destroyOverlay();
            this.isOverlayAllowed = false;
        }
    }

    private void laser(@NonNull Bundle bundle) {
        Laser laser;
        if (!this.isOverlayAllowed) {
            return;
        }
        final String display = bundle.getString("display");
        final String state = bundle.getString("state");
        final float x = bundle.getFloat("x");
        final float y = bundle.getFloat("y");
        try {
            laser = new Laser((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("display", display);
                    this.put("state", state);
                    this.put("x", Float.valueOf(x));
                    this.put("y", Float.valueOf(y));
                }
            });
        }
        catch (SerializationError serializationError) {
            Log.e((String)"CobrowseIO", (String)"Failed to update laser", (Throwable)serializationError);
            return;
        }
        this.prepareOverlay();
        if (this.overlay == null) {
            return;
        }
        this.overlay.post(() -> {
            if (this.overlay == null) {
                return;
            }
            this.overlay.updateLaser(laser);
            if (this.overlay.isEmpty()) {
                this.destroyOverlay();
            }
        });
    }

    private void drawing(@NonNull Bundle bundle) {
        Drawing drawing;
        final String display = bundle.getString("display");
        final String state = bundle.getString("state");
        final byte[] image = bundle.getByteArray("image");
        final float x = bundle.getFloat("x");
        final float y = bundle.getFloat("y");
        final float width = bundle.getFloat("width");
        final float height = bundle.getFloat("height");
        try {
            drawing = new Drawing((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("display", display);
                    if (image != null) {
                        this.put("image", image);
                    }
                    this.put("state", state);
                    this.put("x", Float.valueOf(x));
                    this.put("y", Float.valueOf(y));
                    this.put("width", Float.valueOf(width));
                    this.put("height", Float.valueOf(height));
                }
            });
        }
        catch (SerializationError serializationError) {
            Log.e((String)"CobrowseIO", (String)"Failed to update laser", (Throwable)serializationError);
            return;
        }
        if (!this.isOverlayAllowed) {
            this.toBeDrawn = drawing;
        } else if (drawing.isEmpty()) {
            this.destroyOverlay();
        } else {
            this.prepareOverlay();
            if (this.overlay == null) {
                return;
            }
            this.overlay.post(() -> {
                if (this.overlay == null) {
                    return;
                }
                this.overlay.updateDrawing(drawing);
            });
        }
    }

    public void onReceive(@NonNull Context context, @NonNull Intent intent) {
        try {
            String packageName = context.getPackageName();
            if (packageName == null || !context.getPackageName().equals(intent.getPackage())) {
                return;
            }
            Bundle extras = intent.getExtras();
            if (extras == null) {
                Log.w((String)"CobrowseIO", (String)"Received a broadcast without extras");
                return;
            }
            String action = extras.getString("action");
            if (action == null) {
                Log.w((String)"CobrowseIO", (String)"Received a broadcast without action");
                return;
            }
            Consumer<Bundle> consumer = this.broadcastSenders.get(action);
            if (consumer == null) {
                Log.w((String)"CobrowseIO", (String)String.format("Received a broadcast with unknown action %s", action));
                return;
            }
            consumer.accept((Object)extras);
        }
        catch (Throwable e) {
            Log.i((String)"CobrowseIO", (String)("Error in CobrowseInjectorAccessibility.onReceive(): " + e));
        }
    }

    static void inject(@NonNull Application application, @NonNull Laser laser) {
        Intent intent = new Intent(FULL_DEVICE_OVERLAY_INTENT);
        intent.setPackage(application.getPackageName());
        Bundle data = new Bundle();
        data.putString("action", ACTION_LASER);
        data.putString("display", laser.display);
        data.putString("state", laser.state);
        if (laser.position != null) {
            data.putFloat("x", laser.position.x);
            data.putFloat("y", laser.position.y);
        }
        intent.putExtras(data);
        application.sendBroadcast(intent);
    }

    static void inject(@NonNull Application application, @NonNull Drawing drawing) {
        Intent intent = new Intent(FULL_DEVICE_OVERLAY_INTENT);
        intent.setPackage(application.getPackageName());
        Bundle data = new Bundle();
        data.putString("action", ACTION_DRAWING);
        data.putString("display", drawing.display);
        if (drawing.imageData != null) {
            data.putByteArray("image", drawing.imageData);
        }
        if (drawing.position != null) {
            data.putFloat("x", drawing.position.x);
            data.putFloat("y", drawing.position.y);
        }
        data.putFloat("width", drawing.width);
        data.putFloat("height", drawing.height);
        intent.putExtras(data);
        application.sendBroadcast(intent);
    }

    static void notifySessionStateChanged(@NonNull Application application, @NonNull Session session) {
        Intent intent = new Intent(FULL_DEVICE_OVERLAY_INTENT);
        intent.setPackage(application.getPackageName());
        Bundle data = new Bundle();
        data.putString("action", ACTION_SESSION_STATE);
        data.putString("state", session.state());
        data.putBoolean("full_device", session.fullDevice().booleanValue());
        intent.putExtras(data);
        application.sendBroadcast(intent);
    }
}

