/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import androidx.annotation.NonNull;
import io.cobrowse.Touch;

abstract class GestureRecognizer {
    private GestureState state = GestureState.Possible;

    GestureRecognizer() {
    }

    GestureState state() {
        return this.state;
    }

    void reset() {
        this.state = GestureState.Possible;
    }

    void setState(GestureState newState) {
        if (this.state == GestureState.Failed) {
            return;
        }
        if (newState == GestureState.Started && this.state != GestureState.Possible) {
            return;
        }
        if (newState == GestureState.Changed && this.state != GestureState.Started && this.state != GestureState.Changed) {
            return;
        }
        this.state = newState;
    }

    abstract void onTouchBegan(Touch var1);

    abstract void onTouchMoved(Touch var1);

    abstract void onTouchEnded(Touch var1);

    void onTouchEvent(@NonNull Touch touch) {
        if (touch.isStart()) {
            this.onTouchBegan(touch);
        } else if (touch.isMove()) {
            this.onTouchMoved(touch);
        } else if (touch.isEnd()) {
            this.onTouchEnded(touch);
        }
    }

    public static enum GestureState {
        Possible,
        Started,
        Changed,
        Recognized,
        Failed;

    }
}

