/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.graphics.Bitmap;
import androidx.annotation.NonNull;
import io.cobrowse.BitmapScaleConverter;
import io.cobrowse.Encoder;
import io.cobrowse.Frame;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

final class JPEGEncoder
extends Encoder {
    static final String MIME_TYPE = "image/jpeg";
    @NonNull
    private final BitmapScaleConverter scaleConverter = new BitmapScaleConverter();
    private Frame previousFrame;

    JPEGEncoder(Encoder.Delegate delegate) {
        super(delegate);
    }

    @Override
    @NonNull
    public String mimeType() {
        return MIME_TYPE;
    }

    @Override
    public void encode(@NonNull Frame frame) {
        if (!frame.isDirty() && frame.sameSizeAs(this.previousFrame)) {
            return;
        }
        this.previousFrame = frame;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Bitmap scaled = this.scaleConverter.downscale(frame.getBitmap(), frame.getScale());
        scaled.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)os);
        this.delegate.onEncodedFrameData(this, os.toByteArray());
    }

    @Override
    public int maximumFramesInFlight() {
        return 3;
    }

    @Override
    public void reset() {
        this.previousFrame = null;
    }
}

