/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.cobrowse.Callback;
import io.cobrowse.CodedError;
import io.cobrowse.JSONRequestExecutor;
import io.cobrowse.ThreadUtils;
import io.cobrowse.Tls12OkHttpClient;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.http.HttpMethod;
import org.json.JSONObject;

final class JSONRequest {
    @Nullable
    private Callback<Error, JSONObject> callback;

    JSONRequest(@Nullable Callback<Error, JSONObject> c) {
        this.callback = c;
    }

    public void execute(@NonNull Params req) {
        JSONRequestExecutor.reuse().execute(() -> {
            Pair<Error, JSONObject> rvalue = this.doInBackground(req);
            if (this.callback != null) {
                ThreadUtils.invoke(this.callback, (Error)rvalue.first, (JSONObject)rvalue.second);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private Pair<Error, JSONObject> doInBackground(@NonNull Params req) {
        try {
            String responseString;
            int result;
            RequestBody requestBody;
            Request.Builder requestBuilder = new Request.Builder().url(req.url);
            for (Map.Entry e : req.headers.entrySet()) {
                requestBuilder.header((String)e.getKey(), (String)e.getValue());
            }
            if (req.body != null) {
                if (HttpMethod.permitsRequestBody((String)req.method)) {
                    MediaType json = MediaType.parse((String)"application/json; charset=utf-8");
                    requestBody = RequestBody.create((MediaType)json, (String)req.body.toString());
                } else {
                    requestBody = null;
                }
            } else {
                requestBody = HttpMethod.permitsRequestBody((String)req.method) ? RequestBody.create(null, (byte[])new byte[0]) : null;
            }
            requestBuilder.method(req.method, requestBody);
            Request request = requestBuilder.build();
            OkHttpClient client = Tls12OkHttpClient.reuse();
            Call runningCall = client.newCall(request);
            try (Response response = runningCall.execute();){
                result = response.code();
                if (result == 204) {
                    Pair pair = new Pair(null, null);
                    return pair;
                }
                if (response.body() == null) {
                    Pair pair = new Pair(null, null);
                    return pair;
                }
                responseString = response.body().string();
            }
            JSONObject json = new JSONObject(responseString);
            if (result < 400) return new Pair(null, (Object)json);
            return new Pair((Object)new CodedError(result, json.getString("message")), (Object)json);
        }
        catch (Exception e) {
            return new Pair((Object)new Error(e.getMessage()), null);
        }
    }

    public static class Params {
        @NonNull
        private final HttpUrl url;
        @NonNull
        private final String method;
        @Nullable
        private final JSONObject body;
        @NonNull
        private final HashMap<String, String> headers;

        public Params(@NonNull HttpUrl u, @NonNull String m, @NonNull HashMap<String, String> h) {
            this(u, m, null, h);
        }

        public Params(@NonNull HttpUrl u, @NonNull String m, @Nullable JSONObject b, @NonNull HashMap<String, String> h) {
            this.url = u;
            this.method = m;
            this.body = b;
            this.headers = new HashMap<String, String>(h);
        }
    }
}

