/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.graphics.PointF;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.cobrowse.AgentEvent;
import io.cobrowse.SerializationError;
import io.cobrowse.TypeUtils;
import java.util.Map;

final class Laser
extends AgentEvent {
    @NonNull
    final String state;
    @Nullable
    final PointF position;

    Laser(@NonNull Map<String, Object> obj) throws SerializationError {
        super(obj);
        this.state = TypeUtils.checkNonNull(obj.get("state"), String.class);
        Double x = TypeUtils.check(obj.get("x"), Double.class, null);
        Double y = TypeUtils.check(obj.get("y"), Double.class, null);
        this.position = x != null && y != null ? new PointF(x.floatValue(), y.floatValue()) : null;
    }

    public boolean isStart() {
        return this.state.equalsIgnoreCase("touchstart");
    }

    public boolean isMove() {
        return this.state.equalsIgnoreCase("touchmove");
    }

    public boolean isEnd() {
        return this.state.equalsIgnoreCase("touchend");
    }
}

