/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

final class LaserPointerView
extends View {
    @NonNull
    private final Paint paint = new Paint();
    @Nullable
    private PointF position;

    LaserPointerView(Context context) {
        super(context);
        this.paint.setColor(-65536);
        this.paint.setStyle(Paint.Style.FILL);
    }

    public void draw(@NonNull Canvas canvas) {
        super.draw(canvas);
        if (this.position != null) {
            canvas.drawCircle(this.position.x, this.position.y, 20.0f, this.paint);
        }
    }

    public void setLaserPosition(PointF point) {
        this.position = point;
        this.invalidate();
    }

    public void stopPointing() {
        this.position = null;
        this.invalidate();
    }

    public boolean isPointing() {
        return this.position != null;
    }
}

