/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

final class ObjectMapper {
    ObjectMapper() {
    }

    @NonNull
    static Map<String, Object> toMap(@NonNull JSONObject json) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keys = json.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            List<Object> value = json.opt(key);
            if (value instanceof JSONArray) {
                value = ObjectMapper.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = ObjectMapper.toMap((JSONObject)value);
            }
            map.put(key, value);
        }
        return map;
    }

    @NonNull
    static List<Object> toList(@NonNull JSONArray array) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            List<Object> value = array.opt(i);
            if (value instanceof JSONArray) {
                value = ObjectMapper.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = ObjectMapper.toMap((JSONObject)value);
            }
            list.add(value);
        }
        return list;
    }

    @Nullable
    static JSONObject toJSONObject(@Nullable Map<String, Object> data) {
        if (data == null) {
            return null;
        }
        return new JSONObject(data);
    }
}

