/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.graphics.PointF;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.cobrowse.GestureRecognizer;
import io.cobrowse.Touch;

class PanGestureRecognizer
extends GestureRecognizer {
    @Nullable
    private Touch began;
    @Nullable
    private Touch ended;

    PanGestureRecognizer() {
    }

    @NonNull
    Direction getDirection() {
        if (this.ended != null && this.began != null) {
            PointF delta = this.ended.delta(this.began);
            if (Math.abs(delta.x) > Math.abs(delta.y)) {
                if (delta.x < 0.0f) {
                    return Direction.Left;
                }
                return Direction.Right;
            }
            if (delta.y < 0.0f) {
                return Direction.Up;
            }
            return Direction.Down;
        }
        return Direction.Invalid;
    }

    @Override
    void onTouchBegan(@NonNull Touch touch) {
        this.began = touch;
        this.setState(GestureRecognizer.GestureState.Started);
    }

    @Override
    void onTouchMoved(@NonNull Touch touch) {
    }

    @Override
    void onTouchEnded(@NonNull Touch touch) {
        if (this.began == null) {
            this.ended = null;
            this.setState(GestureRecognizer.GestureState.Failed);
        } else {
            this.ended = touch;
            double distance = this.began.distance(touch);
            if (distance > 20.0) {
                this.setState(GestureRecognizer.GestureState.Recognized);
            } else {
                this.setState(GestureRecognizer.GestureState.Failed);
            }
        }
    }

    @Override
    void reset() {
        this.began = null;
        this.ended = null;
        super.reset();
    }

    static enum Direction {
        Up,
        Down,
        Left,
        Right,
        Invalid;

    }
}

