/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import androidx.annotation.NonNull;

final class PixelFormatConverter {
    private static final int COBROWSE_DEFAULT_COLOR = -1513240;

    PixelFormatConverter() {
    }

    static void argb2rgba(@NonNull int[] src, @NonNull byte[] dest, int width, int height) {
        if (dest.length != width * height * 4) {
            throw new IllegalArgumentException("destination's length should be " + width * height * 4 + ". (destWidth * destHeight * 4)");
        }
        int index = 0;
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int color2 = src[j * width + i];
                dest[index + 0] = (byte)((color2 & 0xFF0000) >> 16);
                dest[index + 1] = (byte)((color2 & 0xFF00) >> 8);
                dest[index + 2] = (byte)((color2 & 0xFF) >> 0);
                dest[index + 3] = 0;
                index += 4;
            }
        }
    }

    static void argb2nv12(@NonNull int[] src, @NonNull byte[] dest, int width, int height) {
        if (dest.length != width * height * 3 / 2) {
            throw new IllegalArgumentException("destination's length should be " + width * height * 3 / 2 + ". (destWidth * destHeight * 3 / 2)");
        }
        int frameSize = width * height;
        int yIndex = 0;
        int uvIndex = frameSize;
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int index = j * width + i;
                int color2 = src[j * width + i];
                int R2 = (color2 & 0xFF0000) >> 16;
                int G = (color2 & 0xFF00) >> 8;
                int B = (color2 & 0xFF) >> 0;
                int Y = (66 * R2 + 129 * G + 25 * B + 128 >> 8) + 16;
                int U = (-38 * R2 - 74 * G + 112 * B + 128 >> 8) + 128;
                int V = (112 * R2 - 94 * G - 18 * B + 128 >> 8) + 128;
                dest[yIndex++] = (byte)(Y < 0 ? 0 : (Y > 255 ? 255 : Y));
                if (j % 2 != 0 || index % 2 != 0) continue;
                dest[uvIndex++] = (byte)(U < 0 ? 0 : (U > 255 ? 255 : U));
                dest[uvIndex++] = (byte)(V < 0 ? 0 : (V > 255 ? 255 : V));
            }
        }
    }

    static void argb2i420(@NonNull int[] src, @NonNull byte[] dest, int width, int height) {
        if (dest.length != width * height * 3 / 2) {
            throw new IllegalArgumentException("destination's length should be " + width * height * 3 / 2 + ". (destWidth * destHeight * 3 / 2)");
        }
        int frameSize = width * height;
        int yIndex = 0;
        int uIndex = frameSize;
        int vIndex = frameSize * 5 / 4;
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int color2 = src[j * width + i];
                int R2 = (color2 & 0xFF0000) >> 16;
                int G = (color2 & 0xFF00) >> 8;
                int B = (color2 & 0xFF) >> 0;
                int Y = (66 * R2 + 129 * G + 25 * B + 128 >> 8) + 16;
                int U = (-38 * R2 - 74 * G + 112 * B + 128 >> 8) + 128;
                int V = (112 * R2 - 94 * G - 18 * B + 128 >> 8) + 128;
                dest[yIndex++] = (byte)(Y < 0 ? 0 : (Y > 255 ? 255 : Y));
                if (j % 2 != 0 || i % 2 != 0) continue;
                dest[uIndex++] = (byte)(U < 0 ? 0 : (U > 255 ? 255 : U));
                dest[vIndex++] = (byte)(V < 0 ? 0 : (V > 255 ? 255 : V));
            }
        }
    }
}

