/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.cobrowse.Callback;
import io.cobrowse.CobrowseIO;
import io.cobrowse.JSONRequest;
import io.cobrowse.ObjectMapper;
import io.cobrowse.ThreadUtils;
import io.cobrowse.TypeUtils;
import java.util.HashMap;
import java.util.Map;
import okhttp3.HttpUrl;

abstract class RESTResource<T> {
    @Nullable
    Map<String, Object> resource;
    @NonNull
    HashMap<String, String> headers = new HashMap();

    RESTResource() {
    }

    @NonNull
    abstract HttpUrl url();

    @Nullable
    <S> S field(@NonNull String name, @NonNull Class<S> cls) {
        if (this.resource == null) {
            return null;
        }
        return TypeUtils.check(this.resource.get(name), cls, null);
    }

    @NonNull
    <S> S field(@NonNull String name, @NonNull Class<S> cls, @NonNull S def) {
        S checked = this.field(name, cls);
        if (checked == null) {
            return def;
        }
        return checked;
    }

    private void request(@NonNull String method, @Nullable Map<String, Object> params, @Nullable Callback<Error, T> callback) {
        RESTResource self = this;
        new JSONRequest((err, json) -> {
            if (err != null) {
                ThreadUtils.invoke(callback, err, null);
            } else {
                if (json != null) {
                    this.updateResource(ObjectMapper.toMap(json));
                }
                ThreadUtils.invoke(callback, null, self);
            }
        }).execute(new JSONRequest.Params(this.url(), method, ObjectMapper.toJSONObject(params), this.headers()));
    }

    void updateResource(@NonNull Map<String, Object> obj) {
        this.resource = obj;
    }

    void reset() {
        this.resource = null;
    }

    void create(@Nullable Map<String, Object> params, @Nullable Callback<Error, T> callback) {
        this.request("POST", params, callback);
    }

    void update(@Nullable Map<String, Object> params, @Nullable Callback<Error, T> callback) {
        this.request("PUT", params, callback);
    }

    void delete(@Nullable Callback<Error, T> callback) {
        this.request("DELETE", null, callback);
    }

    void fetch(@Nullable Callback<Error, T> callback) {
        this.request("GET", null, callback);
    }

    protected void setHeader(String key, String value) {
        this.headers.put(key, value);
    }

    protected HashMap<String, String> headers() {
        HashMap<String, String> merged = new HashMap<String, String>(CobrowseIO.headers());
        for (Map.Entry<String, String> e : this.headers.entrySet()) {
            merged.put(e.getKey(), e.getValue());
        }
        return merged;
    }
}

