/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowId;
import android.webkit.WebView;
import android.widget.HorizontalScrollView;
import android.widget.ScrollView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.UiThread;
import androidx.core.util.Pair;
import io.cobrowse.CobrowseIO;
import io.cobrowse.RedactionExternal;
import io.cobrowse.Selector;
import io.cobrowse.SelectorIndex;
import io.cobrowse.TreeUtils;
import io.cobrowse.ViewTraversal;
import io.cobrowse.WebViewTrackerManager;
import io.cobrowse.Windows;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@UiThread
final class Redaction {
    @NonNull
    private final HashMap<View, Drawable> redactions = new HashMap();
    @NonNull
    private SelectorIndex redactionSelectorIndex = new SelectorIndex(new ArrayList<Selector>());
    @NonNull
    private SelectorIndex unredactionSelectorIndex = new SelectorIndex(new ArrayList<Selector>());
    @NonNull
    private final WebViewTrackerManager webViewTrackerManager;
    @NonNull
    private final List<RedactionExternal> redactionsExternal;

    public Redaction(@NonNull WebViewTrackerManager webViewTrackerManager, @NonNull List<RedactionExternal> redactionsExternal) {
        this.webViewTrackerManager = webViewTrackerManager;
        this.redactionsExternal = redactionsExternal;
    }

    void setSelectors(@NonNull List<Selector> redaction, @NonNull List<Selector> unredaction) {
        this.redactionSelectorIndex = new SelectorIndex(redaction);
        this.unredactionSelectorIndex = new SelectorIndex(unredaction);
        for (RedactionExternal external : this.redactionsExternal) {
            external.setRedactionIndexes(this.redactionSelectorIndex, this.unredactionSelectorIndex);
        }
    }

    private void showOverlay(@NonNull View view) {
        Drawable overlay = this.redactions.get(view);
        if (overlay != null) {
            int height;
            overlay.setVisible(true, true);
            int left = 0;
            int top = 0;
            int width = view.getWidth() == 0 ? Integer.MAX_VALUE : view.getWidth();
            int n = height = view.getHeight() == 0 ? Integer.MAX_VALUE : view.getHeight();
            if (Redaction.isScrollView(view)) {
                View child;
                if (view instanceof ViewGroup && (child = ((ViewGroup)view).getChildAt(0)) != null) {
                    width += child.getWidth();
                    height += child.getHeight();
                }
                if (view instanceof WebView) {
                    top = view.getScrollY();
                    left = view.getScrollX();
                    width += view.getScrollX();
                    height += view.getScrollY();
                }
            } else if (Redaction.isSingleLineTextView(view)) {
                left = view.getScrollX();
                top = view.getScrollY();
                width += view.getScrollX();
                height += view.getScrollY();
            }
            overlay.setBounds(left, top, width, height);
            view.getOverlay().add(overlay);
            view.setWillNotDraw(false);
        } else {
            Log.v((String)"CobrowseIO", (String)("No overlay found for view " + view));
        }
    }

    private static boolean isScrollView(@NonNull View view) {
        return view.isScrollContainer() || view instanceof ScrollView || view instanceof HorizontalScrollView || view.getClass().getName().equals("androidx.core.widget.NestedScrollView");
    }

    @SuppressLint(value={"RtlHardcoded"})
    private static boolean isSingleLineTextView(@NonNull View view) {
        boolean isSingleLine;
        if (!(view instanceof TextView)) {
            return false;
        }
        TextView textView = (TextView)view;
        boolean bl = Build.VERSION.SDK_INT >= 29 ? textView.isSingleLine() : (isSingleLine = textView.getMaxLines() == 1);
        if (!isSingleLine) {
            return false;
        }
        boolean isHorizontalGravityModified = (textView.getGravity() & 0x800007) != 0x800003 || (textView.getGravity() & 7) != 3;
        boolean isVerticalGravityModified = (textView.getGravity() & 0x70) != 48;
        return isHorizontalGravityModified || isVerticalGravityModified;
    }

    private void hideOverlay(@NonNull View view) {
        Drawable overlay = this.redactions.get(view);
        if (overlay != null) {
            view.getOverlay().remove(overlay);
            view.invalidate();
            overlay.invalidateSelf();
        }
    }

    void show() {
        for (RedactionExternal next : this.redactionsExternal) {
            next.show();
        }
        HashMap<View, Drawable> redacted = new HashMap<View, Drawable>(this.redactions);
        for (View view : redacted.keySet()) {
            this.showOverlay(view);
        }
    }

    void hide() {
        for (RedactionExternal next : this.redactionsExternal) {
            next.hide();
        }
        HashMap<View, Drawable> redacted = new HashMap<View, Drawable>(this.redactions);
        for (View view : redacted.keySet()) {
            this.hideOverlay(view);
        }
    }

    @NonNull
    private List<View> validateViews(@NonNull List<View> views) {
        ArrayList<View> validated = new ArrayList<View>();
        for (View v : views) {
            if (v == null) {
                Log.e((String)"CobrowseIO", (String)"A null view was passed to redaction. This is probably not what you meant");
                continue;
            }
            validated.add(v);
        }
        return validated;
    }

    boolean matchesAnySelector(@NonNull SelectorIndex index, @NonNull View view) {
        String tag = Selector.Part.tagFor(view);
        String id2 = Selector.Part.idFor(view);
        Map<String, String> attributes = Selector.Part.attributesFor(view, index.getKnownAttributes());
        Set<Selector> possibleMatches = index.possibleMatches(tag, id2, attributes);
        for (Selector selector : possibleMatches) {
            if (!selector.matches(view)) continue;
            return true;
        }
        return false;
    }

    void forEachView(ViewTraversal.Visitor visitor) {
        List<View> windows = Windows.getAll();
        for (View nextWindow : windows) {
            ViewTraversal.depthFirst(nextWindow, visitor);
        }
    }

    @NonNull
    private Set<View> redactedViewsForActivity(@NonNull Activity activity) {
        Set<View> redactedViews = this.findRedactedViews(activity);
        Set<View> unredactedViews = this.findUnredactedViews(activity);
        this.forEachView(view -> {
            if (this.matchesAnySelector(this.redactionSelectorIndex, view)) {
                redactedViews.add(view);
            }
            if (this.matchesAnySelector(this.unredactionSelectorIndex, view)) {
                unredactedViews.add(view);
            }
            return true;
        });
        HashSet<View> projectedUnredacted = new HashSet<View>();
        for (View view2 : unredactedViews) {
            projectedUnredacted.add(view2);
            projectedUnredacted.addAll(TreeUtils.allParents(view2));
        }
        HashSet<View> redactedProjectedUnredactions = new HashSet<View>(redactedViews);
        redactedProjectedUnredactions.retainAll(projectedUnredacted);
        HashSet<View> toRedact = new HashSet<View>(redactedViews);
        toRedact.removeAll(redactedProjectedUnredactions);
        HashSet<View> projectedUnredactionSiblings = new HashSet<View>();
        for (View view3 : projectedUnredacted) {
            ViewParent parent = view3.getParent();
            if (!(parent instanceof ViewGroup)) continue;
            projectedUnredactionSiblings.addAll(TreeUtils.directChildren((View)((ViewGroup)parent)));
        }
        HashSet potentiallyRedactedUnredactedSiblings = new HashSet(projectedUnredactionSiblings);
        potentiallyRedactedUnredactedSiblings.removeAll(projectedUnredacted);
        for (View view4 : potentiallyRedactedUnredactedSiblings) {
            View closest = TreeUtils.closest(view4, v -> redactedViews.contains(v) || unredactedViews.contains(v));
            if (!redactedViews.contains(closest)) continue;
            toRedact.add(view4);
        }
        for (View v2 : new HashSet<View>(toRedact)) {
            if (!(v2 instanceof ViewGroup) || v2 instanceof WebView || ((ViewGroup)v2).getChildCount() != 0) continue;
            toRedact.remove(v2);
        }
        toRedact.addAll(this.webViewTrackerManager.getRedactedViewsForActivity(activity));
        return toRedact;
    }

    @NonNull
    private Set<View> findRedactedViews(@NonNull Activity activity) {
        List<View> views;
        CobrowseIO.RedactionDelegate delegate;
        List<View> views2;
        HashSet<View> redactedViews = new HashSet<View>();
        if (activity instanceof CobrowseIO.Redacted && (views2 = ((CobrowseIO.Redacted)activity).redactedViews()) != null) {
            redactedViews.addAll(this.validateViews(views2));
        }
        if ((delegate = (CobrowseIO.RedactionDelegate)CobrowseIO.instance().getDelegate(CobrowseIO.RedactionDelegate.class)) != null && (views = delegate.redactedViews(activity)) != null) {
            redactedViews.addAll(this.validateViews(views));
        }
        return redactedViews;
    }

    @NonNull
    private Set<View> findUnredactedViews(@NonNull Activity activity) {
        List<View> views;
        CobrowseIO.UnredactionDelegate delegate;
        List<View> views2;
        HashSet<View> unredactedViews = new HashSet<View>();
        if (activity instanceof CobrowseIO.Unredacted && (views2 = ((CobrowseIO.Unredacted)activity).unredactedViews()) != null) {
            unredactedViews.addAll(this.validateViews(views2));
        }
        if ((delegate = (CobrowseIO.UnredactionDelegate)CobrowseIO.instance().getDelegate(CobrowseIO.UnredactionDelegate.class)) != null && (views = delegate.unredactedViews(activity)) != null) {
            unredactedViews.addAll(this.validateViews(views));
        }
        return unredactedViews;
    }

    private void redact(@NonNull View view) {
        if (this.redactions.get(view) != null) {
            return;
        }
        Log.v((String)"CobrowseIO", (String)("Adding redaction for " + view));
        ColorDrawable overlay = new ColorDrawable(-16777216);
        overlay.setVisible(false, false);
        this.redactions.put(view, (Drawable)overlay);
    }

    private void unredact(@NonNull View view) {
        Log.v((String)"CobrowseIO", (String)("Removing redaction for " + view));
        this.hideOverlay(view);
        this.redactions.remove(view);
    }

    void unredactAll() {
        HashMap<View, Drawable> redacted = new HashMap<View, Drawable>(this.redactions);
        for (View view : redacted.keySet()) {
            this.unredact(view);
        }
    }

    void redact(@NonNull Set<Activity> activities) {
        HashSet<View> removed = new HashSet<View>(this.redactions.keySet());
        for (Activity activity : activities) {
            for (View view : this.redactedViewsForActivity(activity)) {
                this.redact(view);
                removed.remove(view);
            }
        }
        for (View view : removed) {
            this.unredact(view);
        }
    }

    @NonNull
    Set<View> getRedactions() {
        return this.redactions.keySet();
    }

    @NonNull
    List<Pair<Rect, WindowId>> getRedactionsExternal() {
        ArrayList<Pair<Rect, WindowId>> rvalue = new ArrayList<Pair<Rect, WindowId>>();
        for (RedactionExternal next : this.redactionsExternal) {
            rvalue.addAll(next.getTrackedRedactions());
        }
        return rvalue;
    }

    boolean isRedactionExternalFocused() {
        for (RedactionExternal next : this.redactionsExternal) {
            if (!next.isRedactionFocused()) continue;
            return true;
        }
        return false;
    }

    boolean isRedacted(View view) {
        if (view == null) {
            return false;
        }
        boolean redacted = this.redactions.containsKey(view);
        if (redacted) {
            return true;
        }
        ViewParent parent = view.getParent();
        if (parent instanceof View) {
            return this.isRedacted((View)parent);
        }
        return false;
    }
}

