/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.cobrowse.RedactionExternal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

final class RedactionExternalLoader {
    private static final Object sImplementationLoadersLock = new Object();
    @Nullable
    private static Set<RedactionExternalFactory> sImplementationLoaders;

    private RedactionExternalLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void add(@NonNull RedactionExternalFactory factory) {
        Object object = sImplementationLoadersLock;
        synchronized (object) {
            if (sImplementationLoaders == null) {
                sImplementationLoaders = new HashSet<RedactionExternalFactory>();
            }
            if (!sImplementationLoaders.add(factory)) {
                Log.e((String)"CobrowseIO", (String)"This redaction implementation has been already set!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    static List<RedactionExternal> load() {
        Object object = sImplementationLoadersLock;
        synchronized (object) {
            ArrayList<RedactionExternal> rvalue = new ArrayList<RedactionExternal>();
            if (sImplementationLoaders != null) {
                for (RedactionExternalFactory next : sImplementationLoaders) {
                    rvalue.add(next.load());
                }
            }
            return rvalue;
        }
    }

    static interface RedactionExternalFactory {
        @NonNull
        public RedactionExternal load();
    }
}

