/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.app.Activity;
import android.app.Application;
import android.util.Log;
import android.view.Display;
import android.view.ViewTreeObserver;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import io.cobrowse.ActivityWatcher;
import io.cobrowse.Frame;
import io.cobrowse.FrameLoop;
import io.cobrowse.Redaction;
import io.cobrowse.RedactionExternalLoader;
import io.cobrowse.Selector;
import io.cobrowse.Session;
import io.cobrowse.SessionContextModule;
import io.cobrowse.WebViewTrackerManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

@UiThread
final class RedactionManager
extends SessionContextModule
implements Session.Listener,
FrameLoop.Listener,
ActivityWatcher.Observer {
    @NonNull
    final Delegate delegate;
    @NonNull
    private final WebViewTrackerManager webViewTrackerManager = new WebViewTrackerManager();
    @NonNull
    private final Redaction redaction = new Redaction(this.webViewTrackerManager, RedactionExternalLoader.load());
    private final HashSet<Activity> redactedActivities = new HashSet();
    private final ViewTreeObserver.OnGlobalLayoutListener layoutListener = () -> {
        Log.v((String)"CobrowseIO", (String)"Global layout changed");
        this.updateRedaction();
    };
    private final ViewTreeObserver.OnWindowFocusChangeListener focusChangeListener = hasFocus -> {
        Log.v((String)"CobrowseIO", (String)"Window focus changed");
        this.updateRedaction();
    };
    private final ViewTreeObserver.OnGlobalFocusChangeListener globalFocusChangeListener = (oldFocus, newFocus) -> {
        Log.v((String)"CobrowseIO", (String)"Global window focus changed");
        this.updateRedaction();
    };
    private final ViewTreeObserver.OnScrollChangedListener scrollChangedListener = () -> {
        if (this.session.fullDevice().booleanValue()) {
            this.updateRedaction();
        }
    };

    RedactionManager(@NonNull Delegate delegate, @NonNull Application app, @NonNull Session session) {
        super(app, session);
        this.delegate = delegate;
        Log.v((String)"CobrowseIO", (String)("Redaction initialising with activities " + ActivityWatcher.getActivities()));
        for (Activity activity : ActivityWatcher.getActivities()) {
            this.watchActivity(activity);
        }
        session.registerSessionListener(this);
        ActivityWatcher.registerActivityObserver(this);
        this.updateRedaction();
    }

    @Override
    void destroy() {
        Log.v((String)"CobrowseIO", (String)("Destroying RedactionManager for activities: " + this.redactedActivities));
        this.session.removeSessionListener(this);
        ActivityWatcher.removeActivityObserver(this);
        for (Activity activity : new HashSet<Activity>(this.redactedActivities)) {
            this.unwatchActivity(activity);
        }
        this.redaction.unredactAll();
        this.webViewTrackerManager.destroy();
    }

    private void watchActivity(@Nullable Activity activity) {
        if (activity == null) {
            return;
        }
        if (this.redactedActivities.contains(activity)) {
            return;
        }
        Log.v((String)"CobrowseIO", (String)("Watching activity " + activity));
        this.redactedActivities.add(activity);
        ViewTreeObserver observer = activity.getWindow().getDecorView().getViewTreeObserver();
        this.removeObservers(observer);
        this.addObservers(observer);
    }

    private void unwatchActivity(@Nullable Activity activity) {
        if (activity == null) {
            return;
        }
        if (!this.redactedActivities.contains(activity)) {
            return;
        }
        Log.v((String)"CobrowseIO", (String)("Un-watching activity " + activity));
        this.redactedActivities.remove(activity);
        ViewTreeObserver observer = activity.getWindow().getDecorView().getViewTreeObserver();
        this.removeObservers(observer);
        this.webViewTrackerManager.untrackActivity(activity);
    }

    private void addObservers(@NonNull ViewTreeObserver observer) {
        observer.addOnGlobalLayoutListener(this.layoutListener);
        observer.addOnWindowFocusChangeListener(this.focusChangeListener);
        observer.addOnGlobalFocusChangeListener(this.globalFocusChangeListener);
        observer.addOnScrollChangedListener(this.scrollChangedListener);
    }

    private void removeObservers(@NonNull ViewTreeObserver observer) {
        observer.removeOnGlobalLayoutListener(this.layoutListener);
        observer.removeOnWindowFocusChangeListener(this.focusChangeListener);
        observer.removeOnGlobalFocusChangeListener(this.globalFocusChangeListener);
        observer.removeOnScrollChangedListener(this.scrollChangedListener);
    }

    @NonNull
    Redaction getRedaction() {
        return this.redaction;
    }

    private void updateRedaction() {
        HashSet<Activity> removed = new HashSet<Activity>(this.redactedActivities);
        for (Activity activity : ActivityWatcher.getActivities()) {
            this.watchActivity(activity);
            removed.remove(activity);
        }
        for (Activity activity : removed) {
            this.unwatchActivity(activity);
        }
        this.redaction.redact(this.redactedActivities);
        if (this.session.fullDevice().booleanValue()) {
            this.getRedaction().show();
        }
        if (!this.redactedActivities.containsAll(ActivityWatcher.getActivities())) {
            Log.w((String)"CobrowseIO", (String)("Some activities are not redacted " + this.redactedActivities + " tracked " + ActivityWatcher.getActivities()));
        }
        if (!ActivityWatcher.getActivities().containsAll(this.redactedActivities)) {
            Log.w((String)"CobrowseIO", (String)("Some un-tracked activities are redacted " + this.redactedActivities + " tracked " + ActivityWatcher.getActivities()));
        }
    }

    @Override
    public void sessionDidUpdate(final @NonNull Session session) {
        Log.v((String)"CobrowseIO", (String)"Applying selectors");
        this.redaction.setSelectors((List<Selector>)new ArrayList<Selector>(){
            {
                this.addAll(session.redactionSelectors());
                this.addAll(RedactionManager.this.delegate.redactionSelectors());
            }
        }, (List<Selector>)new ArrayList<Selector>(){
            {
                this.addAll(session.unredactionSelectors());
                this.addAll(RedactionManager.this.delegate.unredactionSelectors());
            }
        });
        this.updateRedaction();
    }

    @Override
    public void sessionDidEnd(@NonNull Session session) {
        this.redaction.unredactAll();
    }

    @Override
    public void activityChanged(@Nullable Activity to, @Nullable Activity from) {
        Log.v((String)"CobrowseIO", (String)("Focused activity changed from " + from + " to " + to));
        this.updateRedaction();
    }

    @Override
    public boolean willCaptureFrame(@NonNull Display display) {
        this.updateRedaction();
        if (!this.webViewTrackerManager.isSettled()) {
            return false;
        }
        this.getRedaction().show();
        return true;
    }

    @Override
    public void didCaptureFrame(@NonNull Display display, @Nullable Frame screenshot) {
        if (!this.session.fullDevice().booleanValue()) {
            this.getRedaction().hide();
        }
    }

    static interface Delegate {
        @NonNull
        public List<Selector> redactionSelectors();

        @NonNull
        public List<Selector> unredactionSelectors();
    }
}

