/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.security.KeyPairGeneratorSpec;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Calendar;
import javax.crypto.Cipher;
import javax.security.auth.x500.X500Principal;

final class SecureStorage {
    @NonNull
    private static final String CIPHER = "RSA/ECB/PKCS1Padding";
    @NonNull
    private static final String ALIAS = "io.cobrowse";
    private static SecureStorage instance;

    private SecureStorage() {
    }

    static SecureStorage instance() {
        if (instance == null) {
            instance = new SecureStorage();
        }
        return instance;
    }

    private synchronized void generateKeyPair(@NonNull Context context) throws Exception {
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        end.add(1, 1000);
        KeyPairGeneratorSpec spec = new KeyPairGeneratorSpec.Builder(context).setAlias(ALIAS).setSubject(new X500Principal("CN=Cobrowse")).setSerialNumber(BigInteger.ONE).setStartDate(start.getTime()).setEndDate(end.getTime()).build();
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA", "AndroidKeyStore");
        generator.initialize((AlgorithmParameterSpec)spec);
        generator.generateKeyPair();
    }

    private synchronized KeyStore getKeyStore(@NonNull Context context) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("AndroidKeyStore");
        keyStore.load(null);
        boolean containsAlias = keyStore.containsAlias(ALIAS);
        if (containsAlias) {
            PrivateKey priv = this.getPrivateKey(keyStore);
            PublicKey pub = this.getPublicKey(keyStore);
            if (priv == null || pub == null) {
                keyStore.deleteEntry(ALIAS);
                containsAlias = false;
            }
        }
        if (!containsAlias) {
            this.generateKeyPair(context);
        }
        return keyStore;
    }

    private synchronized PrivateKey getPrivateKey(@NonNull KeyStore ks) throws Exception {
        Key key = ks.getKey(ALIAS, null);
        if (key instanceof PrivateKey) {
            return (PrivateKey)key;
        }
        return null;
    }

    private synchronized PublicKey getPublicKey(@NonNull KeyStore ks) throws Exception {
        Certificate cert = ks.getCertificate(ALIAS);
        if (cert == null) {
            return null;
        }
        return cert.getPublicKey();
    }

    @NonNull
    private String encrypt(@NonNull Context context, @NonNull String plainText) throws Exception {
        Cipher cipher = Cipher.getInstance(CIPHER);
        cipher.init(1, this.getPublicKey(this.getKeyStore(context)));
        byte[] encryptedBytes = cipher.doFinal(plainText.getBytes(StandardCharsets.UTF_8));
        byte[] base64encryptedBytes = Base64.encode((byte[])encryptedBytes, (int)0);
        return new String(base64encryptedBytes);
    }

    @NonNull
    private String decrypt(@NonNull Context context, @NonNull String cipherText) throws Exception {
        byte[] base64encryptedBytes = cipherText.getBytes(StandardCharsets.UTF_8);
        byte[] bytes = Base64.decode((byte[])base64encryptedBytes, (int)0);
        Cipher cipher = Cipher.getInstance(CIPHER);
        cipher.init(2, this.getPrivateKey(this.getKeyStore(context)));
        byte[] decryptedBytes = cipher.doFinal(bytes);
        return new String(decryptedBytes);
    }

    @NonNull
    private SharedPreferences getPreferences(@NonNull Application app) {
        return app.getSharedPreferences(ALIAS, 0);
    }

    @Nullable
    synchronized String getValue(@NonNull Application app, @NonNull String key) {
        String cipherText = this.getPreferences(app).getString(key, null);
        if (cipherText == null) {
            return null;
        }
        try {
            return this.decrypt((Context)app, cipherText);
        }
        catch (Exception e) {
            return null;
        }
    }

    synchronized boolean setValue(@NonNull Application app, @NonNull String key, @NonNull String value) {
        try {
            String cipherText = this.encrypt((Context)app, value);
            SharedPreferences.Editor editor = this.getPreferences(app).edit();
            editor.putString(key, cipherText);
            return editor.commit();
        }
        catch (Exception e) {
            return false;
        }
    }
}

