/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.content.res.Resources;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.cobrowse.TreeUtils;
import io.cobrowse.TypeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class Selector {
    @NonNull
    final List<Part> parts;

    Selector(@NonNull List<Part> parts) {
        this.parts = parts;
    }

    static Selector from(@NonNull List rawParts) {
        ArrayList<Part> parts = new ArrayList<Part>();
        for (Object rawPart : rawParts) {
            if (!(rawPart instanceof Map)) continue;
            parts.add(Part.from((Map)rawPart));
        }
        return new Selector(parts);
    }

    Part lastPart() {
        return this.parts.get(this.parts.size() - 1);
    }

    Boolean matchesDescendantChain(@NonNull List<ViewProperties> parents, @NonNull List<Part> parts) {
        if (parts.isEmpty()) {
            return true;
        }
        if (parents.isEmpty()) {
            return false;
        }
        Part part = parts.get(parts.size() - 1);
        ViewProperties parent = parents.get(parents.size() - 1);
        List<ViewProperties> remainingParents = parents.subList(0, parents.size() - 1);
        if (part.matches(parent.tag, parent.id, parent.attributes)) {
            List<Part> remainingParts = parts.subList(0, parts.size() - 1);
            return this.matchesDescendantChain(remainingParents, remainingParts);
        }
        return this.matchesDescendantChain(remainingParents, parts);
    }

    boolean matches(@NonNull ViewProperties view, @NonNull List<ViewProperties> parents) {
        if (!this.lastPart().matches(view)) {
            return false;
        }
        return this.matchesDescendantChain(parents, this.parts.subList(0, this.parts.size() - 1));
    }

    boolean matches(final @NonNull View view) {
        if (!this.lastPart().matches(view)) {
            return false;
        }
        return this.matches(ViewProperties.describing(view, this.attributesUsed()), (List<ViewProperties>)new ArrayList<ViewProperties>(){
            {
                for (View parent : TreeUtils.allParents(view)) {
                    this.add(ViewProperties.describing(parent, Selector.this.attributesUsed()));
                }
            }
        });
    }

    @NonNull
    Set<String> attributesUsed() {
        HashSet<String> used = new HashSet<String>();
        for (Part part : this.parts) {
            if (part.attributes == null) continue;
            used.addAll(part.attributes.keySet());
        }
        return used;
    }

    static class Part
    extends ViewProperties {
        Part(@Nullable String tag, @Nullable String id2, @Nullable Map<String, String> attributes) {
            super(tag, id2, attributes);
        }

        static Part from(@NonNull Map obj) {
            String tag = TypeUtils.check(obj.get("tag"), String.class);
            String id2 = TypeUtils.check(obj.get("id"), String.class);
            Map attributes = TypeUtils.check(obj.get("attrs"), Map.class);
            HashMap<String, String> typedCheckedAttributes = null;
            if (attributes != null) {
                typedCheckedAttributes = new HashMap<String, String>();
                for (Object entry : attributes.keySet()) {
                    String key = TypeUtils.check(entry, String.class);
                    String value = TypeUtils.check(attributes.get(entry), String.class);
                    if (key == null || value == null) continue;
                    typedCheckedAttributes.put(key, value);
                }
            }
            return new Part(tag, id2, typedCheckedAttributes);
        }

        boolean matches(@Nullable String otherTag, @Nullable String otherId, @Nullable Map<String, String> otherAttributes) {
            if (this.tag != null && !this.tag.equals(otherTag)) {
                return false;
            }
            if (this.id != null && !this.id.equals(otherId)) {
                return false;
            }
            if (this.attributes != null) {
                for (Map.Entry entry : this.attributes.entrySet()) {
                    if (otherAttributes == null) {
                        return false;
                    }
                    String otherValue = otherAttributes.get(entry.getKey());
                    if (otherValue == null) {
                        return false;
                    }
                    if (otherValue.equals(entry.getValue())) continue;
                    return false;
                }
            }
            return true;
        }

        boolean matches(@NonNull ViewProperties view) {
            return this.matches(view.tag, view.id, view.attributes);
        }

        boolean matches(@NonNull View view) {
            return this.matches(ViewProperties.describing(view, this.attributes == null ? null : this.attributes.keySet()));
        }
    }

    static class ViewProperties {
        @Nullable
        final String tag;
        @Nullable
        final String id;
        @Nullable
        final Map<String, String> attributes;

        ViewProperties(@Nullable String tag, @Nullable String id2, @Nullable Map<String, String> attributes) {
            this.tag = tag;
            this.id = id2;
            this.attributes = attributes;
        }

        @NonNull
        static String tagFor(@NonNull View view) {
            return view.getClass().getSimpleName();
        }

        @Nullable
        static String idFor(@NonNull View view) {
            try {
                if (view.getId() == -1) {
                    return null;
                }
                Resources res = view.getResources();
                return res != null ? res.getResourceEntryName(view.getId()) : null;
            }
            catch (Resources.NotFoundException e) {
                return null;
            }
        }

        @Nullable
        static Map<String, String> attributesFor(@NonNull View view, @Nullable Set<String> keys) {
            if (keys == null) {
                return null;
            }
            HashMap<String, String> attrs = new HashMap<String, String>();
            Iterator<String> iterator = keys.iterator();
            block8: while (iterator.hasNext()) {
                String key;
                switch (key = iterator.next()) {
                    case "contentDescription": {
                        attrs.put(key, (String)view.getContentDescription());
                        continue block8;
                    }
                    case "tag": {
                        Object tag = view.getTag();
                        if (!(tag instanceof CharSequence)) continue block8;
                        attrs.put(key, String.valueOf(view.getTag()));
                        continue block8;
                    }
                }
                attrs.put(key, "invalid key");
            }
            return attrs;
        }

        @NonNull
        static ViewProperties describing(@NonNull View view, @Nullable Set<String> attributes) {
            return new ViewProperties(ViewProperties.tagFor(view), ViewProperties.idFor(view), ViewProperties.attributesFor(view, attributes));
        }
    }
}

