/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import androidx.annotation.Nullable;
import io.cobrowse.Selector;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class SelectorIndex {
    private final Set<String> knownAttributes = new HashSet<String>();
    private final Map<String, HashSet<Selector>> byTag = new HashMap<String, HashSet<Selector>>();
    private final Map<String, HashSet<Selector>> byID = new HashMap<String, HashSet<Selector>>();
    private final Map<String, HashSet<Selector>> byAttribute = new HashMap<String, HashSet<Selector>>();

    SelectorIndex(List<Selector> selectors) {
        for (Selector selector : selectors) {
            Selector.Part part = selector.lastPart();
            if (part.tag != null) {
                if (!this.byTag.containsKey(part.tag)) {
                    this.byTag.put(part.tag, new HashSet());
                }
                this.byTag.get(part.tag).add(selector);
            }
            if (part.id != null) {
                if (!this.byID.containsKey(part.id)) {
                    this.byID.put(part.id, new HashSet());
                }
                this.byID.get(part.id).add(selector);
            }
            if (part.attributes == null) continue;
            for (Map.Entry<String, String> entry : part.attributes.entrySet()) {
                this.knownAttributes.add((String)entry.getKey());
                String indexKey = this.attrKey(entry);
                if (!this.byAttribute.containsKey(indexKey)) {
                    this.byAttribute.put(indexKey, new HashSet());
                }
                this.byAttribute.get(indexKey).add(selector);
            }
        }
    }

    private String attrKey(Map.Entry<String, String> entry) {
        return entry.getKey() + "=" + entry.getValue();
    }

    Set<Selector> possibleMatches(@Nullable String tag, @Nullable String id2, @Nullable Map<String, String> attributes) {
        Set m;
        HashSet<Selector> matches = new HashSet<Selector>();
        if (tag != null && (m = (Set)this.byTag.get(tag)) != null) {
            matches.addAll(m);
        }
        if (id2 != null && (m = (Set)this.byID.get(id2)) != null) {
            matches.addAll(m);
        }
        if (attributes != null) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                Set m2 = this.byAttribute.get(this.attrKey(entry));
                if (m2 == null) continue;
                matches.addAll(m2);
            }
        }
        return matches;
    }

    Set<String> getKnownAttributes() {
        return new HashSet<String>(this.knownAttributes);
    }
}

