/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import io.cobrowse.Selector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class SelectorParser {
    private static final String TAG = "(?:[_a-z][_a-z0-9]*)";
    private static final String ID = "(?:#[a-z0-9_-]+)";
    private static final String TAG_ID = String.format("(?:%s%s)", "(?:[_a-z][_a-z0-9]*)", "(?:#[a-z0-9_-]+)");
    private static final String EL = String.format("(?:%s|%s|%s)", TAG_ID, "(?:#[a-z0-9_-]+)", "(?:[_a-z][_a-z0-9]*)");
    private static final String ATTR_KEY = "(?:[a-z][a-z0-9_-]*|\"[a-z][a-z0-9_ -]*\")";
    private static final String VALUE = "(?:[a-z0-9_-]+|\"[a-z0-9_ -]+\")";
    private static final String ASSIGNMENT = String.format("(?:%s=%s)", "(?:[a-z][a-z0-9_-]*|\"[a-z][a-z0-9_ -]*\")", "(?:[a-z0-9_-]+|\"[a-z0-9_ -]+\")");
    private static final String ATTR = String.format("(?:\\[%s\\])", ASSIGNMENT);
    private static final String ATTRS = String.format("(?:%s*)", ATTR);
    private static final String SELECTOR_PART = String.format("(%s)?(%s)", EL, ATTRS);
    private static final Pattern PartMatcher = Pattern.compile(SELECTOR_PART, 2);
    private static final Pattern AssignmentMatcher = Pattern.compile(ASSIGNMENT, 2);

    SelectorParser() {
    }

    private static Selector.Part parsePart(String part) {
        Matcher match = PartMatcher.matcher(part);
        if (!match.matches()) {
            return null;
        }
        String tagId = match.group(1);
        String attrsString = match.group(2);
        String[] tagAndId = (tagId != null ? tagId : "").split("#");
        String tag = tagAndId.length > 0 && !tagAndId[0].isEmpty() ? tagAndId[0] : null;
        String id2 = tagAndId.length > 1 && !tagAndId[1].isEmpty() ? tagAndId[1] : null;
        ArrayList<String> assignments = new ArrayList<String>();
        if (attrsString != null) {
            Matcher assignmentMatcher = AssignmentMatcher.matcher(attrsString);
            while (assignmentMatcher.find()) {
                assignments.add(assignmentMatcher.group());
            }
        }
        HashMap<String, String> attrs = new HashMap<String, String>();
        for (String assignment : assignments) {
            String[] keyValue = assignment.split("=", 2);
            String key = keyValue[0].replaceAll("^\"(.*)\"$", "$1");
            String value = keyValue[1].replaceAll("^\"(.*)\"$", "$1");
            attrs.put(key, value);
        }
        return new Selector.Part(tag, id2, attrs.isEmpty() ? null : attrs);
    }

    public static Selector parse(String selector) {
        Matcher matcher = PartMatcher.matcher(selector);
        String validate = matcher.replaceAll("");
        String trimmed = validate.trim();
        if (!trimmed.isEmpty()) {
            return null;
        }
        ArrayList<Selector.Part> parsedParts = new ArrayList<Selector.Part>();
        matcher.reset();
        while (matcher.find()) {
            String part = matcher.group();
            if (part.trim().isEmpty()) continue;
            Selector.Part parsedPart = SelectorParser.parsePart(part.trim());
            if (parsedPart == null) {
                return null;
            }
            parsedParts.add(parsedPart);
        }
        if (parsedParts.isEmpty()) {
            return null;
        }
        return new Selector(parsedParts);
    }

    public static List<Selector> parseAll(String[] selectors) {
        ArrayList<Selector> parsed = new ArrayList<Selector>();
        for (String s : selectors) {
            parsed.add(SelectorParser.parse(s));
        }
        return parsed;
    }
}

