/*
 * Decompiled with CFR 0.152.
 */
package io.cobrowse;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.cobrowse.Agent;
import io.cobrowse.Callback;
import io.cobrowse.CobrowseAccessibilityService;
import io.cobrowse.CobrowseIO;
import io.cobrowse.CobrowseInitProvider;
import io.cobrowse.Device;
import io.cobrowse.DisplayScaling;
import io.cobrowse.RESTResource;
import io.cobrowse.Selector;
import io.cobrowse.SelectorParser;
import io.cobrowse.SerializationError;
import io.cobrowse.SessionCapabilities;
import io.cobrowse.ThreadUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import okhttp3.HttpUrl;

public final class Session
extends RESTResource<Session> {
    @NonNull
    private final Set<Listener> listeners = new HashSet<Listener>();
    private SessionCapabilities capabilities = null;

    Session(@NonNull String[] capabilities) {
        this.setHeader("X-CobrowseDeviceToken", UUID.randomUUID().toString());
        this.capabilities = new SessionCapabilities(capabilities);
    }

    void destroy() {
        this.listeners.clear();
    }

    public void registerSessionListener(@NonNull Listener listener) {
        this.listeners.add(listener);
        listener.sessionDidUpdate(this);
    }

    public void removeSessionListener(@NonNull Listener listener) {
        this.listeners.remove(listener);
    }

    @Override
    @NonNull
    HttpUrl url() {
        String id2 = this.id() == null ? this.code() : this.id();
        HttpUrl rvalue = id2 != null ? CobrowseIO.instance().apiUrl().resolve("/api/1/sessions/" + id2) : CobrowseIO.instance().apiUrl().resolve("/api/1/sessions");
        if (rvalue == null) {
            throw new RuntimeException("Cannot create an HTTP Url, is API a valid HTTP(S) scheme?");
        }
        return rvalue;
    }

    @Nullable
    public String code() {
        return this.field("code", String.class);
    }

    @Nullable
    public String id() {
        return this.field("id", String.class);
    }

    @Nullable
    public String state() {
        return this.field("state", String.class);
    }

    @Override
    public void update(@Nullable Map<String, Object> params, @Nullable Callback<Error, Session> callback) {
        if (params != null) {
            params.put("capabilities", this.capabilities.toArray());
        }
        super.update(params, callback);
    }

    @Nullable
    public Agent agent() {
        Map agent = this.field("agent", Map.class);
        if (agent == null) {
            return null;
        }
        try {
            return new Agent(agent);
        }
        catch (SerializationError serializationError) {
            return null;
        }
    }

    @NonNull
    List<Selector> redactionSelectors() {
        ArrayList<Selector> selectors = new ArrayList<Selector>();
        List ss = this.field("redaction_selectors", List.class);
        if (ss != null) {
            for (Object s : ss) {
                if (s instanceof String) {
                    Selector parsed = SelectorParser.parse((String)s);
                    if (parsed == null) continue;
                    selectors.add(parsed);
                    continue;
                }
                if (!(s instanceof List) || ((List)s).isEmpty()) continue;
                selectors.add(Selector.from((List)s));
            }
        }
        return selectors;
    }

    @NonNull
    List<Selector> unredactionSelectors() {
        ArrayList<Selector> selectors = new ArrayList<Selector>();
        List ss = this.field("unredaction_selectors", List.class);
        if (ss != null) {
            for (Object s : ss) {
                Selector parsed;
                if (s instanceof String && (parsed = SelectorParser.parse((String)s)) != null) {
                    selectors.add(parsed);
                }
                if (!(s instanceof List) || ((List)s).isEmpty()) continue;
                selectors.add(Selector.from((List)s));
            }
        }
        return selectors;
    }

    @NonNull
    List<String> videoCodecs() {
        ArrayList<String> allowed = new ArrayList<String>();
        List codecs = this.field("video_codecs", List.class);
        if (codecs != null) {
            for (Object codec : codecs) {
                if (!(codec instanceof String)) continue;
                allowed.add((String)codec);
            }
        }
        return allowed;
    }

    float scale(@NonNull Display display) {
        float scaleFactor;
        DisplayMetrics metrics = DisplayScaling.getMetrics(display);
        Number scale = this.field("scale", Number.class);
        if (scale != null) {
            float scaleFactor2 = scale.floatValue() / metrics.density;
            if (scaleFactor2 > 1.0f) {
                scaleFactor2 = 1.0f;
            }
            return scaleFactor2;
        }
        float maxWidth = 500.0f;
        float maxHeight = 500.0f;
        float currentWidth = metrics.widthPixels;
        float currentHeight = metrics.heightPixels;
        float f = scaleFactor = currentWidth > currentHeight ? maxWidth / currentWidth : maxHeight / currentHeight;
        if (scaleFactor > 1.0f) {
            scaleFactor = 1.0f;
        }
        return scaleFactor;
    }

    Boolean requireConsent() {
        return this.field("require_consent", Boolean.class, true);
    }

    public void setRemoteControl(RemoteControlState state, @Nullable Callback<Error, Session> callback) {
        if (this.remoteControl() == state) {
            ThreadUtils.invoke(callback, null, this);
            return;
        }
        HashMap<String, Object> patch = new HashMap<String, Object>();
        patch.put("remote_control", state.name().toLowerCase());
        this.update((Map<String, Object>)patch, callback);
    }

    public RemoteControlState remoteControl() {
        String state;
        switch (state = this.field("remote_control", String.class, "on")) {
            case "on": {
                return RemoteControlState.On;
            }
            case "requested": {
                return RemoteControlState.Requested;
            }
            case "rejected": {
                return RemoteControlState.Rejected;
            }
            case "off": {
                return RemoteControlState.Off;
            }
        }
        return RemoteControlState.Off;
    }

    boolean allowRemoteControl() {
        return this.remoteControl() == RemoteControlState.On;
    }

    @Override
    protected void updateResource(@NonNull Map<String, Object> obj) {
        boolean wasEnded = this.isEnded();
        super.updateResource(obj);
        for (Listener l : new ArrayList<Listener>(this.listeners)) {
            l.sessionDidUpdate(this);
        }
        if (this.isEnded() != wasEnded) {
            for (Listener l : new ArrayList<Listener>(this.listeners)) {
                l.sessionDidEnd(this);
            }
        }
        if (this.isPending() && this.hasAgent()) {
            if (this.requireConsent().booleanValue()) {
                this.setAuthorizing(null);
            } else {
                this.activate(null);
            }
        }
    }

    public boolean hasAgent() {
        return this.field("agent", Object.class) != null;
    }

    public boolean isPending() {
        return "pending".equals(this.state());
    }

    public boolean isAuthorizing() {
        return "authorizing".equals(this.state());
    }

    public boolean isActive() {
        return "active".equals(this.state());
    }

    public boolean isEnded() {
        return "ended".equals(this.state());
    }

    protected void setAuthorizing(@Nullable Callback<Error, Session> callback) {
        if (this.isAuthorizing()) {
            ThreadUtils.invoke(callback, null, this);
        } else {
            try {
                HashMap<String, Object> patch = new HashMap<String, Object>();
                patch.put("state", "authorizing");
                this.update((Map<String, Object>)patch, callback);
            }
            catch (Exception e) {
                ThreadUtils.invoke(callback, new Error(e.getMessage()), null);
            }
        }
    }

    public void activate(@Nullable Callback<Error, Session> callback) {
        if (this.isActive()) {
            ThreadUtils.invoke(callback, new Error("session already active"), null);
            return;
        }
        try {
            HashMap<String, Object> patch = new HashMap<String, Object>();
            patch.put("state", "active");
            patch.put("device", Device.info(CobrowseInitProvider.getApplication()));
            if (CobrowseIO.instance().customData() != null) {
                patch.put("custom_data", CobrowseIO.instance().customData());
            }
            this.update((Map<String, Object>)patch, callback);
        }
        catch (Exception e) {
            ThreadUtils.invoke(callback, new Error(e.getMessage()), null);
        }
    }

    public void end(@Nullable Callback<Error, Session> callback) {
        if (this.isEnded()) {
            ThreadUtils.invoke(callback, new Error("session already ended"), null);
            return;
        }
        try {
            HashMap<String, Object> patch = new HashMap<String, Object>();
            patch.put("state", "ended");
            this.update((Map<String, Object>)patch, callback);
        }
        catch (Exception e) {
            ThreadUtils.invoke(callback, new Error(e.getMessage()), null);
        }
    }

    @Deprecated
    public Boolean fullDevice() {
        String asString = this.field("full_device", String.class);
        if (asString != null) {
            return asString.equals("on") || asString.equals("requested");
        }
        return this.field("full_device", Boolean.class, false);
    }

    @Deprecated
    public void setFullDevice(boolean state, @Nullable Callback<Error, Session> callback) {
        if (this.fullDevice() == state) {
            ThreadUtils.invoke(callback, null, this);
            return;
        }
        this.toggleCapabilitiesForFullDeviceState(!state);
        try {
            HashMap<String, Object> patch = new HashMap<String, Object>();
            patch.put("full_device", state);
            this.update((Map<String, Object>)patch, callback);
        }
        catch (Exception e) {
            ThreadUtils.invoke(callback, new Error(e.getMessage()), null);
        }
    }

    public FullDeviceState fullDeviceState() {
        String state = this.field("full_device", String.class);
        if (state == null) {
            return this.fullDevice() != false ? FullDeviceState.Requested : FullDeviceState.Off;
        }
        switch (state) {
            case "on": {
                return FullDeviceState.On;
            }
            case "requested": {
                return FullDeviceState.Requested;
            }
            case "rejected": {
                return FullDeviceState.Rejected;
            }
            case "off": {
                return FullDeviceState.Off;
            }
        }
        return FullDeviceState.Off;
    }

    public void setFullDeviceState(FullDeviceState state, @Nullable Callback<Error, Session> callback) {
        if (this.fullDeviceState() == state) {
            ThreadUtils.invoke(callback, null, this);
            return;
        }
        this.toggleCapabilitiesForFullDeviceState(state != FullDeviceState.On);
        try {
            HashMap<String, Object> patch = new HashMap<String, Object>();
            patch.put("full_device", state.name().toLowerCase());
            this.update((Map<String, Object>)patch, callback);
        }
        catch (Exception e) {
            ThreadUtils.invoke(callback, new Error(e.getMessage()), null);
        }
    }

    @NonNull
    String[] capabilities() {
        ArrayList<String> resourceCapabilities = this.field("capabilities", ArrayList.class, new ArrayList<String>(Arrays.asList(this.capabilities.toArray())));
        HashSet<String> filteredCapabilities = new HashSet<String>();
        for (String capability : this.capabilities.toArray()) {
            if (!resourceCapabilities.contains(capability)) continue;
            filteredCapabilities.add(capability);
        }
        return filteredCapabilities.toArray(new String[0]);
    }

    public void setCapabilities(@NonNull String[] capabilities, @Nullable Callback<Error, Session> callback) {
        this.capabilities = new SessionCapabilities(capabilities);
        this.update((Map<String, Object>)new HashMap<String, Object>(), callback);
    }

    void toggleCapabilitiesForFullDeviceState(boolean assumedCapabilitiesState) {
        String[] capabilitiesToToggle = new String[]{"laser", "drawing", "pointer", "keypress"};
        boolean canAnnotate = assumedCapabilitiesState ? true : (Build.VERSION.SDK_INT >= 21 ? CobrowseAccessibilityService.isRunning((Context)CobrowseInitProvider.getApplication()) : false);
        this.capabilities.toggle(capabilitiesToToggle, canAnnotate);
    }

    boolean equals(@Nullable Session other) {
        if (other == null) {
            return false;
        }
        if (super.equals(other)) {
            return true;
        }
        return this.hasIdOrCode(other.id()) || this.hasIdOrCode(other.code());
    }

    boolean hasIdOrCode(@Nullable String idOrCode) {
        if (idOrCode == null) {
            return false;
        }
        return idOrCode.equals(this.id()) || idOrCode.equals(this.code());
    }

    public static interface Listener {
        public void sessionDidUpdate(@NonNull Session var1);

        public void sessionDidEnd(@NonNull Session var1);
    }

    public static enum RemoteControlState {
        Off,
        Requested,
        Rejected,
        On;

    }

    public static enum FullDeviceState {
        Off,
        Requested,
        Rejected,
        On;

    }
}

